/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.imutable_impl;

import be.iminds.ilabt.jfed.rspec.model.LinkSetting;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecInterface;
import java.util.Objects;

public class ImmutableLinkSetting
implements LinkSetting {
    private final ImmutableRspecInterface from;
    private final ImmutableRspecInterface to;
    private final Long capacity_kbps;
    private final Integer latency_ms;
    private final Double packetLoss;
    private final boolean shownIfNotActive;

    public ImmutableLinkSetting(ImmutableRspecInterface fromIface, ImmutableRspecInterface toIface, LinkSetting o) {
        this.from = fromIface;
        this.to = toIface;
        assert (this.from != null);
        assert (this.to != null);
        assert (Objects.equals(o.getFromIface().getClientId(), this.getFromIface().getClientId()));
        assert (Objects.equals(o.getToIface().getClientId(), this.getToIface().getClientId()));
        this.capacity_kbps = o.isCapacitySet() ? Long.valueOf(o.getCapacity_Kbps()) : null;
        this.latency_ms = o.isLatencySet() ? Integer.valueOf(o.getLatency_ms()) : null;
        this.packetLoss = o.isPacketLossSet() ? Double.valueOf(o.getPacketLoss()) : null;
        this.shownIfNotActive = o.isShownIfNotActive();
    }

    @Override
    public ImmutableRspecInterface getFromIface() {
        return this.from;
    }

    @Override
    public ImmutableRspecInterface getToIface() {
        return this.to;
    }

    @Override
    public long getCapacity_Kbps() {
        return this.capacity_kbps == null ? -1L : this.capacity_kbps;
    }

    @Override
    public void setCapacity_Kbps(Long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCapacitySet() {
        return this.capacity_kbps != null && this.capacity_kbps >= 0L;
    }

    @Override
    public int getLatency_ms() {
        return this.latency_ms == null ? -1 : this.latency_ms;
    }

    @Override
    public void setLatency_ms(Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLatencySet() {
        return this.latency_ms != null && this.latency_ms >= 0;
    }

    @Override
    public double getPacketLoss() {
        return this.packetLoss == null ? -1.0 : this.packetLoss;
    }

    @Override
    public void setPacketLoss(Double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPacketLossSet() {
        return this.packetLoss != null && this.packetLoss >= 0.0;
    }

    @Override
    public boolean isActive() {
        return this.isCapacitySet() || this.isPacketLossSet() || this.isLatencySet();
    }

    @Override
    public boolean isShownIfNotActive() {
        return this.shownIfNotActive;
    }

    @Override
    public void setShownIfNotActive(boolean shownIfNotActive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSameAs(LinkSetting o) {
        throw new UnsupportedOperationException();
    }
}

