/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.imutable_impl;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecLink;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecNode;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableRspecInterface
implements RspecInterface {
    private static final Logger LOG = LoggerFactory.getLogger(ImmutableRspecInterface.class);
    protected final ImmutableModelRspec modelRspec;
    protected final String clientId;
    protected final GeniUrn sliverId;
    protected final String componentId;
    protected final String macAddress;
    protected final Integer felixVlan;
    protected final String componentName;
    protected final String role;
    protected final String publicIpv4;
    protected final List<ExtraXml> extraXml;
    protected final List<ExtraXml> extraXmlForRef;
    protected final List<RspecInterface.IpAddress> ipAddresses;
    protected boolean forceFinal;
    @Nullable
    protected ImmutableRspecNode node;
    @Nullable
    protected ImmutableRspecLink link;

    ImmutableRspecInterface(ImmutableModelRspec modelRspec, @Nullable ImmutableRspecNode node, @Nullable ImmutableRspecLink link, RspecInterface orig) {
        assert (node == null || node.getRspec() == modelRspec);
        assert (link == null || link.getRspec() == modelRspec);
        this.modelRspec = modelRspec;
        this.clientId = orig.getClientId();
        this.sliverId = orig.getSliverId();
        this.componentId = orig.getComponentId();
        this.componentName = orig.getComponentName();
        this.role = orig.getRole();
        this.publicIpv4 = orig.getPublicIpv4();
        this.macAddress = orig.getMacAddress();
        this.felixVlan = orig.getFelixVlan();
        this.ipAddresses = Collections.unmodifiableList(new ArrayList<RspecInterface.IpAddress>(orig.getIpAddresses()));
        this.extraXml = Collections.unmodifiableList(new ArrayList<ExtraXml>(orig.getExtraXml()));
        this.extraXmlForRef = Collections.unmodifiableList(new ArrayList<ExtraXml>(orig.getRefExtraXml()));
        if (node != null) {
            this.bindNode(node);
        }
        if (link != null) {
            this.bindLink(link);
        }
    }

    @Override
    public void overwritePropertiesWith(RspecInterface other, boolean overwriteWithNull) {
        throw new UnsupportedOperationException();
    }

    public void setForceFinal(boolean forceFinal) {
        this.forceFinal = forceFinal;
    }

    @Override
    public void bindLink(RspecLink rspecLink) {
        if (this.forceFinal) {
            throw new UnsupportedOperationException();
        }
        assert (rspecLink instanceof ImmutableRspecLink);
        assert (this.link == null);
        this.link = (ImmutableRspecLink)rspecLink;
        if (this.node != null && this.link != null) {
            this.forceFinal = true;
        }
    }

    @Override
    public void bindNode(RspecNode rspecNode) {
        if (this.forceFinal) {
            throw new UnsupportedOperationException();
        }
        assert (rspecNode instanceof ImmutableRspecNode);
        assert (this.node == null);
        this.node = (ImmutableRspecNode)rspecNode;
        if (this.node != null && this.link != null) {
            this.forceFinal = true;
        }
    }

    @Override
    public void moveToNode(RspecNode newRspecNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToLink(RspecLink newRspecLink) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBound() {
        return this.node != null && this.link != null;
    }

    @Override
    public boolean isUnbound() {
        return this.node == null || this.link == null;
    }

    @Override
    public boolean isLinkUnbound() {
        return this.link == null;
    }

    @Override
    public boolean isNodeUnbound() {
        return this.node == null;
    }

    @Override
    public boolean isLinkBound() {
        return this.link != null;
    }

    @Override
    public boolean isNodeBound() {
        return this.node != null;
    }

    @Override
    public String getUniqueId() {
        return BasicStringRspec.makeUniqueInterfaceId((String)this.clientId, (String)this.componentId, this.node == null ? null : this.node.getUniqueId());
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String clientId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @Override
    public void setComponentId(String componentId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPublicIpv4() {
        return this.publicIpv4;
    }

    @Override
    public void setPublicIpv4(String publicIpv4) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public void setRole(String role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public void setComponentName(String componentName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GeniUrn getSliverId() {
        return this.sliverId;
    }

    @Override
    public void setSliverId(String sliverId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSliverId(GeniUrn sliverId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public void setMacAddress(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getFelixVlan() {
        return this.felixVlan;
    }

    @Override
    public void setFelixVlan(Integer felixVlan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RspecInterface.IpAddress> getIpAddresses() {
        return this.ipAddresses;
    }

    @Override
    public List<ExtraXml> getExtraXml() {
        return this.extraXml;
    }

    @Override
    public List<ExtraXml> getRefExtraXml() {
        return this.extraXmlForRef;
    }

    @Override
    public ImmutableRspecNode getNode() {
        if (this.node == null) {
            throw new IllegalStateException("bindNode was not yet called");
        }
        return this.node;
    }

    @Override
    public ImmutableRspecLink getLink() {
        if (this.link == null) {
            throw new IllegalStateException("bindLink was not yet called");
        }
        return this.link;
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableModelRspec getRspec() {
        return this.modelRspec;
    }

    public String toString() {
        return "RspecInterface{id=" + this.clientId + "}";
    }
}

