/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.imutable_impl;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.AnsibleService;
import be.iminds.ilabt.jfed.rspec.model.ExecuteService;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.InstallService;
import be.iminds.ilabt.jfed.rspec.model.LoginService;
import be.iminds.ilabt.jfed.rspec.model.NodeLocation;
import be.iminds.ilabt.jfed.rspec.model.ProxyService;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.WebVncService;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableAnsibleService;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableExecuteService;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableInstallService;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecInterface;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecLink;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableRspecNode
implements RspecNode {
    private static final Logger LOG = LoggerFactory.getLogger(ImmutableRspecNode.class);
    private final ImmutableModelRspec modelRspec;
    protected final List<SliverType> sliverTypes;
    final List<ImmutableRspecInterface> interfaces;
    private final String clientId;
    private final double editorPosX;
    private final double editorPosY;
    private final double flackEditorPosX;
    private final double flackEditorPosY;
    private final List<HardwareType> hardwareTypes;
    private final Boolean exclusive;
    private final Boolean available;
    private final NodeLocation nodeLocation;
    private final GeniUrn componentManagerId;
    private final GeniUrn componentId;
    private final String componentName;
    private final GeniUrn sliverId;
    private final String hostname;
    private final boolean hasRoutableControlIp;
    private final List<String> leaseIdRefs;
    private final List<ImmutableExecuteService> executeServices;
    private final List<ImmutableInstallService> installServices;
    private final List<LoginService> loginServices;
    private final List<ProxyService> proxyServices;
    private final List<WebVncService> webVncServices;
    private final List<ImmutableAnsibleService> ansibleServices;
    private final List<String> ansibleGroups;
    private final List<ExtraXml> extraServicesXmls;
    private final List<ExtraXml> extraXmls;
    private final Set<RspecNode.EmptyTag> emptyTags;

    @Override
    public ImmutableModelRspec getRspec() {
        return this.modelRspec;
    }

    private static <T> List<T> listInit(List<T> orig) {
        if (orig == null) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<T>(orig));
    }

    private static <T> Set<T> setInit(Collection<T> orig) {
        if (orig == null) {
            return null;
        }
        return Collections.unmodifiableSet(new TreeSet<T>(orig));
    }

    private static <OT, NT> List<NT> listInit(List<OT> orig, Function<OT, NT> convert) {
        if (orig == null) {
            return null;
        }
        return Collections.unmodifiableList(orig.stream().map(convert).collect(Collectors.toList()));
    }

    ImmutableRspecNode(ImmutableModelRspec newModelRspec, RspecNode orig) {
        this.modelRspec = newModelRspec;
        this.clientId = orig.getClientId();
        this.editorPosX = orig.getEditorX();
        this.editorPosY = orig.getEditorY();
        this.flackEditorPosX = orig.getFlackEditorX();
        this.flackEditorPosY = orig.getFlackEditorY();
        this.componentId = orig.getComponentId();
        this.componentManagerId = orig.getComponentManagerId();
        this.componentName = orig.getComponentName();
        this.sliverId = orig.getSliverId();
        this.exclusive = orig.getExclusive();
        this.available = orig.getAvailable();
        this.hostname = orig.getHostName();
        this.nodeLocation = orig.getLocation();
        this.leaseIdRefs = ImmutableRspecNode.listInit(orig.getLeaseIdRefs());
        this.executeServices = ImmutableRspecNode.listInit(orig.getExecuteServices(), ImmutableExecuteService::new);
        this.hardwareTypes = ImmutableRspecNode.listInit(orig.getHardwareTypes());
        this.installServices = ImmutableRspecNode.listInit(orig.getInstallServices(), ImmutableInstallService::new);
        this.loginServices = ImmutableRspecNode.listInit(orig.getLoginServices());
        this.proxyServices = ImmutableRspecNode.listInit(orig.getProxyServices());
        this.webVncServices = ImmutableRspecNode.listInit(orig.getWebVncServices());
        this.ansibleServices = ImmutableRspecNode.listInit(orig.getAnsibleServices(), ImmutableAnsibleService::new);
        this.ansibleGroups = ImmutableRspecNode.listInit(orig.getAnsibleGroups());
        this.sliverTypes = ImmutableRspecNode.listInit(orig.getSliverTypes());
        this.hasRoutableControlIp = orig.getRoutableControlIp();
        this.emptyTags = ImmutableRspecNode.setInit(orig.getEmptyTags());
        ArrayList<ExtraXml> extraXmls = new ArrayList<ExtraXml>();
        extraXmls.addAll(orig.getExtraXml());
        this.extraXmls = ImmutableRspecNode.listInit(extraXmls);
        this.extraServicesXmls = ImmutableRspecNode.listInit(orig.getExtraServicesXml());
        ArrayList<ImmutableRspecInterface> copiedInterfaces = new ArrayList<ImmutableRspecInterface>();
        for (RspecInterface rspecInterface : orig.getInterfaces()) {
            ImmutableRspecInterface copiedIface = newModelRspec.getInterfaceByClientId(rspecInterface.getClientId());
            if (copiedIface != null) {
                copiedIface.bindNode(this);
            } else {
                copiedIface = new ImmutableRspecInterface(this.getRspec(), this, null, rspecInterface);
            }
            copiedInterfaces.add(copiedIface);
        }
        this.interfaces = Collections.unmodifiableList(copiedInterfaces);
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public String getUniqueId() {
        return BasicStringRspec.makeUniqueNodeId((String)this.clientId, (String)(this.componentId != null ? this.componentId.getValue() : null), this.componentManagerId != null ? this.componentManagerId.getValue() : null);
    }

    @Override
    public double getEditorX() {
        return this.editorPosX;
    }

    @Override
    public void setEditorX(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getEditorY() {
        return this.editorPosY;
    }

    @Override
    public void setEditorY(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getFlackEditorX() {
        return this.flackEditorPosX;
    }

    @Override
    public void setFlackEditorX(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getFlackEditorY() {
        return this.flackEditorPosY;
    }

    @Override
    public void setFlackEditorY(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<HardwareType> getHardwareTypes() {
        return this.hardwareTypes;
    }

    @Override
    public Boolean getExclusive() {
        return this.exclusive;
    }

    @Override
    public void setExclusive(Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean getAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(Boolean available) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSliverTypeDiskImage(String diskImageName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSliverTypeFlavor(String flavor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSliverTypeName() {
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The caller did not expect this RSpec to have multiple sliver types. (it probably expected this to be a request rspec, which does indeed not have multiple sliver_type's)");
        }
        if (this.sliverTypes.isEmpty()) {
            return null;
        }
        return this.sliverTypes.get(0).getName();
    }

    @Override
    public void setSliverTypeName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SliverType getSliverType() {
        if (this.sliverTypes.isEmpty()) {
            return null;
        }
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The caller did not expect this RSpec to have multiple sliver types. (it probably expected this to be a request rspec, which does indeed not have multiple sliver_type's)");
        }
        return this.sliverTypes.get(0);
    }

    @Override
    public void setSliverType(SliverType singleType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getOsImageUrn() {
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The getOsImageUrn convenience method does not support multiple sliver_types");
        }
        if (this.sliverTypes.isEmpty()) {
            return null;
        }
        SliverType sliverType = this.sliverTypes.get(0);
        if (sliverType.getDiskImages().size() > 1) {
            throw new RuntimeException("The getOsImageUrn convenience method does not support multiple disk_images in the sliver_type");
        }
        if (sliverType.getDiskImages().isEmpty()) {
            return null;
        }
        return sliverType.getDiskImages().get(0).getName();
    }

    @Override
    public List<SliverType> getSliverTypes() {
        return this.sliverTypes;
    }

    @Override
    public NodeLocation getLocation() {
        return this.nodeLocation;
    }

    @Override
    public void setLocation(NodeLocation value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GeniUrn getComponentManagerId() {
        return this.componentManagerId;
    }

    @Override
    public void setComponentManagerId(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setComponentManagerId(GeniUrn value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GeniUrn getComponentId() {
        return this.componentId;
    }

    @Override
    public void setComponentId(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setComponentId(GeniUrn value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public void setComponentName(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GeniUrn getSliverId() {
        return this.sliverId;
    }

    @Override
    public void setSliverId(GeniUrn sliverId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSliverId(String sliverId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    public void setHostName(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getRoutableControlIp() {
        return this.hasRoutableControlIp;
    }

    @Override
    public void setRoutableControlIp(boolean hasRoutableControlIp) {
        throw new UnsupportedOperationException();
    }

    public List<ImmutableExecuteService> getExecuteServices() {
        return this.executeServices;
    }

    @Override
    public void setExecuteServices(List<? extends ExecuteService> value) {
        throw new UnsupportedOperationException();
    }

    public List<ImmutableInstallService> getInstallServices() {
        return this.installServices;
    }

    @Override
    public void setInstallServices(List<? extends InstallService> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addExecuteService(ExecuteService executeService) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addInstallService(InstallService installService) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<LoginService> getLoginServices() {
        return this.loginServices;
    }

    @Override
    public void setLoginServices(List<LoginService> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProxyService> getProxyServices() {
        return this.proxyServices;
    }

    @Override
    public void setProxyServices(List<ProxyService> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<WebVncService> getWebVncServices() {
        return this.webVncServices;
    }

    @Override
    public void setWebVncServices(List<WebVncService> value) {
        throw new UnsupportedOperationException();
    }

    public List<ImmutableAnsibleService> getAnsibleServices() {
        return this.ansibleServices;
    }

    @Override
    public void setAnsibleServices(List<? extends AnsibleService> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAnsibleService(AnsibleService as) {
        throw new UnsupportedOperationException();
    }

    public List<ImmutableRspecInterface> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public ImmutableRspecInterface getInterfaceByClientId(String clientId) {
        for (ImmutableRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getClientId(), clientId)) continue;
            return iface;
        }
        return null;
    }

    @Override
    public ImmutableRspecInterface getInterfaceByUniqueId(String uniqueId) {
        for (ImmutableRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getUniqueId(), uniqueId)) continue;
            return iface;
        }
        return null;
    }

    protected boolean addInterface(RspecInterface iface) {
        throw new UnsupportedOperationException();
    }

    protected boolean removeInterface(RspecInterface iface) {
        throw new UnsupportedOperationException();
    }

    public List<ImmutableRspecLink> getLinks() {
        return Collections.unmodifiableList(this.interfaces.stream().filter(ImmutableRspecInterface::isLinkBound).map(ImmutableRspecInterface::getLink).collect(Collectors.toList()));
    }

    @Override
    public List<String> getLeaseIdRefs() {
        return this.leaseIdRefs;
    }

    @Override
    public void addLeaseIdRef(String leaseIdRef) {
        this.leaseIdRefs.add(leaseIdRef);
    }

    @Override
    public List<String> getAnsibleGroups() {
        return this.ansibleGroups;
    }

    @Override
    @Nonnull
    public List<ExtraXml> getExtraXml() {
        return this.extraXmls;
    }

    @Override
    @Nonnull
    public List<ExtraXml> getExtraServicesXml() {
        return this.extraServicesXmls;
    }

    @Override
    public void addEmptyTag(RspecNode.EmptyTag e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasEmptyTag(RspecNode.EmptyTag e) {
        return this.emptyTags.contains((Object)e);
    }

    @Override
    public Collection<RspecNode.EmptyTag> getEmptyTags() {
        return this.emptyTags;
    }

    @Override
    public void overwritePropertiesWith(RspecNode otherNode, boolean overwriteWithNull) {
        throw new UnsupportedOperationException();
    }
}

