/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.parser;

import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.StaxHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListExtraXml
implements ExtraXml {
    private static final Logger LOG = LoggerFactory.getLogger(EventListExtraXml.class);
    final List<XMLEvent> events = new ArrayList<XMLEvent>();
    private QName startElementName;
    private StartElement startElement;
    private String cachedComparisonHelper;

    public EventListExtraXml(StartElement extraXmlElementStartEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        this.startElement = extraXmlElementStartEvent;
        this.startElementName = extraXmlElementStartEvent.getName();
        String name = this.startElementName.getLocalPart();
        this.events.add(extraXmlElementStartEvent);
        int depth = 0;
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            this.events.add(e);
            if (e.isStartElement() && Objects.equals(e.asStartElement().getName().getLocalPart(), name)) {
                ++depth;
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName().getLocalPart(), name)) continue;
            if (depth == 0) {
                return;
            }
            --depth;
        }
        throw new RspecParseException(extraXmlElementStartEvent.getLocation(), "<" + this.startElementName + "> tag was never closed");
    }

    public EventListExtraXml(List<XMLEvent> allEvents) throws XMLStreamException, RspecParseException {
        assert (allEvents != null);
        assert (!allEvents.isEmpty());
        assert (allEvents.get(0).isStartElement());
        this.startElement = allEvents.get(0).asStartElement();
        this.startElementName = this.startElement.getName();
        this.events.addAll(allEvents);
    }

    public EventListExtraXml(ExtraXml orig) {
        this.startElementName = orig.getStartElementName();
        XMLEventWriter w = new XMLEventWriter(){

            @Override
            public void flush() throws XMLStreamException {
            }

            @Override
            public void close() throws XMLStreamException {
            }

            @Override
            public String getPrefix(String uri) throws XMLStreamException {
                return null;
            }

            @Override
            public void setPrefix(String prefix, String uri) throws XMLStreamException {
            }

            @Override
            public void setDefaultNamespace(String uri) throws XMLStreamException {
            }

            @Override
            public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
            }

            @Override
            public NamespaceContext getNamespaceContext() {
                return null;
            }

            @Override
            public void add(XMLEventReader reader) throws XMLStreamException {
            }

            @Override
            public void add(XMLEvent event) {
                if (!event.isStartElement()) {
                    LOG.warn("Ignoring element: " + event.getEventType());
                    return;
                }
                if (EventListExtraXml.this.events.isEmpty()) {
                    EventListExtraXml.this.startElement = event.asStartElement();
                }
                EventListExtraXml.this.events.add(event);
            }
        };
        try {
            orig.writeEvents(w);
        }
        catch (XMLStreamException e) {
            LOG.error("Unhandled XMLStreamException: constructed EventListExtraXml may not be a full copy", (Throwable)e);
        }
    }

    @Override
    public void writeEvents(XMLEventWriter w) throws XMLStreamException {
        for (XMLEvent e : this.events) {
            w.add(e);
        }
    }

    public static List<ExtraXml> readExtraElements(XMLEvent enclosingStartEvent, XMLEventReader eventReader) throws XMLStreamException, RspecParseException {
        ArrayList<ExtraXml> res = new ArrayList<ExtraXml>();
        String name = enclosingStartEvent.asStartElement().getName().getLocalPart();
        while (eventReader.hasNext()) {
            XMLEvent e = eventReader.nextEvent();
            if (e.isStartElement()) {
                res.add(new EventListExtraXml(e.asStartElement(), eventReader));
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName().getLocalPart(), name)) continue;
            return res;
        }
        throw new RspecParseException(enclosingStartEvent.getLocation(), "The \"" + name + "\" element is never closed");
    }

    @Override
    public QName getStartElementName() {
        return this.startElementName;
    }

    public StartElement getStartElement() {
        return this.startElement;
    }

    @Override
    public Location getLocation() {
        if (this.events != null && !this.events.isEmpty()) {
            return this.events.get(0).getLocation();
        }
        return null;
    }

    public XMLEventReader getAsEventReader() {
        return StaxHelper.makeXmlEventReader(this.events);
    }

    private String getComparisonHelper() {
        if (this.cachedComparisonHelper != null) {
            return this.cachedComparisonHelper;
        }
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
            StringWriter sw = new StringWriter();
            XMLEventWriter eventWriter = outputFactory.createXMLEventWriter(sw);
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            eventWriter.add(eventFactory.createStartDocument());
            for (XMLEvent event : this.events) {
                eventWriter.add(event);
            }
            eventWriter.add(eventFactory.createEndDocument());
            eventWriter.close();
            this.cachedComparisonHelper = sw.getBuffer().toString();
        }
        catch (XMLStreamException e) {
            LOG.error("Error creating EventListExtraXml comparisonHelper. Because of this, EventListExtraXml equals and hashCode won't work correctly.");
            this.cachedComparisonHelper = "" + this;
        }
        return this.cachedComparisonHelper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventListExtraXml)) {
            return false;
        }
        EventListExtraXml that = (EventListExtraXml)o;
        return Objects.equals(this.getComparisonHelper(), that.getComparisonHelper());
    }

    public int hashCode() {
        return this.getComparisonHelper().hashCode();
    }
}

