/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.parser;

import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.AnsibleService;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.DiskImageList;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.ExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.ExecuteService;
import be.iminds.ilabt.jfed.rspec.model.FlavorList;
import be.iminds.ilabt.jfed.rspec.model.GeantTestbedType;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.HardwareTypeInfo;
import be.iminds.ilabt.jfed.rspec.model.IPv4;
import be.iminds.ilabt.jfed.rspec.model.InstallService;
import be.iminds.ilabt.jfed.rspec.model.Lease;
import be.iminds.ilabt.jfed.rspec.model.LinkSetting;
import be.iminds.ilabt.jfed.rspec.model.LoginService;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.NodeLocation;
import be.iminds.ilabt.jfed.rspec.model.ProxyService;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.WebVncService;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.RspecXmlConstants;
import be.iminds.ilabt.jfed.rspec.parser.extensions.UserSpecWriter;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaxRspecWriter
implements Callable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(StaxRspecWriter.class);
    @Nonnull
    private final ModelRspec modelRspec;
    @Nonnull
    private final RspecFactory rspecFactory;
    private boolean useNitosENodeBHack;
    private boolean addSchemaLocation;
    private boolean addEmptySliverToNodeHack;
    @Nullable
    private List<String> componentManagerFilter;
    private XMLEventFactory eventFactory;

    public StaxRspecWriter(@Nonnull ModelRspec modelRspec) {
        this.modelRspec = modelRspec;
        this.rspecFactory = RspecFactoryFactory.getRspecFactoryInstance(modelRspec.getModelRspecType());
        this.useNitosENodeBHack = true;
        this.addSchemaLocation = true;
        this.componentManagerFilter = null;
        this.addEmptySliverToNodeHack = false;
    }

    public void setUseNitosENodeBHack(boolean useNitosENodeBHack) {
        this.useNitosENodeBHack = useNitosENodeBHack;
    }

    public void setAddSchemaLocation(boolean addSchemaLocation) {
        this.addSchemaLocation = addSchemaLocation;
    }

    public void setAddEmptySliverToNodeHack(boolean addEmptySliverToNodeHack) {
        this.addEmptySliverToNodeHack = addEmptySliverToNodeHack;
    }

    public void setComponentManagerFilter(List<String> componentManagerFilter) {
        this.componentManagerFilter = componentManagerFilter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String call() throws RspecParseException {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
            StringWriter sw = new StringWriter();
            XMLEventWriter innerEventWriter = outputFactory.createXMLEventWriter(sw);
            IndentingXMLEventWriter eventWriter = new IndentingXMLEventWriter(innerEventWriter);
            this.eventFactory = XMLEventFactory.newInstance();
            if (this.modelRspec.getOrigDefaultNamespace() != null) {
                eventWriter.setDefaultNamespace(this.modelRspec.getOrigDefaultNamespace());
                assert (Objects.equals("http://www.geni.net/resources/rspec/3", this.modelRspec.getOrigDefaultNamespace()));
            } else {
                eventWriter.setDefaultNamespace("http://www.geni.net/resources/rspec/3");
            }
            for (Map.Entry<String, String> entry : this.modelRspec.getNameSpaceInfo().entrySet()) {
                if (Objects.equals(entry.getValue(), "http://www.geni.net/resources/rspec/3") && (this.modelRspec.getOrigDefaultNamespace() == null || this.modelRspec.getOrigDefaultNamespace() != null && Objects.equals(this.modelRspec.getOrigDefaultNamespace(), "http://www.geni.net/resources/rspec/3")) || Objects.equals(entry.getValue(), "http://www.w3.org/2001/XMLSchema-instance")) continue;
                eventWriter.setPrefix(entry.getKey(), entry.getValue());
            }
            eventWriter.add(this.eventFactory.createStartDocument());
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_RSPEC, null, null));
            eventWriter.add(this.eventFactory.createNamespace("http://www.geni.net/resources/rspec/3"));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_RSPEC_TYPE, this.modelRspec.getType()));
            if (this.modelRspec.getExpiresString() != null) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_RSPEC_EXPIRES, this.modelRspec.getExpiresString()));
            }
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_RSPEC_GEN_BY, "jFed RSpec Editor"));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_RSPEC_GEN_DATE, RFC3339Util.dateToRFC3339String((Date)new Date(), (boolean)false, (boolean)false, (boolean)true)));
            HashMap<String, String> nameSpacesInRspecTag = new HashMap<String, String>();
            nameSpacesInRspecTag.put("client", "http://www.protogeni.net/resources/rspec/ext/client/1");
            nameSpacesInRspecTag.put("jfed", "http://jfed.iminds.be/rspec/ext/jfed/1");
            nameSpacesInRspecTag.put("jfed-ssh-keys", "http://jfed.iminds.be/rspec/ext/jfed-ssh-keys/1");
            nameSpacesInRspecTag.put("jfed-command", "http://jfed.iminds.be/rspec/ext/jfed-command/1");
            nameSpacesInRspecTag.put("delay", "http://www.protogeni.net/resources/rspec/ext/delay/1");
            nameSpacesInRspecTag.put("sharedvlan", "http://www.protogeni.net/resources/rspec/ext/shared-vlan/1");
            nameSpacesInRspecTag.put("emulab", "http://www.protogeni.net/resources/rspec/ext/emulab/1");
            if (!this.modelRspec.getGeantTestbedTypes().isEmpty()) {
                nameSpacesInRspecTag.put("gts", "http://jfed.iminds.be/rspec/ext/jfed-gts/1");
            }
            if (!this.modelRspec.getLeases().isEmpty() || !this.modelRspec.getChannels().isEmpty()) {
                nameSpacesInRspecTag.put("ol", "http://nitlab.inf.uth.gr/schema/sfa/rspec/1");
            }
            for (String string : this.modelRspec.getNameSpaceInfo().values()) {
                nameSpacesInRspecTag.values().remove(string);
            }
            nameSpacesInRspecTag.putAll(this.modelRspec.getNameSpaceInfo());
            for (Map.Entry entry : nameSpacesInRspecTag.entrySet()) {
                String prefix = (String)entry.getKey();
                String ns = (String)entry.getValue();
                if (Objects.equals(ns, "http://www.geni.net/resources/rspec/3") && (this.modelRspec.getOrigDefaultNamespace() == null || this.modelRspec.getOrigDefaultNamespace() != null && Objects.equals(this.modelRspec.getOrigDefaultNamespace(), "http://www.geni.net/resources/rspec/3"))) continue;
                eventWriter.add(this.eventFactory.createNamespace(prefix, ns));
            }
            if (this.addSchemaLocation) {
                void var6_12;
                String string = "http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd ";
                if (this.modelRspec.getSchemaLocation() != null) {
                    String string2 = this.modelRspec.getSchemaLocation();
                }
                eventWriter.add(this.eventFactory.createAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", (String)var6_12));
            }
            for (Lease lease : this.modelRspec.getLeases()) {
                this.writeLease((XMLEventWriter)eventWriter, lease);
            }
            for (Channel channel : this.modelRspec.getChannels()) {
                this.writeChannel((XMLEventWriter)eventWriter, channel);
            }
            for (GeantTestbedType geantTestbedType : this.modelRspec.getGeantTestbedTypes()) {
                this.writeGeantTestbedType((XMLEventWriter)eventWriter, geantTestbedType);
            }
            for (AddressPool addressPool : this.modelRspec.getAddressPools()) {
                this.writeAddressPool((XMLEventWriter)eventWriter, addressPool);
            }
            for (ExecuteAnsiblePlaybook executeAnsiblePlaybook : this.modelRspec.getExecuteAnsiblePlaybooks()) {
                this.writeExecuteAnsibleCookbook((XMLEventWriter)eventWriter, executeAnsiblePlaybook);
            }
            for (DistributeSshKeypair distributeSshKeypair : this.modelRspec.getDistributeSshKeypairs()) {
                this.writeDistributeSshKeypair((XMLEventWriter)eventWriter, distributeSshKeypair);
            }
            for (FlavorList flavorList : this.modelRspec.getFlavorLists()) {
                this.writeFlavorList((XMLEventWriter)eventWriter, flavorList);
            }
            for (DiskImageList diskImageList : this.modelRspec.getDiskImageLists()) {
                this.writeDiskImageList((XMLEventWriter)eventWriter, diskImageList);
            }
            if (this.modelRspec.getHardwareTypeInfo() != null) {
                this.writeHardwareTypeInfo((XMLEventWriter)eventWriter, this.modelRspec.getHardwareTypeInfo());
            }
            for (RspecNode rspecNode : this.modelRspec.getNodes()) {
                if (this.componentManagerFilter == null) {
                    this.writeNode((XMLEventWriter)eventWriter, rspecNode);
                    continue;
                }
                if (rspecNode.getComponentManagerId() == null || !this.componentManagerFilter.contains(rspecNode.getComponentManagerId().getValue())) continue;
                this.writeNode((XMLEventWriter)eventWriter, rspecNode);
            }
            block14: for (RspecLink rspecLink : this.modelRspec.getLinks()) {
                if (this.componentManagerFilter == null) {
                    this.writeLink((XMLEventWriter)eventWriter, rspecLink);
                    continue;
                }
                for (GeniUrn urn : rspecLink.getComponentManagerUrns()) {
                    if (!this.componentManagerFilter.contains(urn.getValue())) continue;
                    this.writeLink((XMLEventWriter)eventWriter, rspecLink);
                    continue block14;
                }
            }
            List<UserSpec> list = this.modelRspec.getSshKeys();
            if (list != null && !list.isEmpty()) {
                for (UserSpec userSpec : list) {
                    UserSpecWriter.writeUserSpec(this.eventFactory, (XMLEventWriter)eventWriter, userSpec);
                }
            }
            this.writeRoutableAddresses((XMLEventWriter)eventWriter, this.modelRspec.getRoutableAddressesAvailable(), this.modelRspec.getRoutableAddressesConfigured());
            this.writeCollocateFactor((XMLEventWriter)eventWriter, this.modelRspec.getMultiplexFactor());
            for (ExtraXml extra : this.modelRspec.getExtraXml()) {
                extra.writeEvents((XMLEventWriter)eventWriter);
            }
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_RSPEC, null));
            eventWriter.add(this.eventFactory.createEndDocument());
            eventWriter.close();
            return sw.getBuffer().toString();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Problem writing RSpec", e);
        }
    }

    private void writeCollocateFactor(@Nonnull XMLEventWriter eventWriter, @Nonnull Integer multiplexFactor) throws XMLStreamException {
        if (multiplexFactor == null) {
            return;
        }
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_COLLOCATE_FACTOR, null, null));
        eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COLLOCATE_FACTOR_COUNT, multiplexFactor.toString()));
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_COLLOCATE_FACTOR, null));
    }

    private void writeChannel(@Nonnull XMLEventWriter eventWriter, @Nonnull Channel channel) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_CHANNEL, null, null));
        if (channel.getComponentId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_ID, channel.getComponentId().toString()));
        }
        if (channel.getComponentManagerId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_MAN_ID, channel.getComponentManagerId().toString()));
        }
        if (channel.getComponentName() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_NAME, channel.getComponentName()));
        }
        if (channel.getFrequency() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_FREQUENCY, channel.getFrequency()));
        }
        if (channel.getEditorX() != -1.0 && channel.getEditorY() != -1.0) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_LOCATION_X, Double.toString(channel.getEditorX())));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_LOCATION_Y, Double.toString(channel.getEditorY())));
        }
        for (String leaseIdRef : channel.getLeaseIdRefs()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LEASE_REF, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_ID_REF, leaseIdRef));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LEASE_REF, null));
        }
        for (ExtraXml extraXml : channel.getExtraXml()) {
            extraXml.writeEvents(eventWriter);
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_CHANNEL, null));
    }

    private void writeRoutableAddresses(@Nonnull XMLEventWriter eventWriter, @Nonnull Integer available, @Nonnull Integer configured) throws XMLStreamException {
        if (available == null && configured == null) {
            return;
        }
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_ROUTABLEADRESSES, null, null));
        if (available != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_ROUTABLEADRESSES_AVAILABLE, "" + available));
        }
        if (configured != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_ROUTABLEADRESSES_CONFIGURED, "" + configured));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_ROUTABLEADRESSES, null));
    }

    private void writeGeantTestbedType(@Nonnull XMLEventWriter eventWriter, @Nonnull GeantTestbedType gtt) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_GEANT_TESTBED_TYPE, null, null));
        if (gtt.getName() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_GTT_NAME, gtt.getName()));
        }
        if (gtt.getComponentManagerId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_MAN_ID, gtt.getComponentManagerId().toString()));
        }
        if (gtt.getComponentId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_ID, gtt.getComponentId().toString()));
        }
        if (gtt.getSliverId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_SLIVER_ID, gtt.getSliverId().toString()));
        }
        if (gtt.getEditorX() != -1.0 && gtt.getEditorY() != -1.0) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_LOCATION_X, Double.toString(gtt.getEditorX())));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_LOCATION_Y, Double.toString(gtt.getEditorY())));
        }
        if (gtt.getDsl() != null) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_GTS_DSL, null, null));
            eventWriter.add(this.eventFactory.createCData(gtt.getDsl()));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_GTS_DSL, null));
        }
        if (gtt.getVpnService() != null || !gtt.getWebVncServices().isEmpty()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_GTS_SERVICES, null, null));
            if (gtt.getVpnService() != null) {
                this.writeGtsVpnService(eventWriter, gtt.getVpnService());
            }
            for (WebVncService webVncService : gtt.getWebVncServices()) {
                this.writeWebVncService(eventWriter, webVncService);
            }
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_GTS_SERVICES, null));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_GEANT_TESTBED_TYPE, null));
    }

    private void writeGtsVpnService(@Nonnull XMLEventWriter eventWriter, @Nonnull GeantTestbedType.VpnService vpnService) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_GTS_VPNSERVICE, null, null));
        if (vpnService.getEndpoint() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_ENDPOINT, vpnService.getEndpoint()));
        }
        if (vpnService.getUsername() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_USERNAME, vpnService.getUsername()));
        }
        if (vpnService.getPassword() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_PASSWORD, vpnService.getPassword()));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_GTS_VPNSERVICE, null));
    }

    private void writeWebVncService(@Nonnull XMLEventWriter eventWriter, @Nonnull WebVncService webVncService) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_GTS_WEB_VNC_SERVICE, null, null));
        if (webVncService.getProviderId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_PROVIDER_ID, webVncService.getProviderId()));
        }
        if (webVncService.getVncUrl() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_WEB_VNC_URL, webVncService.getVncUrl()));
        }
        if (webVncService.getUsername() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_USERNAME, webVncService.getUsername()));
        }
        if (webVncService.getPassword() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_PASSWORD, webVncService.getPassword()));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_GTS_WEB_VNC_SERVICE, null));
    }

    private void writeAddressPool(@Nonnull XMLEventWriter eventWriter, @Nonnull AddressPool addressPool) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_ROUTABLE_POOL, null, null));
        if (addressPool.getClientId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_CLIENT_ID, addressPool.getClientId()));
        }
        if (addressPool.getComponentManagerId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_MAN_ID, addressPool.getComponentManagerId().toString()));
        }
        if (addressPool.getCount() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COUNT, addressPool.getCount().toString()));
        }
        if (addressPool.getType() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_ROUTABLE_POOL_TYPE, addressPool.getType()));
        }
        if (addressPool.getEditorX() != -1.0) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_LOCATION_X, Double.toString(addressPool.getEditorX())));
        }
        if (addressPool.getEditorY() != -1.0) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_LOCATION_Y, Double.toString(addressPool.getEditorY())));
        }
        for (IPv4 iPv4 : addressPool.getIPv4s()) {
            this.writeIPv4(eventWriter, iPv4);
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_ROUTABLE_POOL, null));
    }

    private void writeExecuteAnsibleCookbook(@Nonnull XMLEventWriter eventWriter, @Nonnull ExecuteAnsiblePlaybook executeAnsiblePlaybook) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK, null, null));
        if (executeAnsiblePlaybook.getSource() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_SOURCE, executeAnsiblePlaybook.getSource()));
        }
        if (executeAnsiblePlaybook.getOutputFilename() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_EXECUTE_ANSIBLE_PLAYBOOK_OUTPUT_FILE, executeAnsiblePlaybook.getOutputFilename()));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_JFED_EXECUTE_ANSIBLE_PLAYBOOK, null));
    }

    private void writeDistributeSshKeypair(@Nonnull XMLEventWriter eventWriter, @Nonnull DistributeSshKeypair distributeSshKeypair) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_JFED_DISTRIBUTE_SSH_KEYPAIR, null, null));
        if (distributeSshKeypair.getLocation() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LOCATION, distributeSshKeypair.getLocation()));
        }
        if (distributeSshKeypair.getUser() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_USER, distributeSshKeypair.getUser().toString()));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_JFED_DISTRIBUTE_SSH_KEYPAIR, null));
    }

    private void writeFlavorList(@Nonnull XMLEventWriter eventWriter, @Nonnull FlavorList flavorList) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_FLAVOR_LIST, null, null));
        eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_FLAVOR_LIST_ID, flavorList.getId()));
        for (String flavor : flavorList.getFlavors()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_FLAVOR_TYPE, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_FLAVOR_TYPE_NAME, flavor));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_FLAVOR_TYPE, null));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_FLAVOR_LIST, null));
    }

    private void writeDiskImageList(@Nonnull XMLEventWriter eventWriter, @Nonnull DiskImageList diskImageList) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_DISK_IMAGE_LIST, null, null));
        eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_DISK_IMAGE_LIST_ID, diskImageList.getId()));
        for (DiskImage diskImage : diskImageList.getDiskImages()) {
            this.writeDiskImage(eventWriter, diskImage);
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_DISK_IMAGE_LIST, null));
    }

    private void writeHardwareTypeInfo(@Nonnull XMLEventWriter eventWriter, @Nonnull HardwareTypeInfo hardwareTypeInfo) throws XMLStreamException {
        Namespace hwInfoNamespaceAsDefault = this.eventFactory.createNamespace("https://doc.fed4fire.eu/rspec/ext/hwinfo/1");
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_HWINFO_HARDWARE_TYPE_INFO, null, Collections.singleton(hwInfoNamespaceAsDefault).iterator()));
        for (HardwareTypeInfo.Entry overview : hardwareTypeInfo.getOverviews()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_HWINFO_OVERVIEW, null, null));
            if (overview.getMediaType() != null) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_HWINFO_MEDIA_TYPE, overview.getMediaType()));
            }
            if (overview.getHref() != null) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_HWINFO_HREF, overview.getHref()));
            }
            if (overview.getDirectValue() != null) {
                eventWriter.add(this.eventFactory.createCharacters(overview.getDirectValue()));
            }
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_HWINFO_OVERVIEW, null));
        }
        for (HardwareTypeInfo.HardwareTypeInfoEntry e : hardwareTypeInfo.getHardwareTypeInfoEntries()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_HWINFO_HARDWARE_TYPE, null, null));
            if (e.getName() != null) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_HWINFO_NAME, e.getName()));
            }
            if (e.getHrn() != null) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_HWINFO_HRN, e.getHrn()));
            }
            for (HardwareTypeInfo.Entry info : e.getInfos()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_HWINFO_INFO, null, null));
                if (info.getMediaType() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_HWINFO_MEDIA_TYPE, info.getMediaType()));
                }
                if (info.getHref() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_HWINFO_HREF, info.getHref()));
                }
                if (info.getDirectValue() != null) {
                    eventWriter.add(this.eventFactory.createCharacters(info.getDirectValue()));
                }
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_HWINFO_INFO, null));
            }
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_HWINFO_HARDWARE_TYPE, null));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_HWINFO_HARDWARE_TYPE_INFO, null));
    }

    private void writeIPv4(@Nonnull XMLEventWriter eventWriter, @Nonnull IPv4 iPv4) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_IPV4, null, null));
        if (iPv4.getAddress() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_IPV4_ADDRESS, iPv4.getAddress()));
        }
        if (iPv4.getNetmask() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_IPV4_NETMASK, iPv4.getNetmask()));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_IPV4, null));
    }

    public void writeLease(@Nonnull XMLEventWriter eventWriter, @Nonnull Lease lease) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LEASE, null, null));
        if (lease.getLeaseId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_ID, lease.getLeaseId()));
        }
        if (lease.getClientId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_CLIENT_ID, lease.getClientId()));
        }
        if (lease.getValidFromString() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_VALID_FROM, lease.getValidFromString()));
        }
        if (lease.getValidUntilString() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_VALID_UNTIL, lease.getValidUntilString()));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LEASE, null));
    }

    private static boolean isFlexENodeB(@Nonnull RspecNode node) {
        if (node.getHardwareTypes() == null || node.getHardwareTypes().isEmpty()) {
            return false;
        }
        for (HardwareType hardwareType : node.getHardwareTypes()) {
            if (!hardwareType.getName().equals("e_node_b")) continue;
            return true;
        }
        return false;
    }

    public void writeDiskImage(@Nonnull XMLEventWriter eventWriter, @Nonnull DiskImage diskImage) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_SLIVERTYPE_DISKIMAGE, null, null));
        if (diskImage.getName() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_DISKIMAGE_NAME, diskImage.getName()));
        }
        if (diskImage.getUrl() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_DISKIMAGE_URL, diskImage.getUrl()));
        }
        if (diskImage.getOs() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_DISKIMAGE_OS, diskImage.getOs()));
        }
        if (diskImage.getVersion() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_DISKIMAGE_VERSION, diskImage.getVersion()));
        }
        if (diskImage.getDescription() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_DISKIMAGE_DESCRIPTION, diskImage.getDescription()));
        }
        if (diskImage.isDefault() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_DISKIMAGE_DEFAULT, diskImage.isDefault() != false ? "true" : "false"));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_SLIVERTYPE_DISKIMAGE, null));
    }

    public void writeNode(@Nonnull XMLEventWriter eventWriter, @Nonnull RspecNode node) throws XMLStreamException {
        boolean isFlexENodeB;
        boolean bl = isFlexENodeB = this.useNitosENodeBHack && StaxRspecWriter.isFlexENodeB(node);
        if (isFlexENodeB) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NITOS_E_NODE_B, null, null));
        } else {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE, null, null));
        }
        if (node.getClientId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_CLIENT_ID, node.getClientId()));
        }
        if (node.getExclusive() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_EXCLUSIVE, node.getExclusive() != false ? "true" : "false"));
        }
        if (node.getComponentManagerId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_MAN_ID, node.getComponentManagerId().toString()));
        }
        if (node.getComponentId() != null) {
            GeniUrn comId = node.getComponentId();
            if (isFlexENodeB) {
                comId = GeniUrn.createGeniUrnFromEncodedParts((String)comId.getEncodedTopLevelAuthority(), (String)"e_node_b", (String)comId.getEncodedResourceName());
            }
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_ID, comId.toString()));
        }
        if (node.getComponentName() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_NAME, node.getComponentName()));
        }
        if (node.getSliverId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_SLIVER_ID, node.getSliverId().getValue()));
        }
        if (this.addEmptySliverToNodeHack) {
            boolean mustAdd = true;
            for (ExtraXml extraXml : node.getExtraXml()) {
                if (extraXml.getStartElementName() == null || !Objects.equals(extraXml.getStartElementName().getLocalPart(), "sliver")) continue;
                mustAdd = false;
                break;
            }
            if (mustAdd) {
                eventWriter.add(this.eventFactory.createStartElement(new QName("http://www.geni.net/resources/rspec/3", "sliver"), null, null));
                eventWriter.add(this.eventFactory.createEndElement(new QName("http://www.geni.net/resources/rspec/3", "sliver"), null));
            }
        }
        for (SliverType sliverType : node.getSliverTypes()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_SLIVERTYPE, null, null));
            if (sliverType.getName() != null) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_SLIVERTYPE_NAME, sliverType.getName()));
            }
            for (DiskImage diskImage : sliverType.getDiskImages()) {
                if (diskImage == null || diskImage.getName() == null && diskImage.getUrl() == null) {
                    LOG.warn("List of diskImages contained DiskImage without name or url: " + diskImage + " (will be skipped)");
                    continue;
                }
                this.writeDiskImage(eventWriter, diskImage);
            }
            if (sliverType.hasXen()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_SLIVERTYPE_XEN, null, null));
                if (sliverType.getXenCores() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_XEN_CORES, "" + sliverType.getXenCores()));
                }
                if (sliverType.getXenRam() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_XEN_RAM, "" + sliverType.getXenRam()));
                }
                if (sliverType.getXenDisk() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_XEN_DISK, "" + sliverType.getXenDisk()));
                }
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_SLIVERTYPE_XEN, null));
            }
            for (String id : sliverType.getFlavors()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_FLAVOR_TYPE, null, null));
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_FLAVOR_TYPE_NAME, id));
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_FLAVOR_TYPE, null));
            }
            for (String id : sliverType.getFlavorListRefs()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_FLAVOR_LIST_REF, null, null));
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_FLAVOR_LIST_REF_ID, id));
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_FLAVOR_LIST_REF, null));
            }
            for (String id : sliverType.getDiskImageListRefs()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_DISK_IMAGE_LIST_REF, null, null));
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_DISK_IMAGE_LIST_REF_ID, id));
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_DISK_IMAGE_LIST_REF, null));
            }
            for (ExtraXml extraXml : sliverType.getExtraXml()) {
                extraXml.writeEvents(eventWriter);
            }
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_SLIVERTYPE, null));
        }
        if (node.getAvailable() != null) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_AVAILABLE, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_AVAILABLE_NOW, node.getAvailable() != false ? "true" : "false"));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_AVAILABLE, null));
        }
        if (!isFlexENodeB) {
            for (HardwareType hardwareType : node.getHardwareTypes()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_HARDWARETYPE, null, null));
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_HARDWARETYPE_NAME, hardwareType.getName()));
                if (hardwareType.hasTypeSlots()) {
                    eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_HARDWARETYPE_NODETYPE, null, null));
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_HARDWARETYPE_NODETYPE_TYPESLOTS, hardwareType.getTypeSlotsString()));
                    eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_HARDWARETYPE_NODETYPE, null));
                }
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_HARDWARETYPE, null));
            }
        }
        if (node.getRoutableControlIp()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_ROUTABLECONTROLIP, null, null));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_ROUTABLECONTROLIP, null));
        }
        if (!(node.getLoginServices().isEmpty() && node.getProxyServices().isEmpty() && node.getInstallServices().isEmpty() && node.getExecuteServices().isEmpty() && node.getExtraServicesXml().isEmpty() && !node.hasEmptyTag(RspecNode.EmptyTag.SERVICES))) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_SERVICES, null, null));
            for (LoginService loginService : node.getLoginServices()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_SERVICES_LOGIN, null, null));
                if (loginService.getAuthentication() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_SERVICES_LOGIN_AUTH, loginService.getAuthentication()));
                }
                if (loginService.getHostname() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_SERVICES_LOGIN_HOSTNAME, loginService.getHostname()));
                }
                if (loginService.getPort() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_SERVICES_LOGIN_PORT, loginService.getPort()));
                }
                if (loginService.getUsername() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_SERVICES_LOGIN_USERNAME, loginService.getUsername()));
                }
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_SERVICES_LOGIN, null));
            }
            for (ProxyService proxyService : node.getProxyServices()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_PROXY_PROXY, null, null));
                if (proxyService.getProxy() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_PROXY, proxyService.getProxy()));
                }
                if (proxyService.getFor() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_FOR, proxyService.getFor()));
                }
                if (proxyService.getHostKey() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_HOSTKEY, proxyService.getHostKey()));
                }
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_PROXY_PROXY, null));
            }
            for (InstallService installService : node.getInstallServices()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_SERVICES_INSTALL, null, null));
                if (installService.getInstallPath() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_SERVICES_INSTALL_PATH, installService.getInstallPath()));
                }
                if (installService.getUrl() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_SERVICES_INSTALL_URL, installService.getUrl()));
                }
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_SERVICES_INSTALL, null));
            }
            for (ExecuteService executeService : node.getExecuteServices()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_SERVICES_EXECUTE, null, null));
                if (executeService.getShell() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_SERVICES_EXECUTE_SHELL, executeService.getShell()));
                }
                if (executeService.getCommand() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_SERVICES_EXECUTE_COMMAND, executeService.getCommand()));
                }
                if (executeService.getFinishedFile() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_EXECUTE_FINISHED_FLAG, executeService.getFinishedFile()));
                }
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_SERVICES_EXECUTE, null));
            }
            for (AnsibleService ansibleService : node.getAnsibleServices()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_JFED_ANSIBLE_SERVICE, null, null));
                if (ansibleService.getPlaybookCommand() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_PLAYBOOK_COMMAND, ansibleService.getPlaybookCommand()));
                }
                if (ansibleService.getGalaxyCommand() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_GALAXY_COMMAND, ansibleService.getGalaxyCommand()));
                }
                if (ansibleService.getLogfile() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LOGFILE, ansibleService.getLogfile()));
                }
                if (ansibleService.getInstallRequirements() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_INSTALL_REQUIREMENTS, ansibleService.getInstallRequirements()));
                }
                if (ansibleService.getExecutePlaybook() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_EXECUTE_PLAYBOOK, ansibleService.getExecutePlaybook()));
                }
                if (ansibleService.getInventory() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_INVENTORY, ansibleService.getInventory()));
                }
                if (ansibleService.getDebug() != null) {
                    eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_DEBUG, ansibleService.getDebug().toString()));
                }
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_JFED_ANSIBLE_SERVICE, null));
            }
            for (ExtraXml extraXml : node.getExtraServicesXml()) {
                extraXml.writeEvents(eventWriter);
            }
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_SERVICES, null));
        }
        if (node.getLocation() != null) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_NODE_LOCATION, null, null));
            Iterator<String> loc = node.getLocation();
            if (((NodeLocation)((Object)loc)).getCountry() != null) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_LOCATION_COUNTRY, ((NodeLocation)((Object)loc)).getCountry()));
            }
            if (((NodeLocation)((Object)loc)).getLatitude() != null) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_LOCATION_LAT, ((NodeLocation)((Object)loc)).getLatitude()));
            }
            if (((NodeLocation)((Object)loc)).getLongitude() != null) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_NODE_LOCATION_LONG, ((NodeLocation)((Object)loc)).getLongitude()));
            }
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE_LOCATION, null));
        }
        if (node.getEditorX() >= 0.0 || node.getEditorY() >= 0.0) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_JFED_LOCATION, null, null));
            if (node.getEditorX() >= 0.0) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_LOCATION_X, "" + node.getEditorX()));
            }
            if (node.getEditorY() >= 0.0) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_LOCATION_Y, "" + node.getEditorY()));
            }
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_JFED_LOCATION, null));
        }
        for (RspecInterface rspecInterface : node.getInterfaces()) {
            assert (rspecInterface != null);
            this.writeIface(eventWriter, rspecInterface);
        }
        for (String string : node.getLeaseIdRefs()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LEASE_REF, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_ID_REF, string));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LEASE_REF, null));
        }
        List<String> ansibleGroups = node.getAnsibleGroups();
        if (ansibleGroups != null && !ansibleGroups.isEmpty()) {
            for (String string : ansibleGroups) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_JFED_ANSIBLE_GROUP, null, null));
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_ANSIBLE_GROUP_NAME, string));
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_JFED_ANSIBLE_GROUP, null));
            }
        }
        for (ExtraXml extraXml : node.getExtraXml()) {
            extraXml.writeEvents(eventWriter);
        }
        if (isFlexENodeB) {
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NITOS_E_NODE_B, null));
        } else {
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_NODE, null));
        }
    }

    private void writeIface(@Nonnull XMLEventWriter eventWriter, @Nonnull RspecInterface iface) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_INTERFACE, null, null));
        if (iface.getClientId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_CLIENT_ID, iface.getClientId()));
        }
        if (iface.getSliverId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_SLIVER_ID, iface.getSliverId().getValue()));
        }
        if (iface.getComponentId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_ID, iface.getComponentId()));
        }
        if (iface.getComponentName() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_NAME, iface.getComponentName()));
        }
        if (iface.getRole() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_IFACE_ROLE, iface.getRole()));
        }
        if (iface.getPublicIpv4() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_IFACE_PUBIP4, iface.getPublicIpv4()));
        }
        if (iface.getMacAddress() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_INTERFACE_MAC, iface.getMacAddress()));
        }
        for (RspecInterface.IpAddress ip : iface.getIpAddresses()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_INTERFACE_IP, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_INTERFACE_IP_ADDRESS, ip.getAddress()));
            if (ip.getNetmask() != null) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_INTERFACE_IP_NETMASK, ip.getNetmask()));
            }
            if (ip.getType() != null) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_INTERFACE_IP_TYPE, ip.getType()));
            }
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_INTERFACE_IP, null));
        }
        for (ExtraXml extra : iface.getExtraXml()) {
            extra.writeEvents(eventWriter);
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_INTERFACE, null));
    }

    private void writeIfaceRef(@Nonnull XMLEventWriter eventWriter, @Nonnull RspecInterface iface) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_INTERFACE_REF, null, null));
        if (iface.getClientId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_CLIENT_ID, iface.getClientId()));
        }
        if (iface.getSliverId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_SLIVER_ID, iface.getSliverId().getValue()));
        }
        if (iface.getComponentId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_COM_ID, iface.getComponentId()));
        }
        if (iface.getFelixVlan() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_FELIX_VLAN, Integer.toString(iface.getFelixVlan())));
        }
        for (ExtraXml extra : iface.getRefExtraXml()) {
            extra.writeEvents(eventWriter);
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_INTERFACE_REF, null));
    }

    private void writeLink(@Nonnull XMLEventWriter eventWriter, @Nonnull RspecLink link) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LINK, null, null));
        if (link.getClientId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_CLIENT_ID, link.getClientId()));
        }
        if (link.getSliverId() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_SLIVER_ID, link.getSliverId().getValue()));
        }
        if (link.getVlanTag() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LINK_VLANTAG, link.getVlanTag().toString()));
        }
        for (GeniUrn geniUrn : link.getComponentManagerUrns()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LINK_COM_MAN, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LINK_COM_MAN_NAME, geniUrn.getValue()));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LINK_COM_MAN, null));
        }
        for (RspecInterface rspecInterface : link.getInterfaces()) {
            this.writeIfaceRef(eventWriter, rspecInterface);
        }
        for (String string : link.getLinkTypes()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LINK_TYPE, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LINK_TYPE_NAME, string));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LINK_TYPE, null));
        }
        if (link.getSharedLan() != null) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LINK_SHAREDLAN_LINKSHAREDVLAN, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_LINK_SHAREDLAN_ATT_NAME, link.getSharedLan()));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LINK_SHAREDLAN_LINKSHAREDVLAN, null));
        }
        if (link.hasVlanTaggingTag()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LINK_VLAN_TAGGING, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_LINK_VLAN_TAGGING_ENABLED_ATT_NAME, link.isVlanTaggingEnabled() ? "true" : "false"));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LINK_VLAN_TAGGING, null));
        }
        if (link.hasNoMacLearningTag()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LINK_LINKATTRIBUTE, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_LINK_LINKATTRIBUTE_KEY, "nomac_learning"));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_LINK_LINKATTRIBUTE_VALUE, link.getNoMacLeaningValueString()));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LINK_LINKATTRIBUTE, null));
        }
        if (link.hasBestEffortTag()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LINK_BEST_EFFORT, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_LINK_BEST_EFFORT_ENABLED_ATT_NAME, link.isBestEffortEnabled() ? "true" : "false"));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LINK_BEST_EFFORT, null));
        }
        if (link.hasAutoShareLan()) {
            for (String string : link.getAutoShareLanNames()) {
                eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_JFED_LINK_AUTOSHARELAN, null, null));
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_JFED_LINK_AUTOSHARELAN_NAME, string));
                eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_JFED_LINK_AUTOSHARELAN, null));
            }
        }
        if (link.hasLinkMultiplexingTag()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LINK_LINK_MULTIPLEXING, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_LINK_LINK_MULTIPLEXING_ENABLED_ATT_NAME, link.isLinkMultiplexingEnabled() ? "true" : "false"));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LINK_LINK_MULTIPLEXING, null));
        }
        if (link.hasInterswitchDisallowTag()) {
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LINK_INTERSWITCH, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_LINK_INTERSWITCH_ALLOW, link.isInterswitchDisallowed() ? "false" : "true"));
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LINK_INTERSWITCH, null));
        }
        for (LinkSetting linkSetting : link.getLinkSettings()) {
            if (!linkSetting.isActive() && !linkSetting.isShownIfNotActive()) continue;
            eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_LINK_PROPERTY, null, null));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LINK_PROPERTY_SOURCE, linkSetting.getFromIface().getClientId()));
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LINK_PROPERTY_DEST, linkSetting.getToIface().getClientId()));
            if (linkSetting.isCapacitySet()) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LINK_PROPERTY_CAPACITY, "" + linkSetting.getCapacity_Kbps()));
            }
            if (linkSetting.isLatencySet()) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LINK_PROPERTY_LATENCY, "" + linkSetting.getLatency_ms()));
            }
            if (linkSetting.isPacketLossSet()) {
                eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LINK_PROPERTY_LOSS, "" + linkSetting.getPacketLoss()));
            }
            eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LINK_PROPERTY, null));
        }
        for (ExtraXml extraXml : link.getExtraXml()) {
            extraXml.writeEvents(eventWriter);
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_LINK, null));
    }
}

