/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.rspec_source;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.GeantTestbedType;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestRspecMerger {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestRspecMerger.class);
    private final ModelRspecType modelRspecType;
    private final RspecFactory rspecFactory;
    private RequestRspecSource request;
    private final Map<GeniUrn, ManifestRspecSource> manifestBySource = new HashMap<GeniUrn, ManifestRspecSource>();
    private final List<GeniUrn> manifestSources = new ArrayList<GeniUrn>();
    private ManifestRspecSource mergedManifest;
    private boolean addNodesOnlyFoundInRequest;

    public ManifestRspecMerger(ModelRspecType modelRspecType) {
        this.modelRspecType = modelRspecType;
        this.rspecFactory = RspecFactoryFactory.getRspecFactoryInstance(modelRspecType);
    }

    public boolean isAddNodesOnlyFoundInRequest() {
        return this.addNodesOnlyFoundInRequest;
    }

    public void setAddNodesOnlyFoundInRequest(boolean addNodesOnlyFoundInRequest) {
        this.addNodesOnlyFoundInRequest = addNodesOnlyFoundInRequest;
    }

    public void setRequest(RequestRspecSource requestRspecSource) {
        if (this.request == requestRspecSource) {
            return;
        }
        this.request = requestRspecSource;
        this.mergedManifest = null;
    }

    public void setManifest(GeniUrn sourceAuthority, ManifestRspecSource manifestRspecSource) {
        ModelRspec newModelRspec;
        if (this.manifestBySource.get(sourceAuthority) == manifestRspecSource || this.manifestBySource.get(sourceAuthority) != null && manifestRspecSource == null) {
            return;
        }
        if (sourceAuthority.getEncodedTopLevelAuthority_withoutSubAuth().equalsIgnoreCase("exogeni.net") && (newModelRspec = manifestRspecSource.getMutableModelRspec()) != null) {
            for (RspecLink rspecLink : newModelRspec.getLinks()) {
                ArrayList<GeniUrn> origComponentManagerUrns = new ArrayList<GeniUrn>(rspecLink.getComponentManagerUrns());
                for (GeniUrn cm : origComponentManagerUrns) {
                    if (!cm.hasSubAuthority() || !cm.getEncodedTopLevelAuthority_withoutSubAuth().equalsIgnoreCase("exogeni.net") || cm.getEncodedSubAuthName() == null || !cm.getEncodedSubAuthName().endsWith("Net")) continue;
                    String newSubAuth = cm.getEncodedSubAuthName().replaceAll("Net$", "vmsite");
                    GeniUrn newUrn = GeniUrn.createGeniUrnFromEncodedParts((String)("exogeni.net:" + newSubAuth), (String)cm.getEncodedResourceType(), (String)cm.getEncodedResourceName());
                    LOG.debug("Changing link component manager URN from " + cm + " to " + newUrn);
                    rspecLink.getComponentManagerUrns().remove(cm);
                    rspecLink.getComponentManagerUrns().add(newUrn);
                }
            }
            manifestRspecSource = new ManifestRspecSource(newModelRspec);
            LOG.debug("Fixed exogeni manifest for {}: {}", (Object)sourceAuthority, (Object)manifestRspecSource.getRspecXmlString());
        }
        this.manifestBySource.put(sourceAuthority, manifestRspecSource);
        if (!this.manifestSources.contains(sourceAuthority)) {
            this.manifestSources.add(sourceAuthority);
        }
        this.mergedManifest = null;
    }

    public static boolean isAuthoritative(GeniUrn resourceUrn, GeniUrn authorityUrn) {
        if (authorityUrn.hasSubAuthority()) {
            return Objects.equals(resourceUrn.getEncodedTopLevelAuthority(), authorityUrn.getEncodedTopLevelAuthority());
        }
        return Objects.equals(resourceUrn.getEncodedTopLevelAuthority_withoutSubAuth(), authorityUrn.getEncodedTopLevelAuthority_withoutSubAuth());
    }

    protected boolean haveManifestForResource(List<GeniUrn> urns) {
        for (GeniUrn urn : urns) {
            for (GeniUrn manifestAuthority : this.manifestBySource.keySet()) {
                if (!ManifestRspecMerger.isAuthoritative(urn, manifestAuthority)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean haveManifestForResource(GeniUrn urn) {
        ArrayList<GeniUrn> urns = new ArrayList<GeniUrn>();
        urns.add(urn);
        return this.haveManifestForResource(urns);
    }

    public ManifestRspecSource getMergedManifest() {
        Object m;
        Object m2;
        Object m3;
        Object m4;
        Object modelRspec;
        Object modelRspec3;
        if (this.mergedManifest != null) {
            return this.mergedManifest;
        }
        assert (this.manifestSources.size() == this.manifestBySource.size()) : "manifestSources=" + this.manifestSources + "   manifestBySource.keySet=" + this.manifestBySource.keySet();
        LOG.debug("Starting manifest merge " + (this.request == null ? "without request" : "with request") + " and with " + this.manifestSources.size() + " manifests from: " + this.manifestSources);
        ModelRspec mergedModel = this.rspecFactory.createModelRspec("manifest");
        HashSet<String> authoritativeNodesUniqueIds = new HashSet<String>();
        HashMap<String, String> nodesWithOtherUniqueIds = new HashMap<String, String>();
        ArrayList<GeniUrn> sortedSourceUrns = new ArrayList<GeniUrn>(this.manifestSources);
        Date earliestExpireDate = null;
        for (GeniUrn geniUrn : sortedSourceUrns) {
            Object m5;
            ManifestRspecSource manifestRspecSource = this.manifestBySource.get(geniUrn);
            if (manifestRspecSource == null || (m5 = manifestRspecSource.getModelRspec(this.modelRspecType, new ProgressHandler[0])) == null) continue;
            try {
                Iterator<Object> expire = m5.getExpires();
                if (earliestExpireDate != null && (expire == null || !((Date)((Object)expire)).before(earliestExpireDate))) continue;
                earliestExpireDate = expire;
            }
            catch (ParseException parseException) {}
        }
        if (earliestExpireDate != null) {
            mergedModel.setExpires(earliestExpireDate);
        }
        for (GeniUrn geniUrn : sortedSourceUrns) {
            ManifestRspecSource manifestRspecSource = this.manifestBySource.get(geniUrn);
            if (manifestRspecSource == null) {
                LOG.debug("Skip missing  manifest for " + sortedSourceUrns);
                continue;
            }
            Object m6 = manifestRspecSource.getModelRspec(this.modelRspecType, new ProgressHandler[0]);
            if (m6 == null) {
                LOG.debug("Skip invalid  manifest for " + sortedSourceUrns);
                continue;
            }
            for (RspecNode rspecNode : m6.getNodes()) {
                if (rspecNode.getComponentManagerId() == null) continue;
                LOG.debug("Checking authoritative merge for " + geniUrn + " node id=" + rspecNode.getUniqueId() + " (cm=" + rspecNode.getComponentManagerId() + ")");
                if (!ManifestRspecMerger.isAuthoritative(rspecNode.getComponentManagerId(), geniUrn)) continue;
                LOG.debug("    authoritative merge");
                assert (!authoritativeNodesUniqueIds.contains(rspecNode.getUniqueId())) : "already got authority for node client_id=\"" + rspecNode.getClientId() + "\" component_manager_id=\"" + rspecNode.getComponentManagerId() + "\" authorityUrn=" + geniUrn;
                RspecNode rspecNode2 = this.rspecFactory.copyNode(mergedModel, rspecNode, RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE);
                authoritativeNodesUniqueIds.add(rspecNode2.getUniqueId());
                String otherUniqueId = ManifestRspecMerger.getUniqueIdWithoutSubAuth(rspecNode2);
                if (!Objects.equals(otherUniqueId, rspecNode2.getUniqueId())) {
                    authoritativeNodesUniqueIds.add(otherUniqueId);
                    nodesWithOtherUniqueIds.put(otherUniqueId, rspecNode2.getUniqueId());
                }
                mergedModel.addNode(rspecNode2);
            }
            for (GeantTestbedType geantTestbedType : m6.getGeantTestbedTypes()) {
                if (geantTestbedType.getComponentManagerId() == null) continue;
                LOG.debug("Checking authoritative merge for " + geniUrn + " gts name=" + geantTestbedType.getName() + " (cm=" + geantTestbedType.getComponentManagerId() + ")");
                if (!ManifestRspecMerger.isAuthoritative(geantTestbedType.getComponentManagerId(), geniUrn)) continue;
                LOG.debug("    authoritative merge");
                GeantTestbedType geantTestbedType2 = this.rspecFactory.copyGeantTestbedType(mergedModel, geantTestbedType);
                mergedModel.addGeantTestbedType(geantTestbedType2);
            }
        }
        for (GeniUrn geniUrn : sortedSourceUrns) {
            ManifestRspecSource manifestRspecSource = this.manifestBySource.get(geniUrn);
            if (manifestRspecSource == null) {
                LOG.debug("Skip missing  manifest for " + sortedSourceUrns);
                continue;
            }
            Object m7 = manifestRspecSource.getModelRspec(this.modelRspecType, new ProgressHandler[0]);
            if (m7 == null) {
                LOG.debug("Skip invalid  manifest for " + sortedSourceUrns);
                continue;
            }
            for (RspecNode rspecNode : m7.getNodes()) {
                if (rspecNode.getComponentManagerId() == null) continue;
                if (!authoritativeNodesUniqueIds.contains(rspecNode.getUniqueId())) {
                    if (mergedModel.getNodeByUniqueId(rspecNode.getUniqueId()) != null) continue;
                    LOG.debug("Adding missing node from non-authoritative manifest: client_id=" + rspecNode.getClientId() + " (cm=" + rspecNode.getComponentManagerId() + ")");
                    RspecNode rspecNode3 = this.rspecFactory.copyNode(mergedModel, rspecNode, RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE);
                    mergedModel.addNode(rspecNode3);
                    assert (mergedModel.getNodeByUniqueId(rspecNode.getUniqueId()) != null);
                    continue;
                }
                assert (mergedModel.getNodeByUniqueId(rspecNode.getUniqueId()) != null || nodesWithOtherUniqueIds.containsKey(rspecNode.getUniqueId()) && mergedModel.getNodeByUniqueId((String)nodesWithOtherUniqueIds.get(rspecNode.getUniqueId())) != null);
            }
        }
        if (this.request != null && (modelRspec3 = this.request.getModelRspec(this.modelRspecType, new ProgressHandler[0])) != null) {
            for (RspecNode rspecNode : modelRspec3.getNodes()) {
                if (rspecNode.getComponentManagerId() == null) continue;
                if (!authoritativeNodesUniqueIds.contains(rspecNode.getUniqueId())) {
                    if (mergedModel.getNodeByUniqueId(rspecNode.getUniqueId()) != null) continue;
                    LOG.debug("Adding missing node from (non-authoritative) request: client_id=" + rspecNode.getClientId() + " (cm=" + rspecNode.getComponentManagerId() + ")");
                    if (this.addNodesOnlyFoundInRequest && this.haveManifestForResource(rspecNode.getComponentManagerId())) continue;
                    RspecNode rspecNode4 = this.rspecFactory.copyNode(mergedModel, rspecNode, RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE);
                    mergedModel.addNode(rspecNode4);
                    assert (mergedModel.getNodeByUniqueId(rspecNode.getUniqueId()) != null);
                    continue;
                }
                assert (mergedModel.getNodeByUniqueId(rspecNode.getUniqueId()) != null || nodesWithOtherUniqueIds.containsKey(rspecNode.getUniqueId()) && mergedModel.getNodeByUniqueId((String)nodesWithOtherUniqueIds.get(rspecNode.getUniqueId())) != null);
            }
        }
        ArrayList<RspecLink> mergedLinks = new ArrayList<RspecLink>();
        for (GeniUrn geniUrn : sortedSourceUrns) {
            ManifestRspecSource manifestRspecSource = this.manifestBySource.get(geniUrn);
            if (manifestRspecSource == null) {
                LOG.debug("Skip missing  manifest for " + sortedSourceUrns);
                continue;
            }
            Object modelRspec2 = manifestRspecSource.getModelRspec(this.modelRspecType, new ProgressHandler[0]);
            if (modelRspec2 == null) {
                LOG.debug("Skip invalid  manifest for " + sortedSourceUrns);
                continue;
            }
            LOG.debug("Checking {} links for {}", (Object)modelRspec2.getLinks().size(), (Object)geniUrn);
            for (RspecLink rspecLink : modelRspec2.getLinks()) {
                boolean authorityMatches = false;
                for (GeniUrn linkUrn : rspecLink.getComponentManagerUrns()) {
                    if (!ManifestRspecMerger.isAuthoritative(linkUrn, geniUrn)) continue;
                    authorityMatches = true;
                }
                if (authorityMatches) {
                    RspecLink mergedLink = ManifestRspecMerger.findLink(mergedLinks, rspecLink);
                    if (mergedLink != null) {
                        LOG.debug("Updating missing link with additional authoritative manifest (" + geniUrn + "): client_id=" + rspecLink.getClientId() + " (cm=" + rspecLink.getComponentManagerUrns() + ")");
                        mergedLink.overwritePropertiesWith(rspecLink, false);
                        for (GeniUrn geniUrn2 : rspecLink.getComponentManagerUrns()) {
                            if (!ManifestRspecMerger.isAuthoritative(geniUrn2, geniUrn) || rspecLink.getComponentManagerUrns().contains(geniUrn2)) continue;
                            rspecLink.getComponentManagerUrns().add(geniUrn2);
                        }
                        for (RspecInterface rspecInterface : rspecLink.getInterfaces()) {
                            assert (rspecInterface.isNodeBound());
                            RspecNode origNode = rspecInterface.getNode();
                            assert (origNode != null);
                            RspecInterface mergedRspecInterface = mergedModel.getInterfaceByClientId(rspecInterface.getClientId());
                            assert (mergedRspecInterface == null || mergedRspecInterface.isLinkUnbound() || rspecLink.getInterfaceByClientId(rspecInterface.getClientId()) != null);
                            if (!rspecInterface.isLinkBound() || !Objects.equals(rspecInterface.getLink().getClientId(), mergedLink.getClientId()) || !ManifestRspecMerger.isAuthoritative(geniUrn, origNode.getComponentManagerId()) || mergedRspecInterface == null || !mergedRspecInterface.isNodeBound() || !mergedRspecInterface.isLinkUnbound()) continue;
                            for (RspecInterface rspecInterface2 : mergedLink.getInterfaces()) {
                                if (!Objects.equals(rspecInterface2.getClientId(), rspecInterface.getClientId())) continue;
                                assert (rspecInterface2.isNodeUnbound());
                                LOG.warn("Had to remove a duplicate interface. (exists at node and link separately!)");
                                assert (rspecInterface2.isLinkBound());
                                rspecLink.getInterfaces().remove(rspecInterface2);
                            }
                            LOG.info("  Binding dangling interface from authoritative manifest");
                            mergedRspecInterface.bindLink(mergedLink);
                        }
                        for (RspecInterface rspecInterface : mergedLink.getInterfaces()) {
                            RspecInterface manifestRspecInterface = rspecLink.getInterfaceByClientId(rspecInterface.getClientId());
                            if (manifestRspecInterface == null) continue;
                            rspecInterface.overwritePropertiesWith(manifestRspecInterface, false);
                        }
                        continue;
                    }
                    LOG.debug("Adding missing link from authoritative manifest (" + geniUrn + "): client_id=" + rspecLink.getClientId() + " (cm=" + rspecLink.getComponentManagerUrns() + ")");
                    mergedLink = this.addLink(mergedModel, rspecLink);
                    mergedLinks.add(mergedLink);
                    continue;
                }
                LOG.debug("Skipping link {} because it doesn't have authority {}", (Object)rspecLink.getUniqueId(), (Object)geniUrn);
            }
        }
        for (GeniUrn geniUrn : sortedSourceUrns) {
            ManifestRspecSource manifestRspecSource = this.manifestBySource.get(geniUrn);
            if (manifestRspecSource == null) {
                LOG.debug("Skip missing  manifest for " + sortedSourceUrns);
                continue;
            }
            modelRspec = manifestRspecSource.getModelRspec(this.modelRspecType, new ProgressHandler[0]);
            if (modelRspec == null) {
                LOG.debug("Skip invalid  manifest for " + sortedSourceUrns);
                continue;
            }
            for (RspecLink rspecLink : modelRspec.getLinks()) {
                RspecLink mergedLink = ManifestRspecMerger.findLink(mergedLinks, rspecLink);
                if (mergedLink != null) continue;
                LOG.debug("Adding missing link from non-authoritative manifest: client_id=" + rspecLink.getClientId() + " (cm=" + rspecLink.getComponentManagerUrns() + ")");
                mergedLink = this.addLink(mergedModel, rspecLink);
                mergedLinks.add(mergedLink);
            }
        }
        if (this.request != null && (m4 = this.request.getModelRspec(this.modelRspecType, new ProgressHandler[0])) != null) {
            for (RspecLink rspecLink : m4.getLinks()) {
                RspecLink mergedLink = ManifestRspecMerger.findLink(mergedLinks, rspecLink);
                if (mergedLink != null) continue;
                LOG.debug("Adding missing link from (non-authoritative) request: client_id=" + rspecLink.getClientId() + " (cm=" + rspecLink.getComponentManagerUrns() + ")");
                if (this.addNodesOnlyFoundInRequest && this.haveManifestForResource(rspecLink.getComponentManagerUrns())) continue;
                this.addLink(mergedModel, rspecLink);
            }
        }
        for (RspecLink rspecLink : mergedModel.getLinks()) {
            HashSet<GeniUrn> hashSet = new HashSet<GeniUrn>(rspecLink.getComponentManagerUrns());
            for (GeniUrn geniUrn : hashSet) {
                if (!geniUrn.hasSubAuthority()) continue;
                rspecLink.getComponentManagerUrns().remove(GeniUrn.removeSubAuth((GeniUrn)geniUrn));
            }
        }
        for (GeniUrn geniUrn : sortedSourceUrns) {
            ManifestRspecSource manifestRspecSource = this.manifestBySource.get(geniUrn);
            if (manifestRspecSource == null) {
                LOG.debug("Skip missing  manifest for " + sortedSourceUrns);
                continue;
            }
            modelRspec = manifestRspecSource.getModelRspec(this.modelRspecType, new ProgressHandler[0]);
            if (modelRspec == null) {
                LOG.debug("Skip invalid  manifest for " + sortedSourceUrns);
                continue;
            }
            assert (modelRspec.getAddressPools() != null);
            for (AddressPool addressPool : modelRspec.getAddressPools()) {
                if (addressPool.getComponentManagerId() == null) continue;
                LOG.debug("Checking authoritative merge for " + geniUrn + " addresspool id=" + addressPool.getClientId() + " (cm=" + addressPool.getComponentManagerId() + ")");
                if (!ManifestRspecMerger.isAuthoritative(addressPool.getComponentManagerId(), geniUrn)) continue;
                LOG.debug("    authoritative merge");
                AddressPool mergedAddressPool = this.rspecFactory.copyAddressPool(mergedModel, addressPool);
                mergedModel.addAddressPool(mergedAddressPool);
            }
        }
        for (GeniUrn geniUrn : sortedSourceUrns) {
            ManifestRspecSource manifestRspecSource = this.manifestBySource.get(geniUrn);
            if (manifestRspecSource == null) {
                LOG.debug("Skip missing  manifest for " + sortedSourceUrns);
                continue;
            }
            modelRspec = manifestRspecSource.getModelRspec(this.modelRspecType, new ProgressHandler[0]);
            if (modelRspec == null) {
                LOG.debug("Skip invalid  manifest for " + sortedSourceUrns);
                continue;
            }
            assert (modelRspec.getAddressPools() != null);
            for (AddressPool addressPool : modelRspec.getAddressPools()) {
                if (mergedModel.getAddressPoolByClientId(addressPool.getClientId()) != null) continue;
                LOG.debug("Adding missing addresspool from non-authoritative manifest: client_id=" + addressPool.getClientId() + " (cm=" + addressPool.getComponentManagerId() + ")");
                AddressPool mergedAddressPool = this.rspecFactory.copyAddressPool(mergedModel, addressPool);
                mergedModel.addAddressPool(mergedAddressPool);
            }
        }
        if (this.request != null && (m3 = this.request.getModelRspec(this.modelRspecType, new ProgressHandler[0])) != null) {
            for (AddressPool addressPool : m3.getAddressPools()) {
                if (mergedModel.getAddressPoolByClientId(addressPool.getClientId()) != null) continue;
                LOG.debug("Adding missing addresspool from (non-authoritative) request: client_id=" + addressPool.getClientId() + " (cm=" + addressPool.getComponentManagerId() + ")");
                AddressPool mergedAddressPool = this.rspecFactory.copyAddressPool(mergedModel, addressPool);
                mergedModel.addAddressPool(mergedAddressPool);
            }
        }
        if (this.request != null && (m2 = this.request.getModelRspec(this.modelRspecType, new ProgressHandler[0])) != null) {
            for (GeantTestbedType geantTestbedType : m2.getGeantTestbedTypes()) {
                if (mergedModel.getGeantTestbedTypeByName(geantTestbedType.getName()) != null) continue;
                LOG.debug("Adding missing geant testbed service from (non-authorative) request: name={}", (Object)geantTestbedType.getName());
                mergedModel.addGeantTestbedType(this.rspecFactory.copyGeantTestbedType(mergedModel, geantTestbedType));
            }
        }
        if (this.request != null && (m = this.request.getModelRspec(this.modelRspecType, new ProgressHandler[0])) != null) {
            this.rspecFactory.mergeExtra(mergedModel, (ModelRspec)m);
        }
        for (Map.Entry<GeniUrn, ManifestRspecSource> entry : this.manifestBySource.entrySet()) {
            ManifestRspecSource manifestRspecSource = entry.getValue();
            if (manifestRspecSource == null || (modelRspec = manifestRspecSource.getModelRspec(this.modelRspecType, new ProgressHandler[0])) == null) continue;
            this.rspecFactory.mergeExtra(mergedModel, (ModelRspec)modelRspec);
        }
        this.mergedManifest = new ManifestRspecSource(mergedModel);
        return this.mergedManifest;
    }

    public static List<String> linkUniqueIdHelper(List<? extends RspecLink> in) {
        ArrayList<String> res = new ArrayList<String>();
        for (RspecLink rspecLink : in) {
            res.add(rspecLink.getUniqueId());
        }
        return res;
    }

    private static String getUniqueIdWithoutSubAuth(RspecNode rspecNode) {
        return BasicStringRspec.makeUniqueNodeId((String)rspecNode.getClientId(), (String)(rspecNode.getComponentId() != null ? rspecNode.getComponentId().getValue() : null), (String)GeniUrn.removeSubAuth((GeniUrn)rspecNode.getComponentManagerId()).getValue());
    }

    private static String getUniqueIdWithoutSubAuth(RspecLink rspecLink) {
        TreeSet<String> componentManagerWithoutSubAuthUrnStrings = new TreeSet<String>();
        for (GeniUrn componentManagerUrn : rspecLink.getComponentManagerUrns()) {
            componentManagerWithoutSubAuthUrnStrings.add(GeniUrn.removeSubAuth((GeniUrn)componentManagerUrn).getValue());
        }
        return BasicStringRspec.makeUniqueLinkId((String)rspecLink.getClientId(), null, componentManagerWithoutSubAuthUrnStrings);
    }

    @Nullable
    private static RspecLink findLink(List<RspecLink> mergedLinks, RspecLink searchedLink) {
        TreeSet<String> seachedCms = new TreeSet<String>();
        for (GeniUrn componentManagerUrn : searchedLink.getComponentManagerUrns()) {
            seachedCms.add(GeniUrn.removeSubAuth((GeniUrn)componentManagerUrn).getValue());
        }
        for (RspecLink mergedLink : mergedLinks) {
            if (!Objects.equals(mergedLink.getClientId(), searchedLink.getClientId())) continue;
            HashSet<String> mergedLinkCms = new HashSet<String>();
            for (GeniUrn componentManagerUrn : mergedLink.getComponentManagerUrns()) {
                mergedLinkCms.add(GeniUrn.removeSubAuth((GeniUrn)componentManagerUrn).getValue());
            }
            if (mergedLinkCms.isEmpty() != seachedCms.isEmpty()) continue;
            if (!Collections.disjoint(mergedLinkCms, seachedCms)) {
                return mergedLink;
            }
            if (!mergedLinkCms.isEmpty() || !seachedCms.isEmpty()) continue;
            return mergedLink;
        }
        return null;
    }

    @Nonnull
    private RspecLink addLink(@Nonnull ModelRspec mergedModel, @Nonnull RspecLink origLink) {
        LOG.debug("manifest merger is adding link " + origLink.getClientId());
        RspecLink mergedLink = this.rspecFactory.copyLink(mergedModel, origLink, RspecNode.InterfaceCopyMethod.NO_COPY);
        assert (mergedLink.getInterfaces().isEmpty());
        assert (Objects.equals(origLink.getUniqueId(), mergedLink.getUniqueId()));
        mergedModel.addLink(mergedLink);
        for (RspecInterface rspecInterface : origLink.getInterfaces()) {
            assert (mergedLink.getInterfaceByUniqueId(rspecInterface.getUniqueId()) == null);
            RspecInterface mergedInterface = mergedModel.getInterfaceByUniqueId(rspecInterface.getUniqueId());
            if (mergedInterface != null) {
                assert (!mergedInterface.isNodeUnbound());
                assert (mergedInterface.isLinkUnbound());
                mergedInterface.bindLink(mergedLink);
                LOG.debug("manifest merger added iface " + mergedInterface.getClientId() + " to link " + origLink.getClientId());
                assert (!mergedInterface.isNodeUnbound());
                assert (!mergedInterface.isLinkUnbound());
                assert (mergedInterface.getLink() == mergedLink);
                continue;
            }
            LOG.warn("Could not find interface " + rspecInterface.getUniqueId() + " while merging link, all currently known node ifaces: " + mergedModel.getNodes().stream().flatMap(n -> n.getInterfaces().stream()).map(RspecInterface::getUniqueId).collect(Collectors.joining(", ")));
        }
        for (RspecInterface rspecInterface : mergedLink.getInterfaces()) {
            assert (rspecInterface.getNode() != null);
            assert (rspecInterface.getLink() == mergedLink);
        }
        return mergedLink;
    }

    public String makeInputDebugOverview() {
        StringBuilder res = new StringBuilder("###### ManifestRspecMerger-input-debug-overview ###### ");
        if (this.request != null) {
            res.append("request ### ").append(this.request.getRspecXmlString()).append(" ### ");
        }
        for (Map.Entry<GeniUrn, ManifestRspecSource> e : this.manifestBySource.entrySet()) {
            ManifestRspecSource manifestRspecSource = e.getValue();
            if (manifestRspecSource == null) {
                res.append("manifest-").append(e.getKey()).append(" ### NULL ### ");
                continue;
            }
            res.append("manifest-").append(e.getKey()).append(" ### ").append(manifestRspecSource.getRspecXmlString()).append(" ### ");
        }
        res.append(" ######");
        return res.toString();
    }
}

