/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.statistics;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.DiskImageList;
import be.iminds.ilabt.jfed.rspec.model.FlavorList;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.HardwareTypeInfo;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.NodeLocation;
import be.iminds.ilabt.jfed.rspec.model.OpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.AdvertisementRspecSource;
import be.iminds.ilabt.jfed.rspec.statistics.RSpecStatistics;
import be.iminds.ilabt.jfed.rspec.statistics.RSpecStatisticsBuilder;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.Pair;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspecStatisticsMaker {
    private static final Logger ownLOG = LoggerFactory.getLogger(RspecStatisticsMaker.class);
    private final Logger LOG;

    public RspecStatisticsMaker() {
        this(ownLOG);
    }

    public RspecStatisticsMaker(Logger LOG) {
        this.LOG = LOG;
    }

    public static Logger getOwnLOG() {
        return ownLOG;
    }

    @Nullable
    @Contract(value="null,null,null -> null")
    public static String extractSiteId(@Nullable GeniUrn componentUrn, @Nullable GeniUrn componentManagerUrn, @Nullable RspecNode node) {
        if (componentUrn != null && componentUrn.hasSubAuthority() && componentUrn.getSubAuthName(0) != null) {
            return componentUrn.getSubAuthName(0);
        }
        if (componentManagerUrn != null && componentManagerUrn.hasSubAuthority() && componentManagerUrn.getSubAuthName(0) != null) {
            return componentManagerUrn.getSubAuthName(0);
        }
        if (node != null) {
            return null;
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     */
    public Pair<RSpecStatistics, ServerGlimpseBuilder> make(@Nonnull ModelRspec modelRspec, boolean isAvailableAdvertisement, @Nonnull Server targetServer, @Nullable Timestamp timeStamp) {
        boolean debugReportedNodeWithoutLocation = false;
        boolean debugReportedNodeWithLocation = false;
        boolean debugReportedNodeWithLocationError = false;
        RSpecStatisticsBuilder builder = new RSpecStatisticsBuilder();
        ServerGlimpseBuilder glimpse = new ServerGlimpseBuilder();
        glimpse.setServer(targetServer);
        glimpse.setAdvertisementTimestamp(timeStamp);
        boolean debugHasAvailable = false;
        boolean debugExclusive = false;
        boolean debugExclusiveTrue = false;
        boolean debugExclusiveFalse = false;
        for (Object n : modelRspec.getNodes()) {
            try {
                if (isAvailableAdvertisement && Objects.equals(n.getAvailable(), Boolean.FALSE)) {
                    this.LOG.warn("We requested only available nodes, but got a node that was not available. The node will be ignored. component_id=" + n.getComponentId());
                    builder.incCountTotal();
                    continue;
                }
                if (n.getComponentManagerId() != null) {
                    glimpse.addComponentManagerId(n.getComponentManagerId().getValue());
                }
                if (n.getExclusive() != null) {
                    debugExclusive = true;
                    if (n.getExclusive().booleanValue()) {
                        debugExclusiveTrue = true;
                    } else {
                        debugExclusiveFalse = true;
                    }
                }
                if (n.getAvailable() != null) {
                    debugHasAvailable = true;
                }
                boolean doCount = true;
                boolean doCountTotal = true;
                Object curCount = null;
                boolean doCountRaw = true;
                boolean doCountRawTotal = true;
                boolean doCountVm = true;
                boolean doCountVmTotal = true;
                int curCountRaw = 1;
                int curCountRawTotal = 1;
                int curCountVm = 0;
                int curCountVmTotal = 0;
                if (Objects.equals(n.getAvailable(), Boolean.FALSE)) {
                    doCount = false;
                    doCountVm = false;
                    doCountRaw = false;
                }
                HashSet<String> hwTypeNames = new HashSet<String>();
                if (n.getHardwareTypes() != null) {
                    for (HardwareType hwType : n.getHardwareTypes()) {
                        String hwTypeName = hwType.getName();
                        if (hwTypeName != null) {
                            hwTypeNames.add(hwTypeName);
                        }
                        if (hwTypeName != null && this.mustIgnoreNode((RspecNode)n, hwTypeName, targetServer)) {
                            doCount = false;
                            doCountTotal = false;
                            doCountVm = false;
                            doCountRaw = false;
                            doCountVmTotal = false;
                            doCountRawTotal = false;
                            builder.addExplicitSkippedHwType(hwTypeName);
                        }
                        if (this.isVm((RspecNode)n, hwTypeName, targetServer)) {
                            doCountRaw = false;
                            doCountRawTotal = false;
                            if (hwType.hasTypeSlots() && hwType.getTypeSlotsInt() != null && this.mustCountVmTypeSlots((RspecNode)n, hwTypeName, targetServer)) {
                                if (curCount != null && hwType.getTypeSlotsInt().intValue() != ((Integer)curCount).intValue()) {
                                    ownLOG.warn("Count problem: Already saw a different count for hardware_type with type slots. Will overwrite " + (Integer)curCount + " with " + hwType.getTypeSlotsInt());
                                    this.LOG.warn("Count problem: Already saw a different count for hardware_type with type slots. Will overwrite " + (Integer)curCount + " with " + hwType.getTypeSlotsInt());
                                }
                                curCount = hwType.getTypeSlotsInt();
                                curCountVm = hwType.getTypeSlotsInt();
                                if ((Integer)curCount < 0 || curCountVm < 0) {
                                    this.LOG.warn("Count problem: node " + n.getComponentId() + " has typeslot with negative value: " + (Integer)curCount + "  (will consider this 0!)");
                                    curCount = 0;
                                    curCountVm = 0;
                                    builder.addCountWarning("Count problem: node " + n.getComponentId() + " has typeslot with negative value: " + (Integer)curCount + "  (will consider this 0!)");
                                }
                                curCountVmTotal = this.getTotalVmCountPerNode(curCountVm, (RspecNode)n, hwTypeName, targetServer);
                                if (this.includeVmCountInTotal((RspecNode)n, hwTypeName, targetServer)) {
                                    doCount = true;
                                    doCountTotal = true;
                                } else {
                                    doCount = false;
                                    doCountTotal = false;
                                }
                            }
                        }
                        if (!Objects.equals(n.getExclusive(), Boolean.TRUE)) continue;
                        doCountVm = false;
                        doCountVmTotal = false;
                    }
                }
                Server tServ = targetServer;
                Set hwTypeNamesForServerGlimpse = hwTypeNames.stream().filter(Objects::nonNull).filter(arg_0 -> this.lambda$make$0((RspecNode)n, tServ, arg_0)).collect(Collectors.toSet());
                if (n.getComponentId() != null) {
                    ServerGlimpse.AdvertisementInfo.ComponentDetails.Location glimpseLocation;
                    boolean unavailable = Objects.equals(n.getAvailable(), Boolean.FALSE);
                    if (n.getLocation() != null) {
                        NodeLocation rspecLocation = n.getLocation();
                        try {
                            glimpseLocation = new ServerGlimpse.AdvertisementInfo.ComponentDetails.Location(rspecLocation.getCountry(), rspecLocation.getLatitude() == null ? null : Double.valueOf(Double.parseDouble(rspecLocation.getLatitude())), rspecLocation.getLongitude() == null ? null : Double.valueOf(Double.parseDouble(rspecLocation.getLongitude())));
                            if (this.LOG.isDebugEnabled()) {
                                if (!debugReportedNodeWithLocation) {
                                    this.LOG.debug("Saw a node with node location id=\"" + n.getComponentId() + "\" (this is only reported once)");
                                }
                                debugReportedNodeWithLocation = true;
                            }
                        }
                        catch (NumberFormatException e) {
                            builder.addCountWarning("Failed to parse location from rspec node location lat=\"" + rspecLocation.getLatitude() + "\" lng=\"" + rspecLocation.getLongitude() + "\" id=\"" + n.getComponentId() + "\" ");
                            if (this.LOG.isDebugEnabled()) {
                                if (!debugReportedNodeWithLocationError) {
                                    this.LOG.debug("Failed to parse location from rspec node location lat=\"" + rspecLocation.getLatitude() + "\" lng=\"" + rspecLocation.getLongitude() + "\" id=\"" + n.getComponentId() + "\" (this is only reported once)", (Throwable)e);
                                }
                                debugReportedNodeWithoutLocation = true;
                            }
                            glimpseLocation = null;
                        }
                    } else {
                        if (this.LOG.isDebugEnabled()) {
                            if (!debugReportedNodeWithoutLocation) {
                                this.LOG.debug("Saw a node without node location id=\"" + n.getComponentId() + "\" (this is only reported once)");
                            }
                            debugReportedNodeWithoutLocation = true;
                        }
                        glimpseLocation = null;
                    }
                    ServerGlimpse.AdvertisementInfo.ComponentDetails componentDetails = new ServerGlimpse.AdvertisementInfo.ComponentDetails(n.getComponentId().getValue(), new ArrayList(hwTypeNamesForServerGlimpse), Boolean.valueOf(!unavailable), glimpseLocation, n.getComponentManagerId() == null ? null : n.getComponentManagerId().getValue(), RspecStatisticsMaker.extractSiteId(n.getComponentId(), n.getComponentManagerId(), (RspecNode)n));
                    glimpse.addComponentDetails(componentDetails);
                }
                TreeSet<String> sliverTypeNames = new TreeSet<String>();
                if (n.getSliverTypes() != null) {
                    for (SliverType sliverType : n.getSliverTypes()) {
                        if (sliverType.getName() != null) {
                            sliverTypeNames.add(sliverType.getName());
                        }
                        String oneDefaultDiskImageId = null;
                        ArrayList<DiskImage> sliverTypeDiskImages = new ArrayList<DiskImage>();
                        if (sliverType.getDiskImages() != null) {
                            sliverTypeDiskImages.addAll(sliverType.getDiskImages());
                        }
                        for (String diskImageListRef : sliverType.getDiskImageListRefs()) {
                            DiskImageList list = modelRspec.getDiskImageList(diskImageListRef);
                            if (list != null) {
                                sliverTypeDiskImages.addAll(list.getDiskImages());
                                continue;
                            }
                            this.LOG.debug("Did not find referenced disk image list");
                        }
                        for (DiskImage diskImage : sliverTypeDiskImages) {
                            if (diskImage.isDefault() != null && diskImage.isDefault().booleanValue() && diskImage.getName() != null) {
                                oneDefaultDiskImageId = diskImage.getName();
                            }
                            glimpse.mergeDiskImage(diskImage.getName(), diskImage.getUrl(), diskImage.getDescription(), diskImage.getVersion(), diskImage.getOs(), sliverType.getName());
                        }
                        ArrayList<String> flavorsForServerGlimpse = new ArrayList<String>(sliverType.getFlavors());
                        for (String flavorListRef : sliverType.getFlavorListRefs()) {
                            FlavorList list = modelRspec.getFlavorList(flavorListRef);
                            if (list != null) {
                                flavorsForServerGlimpse.addAll(list.getFlavors());
                                continue;
                            }
                            this.LOG.debug("Did not find referenced disk image list");
                        }
                        if (sliverType.getName() == null) continue;
                        glimpse.mergeSliverTypeInfo(sliverType.getName(), hwTypeNamesForServerGlimpse, flavorsForServerGlimpse, oneDefaultDiskImageId);
                    }
                }
                if (sliverTypeNames.isEmpty()) {
                    glimpse.addNoSliverHardwareType(hwTypeNamesForServerGlimpse);
                }
                try {
                    this.LOG.debug(String.format("Counting \"%s\" of hwType \"%s\" exc=%s, as raw=%d/%d vm=%d/%d", this.friendlyName((RspecNode)n), n.getHardwareTypes().stream().map(HardwareType::getName).collect(Collectors.joining("\" and \"")), n.getExclusive(), !doCountRaw ? 0 : curCountRaw, !doCountRawTotal ? 0 : curCountRawTotal, !doCountVm ? 0 : curCountVm, !doCountVmTotal ? 0 : curCountVmTotal));
                }
                catch (Exception e) {
                    this.LOG.error("Error while printing debug info. Will be ignored. " + e.getMessage());
                }
                if (doCountRaw) {
                    builder.incCountRaw(curCountRaw);
                    for (String hwType : hwTypeNamesForServerGlimpse) {
                        builder.incAvailableForHwType(hwType, curCountRaw);
                    }
                }
                if (doCountRawTotal) {
                    builder.incCountRawTotal(curCountRawTotal);
                    for (String hwType : hwTypeNamesForServerGlimpse) {
                        builder.incTotalForHwType(hwType, curCountRawTotal);
                    }
                }
                if (doCountVm) {
                    builder.incCountVm(curCountVm);
                }
                if (doCountVmTotal) {
                    if (curCountVm > curCountVmTotal) {
                        this.LOG.warn("More VMs available (" + curCountVm + ") than supposed maximum (" + curCountVmTotal + ") -> Will fix by updating max");
                        builder.addCountWarning("More VMs available (" + curCountVm + ") than supposed maximum (" + curCountVmTotal + ")");
                        curCountVmTotal = curCountVm;
                    }
                    builder.incCountVmTotal(curCountVmTotal);
                }
                if (doCount) {
                    builder.addCountedHwTypes(hwTypeNames);
                    builder.incCount(curCount == null ? 1 : (Integer)curCount);
                } else {
                    builder.addImplicitSkippedHwTypes(hwTypeNames);
                    builder.incSkippedCount();
                }
                if (!doCountTotal) continue;
                builder.incCountTotal(curCount == null ? 1 : (Integer)curCount);
            }
            catch (Throwable e) {
                ownLOG.warn("Something went wrong while trying to count a node. This error can be ignored but it might cause a bad count.", e);
                this.LOG.warn("Something went wrong while trying to count a node. This error can be ignored but it might cause a bad count.", e);
            }
        }
        if (builder.getCount() > builder.getCountRaw() && builder.getCountRaw() > 0 && builder.getCountVm() > 0) {
            this.LOG.info("           Automatic summary count fixup: " + builder.getCount() + " -> " + builder.getCountRaw() + " (countRaw=" + builder.getCountRaw() + " countVm=" + builder.getCountVm() + ")");
            builder.setCount(builder.getCountRaw());
        }
        if (builder.getCount() == 0 && builder.getCountRaw() == 0 && builder.getCountVm() > 0) {
            this.LOG.info("           Automatic summary count fixup: 0 -> " + builder.getCountVm());
            builder.setCount(builder.getCountVm());
        }
        this.LOG.info("           Counted Hardware Types: " + builder.getCountedHwTypes());
        this.LOG.info("Implicitly Skipped Hardware Types: " + builder.getImplicitSkippedHwTypes());
        this.LOG.info("Explicitly Skipped Hardware Types: " + builder.getExplicitSkippedHwTypes());
        this.LOG.debug("Advertisement RSpec nodes have available: " + debugHasAvailable);
        this.LOG.debug("Advertisement RSpec nodes have exclusive: " + debugExclusive + (String)(debugExclusive ? " hasTrue=" + debugExclusiveTrue + " hasFalse=" + debugExclusiveFalse : ""));
        this.LOG.info("Result count=" + builder.getCount() + " countTotal=" + builder.getCountTotal() + " skippedCount=" + builder.getSkippedCount());
        this.LOG.info("Result count raw " + builder.getCountRaw() + " of " + builder.getCountRawTotal());
        this.LOG.info("Result count  VM " + builder.getCountVm() + " of " + builder.getCountVmTotal());
        List<? extends OpenflowDataPath> openflowDataPaths = modelRspec.getOpenflowDataPaths();
        for (OpenflowDataPath dp : openflowDataPaths) {
            if (dp.getDpid() == null) continue;
            builder.incCount();
            builder.incCountOpenflow();
            builder.incCountOpenflowTotal();
        }
        this.LOG.info("Result count  openflow " + builder.getCountOpenflow() + " of " + builder.getCountOpenflowTotal());
        HardwareTypeInfo hardwareTypeInfo = modelRspec.getHardwareTypeInfo();
        if (hardwareTypeInfo != null) {
            URI htmlOverview;
            try {
                htmlOverview = hardwareTypeInfo.getHtmlOverview() == null ? null : new URI(hardwareTypeInfo.getHtmlOverview());
            }
            catch (URISyntaxException e) {
                this.LOG.warn("Invalid URI in hardwaretypeinfo overview: " + hardwareTypeInfo.getHtmlOverview());
                htmlOverview = null;
            }
            ArrayList<ServerGlimpse.AdvertisementInfo.HardwareTypeInfo.HardwareTypeInfoEntry> entries = new ArrayList<ServerGlimpse.AdvertisementInfo.HardwareTypeInfo.HardwareTypeInfoEntry>();
            for (HardwareTypeInfo.HardwareTypeInfoEntry ee : hardwareTypeInfo.getHardwareTypeInfoEntries()) {
                URI eHtmlDescription;
                try {
                    eHtmlDescription = ee.getHtmlDescription() == null ? null : new URI(ee.getHtmlDescription());
                }
                catch (URISyntaxException e) {
                    this.LOG.warn("Invalid URI in hardwaretypeinfo entry: " + ee.getHtmlDescription());
                    eHtmlDescription = null;
                }
                ServerGlimpse.AdvertisementInfo.HardwareTypeInfo.HardwareTypeInfoEntry e = new ServerGlimpse.AdvertisementInfo.HardwareTypeInfo.HardwareTypeInfoEntry(ee.getName(), ee.getHrn(), ee.getTextDescription(), eHtmlDescription);
                entries.add(e);
            }
            ServerGlimpse.AdvertisementInfo.HardwareTypeInfo glimpseHardwareTypeInfo = new ServerGlimpse.AdvertisementInfo.HardwareTypeInfo(hardwareTypeInfo.getTextOverview(), htmlOverview, entries);
            glimpse.setHardwareTypeInfo(glimpseHardwareTypeInfo);
        }
        builder.setCountIpv4(-1);
        builder.setCountIpv4Total(-1);
        if (modelRspec.getRoutableAddressesAvailable() != null) {
            builder.setCountIpv4(modelRspec.getRoutableAddressesAvailable());
        }
        if (modelRspec.getRoutableAddressesConfigured() != null) {
            builder.setCountIpv4Total(modelRspec.getRoutableAddressesConfigured());
        }
        this.LOG.info("Result count  IPv4 " + builder.getCountIpv4() + " of " + builder.getCountIpv4Total());
        RSpecStatistics stats = builder.create();
        this.LOG.info("Result countPerHwType hwTypes.keys= " + stats.getHwCountKeys());
        this.countsToServerGlimpse(stats, glimpse, isAvailableAdvertisement);
        return new Pair((Object)stats, (Object)glimpse);
    }

    public Pair<RSpecStatistics, ServerGlimpseBuilder> makeUsingFallback(@Nonnull String rspec, boolean isAvailableAdvertisement, @Nonnull Server targetServer, @Nullable Timestamp timeStamp) {
        BasicStringRspec stringRspec = new BasicStringRspec(rspec);
        if (stringRspec == null) {
            throw new RuntimeException("Failed to create stringRspec");
        }
        if (stringRspec.isWellFormed()) {
            throw new RuntimeException("RSpec is not well formed XML");
        }
        if (stringRspec.isValidRspec()) {
            throw new RuntimeException("RSpec is not valid XML");
        }
        List nodeInfos = stringRspec.getBasicNodeInfo();
        if (nodeInfos == null) {
            throw new RuntimeException("Created stringRspec has null nodeInfos list");
        }
        RSpecStatisticsBuilder builder = new RSpecStatisticsBuilder();
        ServerGlimpseBuilder glimpse = new ServerGlimpseBuilder();
        glimpse.setServer(targetServer);
        glimpse.setAdvertisementTimestamp(timeStamp);
        builder.setCount(nodeInfos.size());
        builder.setCountTotal(nodeInfos.size());
        builder.setSkippedCount(0);
        builder.setCountRaw(0);
        builder.setCountRawTotal(0);
        builder.setCountVm(0);
        builder.setCountVmTotal(0);
        builder.addCountWarning("BasicStringRspec parsing fallback used. Counts will not be correct.");
        builder.addCountError("BasicStringRspec parsing fallback used. Counts will not be correct.");
        RSpecStatistics stats = builder.create();
        this.countsToServerGlimpse(stats, glimpse, isAvailableAdvertisement);
        return new Pair((Object)stats, (Object)glimpse);
    }

    public Pair<RSpecStatistics, ServerGlimpseBuilder> make(@Nonnull String rspec, boolean isAvailableAdvertisement, @Nonnull Server targetServer, @Nullable Timestamp timeStamp) {
        try {
            AdvertisementRspecSource rspecSource = new AdvertisementRspecSource(rspec, ModelRspecType.BASIC);
            ImmutableModelRspec modelRspec = rspecSource.getImmutableModelRspec();
            if (modelRspec == null) {
                throw new RuntimeException("Failed to create modelRspec");
            }
            if (modelRspec.getNodes() == null) {
                throw new RuntimeException("Created modelRspec has null node list");
            }
            this.LOG.debug("Advertisement RSpec node count=" + modelRspec.getNodes().size() + "  link count=" + modelRspec.getLinks().size());
            return this.make(modelRspec, isAvailableAdvertisement, targetServer, timeStamp);
        }
        catch (Throwable t) {
            ownLOG.error("Error counting in Advertisement RSpec. Falling back to BasicStringRspec method.\n", t);
            this.LOG.error("\nError counting in Advertisement RSpec (" + t.getMessage() + "). Falling back to BasicStringRspec method.");
            try {
                return this.makeUsingFallback(rspec, isAvailableAdvertisement, targetServer, timeStamp);
            }
            catch (Throwable t2) {
                ownLOG.error("Error counting using fallback, in Advertisement RSpec\n", t2);
                this.LOG.error("\nError counting in Advertisement RSpec (" + t2.getMessage() + "). Both ModelRspec and BasicStringRspec methods failed.");
                RSpecStatisticsBuilder builder = new RSpecStatisticsBuilder();
                ServerGlimpseBuilder glimpse = new ServerGlimpseBuilder();
                glimpse.setServer(targetServer);
                glimpse.setAdvertisementTimestamp(timeStamp);
                builder.setCount(-1);
                builder.setCountTotal(-1);
                builder.addCountWarning("Error counting using fallback. No count done.");
                builder.addCountError("Error counting using fallback. No count done.");
                return new Pair((Object)builder.create(), (Object)glimpse);
            }
        }
    }

    private void countsToServerGlimpse(RSpecStatistics res, ServerGlimpseBuilder glimpse, boolean isAvailableAdvertisement) {
        glimpse.setCount(AdvertisementCounts.CountedObject.ANY, Integer.valueOf(res.getCountTotal()), Integer.valueOf(res.getCount()));
        if (!isAvailableAdvertisement) {
            glimpse.setCount(AdvertisementCounts.CountedObject.RAW_PC, Integer.valueOf(res.getCountRawTotal()), Integer.valueOf(res.getCountRaw()));
            glimpse.setCount(AdvertisementCounts.CountedObject.VM, Integer.valueOf(res.getCountVmTotal()), Integer.valueOf(res.getCountVm()));
            for (Map.Entry<String, RSpecStatistics.CountPair> e : res.getCountPerHwType().entrySet()) {
                String hwType = e.getKey();
                RSpecStatistics.CountPair p = e.getValue();
                glimpse.setHwCount(hwType, Integer.valueOf(p.getTotal()), Integer.valueOf(p.getAvailable()));
            }
        } else {
            glimpse.setCount(AdvertisementCounts.CountedObject.RAW_PC, AdvertisementCounts.CountScope.AVAILABLE, Integer.valueOf(res.getCountRaw()));
            glimpse.setCount(AdvertisementCounts.CountedObject.VM, AdvertisementCounts.CountScope.AVAILABLE, Integer.valueOf(res.getCountVm()));
            for (Map.Entry<String, RSpecStatistics.CountPair> e : res.getCountPerHwType().entrySet()) {
                String hwType = e.getKey();
                RSpecStatistics.CountPair p = e.getValue();
                glimpse.setHwCount(hwType, AdvertisementCounts.CountScope.AVAILABLE, Integer.valueOf(p.getAvailable()));
            }
        }
        if (res.getCountIpv4() >= 0 || res.getCountIpv4Total() >= 0) {
            glimpse.setCount(AdvertisementCounts.CountedObject.IPV4, AdvertisementCounts.CountScope.AVAILABLE, Integer.valueOf(res.getCountIpv4()));
            if (res.getCountIpv4Total() >= 0) {
                glimpse.setCount(AdvertisementCounts.CountedObject.IPV4, AdvertisementCounts.CountScope.ALL, Integer.valueOf(res.getCountIpv4Total()));
            }
        }
        if (res.getCountOpenflow() >= 0 || res.getCountOpenflowTotal() >= 0) {
            glimpse.setCount(AdvertisementCounts.CountedObject.OPENFLOW, AdvertisementCounts.CountScope.AVAILABLE, Integer.valueOf(res.getCountOpenflow()));
            if (res.getCountOpenflowTotal() >= 0) {
                glimpse.setCount(AdvertisementCounts.CountedObject.OPENFLOW, AdvertisementCounts.CountScope.ALL, Integer.valueOf(res.getCountOpenflowTotal()));
            }
        }
    }

    private boolean mustIgnoreNode(RspecNode n, String hwTypeName, Server targetServer) {
        return hwTypeName != null && (hwTypeName.equalsIgnoreCase("switch") || hwTypeName.equalsIgnoreCase("SWITCHPORT") || hwTypeName.equalsIgnoreCase("ipv4") || hwTypeName.equalsIgnoreCase("orca-iscsi-luns") || hwTypeName.equalsIgnoreCase("orca-transit-net-vlan") || hwTypeName.equalsIgnoreCase("xcvr2450") || hwTypeName.equalsIgnoreCase("flex900") || hwTypeName.equalsIgnoreCase("80211") || hwTypeName.toLowerCase().startsWith("interconnect"));
    }

    public boolean mustExcludeHardwareTypeFromServerGlimpse(RspecNode n, String hardwareType, Server server) {
        if (hardwareType == null) {
            return true;
        }
        String hardwareTypeToCheck = hardwareType.trim();
        if (server.getServerType() != null && (server.getServerType().trim().equalsIgnoreCase("emulab") || server.getServerType().trim().equalsIgnoreCase("instageni"))) {
            if (hardwareTypeToCheck.equals("pc")) {
                return true;
            }
            if (hardwareTypeToCheck.equals("vm")) {
                return true;
            }
            if (hardwareTypeToCheck.equals("pcvm")) {
                return true;
            }
            if (hardwareTypeToCheck.equals("delay")) {
                return true;
            }
            if (hardwareTypeToCheck.equals("lan")) {
                return true;
            }
            if (hardwareTypeToCheck.startsWith("pcvm")) {
                return true;
            }
            if (hardwareTypeToCheck.startsWith("delay-")) {
                return true;
            }
            if (hardwareTypeToCheck.startsWith("bridge-")) {
                return true;
            }
            if (hardwareTypeToCheck.startsWith("bridge")) {
                return true;
            }
            if (hardwareTypeToCheck.endsWith("-vm")) {
                return true;
            }
        }
        return false;
    }

    public boolean mustCountVmTypeSlots(RspecNode n, String hwTypeName, Server targetServer) {
        if (hwTypeName.equalsIgnoreCase("orca-vm-cloud")) {
            return true;
        }
        if (hwTypeName.equalsIgnoreCase("pcvm")) {
            return true;
        }
        if (hwTypeName.equalsIgnoreCase("vm") && targetServer.getUrnTld().equalsIgnoreCase("ocf:i2cat:vtam")) {
            return true;
        }
        if (hwTypeName.startsWith("vmhost")) {
            return true;
        }
        return hwTypeName.equals("docker_cluster");
    }

    public int getTotalVmCountPerNode(int curCountVm, RspecNode n, String hwTypeName, Server targetServer) {
        if (targetServer.getUrnTld().equals("wall2.ilabt.iminds.be") || targetServer.getUrnTld().equals("wall1.ilabt.iminds.be")) {
            return 40;
        }
        if (targetServer.isServerType("instageni")) {
            return 50;
        }
        if (hwTypeName.equalsIgnoreCase("orca-vm-cloud")) {
            return 52;
        }
        if (hwTypeName.equalsIgnoreCase("vm") && targetServer.getUrnTld().equalsIgnoreCase("ocf:i2cat:vtam")) {
            return 40;
        }
        if (hwTypeName.equalsIgnoreCase("vmhost-type1-vm")) {
            return 70;
        }
        if (hwTypeName.equalsIgnoreCase("docker_cluster")) {
            return 20;
        }
        return curCountVm;
    }

    public boolean includeVmCountInTotal(RspecNode n, String hwTypeName, Server targetServer) {
        if (targetServer.isServerType("emulab")) {
            return false;
        }
        return !targetServer.isServerType("instageni");
    }

    public boolean isVm(RspecNode n, String hwTypeName, Server targetServer) {
        if (Objects.equals(n.getExclusive(), Boolean.FALSE)) {
            return true;
        }
        return hwTypeName.equalsIgnoreCase("orca-vm-cloud");
    }

    private String friendlyName(RspecNode node) {
        if (node.getComponentName() != null) {
            return node.getComponentName();
        }
        if (node.getComponentId() != null) {
            return node.getComponentId().getResourceName();
        }
        return null;
    }

    private /* synthetic */ boolean lambda$make$0(RspecNode n, Server tServ, String hwTypeName) {
        return !this.mustExcludeHardwareTypeFromServerGlimpse(n, hwTypeName, tServ);
    }
}

