/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.util;

import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicModelRspec;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecNode;
import be.iminds.ilabt.jfed.rspec.parser.RspecCompare;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RspecBinder {
    private RspecBinder() {
    }

    public static String bindUnboundTo(@Nonnull Consumer<String> warn, @Nonnull Consumer<String> warnWithCode, @Nonnull Consumer<String> note, @Nullable String rspec, @Nullable String targetComponentManagerId) {
        if (targetComponentManagerId == null || targetComponentManagerId.trim().isEmpty() || rspec == null) {
            return rspec;
        }
        ImmutableRequestRspecSource requestRspecSource = new ImmutableRequestRspecSource(rspec, ModelRspecType.BASIC);
        BasicModelRspec model = (BasicModelRspec)requestRspecSource.getModelRspec(ModelRspecType.BASIC, new ProgressHandler[0]);
        if (model == null) {
            warn.accept("Could not parse provided RSpec. Will not try to bind unbound nodes.");
            return rspec;
        }
        if (requestRspecSource.isLosingData(ModelRspecType.BASIC)) {
            List<RspecCompare.Difference> diffs = requestRspecSource.getLosingDataDifferences(ModelRspecType.BASIC);
            warn.accept("Something is wrong in RSpec. Because of this, the unbound nodes cannot be bound without losing data. Will not bind nodes. Differences:");
            for (RspecCompare.Difference diff : diffs) {
                warnWithCode.accept("" + diff);
            }
            return rspec;
        }
        if (GeniUrn.parse((String)targetComponentManagerId) == null) {
            warn.accept("The configured target for unbound nodes (\"fixed_rspec_bind_unbound_to\" option) is not a valid URN (and not \"auto\"): \"" + targetComponentManagerId + "\". Will not bind nodes.");
            return rspec;
        }
        note.accept("Will bind unbound nodes to: \"" + targetComponentManagerId + "\"");
        GeniUrn targetComponentManagerIdUrn = GeniUrn.parse((String)targetComponentManagerId);
        assert (targetComponentManagerIdUrn != null);
        boolean boundUnboundNodes = false;
        for (BasicRspecNode node : model.getNodes()) {
            if (node.getComponentManagerId() != null) continue;
            node.setComponentManagerId(targetComponentManagerId);
            boundUnboundNodes = true;
            node.getLinks().stream().filter(link -> !link.getComponentManagerUrns().contains(targetComponentManagerIdUrn)).forEach(link -> link.getComponentManagerUrns().add(targetComponentManagerIdUrn));
        }
        if (boundUnboundNodes) {
            return model.toGeni3Rspec();
        }
        return rspec;
    }
}

