/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl;

import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.LinkSetting;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.RspecXmlConstants;
import be.iminds.ilabt.jfed.rspec.request.ext.delay.Pipe;
import be.iminds.ilabt.jfed.rspec.request.ext.delay.SliverTypeShaping;
import be.iminds.ilabt.jfed.rspec_fx.StaxRspecFxWriter;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXLinkSetting;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;

public class DelayRspecNode
extends FXRspecNode {
    private final ListProperty<FXLinkSetting> linkSettings = new SimpleListProperty(FXCollections.observableArrayList());

    public ListProperty<FXLinkSetting> getLinkSettings() {
        return this.linkSettings;
    }

    public FXLinkSetting getLinkSetting(RspecInterface fromIface, RspecInterface toIface) {
        assert (fromIface instanceof FXRspecInterface);
        assert (toIface instanceof FXRspecInterface);
        assert (this.interfaces.contains((Object)fromIface));
        assert (this.interfaces.contains((Object)toIface));
        for (FXLinkSetting ls : this.linkSettings) {
            if (ls.getFromIface() != fromIface || ls.getToIface() != toIface) continue;
            return ls;
        }
        return null;
    }

    private void updateLinkSettings() {
        Iterator it = this.linkSettings.iterator();
        while (it.hasNext()) {
            FXLinkSetting ls = (FXLinkSetting)it.next();
            if (!this.interfaces.contains((Object)ls.getFromIface()) || !this.interfaces.contains((Object)ls.getToIface())) {
                it.remove();
            }
            if (ls.getFromIface() != ls.getToIface()) continue;
            it.remove();
        }
        for (FXRspecInterface fromIface : this.interfaces) {
            for (FXRspecInterface toIface : this.interfaces) {
                if (fromIface == toIface) continue;
                boolean missing = true;
                for (FXLinkSetting ls : this.linkSettings) {
                    if (ls.getFromIface() != fromIface || ls.getToIface() != toIface) continue;
                    missing = false;
                    break;
                }
                if (!missing) continue;
                FXLinkSetting newLinkSetting = new FXLinkSetting(fromIface, toIface);
                this.linkSettings.add((Object)newLinkSetting);
            }
        }
    }

    public DelayRspecNode(FXModelRspec modelRspec, String id) {
        super(modelRspec, id);
        this.initialize();
    }

    public DelayRspecNode(FXModelRspec newModelRspec, FXRspecNode rspecNode, RspecNode.InterfaceCopyMethod interfaceCopyMethod) {
        super(newModelRspec, rspecNode, interfaceCopyMethod);
        this.initialize();
    }

    public DelayRspecNode(FXModelRspec newModelRspec, FXRspecNode node) {
        this(newModelRspec, node, RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE);
    }

    private void initialize() {
        ArrayList<ModifiedSliverType> sliverTypeList = new ArrayList<ModifiedSliverType>();
        sliverTypeList.add(new ModifiedSliverType("delay", null, null, null, null, null, null, null, null));
        this.sliverTypes.setAll(sliverTypeList);
        this.interfaces.addListener(observable -> this.updateLinkSettings());
    }

    @Override
    public void setSliverTypeName(String name) {
        throw new UnsupportedOperationException("Sliver type of DelayRspecNode is fixed on 'delay', and cannot be changed");
    }

    @Override
    public void setSliverType(SliverType sliverType) {
        throw new UnsupportedOperationException("Sliver type of DelayRspecNode is fixed on 'delay', and cannot be changed");
    }

    void setPropertiesFromSliverTypeShaping(SliverTypeShaping sliverTypeShaping) throws RspecParseException {
        for (Pipe pipe : sliverTypeShaping.getPipe()) {
            FXRspecInterface sourceIface = this.getInterfaceByClientId(pipe.getSource());
            if (sourceIface == null) {
                throw new RspecParseException(null, "Unknown source-iface '" + pipe.getSource() + "' detected in delay-pipe. All interfaces: " + this.getInterfaces());
            }
            FXRspecInterface targetIface = this.getInterfaceByClientId(pipe.getDest());
            if (targetIface == null) {
                throw new RspecParseException(null, "Unknown target-iface '" + pipe.getDest() + "' detected in delay-pipe. All interfaces: " + this.getInterfaces());
            }
            FXLinkSetting linkSetting = this.getLinkSetting(sourceIface, targetIface);
            if (linkSetting == null) {
                linkSetting = new FXLinkSetting(sourceIface, targetIface);
                this.linkSettings.add((Object)linkSetting);
            }
            if (pipe.getCapacity() != null) {
                linkSetting.setCapacity_Kbps(new Long(pipe.getCapacity().intValue()));
            }
            if (pipe.getLatency() != null) {
                linkSetting.setLatency_ms(pipe.getLatency());
            }
            if (pipe.getPacketLoss() == null) continue;
            linkSetting.setPacketLoss(Double.valueOf(pipe.getPacketLoss().floatValue()));
        }
    }

    private SliverTypeShaping getSliverTypeShaping() {
        SliverTypeShaping res = new SliverTypeShaping();
        for (LinkSetting linkSetting : this.linkSettings) {
            Pipe pipe = new Pipe();
            if (linkSetting.getFromIface() != null) {
                pipe.setSource(linkSetting.getFromIface().getClientId());
            }
            if (linkSetting.getToIface() != null) {
                pipe.setDest(linkSetting.getToIface().getClientId());
            }
            if (linkSetting.isCapacitySet()) {
                pipe.setCapacity(Integer.valueOf(new Long(linkSetting.getCapacity_Kbps()).intValue()));
            }
            if (linkSetting.isLatencySet()) {
                pipe.setLatency(Integer.valueOf(linkSetting.getLatency_ms()));
            }
            if (linkSetting.isPacketLossSet()) {
                pipe.setPacketLoss(Float.valueOf(new Double(linkSetting.getPacketLoss()).floatValue()));
            }
            res.getPipe().add(pipe);
        }
        return res;
    }

    @Override
    public ObservableList<SliverType> getSliverTypes() {
        return this.sliverTypes;
    }

    private class ModifiedSliverType
    extends SliverType {
        ModifiedSliverType(String name, Collection<DiskImage> diskImages, Integer xenCores, Integer xenRam, Integer xenDisk, List<String> diskImageListRefs, List<String> flavorListRefs, List<String> flavors, Collection<ExtraXml> other) {
            super(name, diskImages, xenCores, xenRam, xenDisk, diskImageListRefs, flavorListRefs, flavors, other);
        }

        public List<ExtraXml> getExtraXml() {
            ArrayList<ExtraXml> res = new ArrayList<ExtraXml>(super.getExtraXml());
            res.add(new ExtraXml(){

                public void writeEvents(XMLEventWriter w) throws XMLStreamException {
                    StaxRspecFxWriter.getInstance().writeSliverTypeShaping(w, DelayRspecNode.this.getSliverTypeShaping());
                }

                public QName getStartElementName() {
                    return RspecXmlConstants.Q_SLIVER_TYPE_SHAPING;
                }

                public Location getLocation() {
                    return null;
                }
            });
            return res;
        }
    }
}

