/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXRspecInterface
implements RspecInterface {
    private static final Logger LOG = LoggerFactory.getLogger(FXRspecInterface.class);
    protected final FXModelRspec modelRspec;
    protected final ObjectProperty<GeniUrn> sliverId = new SimpleObjectProperty();
    private final List<ExtraXml> extraXml = new ArrayList<ExtraXml>();
    private final List<ExtraXml> extraXmlForRef = new ArrayList<ExtraXml>();
    private final StringProperty clientId = new SimpleStringProperty();
    private final StringProperty componentId = new SimpleStringProperty();
    private final StringProperty componentName = new SimpleStringProperty();
    private final StringProperty role = new SimpleStringProperty();
    private final StringProperty publicIpv4 = new SimpleStringProperty();
    private final StringProperty macAddress = new SimpleStringProperty();
    private final ObjectProperty<Integer> felixVlan = new SimpleObjectProperty(null);
    private final ListProperty<RspecInterface.IpAddress> ipAddresses = new SimpleListProperty(FXCollections.observableArrayList());
    private FXRspecNode node;
    private FXRspecLink link;

    FXRspecInterface(@Nonnull FXRspecNode node, String clientId) {
        this.modelRspec = node.getRspec();
        this.node = node;
        this.clientId.setValue(clientId);
        for (RspecInterface existingIface : node.getInterfaces()) {
            if (existingIface != this && !this.getUniqueId().equals(existingIface.getUniqueId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + existingIface.getUniqueId() + "\"");
        }
        node.addInterface(this);
        assert (!this.isNodeUnbound());
        assert (this.isLinkUnbound());
        assert (!this.isBound());
    }

    FXRspecInterface(@Nonnull FXRspecLink link, String clientId) {
        this.modelRspec = link.getRspec();
        this.node = null;
        this.link = link;
        this.clientId.setValue(clientId);
        for (RspecInterface existingIface : link.getInterfaces()) {
            if (existingIface != this && !this.getUniqueId().equals(existingIface.getUniqueId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + existingIface.getUniqueId() + "\"");
        }
        link.addInterface(this);
        assert (this.isNodeUnbound());
        assert (!this.isLinkUnbound());
        assert (!this.isBound());
    }

    FXRspecInterface(@Nonnull FXRspecNode node, @Nonnull FXRspecLink link, String clientId) {
        assert (node.getRspec() == link.getRspec());
        this.modelRspec = node.getRspec();
        this.node = node;
        this.link = link;
        this.clientId.setValue(clientId);
        for (RspecInterface existingIface : node.getInterfaces()) {
            if (existingIface != this && !this.getUniqueId().equals(existingIface.getUniqueId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + existingIface.getUniqueId() + "\"");
        }
        for (RspecInterface existingIface : link.getInterfaces()) {
            if (existingIface != this && !this.getUniqueId().equals(existingIface.getUniqueId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + existingIface.getUniqueId() + "\"");
        }
        node.addInterface(this);
        link.addInterface(this);
        if (node.getComponentManagerId() != null && !link.getComponentManagerUrns().contains((Object)node.getComponentManagerId())) {
            link.getComponentManagerUrns().add((Object)node.getComponentManagerId());
        }
        assert (!this.isNodeUnbound());
        assert (!this.isLinkUnbound());
        assert (this.isBound());
    }

    public void overwritePropertiesWith(RspecInterface other, boolean overwriteWithNull) {
        if (overwriteWithNull || other.getSliverId() != null) {
            this.sliverId.setValue((Object)other.getSliverId());
        }
        if (overwriteWithNull || other.getClientId() != null) {
            this.clientId.setValue(other.getClientId());
        }
        if (overwriteWithNull || other.getComponentId() != null) {
            this.componentId.setValue(other.getComponentId());
        }
        if (overwriteWithNull || other.getComponentName() != null) {
            this.componentName.setValue(other.getComponentName());
        }
        if (overwriteWithNull || other.getRole() != null) {
            this.role.setValue(other.getRole());
        }
        if (overwriteWithNull || other.getPublicIpv4() != null) {
            this.publicIpv4.setValue(other.getPublicIpv4());
        }
        if (overwriteWithNull || other.getMacAddress() != null) {
            this.macAddress.setValue(other.getMacAddress());
        }
        if (overwriteWithNull || other.getFelixVlan() != null) {
            this.felixVlan.setValue((Object)other.getFelixVlan());
        }
        if (overwriteWithNull || other.getIpAddresses() != null && !other.getIpAddresses().isEmpty()) {
            this.ipAddresses.setAll((Collection)other.getIpAddresses());
        }
        if (overwriteWithNull || other.getExtraXml() != null && !other.getExtraXml().isEmpty()) {
            this.extraXml.clear();
            this.extraXml.addAll(other.getExtraXml());
        }
        if (overwriteWithNull || other.getRefExtraXml() != null && !other.getRefExtraXml().isEmpty()) {
            this.extraXmlForRef.clear();
            this.extraXmlForRef.addAll(other.getRefExtraXml());
        }
    }

    public void bindLink(RspecLink rspecLink) {
        assert (rspecLink instanceof FXRspecLink);
        if (this.node == null || this.link != null) {
            throw new IllegalStateException("bindLink can only be called once, and after the matching constructor  node=" + (String)(this.node == null ? "null" : "not null with uniqId=" + this.node.getUniqueId()) + "  link=" + (String)(this.link == null ? "null" : "not null with uniqId=" + this.link.getUniqueId()) + " and addr=" + System.identityHashCode(this.link) + "  would bind to link with uniqId=" + rspecLink.getUniqueId() + " and addr=" + System.identityHashCode(rspecLink));
        }
        this.link = (FXRspecLink)rspecLink;
        for (RspecInterface existingIface : this.link.getInterfaces()) {
            if (existingIface != this && !this.getClientId().equals(existingIface.getClientId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + existingIface.getClientId() + "\"");
        }
        this.link.addInterface(this);
    }

    public void bindNode(RspecNode rspecNode) {
        assert (rspecNode instanceof FXRspecNode);
        if (this.node != null || this.link == null) {
            throw new IllegalStateException("bindNode can only be called once, and after the matching constructor. node=" + (this.node == null ? "null" : "not null") + " link=" + (this.link == null ? "null" : "not null"));
        }
        this.node = (FXRspecNode)rspecNode;
        for (RspecInterface existingIface : this.node.getInterfaces()) {
            if (existingIface != this && !this.getClientId().equals(existingIface.getClientId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + existingIface.getClientId() + "\"");
        }
        this.node.addInterface(this);
    }

    public void moveToNode(RspecNode newRspecNode) {
        FXRspecNode oldRspecNode = this.node;
        assert (this.node != null);
        assert (oldRspecNode instanceof FXRspecNode);
        assert (newRspecNode instanceof FXRspecNode);
        if (this.node == null) {
            throw new IllegalStateException("moveToNode can only be called an interface that is bound to a nodenode=" + (this.node == null ? "null" : "not null") + " link=" + (this.link == null ? "null" : "not null"));
        }
        this.node = (FXRspecNode)newRspecNode;
        for (RspecInterface existingIface : newRspecNode.getInterfaces()) {
            if (existingIface != this && !this.getClientId().equals(existingIface.getClientId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + existingIface.getClientId() + "\"");
        }
        oldRspecNode.removeInterface(this);
        ((FXRspecNode)newRspecNode).addInterface(this);
    }

    public void moveToLink(RspecLink newRspecLink) {
        FXRspecLink oldRspecLink = this.link;
        assert (this.link != null);
        assert (oldRspecLink instanceof FXRspecLink);
        assert (newRspecLink instanceof FXRspecLink);
        if (this.link == null) {
            throw new IllegalStateException("moveToLink can only be called an interface that is bound to a link");
        }
        this.link = (FXRspecLink)newRspecLink;
        for (RspecInterface existingIface : newRspecLink.getInterfaces()) {
            if (existingIface != this && !this.getClientId().equals(existingIface.getClientId())) continue;
            throw new RuntimeException("Duplicate interfaces in XML Rspec: id=\"" + existingIface.getClientId() + "\"");
        }
        oldRspecLink.removeInterface(this);
        ((FXRspecLink)newRspecLink).addInterface(this);
    }

    public boolean isBound() {
        return this.node != null && this.link != null;
    }

    public boolean isUnbound() {
        return this.node == null || this.link == null;
    }

    public boolean isLinkUnbound() {
        return this.link == null;
    }

    public boolean isNodeUnbound() {
        return this.node == null;
    }

    public boolean isLinkBound() {
        return this.link != null;
    }

    public boolean isNodeBound() {
        return this.node != null;
    }

    public String getUniqueId() {
        return BasicStringRspec.makeUniqueInterfaceId((String)((String)this.clientId.get()), (String)((String)this.componentId.get()), this.node == null ? null : this.node.getUniqueId());
    }

    public String getClientId() {
        return (String)this.clientId.get();
    }

    public StringProperty clientIdProperty() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId.set((Object)clientId);
    }

    public String getComponentId() {
        return (String)this.componentId.get();
    }

    public StringProperty componentIdProperty() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId.set((Object)componentId);
    }

    public String getComponentName() {
        return (String)this.componentName.get();
    }

    public StringProperty componentNameProperty() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName.set((Object)componentName);
    }

    public String getRole() {
        return (String)this.role.get();
    }

    public StringProperty roleProperty() {
        return this.role;
    }

    public void setRole(String role) {
        this.role.set((Object)role);
    }

    public String getPublicIpv4() {
        return (String)this.publicIpv4.get();
    }

    public StringProperty publicIpv4Property() {
        return this.publicIpv4;
    }

    public void setPublicIpv4(String publicIpv4) {
        this.publicIpv4.set((Object)publicIpv4);
    }

    public GeniUrn getSliverId() {
        return (GeniUrn)this.sliverId.get();
    }

    public void setSliverId(String sliverId) {
        if (sliverId == null) {
            this.sliverId.set(null);
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)sliverId);
        if (geniUrn != null) {
            this.sliverId.set((Object)geniUrn);
        } else {
            LOG.warn("Could not set sliverId to {} as it is not a valid URN!", (Object)sliverId);
            this.sliverId.set(null);
        }
    }

    public void setSliverId(GeniUrn sliverId) {
        this.sliverId.set((Object)sliverId);
    }

    public ObjectProperty<GeniUrn> sliverIdProperty() {
        return this.sliverId;
    }

    public String getMacAddress() {
        return (String)this.macAddress.get();
    }

    public void setMacAddress(String value) {
        this.macAddress.set((Object)value);
    }

    public StringProperty macAddressProperty() {
        return this.macAddress;
    }

    public Integer getFelixVlan() {
        return (Integer)this.felixVlan.get();
    }

    public ObjectProperty<Integer> felixVlanProperty() {
        return this.felixVlan;
    }

    public void setFelixVlan(Integer felixVlan) {
        this.felixVlan.setValue((Object)felixVlan);
    }

    public ObservableList<RspecInterface.IpAddress> getIpAddresses() {
        return this.ipAddresses;
    }

    public List<ExtraXml> getExtraXml() {
        return this.extraXml;
    }

    public List<ExtraXml> getRefExtraXml() {
        return this.extraXmlForRef;
    }

    public FXRspecNode getNode() throws IllegalStateException {
        if (this.node == null) {
            throw new IllegalStateException("bindNode was not yet called for interface with clientId=" + this.clientId);
        }
        return this.node;
    }

    public FXRspecLink getLink() throws IllegalStateException {
        if (this.link == null) {
            throw new IllegalStateException("bindLink was not yet called for interface with clientId=" + this.clientId);
        }
        return this.link;
    }

    public boolean delete() {
        boolean removed;
        if (this.link == null && this.node == null) {
            return false;
        }
        if (this.link != null) {
            removed = this.link.removeInterface(this);
            assert (removed);
        }
        if (this.node != null) {
            removed = this.node.removeInterface(this);
            assert (removed);
        }
        this.node = null;
        this.link = null;
        return true;
    }

    public FXModelRspec getRspec() {
        return this.modelRspec;
    }

    public String toString() {
        return "RspecInterface{id=" + (String)this.clientId.get() + "}";
    }
}

