/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.dao;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class BugReportCallMapper
implements ResultSetMapper<SerializableApiCallDetails> {
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    @Override
    public SerializableApiCallDetails map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        Date stopTimeDate;
        Date startTimeDate;
        if (BugReportCallMapper.hasColumn(r, "content_json_text")) {
            SerializableApiCallDetails serializableApiCallDetails;
            String json = r.getString("content_json_text");
            try {
                serializableApiCallDetails = MAPPER.readValue(json, SerializableApiCallDetails.class);
            }
            catch (JsonProcessingException e) {
                throw new WebApplicationException("Error converting SerializableApiCallDetails from JSON in DB", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (IOException e) {
                throw new WebApplicationException("IOException converting SerializableApiCallDetails from JSON in DB", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
            }
            assert (serializableApiCallDetails.getId() == r.getInt("call_id"));
            return serializableApiCallDetails;
        }
        String authorityUrn = BugReportCallMapper.removeQuotes(r.getString("content_authorityUrn"));
        String authorityName = BugReportCallMapper.removeQuotes(r.getString("content_authorityName"));
        String callServerUrl = BugReportCallMapper.removeQuotes(r.getString("content_callServerUrl"));
        String apiName = BugReportCallMapper.removeQuotes(r.getString("content_apiName"));
        String geniMethodName = BugReportCallMapper.removeQuotes(r.getString("content_geniMethodName"));
        String javaMethodName = BugReportCallMapper.removeQuotes(r.getString("content_javaMethodName"));
        String startTime = BugReportCallMapper.removeQuotes(r.getString("content_startTime"));
        String stopTime = BugReportCallMapper.removeQuotes(r.getString("content_stopTime"));
        if (startTime != null) {
            try {
                startTimeDate = RFC3339Util.iso8601StringToDate(startTime);
            }
            catch (ParseException e) {
                startTimeDate = null;
            }
        } else {
            startTimeDate = null;
        }
        if (stopTime != null) {
            try {
                stopTimeDate = RFC3339Util.iso8601StringToDate(stopTime);
            }
            catch (ParseException e) {
                stopTimeDate = null;
            }
        } else {
            stopTimeDate = null;
        }
        int id = r.getInt("call_id");
        SerializableApiCallDetails serializableApiCallDetails = new SerializableApiCallDetails(id, authorityName, authorityUrn, null, callServerUrl, null, null, null, null, null, null, null, null, null, null, null, null, null, null, apiName, javaMethodName, geniMethodName, null, null, null, null, null, null, null, null, null, startTimeDate, stopTimeDate, null, null);
        return serializableApiCallDetails;
    }

    @Nullable
    public static String removeQuotes(@Nullable String orig) {
        if (orig == null) {
            return null;
        }
        if (orig.length() >= 2 && orig.startsWith("\"") && orig.endsWith("\"")) {
            return orig.substring(1, orig.length() - 1);
        }
        return orig;
    }

    public static boolean hasColumn(ResultSet rs, String columnName) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columns = rsmd.getColumnCount();
        for (int x = 1; x <= columns; ++x) {
            if (!columnName.equals(rsmd.getColumnName(x))) continue;
            return true;
        }
        return false;
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

