/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.dao;

import be.iminds.ilabt.jfed.bugreport.dao.OAuthAccessToken;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.BasicLdObjectBuilder;
import javax.annotation.Nonnull;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=OAuthAccessToken.class)
public class OAuthAccessTokenBuilder
extends BasicLdObjectBuilder<OAuthAccessToken> {
    private String username;
    private String serviceProviderBaseUrl;
    private String accessToken;

    public OAuthAccessTokenBuilder() {
    }

    public OAuthAccessTokenBuilder(@Nonnull OAuthAccessToken orig) {
        super(orig);
        this.username = orig.getUsername();
        this.serviceProviderBaseUrl = orig.getServiceProviderBaseUrl();
        this.accessToken = orig.getAccessToken();
    }

    @Nonnull
    public OAuthAccessTokenBuilder setUsername(@Nonnull String username) {
        this.username = username;
        return this;
    }

    @Nonnull
    public OAuthAccessTokenBuilder setServiceProviderBaseUrl(@Nonnull String serviceProviderBaseUrl) {
        this.serviceProviderBaseUrl = serviceProviderBaseUrl;
        return this;
    }

    @Nonnull
    public OAuthAccessTokenBuilder setAccessToken(@Nonnull String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Override
    @Nonnull
    public OAuthAccessToken create() {
        if (this.username == null) {
            throw new IllegalStateException("You need to specify username");
        }
        if (this.serviceProviderBaseUrl == null) {
            throw new IllegalStateException("You need to specify serviceProviderBaseUrl");
        }
        if (this.accessToken == null) {
            throw new IllegalStateException("You need to specify accessToken");
        }
        return new OAuthAccessToken(this.username, this.serviceProviderBaseUrl, this.accessToken);
    }
}

