/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.model;

import be.iminds.ilabt.jfed.bugreport.model.ErrorDetails;
import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonInstantRFC3339Serializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
public class Sliver {
    private static final Logger LOG = LoggerFactory.getLogger(Sliver.class);
    private final String sliverUrn;
    private final String currentStatus;
    private final String sliverStatus;
    private final Instant expirationDate;
    private final Boolean hasManifest;
    private final List<String> components;
    private final List<ErrorDetails> errorDetails;

    @JsonCreator
    public Sliver(@JsonProperty(value="sliverUrn") String sliverUrn, @JsonProperty(value="currentStatus") String currentStatus, @JsonProperty(value="sliverStatus") String sliverStatus, @JsonProperty(value="expirationDate") Instant expirationDate, @JsonProperty(value="hasManifest") Boolean hasManifest, @JsonProperty(value="components") List<String> components, @JsonProperty(value="errorDetails") List<ErrorDetails> errorDetails) {
        this.sliverUrn = sliverUrn;
        this.currentStatus = currentStatus;
        this.sliverStatus = sliverStatus;
        this.expirationDate = expirationDate;
        this.hasManifest = hasManifest;
        this.components = components;
        this.errorDetails = errorDetails;
    }

    @JsonProperty
    public static Logger getLOG() {
        return LOG;
    }

    @JsonProperty
    public String getSliverUrn() {
        return this.sliverUrn;
    }

    @JsonProperty
    public String getCurrentStatus() {
        return this.currentStatus;
    }

    @JsonProperty
    public String getSliverStatus() {
        return this.sliverStatus;
    }

    @JsonProperty
    @JsonSerialize(using=JsonInstantRFC3339Serializer.class)
    @JsonDeserialize(using=JsonInstantRFC3339Deserializer.class)
    public Instant getExpirationDate() {
        return this.expirationDate;
    }

    @JsonProperty
    public Boolean getHasManifest() {
        return this.hasManifest;
    }

    @JsonProperty
    public List<String> getComponents() {
        return this.components;
    }

    @JsonProperty
    public List<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getName() + " to JSON", e);
            return "Exception converting Testbed " + this.getClass().getName() + " to JSON: " + e.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sliver)) {
            return false;
        }
        Sliver sliver = (Sliver)o;
        if (this.sliverUrn != null ? !this.sliverUrn.equals(sliver.sliverUrn) : sliver.sliverUrn != null) {
            return false;
        }
        if (this.currentStatus != null ? !this.currentStatus.equals(sliver.currentStatus) : sliver.currentStatus != null) {
            return false;
        }
        if (this.sliverStatus != null ? !this.sliverStatus.equals(sliver.sliverStatus) : sliver.sliverStatus != null) {
            return false;
        }
        if (this.expirationDate != null ? !this.expirationDate.equals(sliver.expirationDate) : sliver.expirationDate != null) {
            return false;
        }
        if (this.hasManifest != null ? !this.hasManifest.equals(sliver.hasManifest) : sliver.hasManifest != null) {
            return false;
        }
        if (this.components != null ? !this.components.equals(sliver.components) : sliver.components != null) {
            return false;
        }
        return this.errorDetails != null ? this.errorDetails.equals(sliver.errorDetails) : sliver.errorDetails == null;
    }

    public int hashCode() {
        int result = this.sliverUrn != null ? this.sliverUrn.hashCode() : 0;
        result = 31 * result + (this.currentStatus != null ? this.currentStatus.hashCode() : 0);
        result = 31 * result + (this.sliverStatus != null ? this.sliverStatus.hashCode() : 0);
        result = 31 * result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
        result = 31 * result + (this.hasManifest != null ? this.hasManifest.hashCode() : 0);
        result = 31 * result + (this.components != null ? this.components.hashCode() : 0);
        result = 31 * result + (this.errorDetails != null ? this.errorDetails.hashCode() : 0);
        return result;
    }
}

