/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.resource;

import be.iminds.ilabt.jfed.bugreport.dao.BugReportCallDao;
import be.iminds.ilabt.jfed.bugreport.dao.BugReportDao;
import be.iminds.ilabt.jfed.bugreport.jira.JiraClient;
import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.bugreport.model.BugReportBuilder;
import be.iminds.ilabt.jfed.bugreport.resource.BugReportCallHtmlWriter;
import be.iminds.ilabt.jfed.bugreport.resource.OAuthResource;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportAccess;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiConfigurationIface;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.fedmon.webapi.base.AbstractWebApiConfigurationIface;
import be.iminds.ilabt.jfed.fedmon.webapi.service.util.EmailSender;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/bugreport")
@Produces(value={"application/json"})
public class BugReportResource {
    private static final Logger LOG = LoggerFactory.getLogger(BugReportResource.class);
    private static final boolean USE_SECURE_CREATE = false;
    @Context
    UriInfo uriInfo;
    private final BugReportDao bugReportDao;
    private final BugReportCallDao bugReportCallDao;
    private final JFedBugReportWebApiConfigurationIface bugReportConfiguration;
    private final AbstractWebApiConfigurationIface webApiConfiguration;
    private final EmailSender emailSender;
    private final OAuthResource oAuthResource;
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    public BugReportResource(@Nonnull BugReportDao bugReportDao, @Nonnull BugReportCallDao bugReportCallDao, @Nonnull JFedBugReportWebApiConfigurationIface bugReportConfiguration, @Nonnull AbstractWebApiConfigurationIface webApiConfiguration, @Nonnull EmailSender emailSender, @Nonnull OAuthResource oAuthResource) {
        this.bugReportDao = bugReportDao;
        this.bugReportCallDao = bugReportCallDao;
        this.bugReportConfiguration = bugReportConfiguration;
        this.webApiConfiguration = webApiConfiguration;
        this.emailSender = emailSender;
        this.oAuthResource = oAuthResource;
    }

    @GET
    @Path(value="{bugReportId}")
    @Produces(value={"application/json"})
    @Timed
    public BugReport get(@NotNull @PathParam(value="bugReportId") Integer bugReportId, @Context HttpServletRequest request) {
        BugReport res;
        boolean hasAdminAccess = this.webApiConfiguration.isAccessAllowed(JFedBugReportAccess.ADMIN, request);
        if (!hasAdminAccess) {
            GeniUrn authenticatedUser = this.webApiConfiguration.getAuthenticatedUserUrn(request);
            if (authenticatedUser == null) {
                LOG.info("Denied permission to get a BugReport because not authenticated. bugReportId=" + bugReportId + " ");
                throw new WebApplicationException("Permission denied. You need to be an authenticated user.", Response.Status.FORBIDDEN);
            }
            BugReport bugReport = this.bugReportDao.getBasics(bugReportId);
            if (bugReport == null) {
                throw new NotFoundException("There is no BugReport with id=" + bugReportId);
            }
            if (bugReport.getReporterUrn() == null || !bugReport.getReporterUrn().equals(authenticatedUser.getValue())) {
                LOG.info("Denied permission to get bugreport call: bugReport.getReporterUrn()=" + bugReport.getReporterUrn() + " authenticatedUser=" + authenticatedUser + " bugReportId=" + bugReportId + " ");
                throw new WebApplicationException("Permission denied. You are not authorized to read this bugreport.", Response.Status.FORBIDDEN);
            }
        }
        if ((res = this.bugReportDao.get(bugReportId)) == null) {
            throw new NotFoundException("There is no BugReport with id=" + bugReportId);
        }
        BugReportBuilder bugReportBuilder = new BugReportBuilder(res);
        this.webApiConfiguration.getUriTool(AbstractWebApiConfigurationIface.UriType.AUTHENTICATED_HTTPS).setUriRecursive(bugReportBuilder);
        this.setBugReportCallIdsToURIs(bugReportBuilder, AbstractWebApiConfigurationIface.UriType.AUTHENTICATED_HTTPS);
        return bugReportBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    public List<BugReport> getAll(@Context HttpServletRequest request) {
        this.webApiConfiguration.assureAccessAllowed(JFedBugReportAccess.ADMIN, request);
        List<BugReport> res = this.bugReportDao.getAllBasics();
        if (res == null) {
            throw new NotFoundException("There are no bugreports");
        }
        List resBuilder = res.stream().map(BugReportBuilder::new).map(brb -> this.webApiConfiguration.getUriTool(AbstractWebApiConfigurationIface.UriType.AUTHENTICATED_HTTPS).setUriRecursive(brb)).collect(Collectors.toList());
        return resBuilder.stream().map(BugReportBuilder::create).collect(Collectors.toList());
    }

    @GET
    @Path(value="{bugReportId}/call/{callId}")
    @Produces(value={"*/*"})
    @Timed
    public Response getCall(@NotNull @PathParam(value="bugReportId") Integer bugReportId, @NotNull @PathParam(value="callId") Integer callId, @Context HttpServletRequest request) {
        boolean hasAdminAccess = this.webApiConfiguration.isAccessAllowed(JFedBugReportAccess.ADMIN, request);
        GeniUrn authenticatedUser = null;
        if (!hasAdminAccess && (authenticatedUser = this.webApiConfiguration.getAuthenticatedUserUrn(request)) == null) {
            LOG.info("Denied permission to get a BugReport call because not authenticated. bugReportId=" + bugReportId + " callId=" + callId);
            throw new WebApplicationException("Permission denied. You need to be an authenticated user.", Response.Status.FORBIDDEN);
        }
        BugReport bugReport = this.bugReportDao.getBasics(bugReportId);
        if (bugReport == null) {
            throw new NotFoundException("There is no BugReport with id=" + bugReportId);
        }
        if (!(hasAdminAccess || bugReport.getReporterUrn() != null && bugReport.getReporterUrn().equals(authenticatedUser.getValue()))) {
            LOG.info("Denied permission to get bugreport call: bugReport.getReporterUrn()=" + bugReport.getReporterUrn() + " authenticatedUser=" + authenticatedUser + " bugReportId=" + bugReportId + " callId=" + callId);
            throw new WebApplicationException("Permission denied. You are not authorized to get calls of this bugreport.", Response.Status.FORBIDDEN);
        }
        final SerializableApiCallDetails res = this.bugReportCallDao.get(bugReportId, callId);
        if (res == null) {
            throw new NotFoundException("There is no SerializableApiCallDetails with bugReportId=" + bugReportId + " callId=" + callId);
        }
        boolean acceptJson = false;
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader != null) {
            acceptJson = acceptHeader.equalsIgnoreCase("application/json");
        }
        if (acceptJson) {
            StreamingOutput stream = new StreamingOutput(){

                @Override
                public void write(OutputStream os) throws IOException, WebApplicationException {
                    MAPPER.writer().writeValue(os, (Object)res);
                }
            };
            return Response.ok((Object)stream, "application/json").build();
        }
        final BugReportCallHtmlWriter htmlWriter = new BugReportCallHtmlWriter(bugReport, res);
        StreamingOutput stream = new StreamingOutput(){

            @Override
            public void write(OutputStream os) throws IOException, WebApplicationException {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(os, "UTF-8");
                htmlWriter.toHtml(outputStreamWriter, false);
                outputStreamWriter.close();
            }
        };
        return Response.ok((Object)stream, "text/html").build();
    }

    @GET
    @Path(value="{bugReportId}/call")
    @Produces(value={"application/json"})
    @Timed
    public List<SerializableApiCallDetails> getAllCalls(@NotNull @PathParam(value="bugReportId") Integer bugReportId, @Context HttpServletRequest request) {
        BugReport bugReport;
        boolean hasAdminAccess = this.webApiConfiguration.isAccessAllowed(JFedBugReportAccess.ADMIN, request);
        if (!hasAdminAccess) {
            GeniUrn authenticatedUser = this.webApiConfiguration.getAuthenticatedUserUrn(request);
            if (authenticatedUser == null) {
                LOG.info("Denied permission to get all BugReport calls because not authenticated. bugReportId=" + bugReportId + " ");
                throw new WebApplicationException("Permission denied. You need to be an authenticated user.", Response.Status.FORBIDDEN);
            }
            BugReport bugReport2 = this.bugReportDao.getBasics(bugReportId);
            if (bugReport2 == null) {
                throw new NotFoundException("There is no BugReport with id=" + bugReportId);
            }
            if (bugReport2.getReporterUrn() == null || !bugReport2.getReporterUrn().equals(authenticatedUser.getValue())) {
                LOG.info("Denied permission to get all bugreport calls: bugReport.getReporterUrn()=" + bugReport2.getReporterUrn() + " authenticatedUser=" + authenticatedUser + " bugReportId=" + bugReportId);
                throw new WebApplicationException("Permission denied. You are not authorized to get all calls of this bugreport.", Response.Status.FORBIDDEN);
            }
        }
        if ((bugReport = this.bugReportDao.get(bugReportId)).getApiCallDetailIds() == null) {
            return Collections.emptyList();
        }
        List<SerializableApiCallDetails> res = this.bugReportCallDao.getMinimalAllForBugReport(bugReportId);
        return res;
    }

    @GET
    @Path(value="{bugReportId}/screenshot")
    @Produces(value={"image/png"})
    @Timed
    public Response getScreenshot(@NotNull @PathParam(value="bugReportId") Integer bugReportId, @Context HttpServletRequest request) {
        BugReport bugReport;
        boolean hasAdminAccess = this.webApiConfiguration.isAccessAllowed(JFedBugReportAccess.ADMIN, request);
        if (!hasAdminAccess) {
            GeniUrn authenticatedUser = this.webApiConfiguration.getAuthenticatedUserUrn(request);
            if (authenticatedUser == null) {
                LOG.info("Denied permission to get all BugReport calls because not authenticated. bugReportId=" + bugReportId + " ");
                throw new WebApplicationException("Permission denied. You need to be an authenticated user.", Response.Status.FORBIDDEN);
            }
            BugReport bugReport2 = this.bugReportDao.getBasics(bugReportId);
            if (bugReport2 == null) {
                throw new NotFoundException("There is no BugReport with id=" + bugReportId);
            }
            if (bugReport2.getReporterUrn() == null || !bugReport2.getReporterUrn().equals(authenticatedUser.getValue())) {
                LOG.info("Denied permission to get all bugreport calls: bugReport.getReporterUrn()=" + bugReport2.getReporterUrn() + " authenticatedUser=" + authenticatedUser + " bugReportId=" + bugReportId);
                throw new WebApplicationException("Permission denied. You are not authorized to get all calls of this bugreport.", Response.Status.FORBIDDEN);
            }
        }
        if ((bugReport = this.bugReportDao.get(bugReportId)).getScreenshot() == null || bugReport.getScreenshot().trim().isEmpty()) {
            return Response.status(Response.Status.NOT_FOUND).entity("This bugreport contains no screenshot").type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        byte[] decodedImage = Base64.decodeBase64(bugReport.getScreenshot());
        if (decodedImage != null) {
            return Response.ok((Object)decodedImage, "image/png").build();
        }
        throw new WebApplicationException("The stored screenshot could not be decoded", Response.Status.INTERNAL_SERVER_ERROR);
    }

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public Response insert(@NotNull BugReport bugReport, @Context HttpServletRequest request) {
        EmailCreationInfo emailCreationInfo;
        boolean hasAdminAccess = this.webApiConfiguration.isAccessAllowed(JFedBugReportAccess.ADMIN, request);
        CreatedBugReportInfo createdBugReportInfo = this.createdBugReport(bugReport);
        try {
            emailCreationInfo = this.createJiraIssue(bugReport, createdBugReportInfo);
        }
        catch (Exception e) {
            LOG.error("Failed to create jira issue. Will fall back to safe email settings.");
            this.emailSender.sendToAdmin("Error in createJiraIssue", "There was an internal error while processing calling createJiraIssue.\nThe fallback was triggered, so a mail will still be sent.\n\nStacktrace:\n" + IOUtils.exceptionToStacktraceString(e));
            emailCreationInfo = this.withoutJiraIssue(bugReport, createdBugReportInfo);
        }
        this.sendNewBugReportMail(bugReport, createdBugReportInfo, emailCreationInfo);
        return Response.created(createdBugReportInfo.newUri).build();
    }

    @Nonnull
    private CreatedBugReportInfo createdBugReport(@NotNull BugReport bugReport) {
        CreatedBugReportInfo createdBugReportInfo = new CreatedBugReportInfo();
        createdBugReportInfo.newId = this.bugReportDao.insert(bugReport);
        createdBugReportInfo.newUri = this.getBugReportURI(createdBugReportInfo.newId, AbstractWebApiConfigurationIface.UriType.AUTHENTICATED_HTTPS);
        createdBugReportInfo.newUriAsString = createdBugReportInfo.newUri.toASCIIString();
        int lastSlashIndex = createdBugReportInfo.newUriAsString.lastIndexOf(47);
        try {
            if (lastSlashIndex != -1) {
                String issueId = createdBugReportInfo.newUriAsString.substring(lastSlashIndex + 1);
                createdBugReportInfo.bugreportViewerUri = new URI("https://flsmonitor.fed4fire.eu/bugreport/detail/" + issueId);
            } else {
                createdBugReportInfo.bugreportViewerUri = new URI("https://flsmonitor.fed4fire.eu/bugreport/");
            }
        }
        catch (URISyntaxException e) {
            LOG.error("Should not occur", e);
            createdBugReportInfo.bugreportViewerUri = null;
        }
        return createdBugReportInfo;
    }

    @Nonnull
    private EmailCreationInfo createJiraIssue(@NotNull BugReport bugReport, CreatedBugReportInfo createdBugReportInfo) {
        EmailCreationInfo emailCreationInfo = new EmailCreationInfo();
        JiraClient jiraClient = this.oAuthResource.getJiraClient();
        if (jiraClient == null) {
            LOG.info("Jira client disabled: will not try to create jira issue");
            return this.withoutJiraIssue(bugReport, createdBugReportInfo);
        }
        if (bugReport.getReportType() == BugReport.ReportType.UNCAUGHT_EXCEPTION) {
            String stackTraceFull = bugReport.getSubject();
            int atLocation = stackTraceFull.lastIndexOf("@");
            String stackTracePartial = atLocation != -1 ? stackTraceFull.substring(0, atLocation) : stackTraceFull;
            try {
                List<String> issueKeys = jiraClient.getIssueKeysMatchingSummarySearch("FEDIBBTDEV", Collections.singletonList(stackTraceFull), true);
                if (!issueKeys.isEmpty()) {
                    emailCreationInfo.issueKeyInEmailSubject = issueKeys.get(0);
                    jiraClient.addComment(issueKeys.get(0), "Another bugreport had the same error: " + createdBugReportInfo.newUri.toASCIIString() + "  " + (createdBugReportInfo.bugreportViewerUri == null ? "" : createdBugReportInfo.bugreportViewerUri.toASCIIString()));
                    emailCreationInfo.sendEmailToJira = false;
                    emailCreationInfo.duplicateIssue = true;
                } else {
                    List<String> relatedIssueKeys = jiraClient.getIssueKeysMatchingSummarySearch("FEDIBBTDEV", Collections.singletonList(stackTracePartial), true);
                    emailCreationInfo.issueKeyInEmailSubject = jiraClient.createIssue("FEDIBBTDEV", bugReport.getSubject(), this.createIssueDescription(bugReport, createdBugReportInfo.newUri, createdBugReportInfo.bugreportViewerUri), "Bug", Arrays.asList("uncaught_exception"), Collections.singletonList("jFed experimenter GUI"), "", null, relatedIssueKeys);
                    emailCreationInfo.sendEmailToJira = false;
                    emailCreationInfo.duplicateIssue = false;
                }
                if (emailCreationInfo.issueKeyInEmailSubject != null) {
                    emailCreationInfo.issueUriForEmail = new URI("https://ibcn-jira.intec.ugent.be/browse/" + emailCreationInfo.issueKeyInEmailSubject);
                }
            }
            catch (Exception e) {
                this.emailSender.sendToAdmin("Error processing UNCAUGHT_EXCEPTION", "There was an internal error while processing an UNCAUGHT_EXCEPTION:\n\n" + IOUtils.exceptionToStacktraceString(e));
                emailCreationInfo.issueKeyInEmailSubject = null;
                emailCreationInfo.issueUriForEmail = null;
                emailCreationInfo.duplicateIssue = false;
            }
        } else {
            try {
                GeniUrn userUrn = GeniUrn.parse(bugReport.getReporterUrn());
                String username = userUrn == null ? "?" : userUrn.getEncodedResourceName();
                String summary = "FB #" + createdBugReportInfo.newId + " (" + username + "): " + bugReport.getSubject();
                String issueTypeName = "Bug";
                String requestTypeName = "Incident";
                boolean aboutExperimenterGui = false;
                boolean sendToServiceDesk = false;
                if (bugReport.getReportType() != null) {
                    switch (bugReport.getReportType()) {
                        case BUG: {
                            issueTypeName = "Bug";
                            aboutExperimenterGui = true;
                            break;
                        }
                        case CONNECTIVITY: {
                            issueTypeName = "Task";
                            requestTypeName = "Problem";
                            sendToServiceDesk = true;
                            break;
                        }
                        case FEATURE: {
                            issueTypeName = "New Feature";
                            break;
                        }
                        case QUESTION: {
                            issueTypeName = "Task";
                            requestTypeName = "Service Request";
                            sendToServiceDesk = true;
                            break;
                        }
                        case OTHER: {
                            issueTypeName = "Task";
                            requestTypeName = "Service Request";
                            sendToServiceDesk = true;
                            break;
                        }
                        default: {
                            issueTypeName = "Bug";
                        }
                    }
                }
                ArrayList<String> requestParticipants = new ArrayList<String>();
                String assignee = "";
                if (this.isWilabBugReport(bugReport)) {
                    assignee = "pbecue";
                    emailCreationInfo.additionalCC.add("Pieter.Becue@ugent.be");
                    emailCreationInfo.additionalCC.add("Vincent.Sercu@ugent.be");
                    requestParticipants.add("pieter.becue@ugent.be");
                    requestParticipants.add("vincent.sercu@ugent.be");
                }
                emailCreationInfo.issueKeyInEmailSubject = jiraClient.createIssue("FEDIBBTDEV", summary, this.createIssueDescription(bugReport, createdBugReportInfo.newUri, createdBugReportInfo.bugreportViewerUri), issueTypeName, Collections.singletonList("fedmon_feedback"), aboutExperimenterGui ? Collections.singletonList("jFed experimenter GUI") : Collections.emptyList(), assignee, null, null);
                emailCreationInfo.sendEmailToJira = false;
                emailCreationInfo.issueUriForEmail = new URI("https://ibcn-jira.intec.ugent.be/browse/" + emailCreationInfo.issueKeyInEmailSubject);
                emailCreationInfo.duplicateIssue = false;
            }
            catch (Exception e) {
                this.emailSender.sendToAdmin("Error processing fedmon feedback", "There was an internal error while processing fedmon feedback:\n\n" + IOUtils.exceptionToStacktraceString(e));
                emailCreationInfo.issueKeyInEmailSubject = null;
                emailCreationInfo.issueUriForEmail = null;
                emailCreationInfo.duplicateIssue = false;
            }
        }
        return emailCreationInfo;
    }

    private boolean isImecBugReport(BugReport bugReport) {
        return bugReport.getRelatedTestbeds().stream().map(GeniUrn::getEncodedTopLevelAuthority).anyMatch(tld -> tld.contains("ilabt."));
    }

    private boolean isWilabBugReport(BugReport bugReport) {
        return bugReport.getRelatedTestbeds().stream().map(GeniUrn::getEncodedTopLevelAuthority).anyMatch(tld -> tld.contains("wilab"));
    }

    @Nonnull
    private EmailCreationInfo withoutJiraIssue(@NotNull BugReport bugReport, CreatedBugReportInfo createdBugReportInfo) {
        EmailCreationInfo emailCreationInfo = new EmailCreationInfo();
        emailCreationInfo.issueKeyInEmailSubject = null;
        emailCreationInfo.issueUriForEmail = null;
        emailCreationInfo.sendEmailNeeded = true;
        emailCreationInfo.sendEmailToJira = true;
        return emailCreationInfo;
    }

    private void sendNewBugReportMail(@NotNull BugReport bugReport, CreatedBugReportInfo createdBugReportInfo, EmailCreationInfo emailCreationInfo) {
        if (emailCreationInfo.sendEmailNeeded) {
            try {
                ArrayList<InternetAddress> tos = new ArrayList<InternetAddress>(this.bugReportConfiguration.getBugReportTos());
                ArrayList<InternetAddress> replyTos = new ArrayList<InternetAddress>();
                if (this.bugReportConfiguration.getBugReportJiraAddresses() != null) {
                    if (emailCreationInfo.sendEmailToJira) {
                        tos.addAll(this.bugReportConfiguration.getBugReportJiraAddresses());
                    } else {
                        replyTos.add(this.bugReportConfiguration.getBugReportFrom());
                        replyTos.addAll(this.bugReportConfiguration.getBugReportJiraAddresses());
                    }
                }
                ArrayList ccsWithoutUser = new ArrayList();
                ArrayList<InternetAddress> ccsWithUser = new ArrayList<InternetAddress>();
                if (bugReport.getMail() != null && !bugReport.getMail().trim().isEmpty()) {
                    if (!bugReport.getReportTypeOrDefault().equals((Object)BugReport.ReportType.UNCAUGHT_EXCEPTION)) {
                        try {
                            InternetAddress userAddress = new InternetAddress(bugReport.getMail());
                            ccsWithUser.add(userAddress);
                            if (!replyTos.isEmpty()) {
                                replyTos.add(userAddress);
                            }
                        }
                        catch (AddressException e) {
                            LOG.warn("Invalid user email address \"" + bugReport.getMail() + "\". Will not try to CC to user.", e);
                        }
                    } else {
                        LOG.debug("Skipped adding user email because this is an UNCAUGHT_EXCEPTION bugreport.");
                    }
                }
                boolean isWall2User = bugReport.getReporterUrn() != null && bugReport.getReporterUrn().startsWith("urn:publicid:IDN+wall2.ilabt.iminds.be+user+");
                String body = this.createMailBody(false, emailCreationInfo.duplicateIssue, bugReport, createdBugReportInfo.newUri, createdBugReportInfo.bugreportViewerUri, emailCreationInfo.issueUriForEmail);
                String idHelper = "#" + createdBugReportInfo.newId + (String)(emailCreationInfo.issueKeyInEmailSubject == null ? "" : " (" + emailCreationInfo.issueKeyInEmailSubject + ")");
                String subject = "jFed Feedback " + idHelper + ": " + bugReport.getSubject();
                if (bugReport.getReportTypeOrDefault().equals((Object)BugReport.ReportType.UNCAUGHT_EXCEPTION)) {
                    subject = "jFed UncaughtEx " + idHelper + ": " + bugReport.getSubject();
                }
                ArrayList<InternetAddress> finalAdminMailCCs = new ArrayList<InternetAddress>(bugReport.getPostOnPublicListOrDefault() ? ccsWithoutUser : ccsWithUser);
                ArrayList<InternetAddress> finalPublicMailCCs = new ArrayList<InternetAddress>(ccsWithUser);
                if (!emailCreationInfo.additionalCC.isEmpty()) {
                    for (String cc : emailCreationInfo.additionalCC) {
                        try {
                            finalAdminMailCCs.add(new InternetAddress(cc));
                            finalPublicMailCCs.add(new InternetAddress(cc));
                        }
                        catch (AddressException e) {
                            LOG.error("AddressException adding additionalCC \"" + cc + "\". Will ignore. ");
                        }
                    }
                }
                this.emailSender.sendTo(this.bugReportConfiguration.getBugReportFrom(), replyTos, tos, finalAdminMailCCs, subject, body);
                if (bugReport.getPostOnPublicListOrDefault()) {
                    if (isWall2User) {
                        tos.addAll(this.bugReportConfiguration.getBugReportPublicTos());
                        if (!replyTos.isEmpty()) {
                            replyTos.addAll(this.bugReportConfiguration.getBugReportPublicTos());
                        }
                        body = this.createMailBody(true, false, bugReport, createdBugReportInfo.newUri, createdBugReportInfo.bugreportViewerUri, null);
                        subject = "jFed Feedback #" + createdBugReportInfo.newId + ": " + bugReport.getSubject();
                        if (bugReport.getReportTypeOrDefault().equals((Object)BugReport.ReportType.UNCAUGHT_EXCEPTION)) {
                            subject = "jFed UncaughtEx #" + createdBugReportInfo.newId + ": " + bugReport.getSubject();
                        }
                        this.emailSender.sendTo(this.bugReportConfiguration.getBugReportFrom(), replyTos, tos, finalPublicMailCCs, subject, body);
                    } else {
                        LOG.info("Skipping public list mail because user is not a wall2 user.");
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Something went wrong sending a mail to the admin about a new bugreport", t);
                try {
                    this.emailSender.sendExceptionToAdmin("bugreport.create " + createdBugReportInfo.newId, t);
                }
                catch (Throwable t2) {
                    LOG.error("Something went wrong sending a mail to the admin about the error creating a new bugreport", t2);
                }
            }
        }
    }

    @Nonnull
    private String createIssueDescription(@Nonnull BugReport bugReport, @Nonnull URI newUri, @Nullable URI bugreportViewerUri) {
        Object desc = "";
        desc = (String)desc + "BugReport json: [" + newUri.toASCIIString() + "]\n";
        if (bugreportViewerUri != null) {
            desc = (String)desc + "BugReport view: [" + bugreportViewerUri.toASCIIString() + "]\n";
        }
        desc = (String)desc + "\n";
        desc = (String)desc + "User email: [mailto:" + bugReport.getMail() + "]\n";
        desc = (String)desc + "User URN: {{" + bugReport.getReporterUrn() + "}}\n";
        desc = (String)desc + "\n";
        desc = (String)desc + "Feedback:\n";
        if (!bugReport.getReportTypeOrDefault().equals((Object)BugReport.ReportType.OTHER)) {
            desc = (String)desc + "* Type: {{" + bugReport.getReportTypeOrDefault().getHrn() + "}}\n";
        }
        if (!bugReport.getReportTargetOrDefault().equals((Object)BugReport.ReportTarget.OTHER)) {
            desc = (String)desc + "* About: {{" + bugReport.getReportTargetOrDefault().getHrn() + "}}\n";
        }
        if (bugReport.getRelatedTestbeds() != null && !bugReport.getRelatedTestbeds().isEmpty()) {
            desc = (String)desc + "* Related testbeds:\n";
            desc = (String)desc + bugReport.getRelatedTestbeds().stream().map(ResourceUrn::getValue).map(s2 -> "** {{" + s2 + "}}").collect(Collectors.joining("\n")) + "\n";
        }
        desc = (String)desc + "* Description:\n";
        desc = (String)desc + "{quote}\n";
        desc = (String)desc + bugReport.getDescription() + "\n";
        desc = (String)desc + "{quote}\n";
        desc = (String)desc + "* jFed Version: " + bugReport.getVersion() + "\n";
        desc = (String)desc + "* jFed Environment: " + bugReport.getEnvironment() + "\n";
        desc = (String)desc + "* Send to mailinglist: " + (bugReport.getPostOnPublicListOrDefault() ? "??Yes??" : "??No??") + "\n";
        desc = (String)desc + "* Included calls: " + (String)(bugReport.getApiCallDetailIds() == null ? "Unknown (at time of issue creation)" : "" + bugReport.getApiCallDetailIds().size()) + "\n";
        String screenshotUri = newUri.toASCIIString() + "/screenshot";
        if (bugReport.getScreenshot() != null && !bugReport.getScreenshot().trim().isEmpty()) {
            desc = (String)desc + "* Includes screenshot: Yes:\n";
            desc = (String)desc + "!" + screenshotUri + "|align=right, vspace=4!\n";
        } else {
            desc = (String)desc + "* Includes screenshot: No\n";
        }
        desc = (String)desc + "\n\n";
        return desc;
    }

    @Nonnull
    private String createMailBody(boolean publicList, boolean isDuplicate, @Nonnull BugReport bugReport, @Nonnull URI newUri, @Nullable URI bugreportViewerUri, @Nullable URI issueUri) {
        String body = "The jFed Experimenter GUI sent feedback for user " + bugReport.getMail() + "\n";
        body = body + "\n";
        if (isDuplicate) {
            body = body + "\n";
            body = body + "**********************************************************\n";
            body = body + "This issue was already reported: " + (issueUri == null ? "(unknown issue)" : issueUri.toASCIIString()) + "\n";
            body = body + "No new issue has been created.\n";
            body = body + "**********************************************************\n";
            body = body + "\n";
            body = body + "\n";
        }
        body = body + "Feedback:\n";
        if (!bugReport.getReportTypeOrDefault().equals((Object)BugReport.ReportType.OTHER)) {
            body = body + "  Type: " + bugReport.getReportTypeOrDefault().getHrn() + "\n";
        }
        if (!bugReport.getReportTargetOrDefault().equals((Object)BugReport.ReportTarget.OTHER)) {
            body = body + "  About: " + bugReport.getReportTargetOrDefault().getHrn() + "\n";
        }
        if (bugReport.getRelatedTestbeds() != null && !bugReport.getRelatedTestbeds().isEmpty()) {
            String prefix = "  Related testbeds: ";
            String spaces = "                    ";
            body = body + prefix + bugReport.getRelatedTestbeds().stream().map(ResourceUrn::getValue).collect(Collectors.joining("\n" + spaces)) + "\n";
        }
        body = body + "\n";
        String descriptionPrefix = "Description: ";
        body = body + descriptionPrefix + "\n" + TextUtil.indent(3, bugReport.getDescription()) + "\n";
        body = body + "\n\n";
        if (!publicList) {
            boolean isWall2User = bugReport.getReporterUrn() != null && bugReport.getReporterUrn().startsWith("urn:publicid:IDN+wall2.ilabt.iminds.be+user+");
            body = body + "Details:\n";
            body = body + "  User URN: " + bugReport.getReporterUrn() + "\n";
            if (!isWall2User && bugReport.getPostOnPublicListOrDefault()) {
                body = body + "            **WARNING** This is not a wall2 user, yet a mail to the public list was requested. (will not send mail to public list)\n";
            }
            body = body + "  User email: " + bugReport.getMail() + "\n";
            body = body + "  jFed Version: " + bugReport.getVersion() + "\n";
            body = body + "  jFed Environment: " + bugReport.getEnvironment() + "\n";
            body = body + "  Send to mailinglist: " + (bugReport.getPostOnPublicListOrDefault() ? "Yes" : "No") + "\n";
            body = body + "  Included calls: " + (String)(bugReport.getApiCallDetailIds() == null ? "Unknown (at time of this mail)" : "" + bugReport.getApiCallDetailIds().size()) + "\n";
            String screenshotUri = newUri.toASCIIString() + "/screenshot";
            if (bugReport.getScreenshot() != null && !bugReport.getScreenshot().trim().isEmpty()) {
                body = body + "  Includes screenshot: " + (String)(bugReport.getScreenshot() != null && !bugReport.getScreenshot().trim().isEmpty() ? "Yes: " + screenshotUri : "No") + "\n";
            }
            body = body + "\n\n";
            body = body + "jFed admins can find additional details at: " + newUri.toASCIIString();
            if (bugreportViewerUri != null) {
                body = body + " and " + bugreportViewerUri.toASCIIString();
            }
            body = body + "\n";
            if (issueUri != null) {
                body = body + "jFed admins can access the Jira issue: " + issueUri.toASCIIString() + "\n";
            }
        }
        return body;
    }

    @POST
    @Path(value="{bugReportId}/call")
    @Consumes(value={"application/json"})
    @Timed
    public Response insertCall(@NotNull @PathParam(value="bugReportId") Integer bugReportId, @NotNull SerializableApiCallDetails serializableApiCallDetails, @Context HttpServletRequest request) {
        boolean hasAdminAccess = this.webApiConfiguration.isAccessAllowed(JFedBugReportAccess.ADMIN, request);
        int callId = serializableApiCallDetails.getId();
        int rowsInserted = this.bugReportCallDao.insert(bugReportId, callId, serializableApiCallDetails);
        if (rowsInserted != 1) {
            throw new WebApplicationException("Could not include call. rowsInserted=" + rowsInserted, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.created(this.getBugReportCallURI(bugReportId, callId, AbstractWebApiConfigurationIface.UriType.AUTHENTICATED_HTTPS)).build();
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull @PathParam(value="id") Integer id, @Context HttpServletRequest request) {
        this.webApiConfiguration.assureAccessAllowed(JFedBugReportAccess.ADMIN, request);
        throw new WebApplicationException("not yet implemented", Response.Status.NOT_IMPLEMENTED);
    }

    @DELETE
    @Path(value="{bugReportId}/call/{callId}")
    @Timed
    public void deleteCall(@NotNull @PathParam(value="bugReportId") Integer bugReportId, @NotNull @PathParam(value="callId") Integer callId, @Context HttpServletRequest request) {
        this.webApiConfiguration.assureAccessAllowed(JFedBugReportAccess.ADMIN, request);
        throw new WebApplicationException("not yet implemented", Response.Status.NOT_IMPLEMENTED);
    }

    private URI getBugReportURI(int bugReportId, AbstractWebApiConfigurationIface.UriType uriType) {
        return this.webApiConfiguration.getUriTool(uriType).getUriUsingFedmonObject(BugReport.class, bugReportId);
    }

    private URI getBugReportCallURI(int bugReportId, int callId, AbstractWebApiConfigurationIface.UriType uriType) {
        return this.webApiConfiguration.getUriTool(uriType).getUriUsingFedmonObject(BugReport.class, bugReportId + "/call/" + callId);
    }

    private void setBugReportCallIdsToURIs(BugReportBuilder bugReportBuilder, AbstractWebApiConfigurationIface.UriType uriType) {
        if (bugReportBuilder.getId() == null || bugReportBuilder.getApiCallDetailIds() == null) {
            return;
        }
        bugReportBuilder.setApiCallDetailUris(bugReportBuilder.getApiCallDetailIds().stream().map(callId -> this.getBugReportCallURI((Integer)bugReportBuilder.getId(), (int)callId, uriType)).collect(Collectors.toList()));
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }

    private static class CreatedBugReportInfo {
        private Integer newId;
        private URI newUri;
        private String newUriAsString;
        private URI bugreportViewerUri;

        private CreatedBugReportInfo() {
        }
    }

    private static class EmailCreationInfo {
        private boolean duplicateIssue = false;
        private boolean sendEmailNeeded = true;
        private String issueKeyInEmailSubject = null;
        @NotNull
        private final List<String> additionalCC = new ArrayList<String>();
        private URI issueUriForEmail = null;
        private boolean sendEmailToJira = true;

        private EmailCreationInfo() {
        }
    }
}

