/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.service;

import be.iminds.ilabt.jfed.bugreport.dao.BugReportCallDao;
import be.iminds.ilabt.jfed.bugreport.dao.BugReportDao;
import be.iminds.ilabt.jfed.bugreport.dao.OAuthDao;
import be.iminds.ilabt.jfed.bugreport.resource.BugReportResource;
import be.iminds.ilabt.jfed.bugreport.resource.OAuthResource;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiConfiguration;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiConfigurationIface;
import be.iminds.ilabt.jfed.fedmon.webapi.base.AbstractWebApiApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.base.AbstractWebApiConfigurationIface;
import be.iminds.ilabt.jfed.fedmon.webapi.service.util.EmailSender;
import io.dropwizard.setup.Environment;
import org.skife.jdbi.v2.DBI;

public class JFedBugReportWebApiApplication
extends AbstractWebApiApplication<JFedBugReportWebApiConfiguration> {
    public static void main(String[] args) throws Exception {
        new JFedBugReportWebApiApplication().run(args);
    }

    public JFedBugReportWebApiApplication() {
        super("jfed-bugreport-migrations.xml");
    }

    @Override
    public String getName() {
        return "fedmon-webapi";
    }

    @Override
    public void run(JFedBugReportWebApiConfiguration configuration, Environment environment) {
        super.run(configuration, environment);
        this.initializeDaosAndResources(configuration, environment, this.jdbi);
    }

    @Override
    public void initializeDaosAndResources(JFedBugReportWebApiConfiguration configuration, Environment environment, DBI jdbi) {
        JFedBugReportWebApiApplication.initializeDaosAndResourcesHelper(configuration, environment, jdbi, this.emailSender);
    }

    public static <Conf extends JFedBugReportWebApiConfigurationIface & AbstractWebApiConfigurationIface> void initializeDaosAndResourcesHelper(Conf configuration, Environment environment, DBI jdbi, EmailSender emailSender) {
        BugReportDao bugReportDao = jdbi.onDemand(BugReportDao.class);
        BugReportCallDao bugReportCallDao = jdbi.onDemand(BugReportCallDao.class);
        OAuthDao oAuthDao = jdbi.onDemand(OAuthDao.class);
        OAuthResource oAuthResource = new OAuthResource(configuration, configuration, emailSender, oAuthDao);
        BugReportResource bugReportResource = new BugReportResource(bugReportDao, bugReportCallDao, configuration, configuration, emailSender, oAuthResource);
        environment.jersey().register(bugReportResource);
        environment.jersey().register(oAuthResource);
    }
}

