/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.impl;

import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdConfig;
import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdManager;
import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.RrdDb;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeLoginRrd
extends TestInstanceRrd {
    public static final String SUCCESS_COUNT_DS_NAME = "ok";
    public static final String WARNING_COUNT_DS_NAME = "warn";
    public static final String FAILURE_COUNT_DS_NAME = "fail";
    private static final Logger LOG = LoggerFactory.getLogger(NodeLoginRrd.class);

    public NodeLoginRrd(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, RrdConfig rrdConfig) {
        super(testInstance, testInstanceFrequency, testDefinition, rrdConfig, "login");
    }

    public NodeLoginRrd(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, RrdConfig rrdConfig, File altFile) {
        super(testInstance, testInstanceFrequency, testDefinition, rrdConfig, "login", altFile);
    }

    @Override
    public List<TestInstanceRrd.Val> getValues(@Nonnull Result result) {
        boolean debugHack;
        int tid = this.testInstance != null && this.testInstance.getId() != null ? (Integer)this.testInstance.getId() : -1;
        boolean bl = debugHack = tid == 7 || tid == 653;
        if (debugHack) {
            LOG.info("debugHack " + tid + " NodeLoginRrd.getValues()");
        }
        if (this.wasTestInPlannedMaintenance(result)) {
            return Collections.emptyList();
        }
        Result.ResultStatus status = result.getSummaryStatus();
        if (debugHack) {
            LOG.info("getValues() debugHack ti={} processing status {}", this.testInstance.getId(), (Object)status);
        }
        if (status == null) {
            return Collections.emptyList();
        }
        switch (status) {
            case SUCCESS: 
            case WARNING: 
            case FAILURE: {
                return Arrays.asList(new TestInstanceRrd.Val(SUCCESS_COUNT_DS_NAME, status == Result.ResultStatus.SUCCESS ? 1.0 : 0.0), new TestInstanceRrd.Val(WARNING_COUNT_DS_NAME, status == Result.ResultStatus.WARNING ? 1.0 : 0.0), new TestInstanceRrd.Val(FAILURE_COUNT_DS_NAME, status == Result.ResultStatus.FAILURE ? 1.0 : 0.0));
            }
            case CANCELLED: {
                return Collections.emptyList();
            }
        }
        LOG.warn("Node Login result has unsupported SummaryStatus {}", (Object)status);
        return Collections.emptyList();
    }

    @Override
    public TestInstanceStatistics.RrdStatistics getTestStatistics() {
        boolean debugHack;
        if (!this.isEnabled() || !this.exists()) {
            return null;
        }
        int tid = this.testInstance != null && this.testInstance.getId() != null ? (Integer)this.testInstance.getId() : -1;
        boolean bl = debugHack = tid == 7 || tid == 653;
        if (debugHack) {
            LOG.info("debugHack " + tid + " NodeLoginRrd.getTestStatistics()");
        }
        long now = System.currentTimeMillis() / 1000L;
        long startMonth = now - RrdManager.rrdTimeToS("1M");
        long startWeek = now - RrdManager.rrdTimeToS("1w");
        long startDay = now - RrdManager.rrdTimeToS("1d");
        long endDay = now + RrdManager.rrdTimeToS("12h");
        try {
            double totalDownTimeMonth = this.summarizeRawData(ConsolFun.MAX, startMonth, startWeek, TestInstanceRrd.SummaryOp.TOTAL, FAILURE_COUNT_DS_NAME);
            double totalDownTimeWeek = this.summarizeRawData(ConsolFun.MAX, startWeek, startDay, TestInstanceRrd.SummaryOp.TOTAL, FAILURE_COUNT_DS_NAME);
            double totalDownTimeDay = this.summarizeRawData(ConsolFun.MAX, startDay, endDay, TestInstanceRrd.SummaryOp.TOTAL, FAILURE_COUNT_DS_NAME);
            return new TestInstanceStatisticsBuilder.RrdStatisticsBuilder().setMetricName("failure").setUnit("times").setDayTotal(totalDownTimeDay).setWeekTotal(totalDownTimeWeek).setMonthTotal(totalDownTimeMonth).create();
        }
        catch (Exception e) {
            LOG.error("(also triggers debugHack " + tid + ") Failed to fetch statistics data from RRD", e);
            return null;
        }
    }

    public TestInstanceStatistics.SummationDetail calcAggregateDetail(RrdDb rrdDb, long startPeriod, long endPeriod) throws IOException {
        double success = this.summarizeRawData(ConsolFun.MAX, startPeriod, endPeriod, TestInstanceRrd.SummaryOp.TOTAL, SUCCESS_COUNT_DS_NAME);
        double warning = this.summarizeRawData(ConsolFun.MAX, startPeriod, endPeriod, TestInstanceRrd.SummaryOp.TOTAL, WARNING_COUNT_DS_NAME);
        double failure = this.summarizeRawData(ConsolFun.MAX, startPeriod, endPeriod, TestInstanceRrd.SummaryOp.TOTAL, FAILURE_COUNT_DS_NAME);
        return new TestInstanceStatistics.SummationDetail(success, warning, failure, failure + success + warning);
    }

    @Override
    public TestInstanceStatistics.Summation getSummation() {
        if (!this.isEnabled() || !this.exists()) {
            return null;
        }
        long now = System.currentTimeMillis() / 1000L;
        long startYear = now - RrdManager.rrdTimeToS("1y");
        long startMonth = now - RrdManager.rrdTimeToS("1M");
        long startWeek = now - RrdManager.rrdTimeToS("1w");
        long startDay = now - RrdManager.rrdTimeToS("1d");
        long endDay = now + RrdManager.rrdTimeToS("12h");
        try {
            RrdDb rrdDb = new RrdDb(this.rrdFile.getAbsolutePath(), true);
            return new TestInstanceStatisticsBuilder.SummationBuilder().setUnit("times").setDay(this.calcAggregateDetail(rrdDb, startDay, endDay)).setWeek(this.calcAggregateDetail(rrdDb, startWeek, endDay)).setMonth(this.calcAggregateDetail(rrdDb, startMonth, endDay)).setYear(this.calcAggregateDetail(rrdDb, startYear, endDay)).create();
        }
        catch (Exception e) {
            LOG.error("Failed to fetch Summation data from RRD", e);
            return null;
        }
    }

    @Override
    public List<TestInstanceRrd.GraphInfo> getGraphInfo() {
        long now = System.currentTimeMillis() / 1000L;
        ArrayList<TestInstanceRrd.GraphInfo> res = new ArrayList<TestInstanceRrd.GraphInfo>();
        LOG.debug("stored graph start=" + this.rrdDef.getStartTime());
        for (ArcDef arcDef : this.rrdDef.getArcDefs()) {
            long periodS = (long)(arcDef.getRows() * arcDef.getSteps()) * this.rrdDef.getStep();
            long graphStart = now - (long)(arcDef.getRows() * arcDef.getSteps()) * this.rrdDef.getStep();
            LOG.debug("graph start=" + graphStart + " stop=" + now + " diff=" + (now - graphStart));
            res.add(new TestInstanceRrd.GraphInfo(this.name, null, periodS, "Login Test Result", this.testInstance, this.testDefinition, graphStart, now, this.rrdDef, null, arcDef));
        }
        if (this.rrdDef.getArcDefs().length == 1) {
            long interval = RrdManager.rrdTimeToS("1M");
            String totalTime = RrdManager.makeTimePretty(interval);
            long graphStart = now - interval;
            LOG.debug("graph start=" + graphStart + " stop=" + now + " diff=" + (now - graphStart));
            res.add(new TestInstanceRrd.GraphInfo(this.name, null, interval, "Login Test Result", this.testInstance, this.testDefinition, graphStart, now, this.rrdDef, null, this.rrdDef.getArcDefs()[0]));
        }
        return res;
    }

    @Override
    @Nonnull
    public List<TestInstanceRrd.RawDataInfo> getRawDataInfo(String baseUri) {
        ArrayList<TestInstanceRrd.RawDataInfo> res = new ArrayList<TestInstanceRrd.RawDataInfo>();
        for (ArcDef arcDef : this.rrdDef.getArcDefs()) {
            TestInstanceRrd.RawDataInfo rdi = new TestInstanceRrd.RawDataInfo(this, this.testInstance, this.testDefinition, this.rrdDef, Arrays.asList(this.rrdDef.getDsDefs()), arcDef, baseUri);
            res.add(rdi);
        }
        return res;
    }

    @Override
    protected void postProcessRawValues(Map<String, Double> values, boolean hasNonNull) {
        super.postProcessRawValues(values, hasNonNull);
        if (!hasNonNull) {
            return;
        }
        for (Map.Entry<String, Double> e : values.entrySet()) {
            String key = e.getKey();
            Double val = e.getValue();
            if (val != null) continue;
            values.put(key, 0.0);
        }
    }

    protected static Color colorByDs(String dsDetailName) {
        if (dsDetailName.equalsIgnoreCase(FAILURE_COUNT_DS_NAME)) {
            return Color.RED;
        }
        if (dsDetailName.equalsIgnoreCase(WARNING_COUNT_DS_NAME)) {
            return Color.ORANGE;
        }
        if (dsDetailName.equalsIgnoreCase(SUCCESS_COUNT_DS_NAME)) {
            return Color.GREEN;
        }
        LOG.warn("Unknown ds: " + dsDetailName);
        return Color.BLUE;
    }

    @Override
    public File makeGraph(TestInstanceRrd.GraphInfo graphInfo) throws IOException {
        File tmpFile = File.createTempFile(graphInfo.getId(), ".png");
        RrdGraphDef gDef1 = new RrdGraphDef();
        gDef1.setWidth(500);
        gDef1.setHeight(300);
        gDef1.setFilename(tmpFile.getAbsolutePath());
        gDef1.setStartTime(graphInfo.getGraphStartTimeInSecondsSinceEpoch());
        gDef1.setEndTime(graphInfo.getGraphEndTimeInSecondsSinceEpoch());
        gDef1.setUnitsExponent(0);
        gDef1.setMinValue(0.0);
        gDef1.datasource(WARNING_COUNT_DS_NAME, this.rrdFile.getAbsolutePath(), this.makeDsName(WARNING_COUNT_DS_NAME), graphInfo.getArcDef().getConsolFun());
        gDef1.area(WARNING_COUNT_DS_NAME, (Paint)NodeLoginRrd.colorByDs(WARNING_COUNT_DS_NAME), "Not Enough Resources");
        gDef1.datasource(FAILURE_COUNT_DS_NAME, this.rrdFile.getAbsolutePath(), this.makeDsName(FAILURE_COUNT_DS_NAME), graphInfo.getArcDef().getConsolFun());
        gDef1.area(FAILURE_COUNT_DS_NAME, (Paint)NodeLoginRrd.colorByDs(FAILURE_COUNT_DS_NAME), "Login Failure");
        gDef1.setImageInfo("<img src='%s' width='%d' height='%d'>");
        gDef1.setImageFormat("png");
        LOG.debug("Rendering graph \"" + graphInfo.getId() + "\" to temp file \"" + tmpFile + "\"");
        RrdGraph graph1 = new RrdGraph(gDef1);
        LOG.debug("Rendered graph has size " + graph1.getRrdGraphInfo().getByteCount());
        return tmpFile;
    }
}

