/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.util;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class TiParamExpander {
    private static final Pattern expandTiPattern = Pattern.compile("\\$\\$\\$ti\\.parameters\\.([A-Za-z0-9_-]+)(\\?(.*))?\\$\\$\\$");

    public static Optional<String> expandTiParameters(@Nonnull String value, @Nonnull TestInstance testInstance) {
        Matcher matcher = expandTiPattern.matcher(value);
        StringBuffer res = new StringBuffer();
        while (matcher.find()) {
            boolean nullAllowed;
            String match = matcher.group();
            String paramName = matcher.group(1);
            boolean bl = nullAllowed = matcher.group(2) != null;
            assert (!nullAllowed || matcher.group(2).startsWith("?"));
            boolean replaceNull = matcher.group(3) != null && !matcher.group(3).isEmpty();
            String replacement = testInstance.getStringParameter(paramName);
            if (replacement == null) {
                if (nullAllowed) {
                    if (replaceNull) {
                        if (match.equals(value)) {
                            return Optional.of(matcher.group(3));
                        }
                        matcher.appendReplacement(res, matcher.group(3));
                        continue;
                    }
                    if (match.equals(value)) {
                        return Optional.empty();
                    }
                    matcher.appendReplacement(res, "");
                    continue;
                }
                throw new RuntimeException("\"" + match + "\" needed to be expanded, but testInstance has no " + paramName + " parameter (or it is not a String),and null is not allowed (= no '?' at end of varname).");
            }
            matcher.appendReplacement(res, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(res);
        return Optional.of(res.toString());
    }

    public static Map expandTiParameters(@Nonnull Map automatedTesterConfigMap, @Nonnull TestInstance testInstance) {
        HashMap res = new HashMap(automatedTesterConfigMap);
        LinkedList objectsToCheck = new LinkedList(Collections.singleton(res));
        while (!objectsToCheck.isEmpty()) {
            Object o = objectsToCheck.pop();
            if (o instanceof Map) {
                Map m3 = (Map)o;
                Iterator it = m3.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    Object key = e.getKey();
                    Object val = e.getValue();
                    if (val instanceof String) {
                        Optional<String> expanded = TiParamExpander.expandTiParameters((String)val, testInstance);
                        if (expanded.isPresent()) {
                            m3.put(key, expanded.get());
                        } else {
                            it.remove();
                        }
                    }
                    if (val instanceof List) {
                        ArrayList subList = new ArrayList((List)val);
                        objectsToCheck.add(subList);
                        m3.put(key, subList);
                    }
                    if (!(val instanceof Map)) continue;
                    HashMap subMap = new HashMap((Map)val);
                    objectsToCheck.add(subMap);
                    m3.put(key, subMap);
                }
            }
            if (!(o instanceof List)) continue;
            List l = (List)o;
            for (int i = 0; i < l.size(); ++i) {
                Object oo = l.get(i);
                if (oo instanceof String) {
                    Optional<String> expanded = TiParamExpander.expandTiParameters((String)oo, testInstance);
                    l.set(i, expanded.orElse(null));
                }
                if (oo instanceof List) {
                    ArrayList subList = new ArrayList((List)oo);
                    objectsToCheck.add(subList);
                    l.set(i, subList);
                }
                if (!(oo instanceof Map)) continue;
                HashMap subMap = new HashMap((Map)oo);
                objectsToCheck.add(subMap);
                l.set(i, subMap);
            }
        }
        return res;
    }
}

