/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.base;

import be.iminds.ilabt.jfed.fedmon.webapi.base.AbstractWebApiConfigurationIface;
import be.iminds.ilabt.jfed.fedmon.webapi.service.util.EmailSender;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.UriTool;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.Configuration;
import io.dropwizard.db.DataSourceFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebApiConfiguration<Access extends Enum<Access>>
extends Configuration
implements AbstractWebApiConfigurationIface<Access> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWebApiConfiguration.class);
    protected final Class<Access> accessClass;
    protected final BaseAccessEnumFactory<Access> accessEnumFactory;
    private String defaultBaseUrl;
    private String baseHttpUrl;
    private String baseHttpsUrl;
    private String baseAuthenticatedHttpsUrl;
    private Integer baseAuthenticatedHttpsUrlPort;
    @JsonIgnore
    protected final Map<AbstractWebApiConfigurationIface.UriType, UriTool> uriToolMap;
    @Valid
    @NotNull
    private DataSourceFactory database = new DataSourceFactory();
    private List<String> adminUsers;
    @JsonIgnore
    private List<GeniUrn> adminUsersUrns;
    private List<String> adminHosts;
    @JsonIgnore
    private List<InetAddress> adminHostsAddresses;
    private Boolean disableAuthentication;
    private Boolean disableAdminAuthentication;
    private Boolean disableLocalhostAuthentication;
    private Boolean disableLocalhostAdminAuthentication;
    private EmailSender.EmailSenderConfig adminEmail;
    protected static JsonLdObjectsMetaData instance = null;

    protected AbstractWebApiConfiguration(Class<Access> accessClass, BaseAccessEnumFactory<Access> accessEnumFactory) {
        this.accessClass = accessClass;
        this.accessEnumFactory = accessEnumFactory;
        this.uriToolMap = new EnumMap<AbstractWebApiConfigurationIface.UriType, UriTool>(AbstractWebApiConfigurationIface.UriType.class);
    }

    @Override
    @JsonProperty
    @Nullable
    public EmailSender.EmailSenderConfig getAdminEmail() {
        return this.adminEmail;
    }

    @JsonProperty
    public void setAdminEmail(@Nullable EmailSender.EmailSenderConfig adminEmail) {
        this.adminEmail = adminEmail;
    }

    @Override
    @JsonProperty
    public String getBaseUrl() {
        return this.defaultBaseUrl;
    }

    @JsonProperty
    public void setBaseUrl(String baseUrl) {
        this.defaultBaseUrl = baseUrl;
    }

    @JsonProperty
    public String getBaseHttpUrl() {
        return this.baseHttpUrl;
    }

    @JsonProperty
    public void setBaseHttpUrl(String baseHttpUrl) {
        this.baseHttpUrl = baseHttpUrl;
    }

    @JsonProperty
    public String getBaseHttpsUrl() {
        return this.baseHttpsUrl;
    }

    @JsonProperty
    public void setBaseHttpsUrl(String baseHttpsUrl) {
        this.baseHttpsUrl = baseHttpsUrl;
    }

    @JsonProperty
    public String getBaseAuthenticatedHttpsUrl() {
        return this.baseAuthenticatedHttpsUrl;
    }

    @JsonProperty
    public void setBaseAuthenticatedHttpsUrl(String baseAuthenticatedHttpsUrl) {
        this.baseAuthenticatedHttpsUrl = baseAuthenticatedHttpsUrl;
        if (baseAuthenticatedHttpsUrl != null) {
            try {
                URL uri = new URL(baseAuthenticatedHttpsUrl);
                this.baseAuthenticatedHttpsUrlPort = uri.getPort() == -1 ? uri.getDefaultPort() : uri.getPort();
            }
            catch (MalformedURLException e) {
                this.baseAuthenticatedHttpsUrlPort = null;
                LOG.error("Invalid URI for setBaseAuthenticatedHttpsUrl: \"" + baseAuthenticatedHttpsUrl + "\"", e);
            }
        } else {
            this.baseAuthenticatedHttpsUrlPort = null;
        }
        LOG.debug("baseAuthenticatedHttpsUrlPort=" + this.baseAuthenticatedHttpsUrlPort + "  for baseAuthenticatedHttpsUrl=" + baseAuthenticatedHttpsUrl);
    }

    @JsonIgnore
    protected Integer getBaseAuthenticatedHttpsUrlPort() {
        return this.baseAuthenticatedHttpsUrlPort;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public String getBaseUrl(AbstractWebApiConfigurationIface.UriType uriType) {
        switch (uriType) {
            case DEFAULT: {
                return AbstractWebApiConfiguration.coalesce(this.defaultBaseUrl, this.baseHttpsUrl, this.baseHttpUrl, this.baseAuthenticatedHttpsUrl);
            }
            case HTTP: {
                return AbstractWebApiConfiguration.coalesce(this.baseHttpUrl, this.defaultBaseUrl, this.baseHttpsUrl, this.baseAuthenticatedHttpsUrl);
            }
            case HTTPS: {
                return AbstractWebApiConfiguration.coalesce(this.baseHttpsUrl, this.defaultBaseUrl, this.baseAuthenticatedHttpsUrl, this.baseHttpUrl);
            }
            case AUTHENTICATED_HTTPS: {
                return AbstractWebApiConfiguration.coalesce(this.baseAuthenticatedHttpsUrl, this.baseHttpsUrl, this.defaultBaseUrl, this.baseHttpUrl);
            }
        }
        throw new IllegalArgumentException("Unknown UriType: " + uriType);
    }

    public static <T> T coalesce(T a, T b) {
        return a == null ? b : a;
    }

    public static <T> T coalesce(T a, T b, T c) {
        return a != null ? a : (b != null ? b : c);
    }

    public static <T> T coalesce(T a, T b, T c, T d) {
        return a != null ? a : (b != null ? b : (c != null ? c : d));
    }

    @Override
    @JsonProperty
    public Boolean getDisableAuthentication() {
        return this.disableAuthentication;
    }

    @JsonProperty
    public void setDisableAuthentication(Boolean disableAuthentication) {
        this.disableAuthentication = disableAuthentication;
    }

    @Override
    @JsonProperty
    public Boolean getDisableLocalhostAuthentication() {
        return this.disableLocalhostAuthentication;
    }

    @JsonProperty
    public void setDisableLocalhostAuthentication(Boolean disableLocalhostAuthentication) {
        this.disableLocalhostAuthentication = disableLocalhostAuthentication;
    }

    @Override
    @JsonProperty
    public Boolean getDisableLocalhostAdminAuthentication() {
        return this.disableLocalhostAdminAuthentication;
    }

    @JsonProperty
    public void setDisableLocalhostAdminAuthentication(Boolean disableLocalhostAdminAuthentication) {
        this.disableLocalhostAdminAuthentication = disableLocalhostAdminAuthentication;
    }

    @Override
    @JsonProperty
    public Boolean getDisableAdminAuthentication() {
        return this.disableAdminAuthentication;
    }

    @JsonProperty
    public void setDisableAdminAuthentication(Boolean disableAdminAuthentication) {
        this.disableAdminAuthentication = disableAdminAuthentication;
    }

    @JsonProperty(value="database")
    public void setDataSourceFactory(DataSourceFactory factory) {
        this.database = factory;
    }

    @Override
    @JsonProperty(value="database")
    public DataSourceFactory getDataSourceFactory() {
        return this.database;
    }

    @Override
    @JsonProperty
    public List<String> getAdminUsers() {
        return this.adminUsers;
    }

    @JsonProperty
    public void setAdminUsers(List<String> adminUsers) {
        this.adminUsers = adminUsers;
    }

    @Override
    @JsonProperty
    public List<String> getAdminHosts() {
        return this.adminHosts;
    }

    @JsonProperty
    public void setAdminHosts(List<String> adminHosts) {
        this.adminHosts = adminHosts;
    }

    @Override
    @JsonIgnore
    public JsonLdObjectsMetaData getJsonLdObjectsMetaData() {
        if (instance == null) {
            instance = this.createJsonLdObjectsMetaData();
        }
        return instance;
    }

    protected abstract JsonLdObjectsMetaData createJsonLdObjectsMetaData();

    @Override
    @JsonIgnore
    @Nonnull
    public UriTool getUriTool(AbstractWebApiConfigurationIface.UriType uriType) {
        return this.uriToolMap.computeIfAbsent(uriType, key -> this.createUriTool(this.getBaseUrl((AbstractWebApiConfigurationIface.UriType)((Object)key))));
    }

    @JsonIgnore
    @Nonnull
    protected UriTool createUriTool(String baseUrl) {
        return this.getJsonLdObjectsMetaData().makeUriTool(baseUrl, (UriTool.DerivedUriGenerator)null);
    }

    @Override
    @JsonIgnore
    public boolean isAccessAllowed(Access neededAccess, HttpServletRequest request) {
        Set<Access> allAccess = this.getAccess(request);
        if (allAccess.contains(this.accessEnumFactory.getAdmin())) {
            return true;
        }
        return allAccess.contains(neededAccess);
    }

    @Override
    @JsonIgnore
    public void assureAccessAllowed(Access neededAccess, HttpServletRequest request) throws WebApplicationException {
        if (!this.isAccessAllowed(neededAccess, request)) {
            throw new WebApplicationException("Permission denied. You do not have " + neededAccess + " access.", Response.Status.FORBIDDEN);
        }
    }

    @Override
    @JsonIgnore
    public boolean hasAnyAccess(HttpServletRequest request, Access ... anyAccess) throws WebApplicationException {
        Set<Access> allAccess = this.getAccess(request);
        if (allAccess.contains(this.accessEnumFactory.getAdmin())) {
            return true;
        }
        for (Access neededAccess : anyAccess) {
            if (!allAccess.contains(neededAccess)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<Access> getAccess(HttpServletRequest request) {
        if (this.disableAdminAuthentication != null && this.disableAdminAuthentication.booleanValue()) {
            LOG.debug("getAccess() -> disableAdminAuthentication -> granting all access");
            return EnumSet.allOf(this.accessClass);
        }
        if (this.disableAuthentication != null && this.disableAuthentication.booleanValue()) {
            LOG.debug("getAccess() -> disableAuthentication -> granting all but ADMIN access");
            return EnumSet.complementOf(EnumSet.of(this.accessEnumFactory.getAdmin()));
        }
        EnumSet<Access> res = EnumSet.noneOf(this.accessClass);
        res.add(this.accessEnumFactory.getRead());
        if (request != null) {
            GeniUrn authenticatedUser;
            String remoteAddress = request.getRemoteAddr();
            boolean isLocalhost = remoteAddress != null && (remoteAddress.equals("0:0:0:0:0:0:0:1") || remoteAddress.equals("::1") || remoteAddress.startsWith("127.0.0.1") || remoteAddress.equals("localhost"));
            LOG.debug("getAccess() -> Got request from \"" + remoteAddress + "\". isLocalhost=" + isLocalhost);
            if (isLocalhost && this.disableLocalhostAdminAuthentication.booleanValue()) {
                LOG.debug("getAccess() -> disableLocalhostAdminAuthentication -> granting all access");
                return EnumSet.allOf(this.accessClass);
            }
            if (isLocalhost && this.disableLocalhostAuthentication.booleanValue()) {
                LOG.debug("getAccess() -> disableLocalhostAuthentication -> granting all but ADMIN access");
                return EnumSet.complementOf(EnumSet.of(this.accessEnumFactory.getAdmin()));
            }
            if (remoteAddress != null) {
                res.addAll(this.getHostBasedAccess(remoteAddress));
            }
            if ((authenticatedUser = this.getAuthenticatedUserUrn(request)) != null) {
                res.addAll(this.getUserBasedAccess(authenticatedUser));
            }
        } else {
            LOG.warn("@Context HttpServletRequest request == null. (Are you testing?)");
        }
        return res;
    }

    @Override
    @Nullable
    @JsonIgnore
    public GeniUrn getAuthenticatedUserUrn(@Nonnull HttpServletRequest request) {
        return AbstractWebApiConfiguration.getAuthenticatedUserUrnFromRequest(request);
    }

    @Override
    @Nonnull
    public AbstractWebApiConfigurationIface.UriType getCalledUriType(@Nonnull HttpServletRequest request) {
        switch (request.getScheme()) {
            case "http": {
                return AbstractWebApiConfigurationIface.UriType.HTTP;
            }
            case "https": {
                if (this.getBaseAuthenticatedHttpsUrlPort() != null && request.getServerPort() == this.getBaseAuthenticatedHttpsUrlPort().intValue()) {
                    return AbstractWebApiConfigurationIface.UriType.AUTHENTICATED_HTTPS;
                }
                return AbstractWebApiConfigurationIface.UriType.HTTPS;
            }
        }
        LOG.error("getCalledUriType-> unknown request.getProtocol()=" + request.getProtocol());
        return AbstractWebApiConfigurationIface.UriType.DEFAULT;
    }

    @Nullable
    @JsonIgnore
    public static GeniUrn getAuthenticatedUserUrnFromRequest(@Nonnull HttpServletRequest request) {
        X509Certificate[] clientCerts = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (clientCerts != null) {
            if (clientCerts.length == 0) {
                return null;
            }
            X509Certificate firstCert = clientCerts[0];
            List<GeniUrn> userUrns = KeyUtil.findUrnsInCertAltNames(firstCert, KeyUtil.AltNamesSource.SUBJECT_ALT_NAMES, true);
            if (!userUrns.isEmpty()) {
                GeniUrn authenticatedUser = userUrns.get(0);
                LOG.debug("getAccess() -> request client cert processed -> Successfully Authenticated as " + authenticatedUser);
                if (userUrns.size() > 1) {
                    LOG.debug("getAccess() -> request client cert note: there were additional user URNs in subject alt names. All user urns: " + userUrns);
                }
                return authenticatedUser;
            }
            return null;
        }
        return null;
    }

    @Nonnull
    @JsonIgnore
    protected Set<Access> getUserBasedAccess(@Nonnull GeniUrn user) {
        this.initAccessUrns();
        EnumSet<Access> res = EnumSet.noneOf(this.accessClass);
        if (this.adminUsersUrns.contains(user)) {
            res.add(this.accessEnumFactory.getAdmin());
        }
        return res;
    }

    @Nonnull
    @JsonIgnore
    protected Set<Access> getHostBasedAccess(@Nonnull String remoteAddress) {
        this.initAccessAddresses();
        try {
            InetAddress remote = InetAddress.getByName(remoteAddress);
            if (remote == null) {
                LOG.warn("remote address is null");
            }
            EnumSet<Access> res = EnumSet.noneOf(this.accessClass);
            if (this.adminHostsAddresses.contains(remote)) {
                res.add(this.accessEnumFactory.getAdmin());
            }
            LOG.debug("   access=" + res + " for remoteAddress=\"" + remoteAddress + "\"");
            return res;
        }
        catch (UnknownHostException e) {
            LOG.error("Unknown host: \"" + remoteAddress + "\"", e);
            return Collections.emptySet();
        }
    }

    @JsonIgnore
    protected void initAccessAddresses() {
        if (this.adminHostsAddresses == null) {
            this.adminHostsAddresses = new ArrayList<InetAddress>();
            if (this.adminHosts != null) {
                for (String addressStr : this.adminHosts) {
                    try {
                        InetAddress address = InetAddress.getByName(addressStr);
                        if (address != null) {
                            this.adminHostsAddresses.add(address);
                            continue;
                        }
                        LOG.error("Config error: Invalid Internet address in adminHosts: " + addressStr);
                    }
                    catch (UnknownHostException e) {
                        LOG.error("UnknownHostException calling InetAddress.getByName(\"" + addressStr + "\")", e);
                    }
                }
            }
        }
        assert (this.adminHostsAddresses != null);
    }

    @JsonIgnore
    protected void initAccessUrns() {
        if (this.adminUsersUrns == null) {
            this.adminUsersUrns = new ArrayList<GeniUrn>();
            if (this.adminUsers != null) {
                for (String uStr : this.adminUsers) {
                    GeniUrn urn = GeniUrn.parse(uStr.trim());
                    if (urn != null) {
                        this.adminUsersUrns.add(urn);
                        continue;
                    }
                    LOG.error("Config error: Invalid user URN in adminUsers: " + uStr);
                }
            }
        }
        assert (this.adminUsersUrns != null);
    }

    public static interface BaseAccessEnumFactory<Access extends Enum<Access>> {
        public Access getRead();

        public Access getAdmin();
    }

    public static interface AccessEnum {
        public String getName();
    }
}

