/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FederationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import java.net.URISyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class FederationMapper
implements ResultSetMapper<FederationBuilder> {
    @Override
    public FederationBuilder map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        FederationBuilder federation = null;
        try {
            federation = ((FederationBuilder)new FederationBuilder().setId(r.getString("id"))).setDescription(r.getString("description")).setLongName(r.getString("long_name")).setNotes(r.getString("notes")).setUrlsFromStrings(DaoCommon.rowStringArray(r, "urls_csv")).setFederatedWith(r.getString("parent_federation_id")).setTestbeds(FederationMapper.idToTestbed(DaoCommon.rowStringArray(r, "federation$testbed_ids")));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bad URI in DB: '" + r.getString("urls_csv") + "'", e);
        }
        return federation;
    }

    private static List<Testbed> idToTestbed(List<String> testbedIds) {
        if (testbedIds == null) {
            return null;
        }
        return testbedIds.stream().map(FederationMapper::idToTestbed).collect(Collectors.toList());
    }

    private static Testbed idToTestbed(String testbedId) {
        if (testbedId == null) {
            return null;
        }
        return ((TestbedBuilder)new TestbedBuilder().setId(testbedId)).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
    }
}

