/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.JFedUserStatisticsMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterMapper(value={JFedUserStatisticsMapper.class})
public abstract class JFedUserStatisticsDao
implements GetHandle {
    private static final Logger LOG = LoggerFactory.getLogger(JFedUserStatisticsDao.class);

    @SqlUpdate(value="INSERT INTO jfed_user_stats (stats) VALUES (CAST(:asJsonString AS jsonb))")
    public abstract void logUserConfigRequest(@Nonnull @BindBean UserInfo var1);

    @SqlUpdate(value="INSERT INTO jfed_user_stats (stats, login) VALUES (CAST(:userInfoAsJsonString AS jsonb), :loginInstant)")
    public abstract void logUserConfigRequest(@Nonnull @BindBean UserInfo var1, @Nonnull Instant var2);

    @SqlQuery(value="SELECT login,CAST(stats AS text) AS stats_jsonstr FROM jfed_user_stats  WHERE login > NOW() - (:maxDays * INTERVAL '1 days')")
    protected abstract List<JFedUserStatistic> getAll(@Bind(value="maxDays") int var1);

    public static Instant truncateTo(@Nonnull Instant in, @Nonnull TemporalUnit trunc) {
        if (trunc.getDuration().getSeconds() <= ChronoUnit.DAYS.getDuration().getSeconds()) {
            return in.truncatedTo(trunc);
        }
        if (trunc == ChronoUnit.YEARS) {
            return in.truncatedTo(ChronoUnit.DAYS).atOffset(ZoneOffset.UTC).with(TemporalAdjusters.firstDayOfYear()).toInstant();
        }
        if (trunc == ChronoUnit.MONTHS) {
            return in.truncatedTo(ChronoUnit.DAYS).atOffset(ZoneOffset.UTC).with(TemporalAdjusters.firstDayOfMonth()).toInstant();
        }
        if (trunc == ChronoUnit.WEEKS) {
            Instant res = in.truncatedTo(ChronoUnit.DAYS);
            DayOfWeek dayOfWeek = res.atOffset(ZoneOffset.UTC).getDayOfWeek();
            if (dayOfWeek != DayOfWeek.MONDAY) {
                assert (DayOfWeek.MONDAY.getValue() == 1);
                res = res.minus(dayOfWeek.getValue() - 1, ChronoUnit.DAYS);
            }
            return res;
        }
        throw new UnsupportedTemporalTypeException("Unit " + trunc + " not supported");
    }

    public static Instant truncateUpTo(@Nonnull Instant in, @Nonnull TemporalUnit trunc) {
        if (trunc.getDuration().getSeconds() <= ChronoUnit.DAYS.getDuration().getSeconds()) {
            return in.truncatedTo(trunc).plus(1L, trunc);
        }
        if (trunc == ChronoUnit.YEARS) {
            return in.truncatedTo(ChronoUnit.DAYS).atOffset(ZoneOffset.UTC).with(TemporalAdjusters.lastDayOfYear()).plus(1L, ChronoUnit.DAYS).toInstant();
        }
        if (trunc == ChronoUnit.MONTHS) {
            return in.truncatedTo(ChronoUnit.DAYS).atOffset(ZoneOffset.UTC).with(TemporalAdjusters.lastDayOfMonth()).plus(1L, ChronoUnit.DAYS).toInstant();
        }
        if (trunc == ChronoUnit.WEEKS) {
            Instant res = in.truncatedTo(ChronoUnit.DAYS);
            DayOfWeek dayOfWeek = res.atOffset(ZoneOffset.UTC).getDayOfWeek();
            res = res.plus((long)(DayOfWeek.SUNDAY.getValue() - dayOfWeek.getValue()), ChronoUnit.DAYS);
            res = res.plus(1L, ChronoUnit.DAYS);
            return res;
        }
        throw new UnsupportedTemporalTypeException("Unit " + trunc + " not supported");
    }

    private static boolean isFTester(@Nonnull JFedUserStatistic s2) {
        if (s2.getUserInfo() == null) {
            return false;
        }
        if (s2.getUserInfo().getUrn() == null) {
            return false;
        }
        ArrayList<String> ftesterUrns = new ArrayList<String>();
        ftesterUrns.add("urn:publicid:IDN+wall2.ilabt.iminds.be+user+ftester".toLowerCase(Locale.ROOT));
        ftesterUrns.add("urn:publicid:IDN+ilabt.imec.be+user+ftester".toLowerCase(Locale.ROOT));
        ftesterUrns.add("urn:publicid:IDN+ch.geni.net+user+wimvande".toLowerCase(Locale.ROOT));
        return ftesterUrns.contains(s2.getUserInfo().getUrn().toLowerCase(Locale.ROOT));
    }

    public List<AggUserStatistics> get(int maxDays, @Nonnull TemporalUnit aggregationUnit) {
        List<JFedUserStatistic> raw = this.getAll(maxDays);
        if (raw.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Instant, AggUserStatistics> res = new HashMap<Instant, AggUserStatistics>();
        for (JFedUserStatistic s2 : raw) {
            if (JFedUserStatisticsDao.isFTester(s2)) continue;
            Instant bucketStart = JFedUserStatisticsDao.truncateTo(s2.getLogin(), aggregationUnit);
            Instant bucketEnd = JFedUserStatisticsDao.truncateUpTo(bucketStart, aggregationUnit);
            AggUserStatistics agg = res.computeIfAbsent(bucketStart, key -> new AggUserStatistics(bucketStart, bucketEnd));
            agg.add(s2.getLogin(), s2.getUserInfo());
        }
        return new ArrayList<AggUserStatistics>(res.values());
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class JFedUserStatistic {
        @Nonnull
        private final Instant login;
        @Nonnull
        private final UserInfo userInfo;

        @JsonCreator
        public JFedUserStatistic(@Nonnull @JsonProperty(value="login") Instant login, @Nonnull @JsonProperty(value="userInfo") UserInfo userInfo) {
            this.login = login;
            this.userInfo = userInfo;
        }

        @Nonnull
        @JsonProperty
        public Instant getLogin() {
            return this.login;
        }

        @Nonnull
        @JsonProperty
        public UserInfo getUserInfo() {
            return this.userInfo;
        }

        @Nonnull
        @JsonIgnore
        public String getUserInfoAsJsonString() {
            ObjectMapper mapper = Jackson.newObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.userInfo);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting triggeredMessages into JSON", e);
                throw new RuntimeException("Exception converting triggeredMessages into JSON");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JFedUserStatistic that = (JFedUserStatistic)o;
            return this.login.equals(that.login) && this.userInfo.equals(that.userInfo);
        }

        public int hashCode() {
            return Objects.hash(this.login, this.userInfo);
        }

        public String toString() {
            return "JFedUserStatistics{login=" + this.login + ", userInfo=" + this.userInfo + "}";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class AggUserStatistics {
        @Nonnull
        private final Instant bucketStart;
        @Nonnull
        private final Instant bucketEnd;
        @Nonnull
        private int loginCount;
        @Nonnull
        private int uniqueUsers;
        @Nonnull
        private final Map<Integer, Integer> loginHourCounts = new HashMap<Integer, Integer>();
        @Nonnull
        private final Map<String, Integer> loginDayCounts = new HashMap<String, Integer>();
        @Nonnull
        private final Map<String, Integer> usersPerAuth = new HashMap<String, Integer>();
        @Nonnull
        private final Map<String, Integer> usersPerJFedVersion = new HashMap<String, Integer>();
        @Nonnull
        private final Map<String, Integer> usersPerJavaVendor = new HashMap<String, Integer>();
        @Nonnull
        private final Map<String, Integer> usersPerJavaVersion = new HashMap<String, Integer>();
        @Nonnull
        private final Map<String, Integer> usersPerJavaSpec = new HashMap<String, Integer>();
        @Nonnull
        private final Map<String, Integer> usersPerArch = new HashMap<String, Integer>();
        @Nonnull
        private final Map<String, Integer> usersPerOsVersion = new HashMap<String, Integer>();
        @Nonnull
        private final Map<String, Integer> usersPerOs = new HashMap<String, Integer>();
        @Nonnull
        private final Set<String> users = new HashSet<String>();

        public AggUserStatistics(@Nonnull Instant bucketStart, @Nonnull Instant bucketEnd) {
            this.bucketStart = bucketStart;
            this.bucketEnd = bucketEnd;
            this.loginCount = 0;
            this.uniqueUsers = 0;
            for (int hour = 0; hour < 24; ++hour) {
                this.loginHourCounts.put(hour, 0);
            }
            for (DayOfWeek day : DayOfWeek.values()) {
                this.loginDayCounts.put(day.toString(), 0);
            }
        }

        private static <T> void inc(@Nonnull Map<T, Integer> m3, @Nullable T key) {
            if (key != null) {
                m3.compute(key, (k, v) -> v == null ? 1 : v + 1);
            }
        }

        @Nonnull
        private static String extractOs(@Nullable String osVersion) {
            if (osVersion == null) {
                return "unknown";
            }
            if (osVersion.toLowerCase(Locale.ROOT).startsWith("linux")) {
                return "Linux";
            }
            if (osVersion.toLowerCase(Locale.ROOT).startsWith("mac")) {
                return "Mac";
            }
            if (osVersion.toLowerCase(Locale.ROOT).startsWith("windows")) {
                return "Windows";
            }
            return Arrays.stream(osVersion.strip().split(" ")).findFirst().orElse("unknown");
        }

        public void add(@Nonnull Instant login, @Nonnull UserInfo userInfo) {
            assert (login.isBefore(this.bucketEnd));
            assert (login.isAfter(this.bucketStart) || login.equals(this.bucketStart));
            ++this.loginCount;
            boolean newUser = this.users.add(userInfo.getUrn());
            this.uniqueUsers = this.users.size();
            int hour = login.atZone(ZoneOffset.UTC).getHour();
            DayOfWeek day = login.atZone(ZoneOffset.UTC).getDayOfWeek();
            AggUserStatistics.inc(this.loginHourCounts, hour);
            AggUserStatistics.inc(this.loginDayCounts, day.toString());
            if (!newUser) {
                return;
            }
            GeniUrn userUrn = GeniUrn.parse(userInfo.getUrn());
            String auth = userUrn == null ? "no user" : userUrn.getTopLevelAuthority_withoutSubAuth();
            AggUserStatistics.inc(this.usersPerAuth, auth);
            AggUserStatistics.inc(this.usersPerJFedVersion, userInfo.getVersion().getjFed());
            AggUserStatistics.inc(this.usersPerJavaVendor, userInfo.getVersion().getJavaVendor());
            AggUserStatistics.inc(this.usersPerJavaVersion, userInfo.getVersion().getJava());
            AggUserStatistics.inc(this.usersPerJavaSpec, userInfo.getVersion().getJavaSpec());
            AggUserStatistics.inc(this.usersPerArch, userInfo.getVersion().getArch());
            AggUserStatistics.inc(this.usersPerOs, AggUserStatistics.extractOs(userInfo.getVersion().getOs()));
            AggUserStatistics.inc(this.usersPerOsVersion, userInfo.getVersion().getOs());
        }

        @Nonnull
        @JsonProperty
        public Instant getBucketStart() {
            return this.bucketStart;
        }

        @Nonnull
        @JsonProperty
        public Instant getBucketEnd() {
            return this.bucketEnd;
        }

        @JsonProperty
        public int getLoginCount() {
            return this.loginCount;
        }

        @JsonProperty
        public int getUniqueUsers() {
            return this.uniqueUsers;
        }

        @Nonnull
        @JsonProperty
        public Map<String, Integer> getUsersPerAuth() {
            return this.usersPerAuth;
        }

        @Nonnull
        @JsonProperty
        public Map<String, Integer> getUsersPerJFedVersion() {
            return this.usersPerJFedVersion;
        }

        @Nonnull
        @JsonProperty
        public Map<String, Integer> getUsersPerJavaVendor() {
            return this.usersPerJavaVendor;
        }

        @Nonnull
        @JsonProperty
        public Map<String, Integer> getUsersPerJavaVersion() {
            return this.usersPerJavaVersion;
        }

        @Nonnull
        @JsonProperty
        public Map<String, Integer> getUsersPerJavaSpec() {
            return this.usersPerJavaSpec;
        }

        @Nonnull
        @JsonProperty
        public Map<String, Integer> getUsersPerArch() {
            return this.usersPerArch;
        }

        @Nonnull
        @JsonProperty
        public Map<String, Integer> getUsersPerOs() {
            return this.usersPerOs;
        }

        @Nonnull
        @JsonProperty
        public Map<String, Integer> getUsersPerOsVersion() {
            return this.usersPerOsVersion;
        }

        @Nonnull
        @JsonProperty
        public Map<Integer, Integer> getLoginHourCounts() {
            return this.loginHourCounts;
        }

        @Nonnull
        @JsonProperty
        public Map<String, Integer> getLoginDayCounts() {
            return this.loginDayCounts;
        }

        public String toString() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting to JSON", e);
                return "Exception converting to JSON: " + e.getMessage();
            }
        }
    }
}

