/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.LogDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogContentMapper
implements ResultSetMapper<LogDao.ContentAndType> {
    private static final Logger LOG = LoggerFactory.getLogger(LogContentMapper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LogDao.ContentAndType map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        Log.LogMediaType mediaType;
        String mediaTypeString = r.getString("media_type");
        if (mediaTypeString == null) {
            mediaType = Log.LogMediaType.BINARY;
        } else {
            try {
                mediaType = Log.LogMediaType.valueOf(mediaTypeString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Illegal media_type in DB: \"" + mediaTypeString + "\"");
            }
        }
        try (InputStream asciiStream = r.getAsciiStream("contentb64");){
            if (asciiStream == null) {
                LogDao.ContentAndType contentAndType2 = new LogDao.ContentAndType(null, mediaType);
                return contentAndType2;
            }
            String encodedContent = IOUtils.streamToString(asciiStream, "UTF-8").replaceAll("\n", "");
            byte[] decodedContent = new byte[]{};
            try {
                decodedContent = Base64.getDecoder().decode(encodedContent);
            }
            catch (Exception e) {
                LOG.error("Error decoding base64 \"" + encodedContent + "\".", e);
            }
            LogDao.ContentAndType contentAndType = new LogDao.ContentAndType(decodedContent, mediaType);
            return contentAndType;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading content", e);
        }
    }
}

