/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LogBuilder;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDao {
    private static final Logger LOG = LoggerFactory.getLogger(LogDao.class);
    private final DBI jdbi;
    private final Handle handle;

    public LogDao(DBI jdbi) {
        this.jdbi = jdbi;
        this.handle = jdbi.open();
    }

    public void close() {
        this.handle.close();
    }

    private Log resultSetToLog(ResultSet rs) throws SQLException {
        LogBuilder logBuilder = new LogBuilder();
        logBuilder.setId((Object)rs.getLong(1));
        assert (!rs.wasNull());
        logBuilder.setName(rs.getString(2));
        if (rs.wasNull()) {
            logBuilder.setName(null);
        }
        logBuilder.setTaskId(rs.getLong(3));
        if (rs.wasNull()) {
            logBuilder.setTask(null);
        }
        logBuilder.setResultId(rs.getLong(4));
        if (rs.wasNull()) {
            logBuilder.setResultId(null);
        }
        logBuilder.setStartTime(rs.getTimestamp(5));
        if (rs.wasNull()) {
            logBuilder.setStartTime(null);
        }
        logBuilder.setStopTime(rs.getTimestamp(6));
        if (rs.wasNull()) {
            logBuilder.setStopTime(null);
        }
        logBuilder.setLive(rs.getBoolean(7));
        if (rs.wasNull()) {
            logBuilder.setLive(null);
        }
        logBuilder.setComplete(rs.getBoolean(8));
        if (rs.wasNull()) {
            logBuilder.setComplete(null);
        }
        logBuilder.setSize(rs.getLong(9));
        if (rs.wasNull()) {
            logBuilder.setSize(0L);
        }
        String mediaTypeString = rs.getString(10);
        if (rs.wasNull()) {
            logBuilder.setMediaType(Log.LogMediaType.BINARY);
        } else {
            Log.LogMediaType mediaType = Log.LogMediaType.caseInsensitiveValueOf(mediaTypeString);
            assert (mediaType != null) : "unknown media type \"" + mediaTypeString + "\"";
            if (mediaType == null) {
                LOG.error("Unknown media type in DB: \"" + mediaTypeString + "\"");
            }
            logBuilder.setMediaType(mediaType);
        }
        return logBuilder.create();
    }

    public Log getById(Long id) throws SQLException {
        Connection connection = this.handle.getConnection();
        PreparedStatement ps = connection.prepareStatement("SELECT id,name,task_id,result_id,start,stop,live,complete,length(content) AS content_size,media_type  FROM log WHERE id=?");
        ps.setLong(1, id);
        ResultSet rs = ps.executeQuery();
        boolean hasNext = rs.next();
        Log res = hasNext ? this.resultSetToLog(rs) : null;
        ps.close();
        return res;
    }

    public ContentAndType getContentById(Long id) throws SQLException {
        ContentAndType res;
        Connection connection = this.handle.getConnection();
        PreparedStatement ps = connection.prepareStatement("SELECT content,media_type FROM log WHERE id=?");
        ps.setLong(1, id);
        ResultSet rs = ps.executeQuery();
        boolean hasNext = rs.next();
        if (!hasNext) {
            res = null;
        } else {
            String mediaTypeString = rs.getString(2);
            byte[] content = rs.getBytes(1);
            res = new ContentAndType(content == null ? new byte[]{} : content, mediaTypeString == null ? null : Log.LogMediaType.caseInsensitiveValueOf(mediaTypeString));
        }
        ps.close();
        return res;
    }

    public int appendContent(Long id, InputStream content, String mediaType) throws SQLException {
        Connection connection = this.handle.getConnection();
        PreparedStatement ps = connection.prepareStatement("UPDATE log SET content=(content || ?),complete=(NOT live),stop=CASE WHEN ((NOT live) AND stop IS NULL) THEN (NOW()) ELSE stop END WHERE id=? AND (NOT complete) AND LOWER(media_type)=LOWER(?)");
        ps.setBinaryStream(1, content);
        ps.setLong(2, id);
        ps.setString(3, mediaType);
        int res = ps.executeUpdate();
        ps.close();
        return res;
    }

    public int updateFields(@Nonnull Long id, @Nullable Timestamp stop, boolean complete, @Nullable Long resultId, @Nullable Long taskId) throws SQLException {
        Connection connection = this.handle.getConnection();
        PreparedStatement ps = connection.prepareStatement("UPDATE log SET stop=?,complete=?,result_id=?,task_id=?  WHERE id=? AND (? OR NOT complete)");
        if (stop == null) {
            ps.setNull(1, 93);
        } else {
            ps.setTimestamp(1, stop);
        }
        ps.setBoolean(2, complete);
        ps.setBoolean(6, complete);
        if (resultId == null) {
            ps.setNull(3, 3);
        } else {
            ps.setLong(3, resultId);
        }
        if (taskId == null) {
            ps.setNull(4, 3);
        } else {
            ps.setLong(4, taskId);
        }
        assert (id != null);
        ps.setLong(5, id);
        int res = ps.executeUpdate();
        ps.close();
        return res;
    }

    public Long insert(Log log) throws SQLException {
        Connection connection = this.handle.getConnection();
        PreparedStatement ps = connection.prepareStatement("INSERT INTO log (name,task_id,result_id,start,stop,live,complete,media_type,content) VALUES (?, ?, ?, ?, ?, ?, ?, ?, '') RETURNING id");
        ps.setString(1, log.getName());
        if (log.getTaskId() == null) {
            ps.setNull(2, 3);
        } else {
            ps.setLong(2, log.getTaskId());
        }
        if (log.getResultId() == null) {
            ps.setNull(3, 3);
        } else {
            ps.setLong(3, log.getResultId());
        }
        ps.setTimestamp(4, log.getStartTime());
        ps.setTimestamp(5, log.getStopTime());
        ps.setBoolean(6, log.getLive());
        ps.setBoolean(7, log.getComplete());
        ps.setString(8, log.getMediaType().name());
        ResultSet rs = ps.executeQuery();
        boolean hasNext = rs.next();
        assert (hasNext);
        if (!hasNext) {
            throw new RuntimeException("Failed to insert log");
        }
        Long res = rs.getLong(1);
        ps.close();
        return res;
    }

    public static class ContentAndType {
        private final byte[] content;
        private final Log.LogMediaType mediaType;

        public ContentAndType(byte[] content, Log.LogMediaType mediaType) {
            this.content = content;
            this.mediaType = mediaType;
        }

        public byte[] getContent() {
            return this.content;
        }

        public Log.LogMediaType getMediaType() {
            return this.mediaType;
        }
    }
}

