/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.OrganisationMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterMapper(value={OrganisationMapper.class})
public abstract class OrganisationDao {
    private static final Logger LOG = LoggerFactory.getLogger(OrganisationDao.class);

    @SqlQuery(value="SELECT o.id,o.name,o.logo_url,o.site_url,o.coordinates, array_to_string(o.technical_contact_emails, ',') AS organisation$technical_contact_emails_csv,  t.id AS testbed$id,t.default_urn AS testbed$urn,t.geni_id AS testbed$geni_id  FROM organisation o  LEFT JOIN testbed t ON t.organisation_id = o.id WHERE o.id=:id ")
    protected abstract List<OrganisationMapper.OrganisationMappingHelper> findByIdHelper(@NotNull @Bind(value="id") String var1);

    @SqlQuery(value="SELECT o.id,o.name,o.logo_url,o.site_url,o.coordinates, array_to_string(o.technical_contact_emails, ',') AS organisation$technical_contact_emails_csv,  t.id AS testbed$id,t.default_urn AS testbed$urn,t.geni_id AS testbed$geni_id  FROM organisation o  LEFT JOIN testbed t ON t.organisation_id = o.id")
    protected abstract List<OrganisationMapper.OrganisationMappingHelper> findAllHelper();

    public List<Organisation> findAll() {
        List<OrganisationMapper.OrganisationMappingHelper> h2 = this.findAllHelper();
        if (h2.isEmpty()) {
            return Collections.emptyList();
        }
        return h2.get(0).getResult();
    }

    public Organisation findById(@NotNull String id) {
        List<OrganisationMapper.OrganisationMappingHelper> h2 = this.findByIdHelper(id);
        LOG.debug("h=" + h2);
        if (h2.isEmpty() || h2.get(0).getResult() == null || h2.get(0).getResult().isEmpty()) {
            return null;
        }
        if (h2.get(0).getResult().size() > 1) {
            throw new RuntimeException("Implementation error: this query should have returned only a single Organisation, but it returned " + h2.get(0).getResult().size() + " instead");
        }
        return h2.get(0).getResult().get(0);
    }

    @SqlUpdate(value="UPDATE organisation \n SET name=:name,\n     logo_url=:logoUrl,\n     site_url=:siteUrl,\n     coordinates=:locationEncodedAsString,\n     technical_contact_emails=CAST(string_to_array(:technicalContactEmailsAsCsv, ',') AS text[])\n WHERE id=:id")
    public abstract void update(@BindBean Organisation var1);

    @SqlUpdate(value="INSERT INTO organisation (id, name, logo_url, site_url, coordinates, technical_contact_emails)  VALUES (:id, :name, :logoUrl, :siteUrl, :locationEncodedAsString,         CAST(string_to_array(:technicalContactEmailsAsCsv, ',') AS text[]) ) ")
    public abstract void insert(@BindBean Organisation var1);

    @SqlUpdate(value="DELETE FROM organisation WHERE id=:id")
    public abstract void deleteById(Integer var1);
}

