/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class ResourceMapper
implements ResultSetMapper<ResourceBuilder> {
    private String idColumnName = "id";
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    public void setIdColumnName(String idColumnName) {
        this.idColumnName = idColumnName;
    }

    @Override
    public ResourceBuilder map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        return this.map(new DaoCommon.ResultSetRowHandler(r));
    }

    public ResourceBuilder map(Map<String, Object> row) throws SQLException {
        return this.map(new DaoCommon.MapRowHandler(row));
    }

    public ResourceBuilder map(DaoCommon.RowHandler r) throws SQLException {
        ResourceBuilder resource = new ResourceBuilder();
        resource.setId(r.getInt(this.idColumnName));
        resource.setRspecElementName(r.getString("rspec_element_name"));
        resource.setComponentUrn(r.getString("component_urn"));
        resource.setDiskImage(r.getString("disk_image"));
        resource.setSliverType(r.getString("sliver_type"));
        resource.setHardwareType(r.getString("hardware_type"));
        resource.setDefaultExclusive(r.getBoolean("exclusive"));
        resource.setAllowModifyExclusive(r.getBoolean("allow_modify_exclusive"));
        resource.setLayer3(r.getBoolean("layer3"));
        resource.setRequireFixedNodeAssignment(r.getBoolean("require_fixed_node_assignment"));
        resource.setRequireDiskImage(r.getBoolean("require_disk_image"));
        resource.setRequireHardwareType(r.getBoolean("require_hardware_type"));
        resource.setAllowFixedNodeAssignment(r.getBoolean("allow_fixed_node_assignment"));
        resource.setAllowDiskImage(r.getBoolean("allow_disk_image"));
        resource.setAllowHardwareType(r.getBoolean("allow_hardware_type"));
        resource.setServer(ResourceMapper.idToServer(r.getInt("server_id")));
        resource.setAllowedSliverTypes(r.getStringArray("allowed_sliver_types"));
        resource.setAllowLinks(r.getBoolean("allow_links"));
        resource.setAllowStitchedLinks(r.getBoolean("allow_stitched_links"));
        resource.setDefaultLinkType(r.getString("default_link_type"));
        resource.setAllowedLinkTypes(r.getStringArray("allowed_link_types"));
        resource.setAutoFilterFixedNodesByHardwareType(r.getBoolean("auto_filter_fixed_nodes_by_hardware_type"));
        resource.setAutoFilterFixedNodesBySliverType(r.getBoolean("auto_filter_fixed_nodes_by_sliver_type"));
        resource.setFilterFixedNodesByHardwareType(r.getStringArray("filter_fixed_nodes_by_hardware_type_csv"));
        resource.setFilterFixedNodesBySliverType(r.getStringArray("filter_fixed_nodes_by_sliver_type_csv"));
        resource.setLinkInfo(this.linkInfoFromJsonString(r.getString("link_info_jsontext")));
        resource.setOverwriteServerName(r.getString("overwrite_server_name"));
        resource.setAllowSiteSelection(r.getBoolean("allow_site_selection"));
        return resource;
    }

    private static Server idToServer(Integer serverId) {
        if (serverId == null) {
            return null;
        }
        return ((ServerBuilder)new ServerBuilder().setId(serverId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
    }

    private List<Resource.LinkInfo> linkInfoFromJsonString(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (List)MAPPER.readValue(json, (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, Resource.LinkInfo.class));
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException("Error converting Resource.LinkInfo from JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            throw new WebApplicationException("IOException converting Resource.LinkInfo from JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

