/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServerGlimpseMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.HashPrefixStatementRewriter;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.Transaction;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterMapper(value={ServerGlimpseMapper.class})
public abstract class ServerGlimpseDao
implements GetHandle {
    private static final Logger LOG = LoggerFactory.getLogger(ServerGlimpseDao.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    @SqlQuery(value="SELECT server_id,         CAST(advertisement_info AS text) AS advertisement_info_json_text,         CAST(health_info AS text) AS health_info_json_text,         CAST(maintenance AS text) AS maintenance_json_text,         reputation   FROM serverglimpse")
    public abstract Collection<ServerGlimpseBuilder> findAllServerGlimpses();

    @SqlQuery(value="SELECT server_id,         CAST(advertisement_info AS text) AS advertisement_info_json_text,         CAST(health_info AS text) AS health_info_json_text,          CAST(maintenance AS text) AS maintenance_json_text,         reputation   FROM serverglimpse  WHERE server_id = :serverId")
    public abstract ServerGlimpseBuilder getServerGlimpse(@Bind(value="serverId") Integer var1);

    @SqlUpdate(value="DELETE FROM serverglimpse WHERE server_id = :serverId")
    public abstract void deleteByServerId(@Bind(value="serverId") Integer var1);

    public void addMaintenance(@Nonnull Integer serverId, @Nonnull MaintenanceInfo maintenanceInfo) {
        this.addMaintenanceFromJsonString(serverId, this.maintenanceToJson(maintenanceInfo));
    }

    public void replaceMaintenances(@Nonnull Integer serverId, @Nonnull List<MaintenanceInfo> maintenanceInfos) {
        this.replaceMaintenancesFromJsonString(serverId, this.maintenanceToJson(maintenanceInfos));
    }

    @SqlUpdate(value="UPDATE serverglimpse SET maintenance = COALESCE(maintenance, CAST('[]' AS jsonb)) || CAST(:maintenance AS jsonb) WHERE server_id=:serverId")
    abstract void addMaintenanceFromJsonString(@Bind(value="serverId") Integer var1, @Bind(value="maintenance") String var2);

    @SqlUpdate(value="UPDATE serverglimpse SET maintenance = CAST(:maintenances AS jsonb) WHERE server_id=:serverId")
    abstract void replaceMaintenancesFromJsonString(@Bind(value="serverId") Integer var1, @Bind(value="maintenances") String var2);

    public void upsert(ServerGlimpse serverGlimpse, boolean updateAdvertisement, boolean updateHealth, boolean updateReputation, boolean updateMaintenance) {
        this.upsertPostPostgres95(serverGlimpse, updateAdvertisement, updateHealth, updateReputation, updateMaintenance);
    }

    @Transaction
    public void upsertPostPostgres95(ServerGlimpse serverGlimpse, boolean updateAdvertisement, boolean updateHealth, boolean updateReputation, boolean updateMaintenance) {
        if (!(updateAdvertisement || updateHealth || updateMaintenance || updateReputation)) {
            return;
        }
        boolean has1stComma = updateAdvertisement && (updateHealth || updateMaintenance || updateReputation);
        boolean has2ndComma = updateHealth && (updateMaintenance || updateReputation);
        boolean has3rdComma = updateMaintenance && updateReputation;
        Object upsertString = "INSERT INTO serverglimpse (server_id, ";
        if (updateAdvertisement) {
            upsertString = (String)upsertString + "advertisement_info";
        }
        if (has1stComma) {
            upsertString = (String)upsertString + ", ";
        }
        if (updateHealth) {
            upsertString = (String)upsertString + "health_info";
        }
        if (has2ndComma) {
            upsertString = (String)upsertString + ", ";
        }
        if (updateMaintenance) {
            upsertString = (String)upsertString + "maintenance";
        }
        if (has3rdComma) {
            upsertString = (String)upsertString + ", ";
        }
        if (updateReputation) {
            upsertString = (String)upsertString + "reputation";
        }
        upsertString = (String)upsertString + ")";
        upsertString = (String)upsertString + " VALUES (#serverId,\n";
        if (updateAdvertisement) {
            upsertString = (String)upsertString + "  CAST(#advertisementInfoJson AS jsonb)";
        }
        if (has1stComma) {
            upsertString = (String)upsertString + ",\n";
        }
        if (updateHealth) {
            upsertString = (String)upsertString + "  CAST(#healthInfoJson AS jsonb)";
        }
        if (has2ndComma) {
            upsertString = (String)upsertString + ",\n";
        }
        if (updateMaintenance) {
            upsertString = (String)upsertString + "  CAST(#maintenance AS jsonb)";
        }
        if (has3rdComma) {
            upsertString = (String)upsertString + ",\n";
        }
        if (updateReputation) {
            upsertString = (String)upsertString + "  #reputation";
        }
        upsertString = (String)upsertString + ")\n";
        upsertString = (String)upsertString + "   ON CONFLICT (server_id) DO UPDATE SET ";
        if (updateAdvertisement) {
            upsertString = (String)upsertString + "advertisement_info=EXCLUDED.advertisement_info";
        }
        if (has1stComma) {
            upsertString = (String)upsertString + ",";
        }
        if (updateHealth) {
            upsertString = (String)upsertString + "health_info=EXCLUDED.health_info";
        }
        if (has2ndComma) {
            upsertString = (String)upsertString + ",";
        }
        if (updateMaintenance) {
            upsertString = (String)upsertString + "maintenance=EXCLUDED.maintenance";
        }
        if (has3rdComma) {
            upsertString = (String)upsertString + ",";
        }
        if (updateReputation) {
            upsertString = (String)upsertString + "reputation=EXCLUDED.reputation";
        }
        Handle h2 = this.getHandle();
        Update upsert = h2.createStatement((String)upsertString);
        upsert.setStatementRewriter(new HashPrefixStatementRewriter());
        upsert = (Update)upsert.bind("serverId", (Integer)serverGlimpse.getServer().getId());
        upsert = (Update)upsert.bind("advertisementInfoJson", this.advertisementInfoToJson(serverGlimpse.getAdvertisementInfo()));
        upsert = (Update)upsert.bind("healthInfoJson", this.healthInfoToJson(serverGlimpse.getHealthInfo()));
        upsert = (Update)upsert.bind("maintenance", this.maintenanceToJson(serverGlimpse.getMaintenance()));
        upsert = (Update)upsert.bind("reputation", serverGlimpse.getReputation());
        int rows = upsert.execute();
        if (rows != 1) {
            throw new WebApplicationException("upsert affected " + rows + " rows instead of the expected 1", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Transaction
    public void upsertPrePostgres95(ServerGlimpse serverGlimpse, boolean updateAdvertisement, boolean updateHealth) {
        if (!updateAdvertisement && !updateHealth) {
            return;
        }
        boolean updateBoth = updateAdvertisement && updateHealth;
        Object updateString = "UPDATE serverglimpse SET \n";
        if (updateAdvertisement) {
            updateString = (String)updateString + " advertisement_info=CAST(#advertisementInfoJson AS jsonb)";
        }
        if (updateBoth) {
            updateString = (String)updateString + ",\n";
        }
        if (updateHealth) {
            updateString = (String)updateString + "    health_info=CAST(#healthInfoJson AS jsonb)\n";
        }
        updateString = (String)updateString + " WHERE server_id=#serverId";
        String insertString = "INSERT INTO serverglimpse VALUES (#serverId,\n                               CAST(#advertisementInfoJson AS jsonb),\n                               CAST(#healthInfoJson AS jsonb))";
        Handle h2 = this.getHandle();
        Update update2 = h2.createStatement((String)updateString);
        update2.setStatementRewriter(new HashPrefixStatementRewriter());
        update2 = (Update)update2.bind("serverId", (Integer)serverGlimpse.getServer().getId());
        update2 = (Update)update2.bind("advertisementInfoJson", this.advertisementInfoToJson(serverGlimpse.getAdvertisementInfo()));
        update2 = (Update)update2.bind("healthInfoJson", this.healthInfoToJson(serverGlimpse.getHealthInfo()));
        int rowsUpdated = update2.execute();
        if (rowsUpdated != 1) {
            Update insert = h2.createStatement(insertString);
            insert.setStatementRewriter(new HashPrefixStatementRewriter());
            insert = (Update)insert.bind("serverId", (Integer)serverGlimpse.getServer().getId());
            insert = (Update)insert.bind("advertisementInfoJson", this.advertisementInfoToJson(serverGlimpse.getAdvertisementInfo()));
            insert = (Update)insert.bind("healthInfoJson", this.healthInfoToJson(serverGlimpse.getHealthInfo()));
            int rowsInserted = insert.execute();
            if (rowsInserted != 1) {
                throw new WebApplicationException("upsert failed both update and insert: affected " + rowsUpdated + " rows on update and " + rowsInserted + " rows on insert instead of the expected 1", Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private String advertisementInfoToJson(ServerGlimpse.AdvertisementInfo advertisementInfo) {
        if (advertisementInfo == null) {
            return null;
        }
        try {
            return MAPPER.writer().writeValueAsString(advertisementInfo);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException("Error converting ServerGlimpse.AdvertisementInfo to JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String healthInfoToJson(ServerGlimpse.HealthInfo healthInfo) {
        if (healthInfo == null) {
            return null;
        }
        try {
            return MAPPER.writer().writeValueAsString(healthInfo);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException("Error converting ServerGlimpse.HealthInfo to JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String maintenanceToJson(List<MaintenanceInfo> maintenanceInfo) {
        if (maintenanceInfo == null) {
            return null;
        }
        try {
            return MAPPER.writer().writeValueAsString(maintenanceInfo);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException("Error converting MaintenanceInfo to JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String maintenanceToJson(MaintenanceInfo maintenanceInfo) {
        if (maintenanceInfo == null) {
            return null;
        }
        try {
            return MAPPER.writer().writeValueAsString(maintenanceInfo);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException("Error converting MaintenanceInfo to JSON", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static List<Result> idToResult(List<Long> resultIds) {
        if (resultIds == null) {
            return null;
        }
        return resultIds.stream().map(i -> ServerGlimpseDao.idToResult(i)).collect(Collectors.toList());
    }

    private static Result idToResult(Long resultId) {
        if (resultId == null) {
            return null;
        }
        return ((ResultBuilder)new ResultBuilder().setId(resultId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
    }

    private static List<Server> idToServer(List<Integer> serverIds) {
        if (serverIds == null) {
            return null;
        }
        return serverIds.stream().map(i -> ServerGlimpseDao.idToServer(i)).collect(Collectors.toList());
    }

    private static Server idToServer(Integer serverId) {
        if (serverId == null) {
            return null;
        }
        return ((ServerBuilder)new ServerBuilder().setId(serverId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

