/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.base.dao.DaoCommon;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceStatisticsMapper;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.HashPrefixStatementRewriter;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterMapper(value={TestInstanceStatisticsMapper.class})
public abstract class TestInstanceStatisticsDao
implements GetHandle {
    private static final Logger LOG = LoggerFactory.getLogger(TestInstanceStatisticsDao.class);
    private final String noExpiredTaskFilter = "((task.stop IS NULL AND :now < task.deadline) OR task.stop < task.deadline)";

    @SqlQuery(value="SELECT ti.id,next_run,last_run,last_result_id,last_result_id_excluding_cancelled,last_result_date,last_result_excluding_cancelled_date,CAST(test_statistics AS text) AS test_statistics_text, CAST(summation AS text) AS summation_text, task.id AS active_task_id  FROM testinstance ti  LEFT JOIN task task ON task.testinstance_id=ti.id AND      (task.state = 'RUNNING' OR task.state = 'CREATED' OR task.state = 'CANCELLING') AND     ((task.stop IS NULL AND :now < task.deadline) OR task.stop < task.deadline)  WHERE ti.id = :id")
    public abstract TestInstanceStatisticsBuilder getByTestInstanceId(@NotNull @Bind(value="id") int var1, @Bind(value="now") Timestamp var2);

    @SqlQuery(value="SELECT ti.id,next_run,last_run,last_result_id,last_result_id_excluding_cancelled,last_result_date,last_result_excluding_cancelled_date,CAST(test_statistics AS text) AS test_statistics_text, CAST(summation AS text) AS summation_text, task.id AS active_task_id  FROM testinstance ti  LEFT JOIN task task ON task.testinstance_id=ti.id AND                            (task.state = 'RUNNING' OR task.state = 'CREATED' OR task.state = 'CANCELLING') AND                           ((task.stop IS NULL AND :now < task.deadline) OR task.stop < task.deadline)")
    public abstract List<TestInstanceStatisticsBuilder> getAll(@Bind(value="now") Timestamp var1);

    @SqlUpdate(value="UPDATE testinstance SET test_statistics=CAST(:testStatisticsJsonText AS jsonb) WHERE id = :testInstanceId")
    public abstract void updateTestStatistics(@Bind(value="testInstanceId") Integer var1, @Bind(value="testStatisticsJsonText") String var2);

    @SqlUpdate(value="UPDATE testinstance SET summation=CAST(:summationJsonText AS jsonb) WHERE id = :testInstanceId")
    public abstract void updateSummation(@Bind(value="testInstanceId") Integer var1, @Bind(value="summationJsonText") String var2);

    @SqlUpdate(value="UPDATE testinstance SET next_run=:nextRun WHERE id = :testInstanceId")
    public abstract void updateNextRun(@Bind(value="testInstanceId") Integer var1, @Bind(value="nextRun") Timestamp var2);

    public List<TestInstanceStatisticsBuilder> search(List<String> versionNameFilter, List<String> testInstanceNameFilter, List<String> testDefinitionNameFilter, List<Integer> testInstanceIdFilter, List<String> testbedCategoryFilter, List<String> testbedGeniNameFilter, List<String> testbedNameFilter, List<String> testbedUrnFilter, boolean nextRun, Boolean disabled, Boolean activeTask, @Nonnull Timestamp now) {
        List<TestInstanceStatisticsBuilder> list;
        boolean hasTestbedFilter = false;
        ArrayList<Object> whereParts = new ArrayList<Object>();
        if (versionNameFilter != null && !versionNameFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.test_version_name", "ver", versionNameFilter.size()));
        }
        if (testInstanceNameFilter != null && !testInstanceNameFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.name", "name", testInstanceNameFilter.size()));
        }
        if (testDefinitionNameFilter != null && !testDefinitionNameFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.testdefinition_id", "td", testDefinitionNameFilter.size()));
        }
        if (testInstanceIdFilter != null && !testInstanceIdFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.id", "id", testInstanceIdFilter.size()));
        }
        if (testbedCategoryFilter != null && !testbedCategoryFilter.isEmpty()) {
            whereParts.add("ARRAY[" + DaoCommon.makeWherePartList("tbcat", testbedCategoryFilter.size()) + "]::varchar[] && ti.testbed_categories");
            hasTestbedFilter = true;
        }
        if (testbedGeniNameFilter != null && !testbedGeniNameFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.testbed_geni_id", "tbgeni", testbedGeniNameFilter.size()));
            hasTestbedFilter = true;
        }
        if (testbedUrnFilter != null && !testbedUrnFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.testbed_default_urn", "tburn", testbedUrnFilter.size()));
            hasTestbedFilter = true;
        }
        if (testbedNameFilter != null && !testbedNameFilter.isEmpty()) {
            whereParts.add(DaoCommon.makeWherePart("ti.testbed_id", "tb", testbedNameFilter.size()));
            hasTestbedFilter = true;
        }
        if (nextRun) {
            whereParts.add("ti.next_run IS NULL OR ti.next_run <= #now");
        }
        if (disabled != null) {
            if (disabled.booleanValue()) {
                whereParts.add("ti.enabled = FALSE");
            } else {
                whereParts.add("ti.enabled = TRUE");
            }
        }
        if (activeTask != null) {
            if (activeTask.booleanValue()) {
                whereParts.add("task.id IS NOT NULL");
            } else {
                whereParts.add("task.id IS NULL");
            }
        }
        String queryString = "SELECT ti.id,next_run,last_run,last_result_id,last_result_id_excluding_cancelled,last_result_date,last_result_excluding_cancelled_date,CAST(test_statistics AS text) AS test_statistics_text, CAST(summation AS text) AS summation_text, task.id AS active_task_id " + (hasTestbedFilter ? " FROM testinstance_with_testbed ti " : " FROM testinstance ti ") + " LEFT JOIN task task ON task.testinstance_id=ti.id AND                             (task.state = 'RUNNING' OR task.state = 'CREATED' OR task.state = 'CANCELLING') AND                             " + "((task.stop IS NULL AND :now < task.deadline) OR task.stop < task.deadline)".replaceAll(Pattern.quote(":now"), "#now");
        if (!whereParts.isEmpty()) {
            queryString = queryString + " WHERE ";
            boolean first = true;
            for (String string : whereParts) {
                if (!first) {
                    queryString = queryString + " AND ";
                }
                queryString = queryString + "(" + string + ")";
                first = false;
            }
            queryString = queryString + " ";
        }
        LOG.debug("search() queryString=\"" + queryString + "\"");
        Handle h2 = this.getHandle();
        h2.registerMapper(new TestInstanceStatisticsMapper());
        Query<Map<String, Object>> query = h2.createQuery(queryString);
        query.setStatementRewriter(new HashPrefixStatementRewriter());
        if (versionNameFilter != null && !versionNameFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "ver", versionNameFilter);
        }
        if (testInstanceNameFilter != null && !testInstanceNameFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "name", testInstanceNameFilter);
        }
        if (testDefinitionNameFilter != null && !testDefinitionNameFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "td", testDefinitionNameFilter);
        }
        if (testInstanceIdFilter != null && !testInstanceIdFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "id", testInstanceIdFilter);
        }
        if (testbedCategoryFilter != null && !testbedCategoryFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "tbcat", testbedCategoryFilter);
        }
        if (testbedGeniNameFilter != null && !testbedGeniNameFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "tbgeni", testbedGeniNameFilter);
        }
        if (testbedUrnFilter != null && !testbedUrnFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "tburn", testbedUrnFilter);
        }
        if (testbedNameFilter != null && !testbedNameFilter.isEmpty()) {
            query = DaoCommon.setVars(query, "tb", testbedNameFilter);
        }
        if ((list = (query = (Query<Map<String, Object>>)query.bind("now", now)).mapTo(TestInstanceStatisticsBuilder.class).list()).isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }
}

