/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GtsConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GuiConfigSetBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LoginSite;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dropwizard.jackson.Jackson;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="guiconfigset", builderClass=GuiConfigSetBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class GuiConfigSet
extends PrimaryIdObject<String> {
    private static final Logger LOG = LoggerFactory.getLogger(GuiConfigSet.class);
    private final List<Server> bindableServers;
    private final List<Server> hideServers;
    private final Map<String, Object> flags;
    private final GtsConfig gtsConfig;
    private final List<TriggeredMessage> triggeredMessages;
    private final List<LoginSite> loginSites;
    private final String description;

    @JsonCreator
    GuiConfigSet(@JsonProperty(value="id") String id, @JsonProperty(value="bindableServers") List<Server> bindableServers, @JsonProperty(value="hideServers") List<Server> hideServers, @JsonProperty(value="flags") Map<String, Object> flags, @JsonProperty(value="gtsConfig") GtsConfig gtsConfig, @JsonProperty(value="triggeredMessages") List<TriggeredMessage> triggeredMessages, @JsonProperty(value="loginSites") List<LoginSite> loginSites, @JsonProperty(value="description") String description, @JsonProperty(value="@id") URI uri) {
        super(id, uri, false);
        this.bindableServers = bindableServers;
        this.hideServers = hideServers;
        this.flags = flags;
        this.gtsConfig = gtsConfig;
        this.triggeredMessages = triggeredMessages;
        this.loginSites = loginSites;
        this.description = description;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServerListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildrenLinkListSerializer.class)
    public List<Server> getBindableServers() {
        return this.bindableServers;
    }

    @JsonIgnore
    public String getBindableServersIdCsv() {
        return this.bindableServers == null ? null : this.bindableServers.stream().map(PrimaryIdObject::getId).map(Object::toString).collect(Collectors.joining(","));
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServerListDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildrenLinkListSerializer.class)
    public List<Server> getHideServers() {
        return this.hideServers;
    }

    @JsonIgnore
    public String getHideServersIdCsv() {
        return this.hideServers == null ? null : this.hideServers.stream().map(PrimaryIdObject::getId).map(Object::toString).collect(Collectors.joining(","));
    }

    @JsonProperty
    public Map<String, Object> getFlags() {
        return this.flags;
    }

    @JsonIgnore
    public String getFlagsAsJsonString() {
        if (this.flags == null) {
            return null;
        }
        if (this.flags.isEmpty()) {
            return "{}";
        }
        ObjectMapper mapper = Jackson.newObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.flags);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting flags into JSON", e);
            throw new RuntimeException("Exception converting flags into JSON");
        }
    }

    @JsonProperty
    public GtsConfig getGtsConfig() {
        return this.gtsConfig;
    }

    @JsonIgnore
    public String getGtsConfigAsJsonString() {
        if (this.gtsConfig == null) {
            return null;
        }
        ObjectMapper mapper = Jackson.newObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.gtsConfig);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting gtsConfig into JSON", e);
            throw new RuntimeException("Exception converting gtsConfig into JSON");
        }
    }

    @JsonProperty
    public List<TriggeredMessage> getTriggeredMessages() {
        return this.triggeredMessages;
    }

    @JsonIgnore
    public String getTriggeredMessagesAsJsonString() {
        if (this.triggeredMessages == null) {
            return null;
        }
        if (this.triggeredMessages.isEmpty()) {
            return "[]";
        }
        ObjectMapper mapper = Jackson.newObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.triggeredMessages);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting triggeredMessages into JSON", e);
            throw new RuntimeException("Exception converting triggeredMessages into JSON");
        }
    }

    @JsonProperty
    public List<LoginSite> getLoginSites() {
        return this.loginSites;
    }

    @JsonIgnore
    public String getLoginSitesAsJsonString() {
        if (this.loginSites == null) {
            return null;
        }
        if (this.loginSites.isEmpty()) {
            return "[]";
        }
        ObjectMapper mapper = Jackson.newObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.loginSites);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting loginSites into JSON", e);
            throw new RuntimeException("Exception converting loginSites into JSON");
        }
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuiConfigSet that = (GuiConfigSet)o;
        if (this.id != null ? !((String)this.id).equals(that.id) : that.id != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.flags != null ? !this.flags.equals(that.flags) : that.flags != null) {
            return false;
        }
        if (this.gtsConfig != null ? !this.gtsConfig.equals(that.gtsConfig) : that.gtsConfig != null) {
            return false;
        }
        if (this.triggeredMessages != null ? !this.triggeredMessages.equals(that.triggeredMessages) : that.triggeredMessages != null) {
            return false;
        }
        return !(this.loginSites != null ? !this.loginSites.equals(that.loginSites) : that.loginSites != null);
    }

    @Override
    public int hashCode() {
        int result = this.id != null ? ((String)this.id).hashCode() : 0;
        result = 31 * result + (this.flags != null ? this.flags.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.gtsConfig != null ? this.gtsConfig.hashCode() : 0);
        result = 31 * result + (this.triggeredMessages != null ? this.triggeredMessages.hashCode() : 0);
        result = 31 * result + (this.loginSites != null ? this.loginSites.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting GuiConfigSet " + (String)this.id + " to JSON", e);
            return "Exception converting GuiConfigSet " + (String)this.id + " to JSON: " + e.getMessage();
        }
    }
}

