/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GtsConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LoginSite;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClassBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.BasicLdObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=JFedExperimenterGuiConfig.class)
public class JFedExperimenterGuiConfigBuilder
extends BasicLdObjectBuilder<JFedExperimenterGuiConfig> {
    private UserInfo user;
    private Map<String, Object> flags;
    private GtsConfig gtsConfig;
    private Set<ResourceClass> resourceClasses;
    private Set<ResourceClassBuilder> resourceClassBuilders;
    private Set<Server> bindableServers;
    private Set<Server> hideServers;
    private Set<TriggeredMessage> triggeredMessages;
    private Set<LoginSite> loginSites;
    private static final Comparator<ResourceClass> RESOURCECLASS_COMPARATOR = new Comparator<ResourceClass>(){

        @Override
        public int compare(ResourceClass r1, ResourceClass r2) {
            if (r1 == null || r2 == null) {
                throw new NullPointerException("Cannot compare null ResourceClass");
            }
            if (r1.getId() == null || r2.getId() == null) {
                throw new NullPointerException("Cannot compare ResourceClasses with null ID");
            }
            return ((String)r1.getId()).compareTo((String)r2.getId());
        }
    };
    private static final Comparator<TriggeredMessage> TRIGGERED_MESSAGE_COMPARATOR = new Comparator<TriggeredMessage>(){

        @Override
        public int compare(TriggeredMessage r1, TriggeredMessage r2) {
            if (r1 == null || r2 == null) {
                throw new NullPointerException("Cannot compare null TriggeredMessage");
            }
            if (r1.getId() == null || r2.getId() == null) {
                throw new NullPointerException("Cannot compare TriggeredMessage with null ID");
            }
            return r1.getId().compareTo(r2.getId());
        }
    };
    private static final Comparator<LoginSite> LOGINSITE_COMPARATOR = new Comparator<LoginSite>(){

        @Override
        public int compare(LoginSite r1, LoginSite r2) {
            if (r1 == null || r2 == null) {
                throw new NullPointerException("Cannot compare null LoginSites");
            }
            if (r1.getId() == null || r2.getId() == null) {
                throw new NullPointerException("Cannot compare LoginSite with null ID");
            }
            return r1.getId().compareTo(r2.getId());
        }
    };
    private static final Comparator<ResourceClassBuilder> RESOURCECLASSBUILDER_COMPARATOR = new Comparator<ResourceClassBuilder>(){

        @Override
        public int compare(ResourceClassBuilder r1, ResourceClassBuilder r2) {
            if (r1 == null || r2 == null) {
                throw new NullPointerException("Cannot compare null ResourceClassBuilder");
            }
            if (r1.getId() == null || r2.getId() == null) {
                throw new NullPointerException("Cannot compare ResourceClassBuilder with null ID");
            }
            return ((String)r1.getId()).compareTo((String)r2.getId());
        }
    };
    private static final Comparator<Server> SERVER_COMPARATOR = new Comparator<Server>(){

        @Override
        public int compare(Server s1, Server s2) {
            if (s1 == null || s2 == null) {
                throw new NullPointerException("Cannot compare null Server");
            }
            if (s1.getId() == null || s2.getId() == null) {
                throw new NullPointerException("Cannot compare Server with null ID");
            }
            return ((Integer)s1.getId()).compareTo((Integer)s2.getId());
        }
    };

    public JFedExperimenterGuiConfigBuilder() {
    }

    public JFedExperimenterGuiConfigBuilder(JFedExperimenterGuiConfig orig) {
        super(orig);
        this.user = orig.getUser();
        this.flags = orig.getFlags();
        this.gtsConfig = orig.getGtsConfig();
        this.resourceClassBuilders = null;
        if (orig.getResourceClasses() == null) {
            this.resourceClasses = null;
        } else {
            this.resourceClasses = new TreeSet<ResourceClass>(RESOURCECLASS_COMPARATOR);
            this.resourceClasses.addAll(orig.getResourceClasses());
        }
        if (orig.getBindableServers() == null) {
            this.bindableServers = null;
        } else {
            this.bindableServers = new TreeSet<Server>(SERVER_COMPARATOR);
            this.bindableServers.addAll(orig.getBindableServers());
        }
        if (orig.getHideServers() == null) {
            this.hideServers = null;
        } else {
            this.hideServers = new TreeSet<Server>(SERVER_COMPARATOR);
            this.hideServers.addAll(orig.getHideServers());
        }
        if (orig.getTriggeredMessages() == null) {
            this.triggeredMessages = null;
        } else {
            this.triggeredMessages = new TreeSet<TriggeredMessage>(TRIGGERED_MESSAGE_COMPARATOR);
            this.triggeredMessages.addAll(orig.getTriggeredMessages());
        }
        if (orig.getLoginSites() == null) {
            this.loginSites = null;
        } else {
            this.loginSites = new TreeSet<LoginSite>(LOGINSITE_COMPARATOR);
            this.loginSites.addAll(orig.getLoginSites());
        }
    }

    public JFedExperimenterGuiConfigBuilder setUser(UserInfo user) {
        this.user = user;
        return this;
    }

    public JFedExperimenterGuiConfigBuilder setFlags(Map<String, Object> flags) {
        this.flags = new TreeMap<String, Object>(flags);
        return this;
    }

    public JFedExperimenterGuiConfigBuilder setFlag(String key, Object value) {
        if (this.flags == null) {
            this.flags = new TreeMap<String, Object>();
        }
        this.flags.put(key, value);
        return this;
    }

    public JFedExperimenterGuiConfigBuilder setGtsConfig(GtsConfig gtsConfig) {
        this.gtsConfig = gtsConfig;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=ResourceClass.class)
    public JFedExperimenterGuiConfigBuilder setResourceClasses(Collection<ResourceClass> resourceClasses) {
        if (resourceClasses != null) {
            this.resourceClasses = new TreeSet<ResourceClass>(RESOURCECLASS_COMPARATOR);
            this.resourceClasses.addAll(resourceClasses);
        } else {
            this.resourceClasses = null;
        }
        return this;
    }

    public JFedExperimenterGuiConfigBuilder addResourceClass(ResourceClass resourceClass) {
        if (this.resourceClasses == null) {
            this.resourceClasses = new TreeSet<ResourceClass>(RESOURCECLASS_COMPARATOR);
        }
        this.resourceClasses.add(resourceClass);
        return this;
    }

    public JFedExperimenterGuiConfigBuilder setTriggeredMessages(Collection<TriggeredMessage> triggeredMessages) {
        if (triggeredMessages != null) {
            this.triggeredMessages = new TreeSet<TriggeredMessage>(TRIGGERED_MESSAGE_COMPARATOR);
            this.triggeredMessages.addAll(triggeredMessages);
        } else {
            this.triggeredMessages = null;
        }
        return this;
    }

    public JFedExperimenterGuiConfigBuilder addTriggeredMessage(TriggeredMessage triggeredMessage) {
        if (this.triggeredMessages == null) {
            this.triggeredMessages = new TreeSet<TriggeredMessage>(TRIGGERED_MESSAGE_COMPARATOR);
        }
        this.triggeredMessages.add(triggeredMessage);
        return this;
    }

    public JFedExperimenterGuiConfigBuilder setLoginSites(Collection<LoginSite> loginSites) {
        if (loginSites != null) {
            this.loginSites = new TreeSet<LoginSite>(LOGINSITE_COMPARATOR);
            this.loginSites.addAll(loginSites);
        } else {
            this.loginSites = null;
        }
        return this;
    }

    public JFedExperimenterGuiConfigBuilder addLoginSite(LoginSite loginSite) {
        if (this.loginSites == null) {
            this.loginSites = new TreeSet<LoginSite>(LOGINSITE_COMPARATOR);
        }
        this.loginSites.add(loginSite);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=ResourceClass.class, builderReference=true)
    public JFedExperimenterGuiConfigBuilder setResourceClassBuilders(Collection<ResourceClassBuilder> resourceClassBuilders) {
        if (resourceClassBuilders != null) {
            this.resourceClassBuilders = new TreeSet<ResourceClassBuilder>(RESOURCECLASSBUILDER_COMPARATOR);
            this.resourceClassBuilders.addAll(resourceClassBuilders);
        } else {
            this.resourceClassBuilders = null;
        }
        return this;
    }

    public JFedExperimenterGuiConfigBuilder addResourceClassBuilder(ResourceClassBuilder resourceClassBuilder) {
        if (this.resourceClassBuilders == null) {
            this.resourceClassBuilders = new TreeSet<ResourceClassBuilder>(RESOURCECLASSBUILDER_COMPARATOR);
        }
        this.resourceClassBuilders.add(resourceClassBuilder);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Server.class, name="bindableServers")
    public JFedExperimenterGuiConfigBuilder setBindableServers(Collection<Server> bindableServers) {
        if (bindableServers != null) {
            this.bindableServers = new TreeSet<Server>(SERVER_COMPARATOR);
            this.bindableServers.addAll(bindableServers);
        } else {
            this.bindableServers = null;
        }
        return this;
    }

    public JFedExperimenterGuiConfigBuilder addBindableServer(Server bindableServer) {
        if (this.bindableServers == null) {
            this.bindableServers = new TreeSet<Server>(SERVER_COMPARATOR);
        }
        this.bindableServers.add(bindableServer);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Server.class, name="hideServers")
    public JFedExperimenterGuiConfigBuilder setHideServers(Collection<Server> hideServers) {
        if (hideServers != null) {
            this.hideServers = new TreeSet<Server>(SERVER_COMPARATOR);
            this.hideServers.addAll(hideServers);
        } else {
            this.hideServers = null;
        }
        return this;
    }

    public JFedExperimenterGuiConfigBuilder addHideServer(Server hideServer) {
        if (this.hideServers == null) {
            this.hideServers = new TreeSet<Server>(SERVER_COMPARATOR);
        }
        this.hideServers.add(hideServer);
        return this;
    }

    @Override
    public JFedExperimenterGuiConfig create() {
        if (this.resourceClassBuilders != null && this.resourceClasses != null) {
            throw new IllegalStateException("Either none, only resources or only resourceBuilders must be set, not both.");
        }
        Collection<ResourceClass> usedResourceClasses = null;
        if (this.resourceClassBuilders != null) {
            usedResourceClasses = this.resourceClassBuilders.stream().map(ResourceClassBuilder::create).collect(Collectors.toList());
        }
        if (this.resourceClasses != null) {
            usedResourceClasses = this.resourceClasses;
        }
        assert ((this.resourceClassBuilders == null && this.resourceClasses == null) == (usedResourceClasses == null));
        return new JFedExperimenterGuiConfig(this.user, this.flags, this.gtsConfig, usedResourceClasses, this.bindableServers == null ? null : ServerBuilder.minimize(JsonLdObjectsMetaData.Minimization.ID_ONLY, this.bindableServers), this.hideServers == null ? null : ServerBuilder.minimize(JsonLdObjectsMetaData.Minimization.ID_ONLY, this.hideServers), this.triggeredMessages == null ? null : new ArrayList<TriggeredMessage>(this.triggeredMessages), (List<LoginSite>)(this.loginSites == null ? null : new ArrayList<LoginSite>(this.loginSites)));
    }

    @Override
    public JFedExperimenterGuiConfig createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        if (this.resourceClassBuilders != null && this.resourceClasses != null) {
            throw new IllegalStateException("Either none, only resources or only resourceBuilders must be set, not both.");
        }
        Collection<ResourceClass> usedResourceClasses = null;
        if (this.resourceClassBuilders != null && minimization.includeChildren()) {
            usedResourceClasses = this.resourceClassBuilders.stream().map(ResourceClassBuilder::create).collect(Collectors.toList());
        }
        if (this.resourceClasses != null) {
            usedResourceClasses = this.resourceClasses;
        }
        assert ((this.resourceClassBuilders == null && this.resourceClasses == null) == (usedResourceClasses == null));
        return new JFedExperimenterGuiConfig(this.user, this.flags, this.gtsConfig, usedResourceClasses == null || !minimization.includeChildren() ? null : ResourceClassBuilder.minimize(minimization.getChildrenMinimization(), usedResourceClasses), this.bindableServers == null || !minimization.includeChildren() ? null : ServerBuilder.minimize(JsonLdObjectsMetaData.Minimization.ID_ONLY, this.bindableServers), this.hideServers == null || !minimization.includeChildren() ? null : ServerBuilder.minimize(JsonLdObjectsMetaData.Minimization.ID_ONLY, this.hideServers), this.triggeredMessages == null ? null : new ArrayList<TriggeredMessage>(this.triggeredMessages), (List<LoginSite>)(this.loginSites == null ? null : new ArrayList<LoginSite>(this.loginSites)));
    }

    public static List<JFedExperimenterGuiConfig> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<JFedExperimenterGuiConfig> in) {
        if (in == null) {
            return null;
        }
        ArrayList<JFedExperimenterGuiConfig> res = new ArrayList<JFedExperimenterGuiConfig>();
        for (JFedExperimenterGuiConfig jegc : in) {
            res.add(new JFedExperimenterGuiConfigBuilder(jegc).createMinimized(minimization));
        }
        return res;
    }

    public static JFedExperimenterGuiConfig minimize(JsonLdObjectsMetaData.Minimization minimization, JFedExperimenterGuiConfig in) {
        if (in == null) {
            return null;
        }
        return new JFedExperimenterGuiConfigBuilder(in).createMinimized(minimization);
    }

    public UserInfo getUser() {
        return this.user;
    }

    public Map<String, Object> getFlags() {
        return this.flags;
    }

    public GtsConfig getGtsConfig() {
        return this.gtsConfig;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=ResourceClass.class)
    public Set<ResourceClass> getResourceClasses() {
        return this.resourceClasses;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=ResourceClass.class, builderReference=true)
    public Set<ResourceClassBuilder> getResourceClassBuilders() {
        return this.resourceClassBuilders;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Server.class, name="bindableServers")
    public Set<Server> getBindableServers() {
        return this.bindableServers;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Server.class, name="hideServers")
    public Set<Server> getHideServers() {
        return this.hideServers;
    }

    public Set<TriggeredMessage> getTriggeredMessages() {
        return this.triggeredMessages;
    }

    public Set<LoginSite> getLoginSites() {
        return this.loginSites;
    }
}

