/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LogBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Serializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="log", builderClass=LogBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Log
extends PrimaryIdObject<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(Log.class);
    private final String name;
    private final Task task;
    private final Result result;
    private final Timestamp startTime;
    private final Timestamp stopTime;
    private final Boolean live;
    private final Boolean complete;
    private final Long size;
    private final LogMediaType mediaType;
    private final URI content;

    @JsonCreator
    Log(@JsonProperty(value="id") Long id, @JsonProperty(value="name") String name, @JsonProperty(value="task") Task task, @JsonProperty(value="result") Result result, @JsonProperty(value="startTime") Timestamp startTime, @JsonProperty(value="stopTime") Timestamp stopTime, @JsonProperty(value="live") Boolean live, @JsonProperty(value="complete") Boolean complete, @JsonProperty(value="size") Long size, @JsonProperty(value="mediaType") LogMediaType mediaType, @JsonProperty(value="content") URI content, @JsonProperty(value="@id") URI uri) {
        this(id, name, task, result, startTime, stopTime, live, complete, size, mediaType, content, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    Log(Long id, String name, Task task, Result result, Timestamp startTime, Timestamp stopTime, Boolean live, Boolean complete, Long size, LogMediaType mediaType, URI content, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super(id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.name = name;
        this.task = task;
        this.result = result;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.live = live;
        this.complete = complete;
        this.size = size;
        this.mediaType = mediaType;
        this.content = content;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TaskDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
    public Task getTask() {
        return this.task;
    }

    @JsonIgnore
    public Long getTaskId() {
        return this.task == null ? null : (Long)this.task.getId();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResultDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
    public Result getResult() {
        return this.result;
    }

    @JsonIgnore
    public Long getResultId() {
        return this.result == null ? null : (Long)this.result.getId();
    }

    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @JsonProperty
    public Timestamp getStartTime() {
        return this.startTime;
    }

    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @JsonProperty
    public Timestamp getStopTime() {
        return this.stopTime;
    }

    @JsonProperty
    public Boolean getLive() {
        return this.live;
    }

    @JsonIgnore
    public Boolean isLive() {
        return this.live;
    }

    @JsonProperty
    public Boolean getComplete() {
        return this.complete;
    }

    @JsonIgnore
    public Boolean isComplete() {
        return this.complete;
    }

    @JsonProperty
    public LogMediaType getMediaType() {
        return this.mediaType;
    }

    @JsonProperty
    public Long getSize() {
        return this.size;
    }

    @JsonProperty
    public URI getContent() {
        return this.content;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Log log = (Log)o;
        if (this.size != log.size) {
            return false;
        }
        if (this.complete != null ? !this.complete.equals(log.complete) : log.complete != null) {
            return false;
        }
        if (this.content != null ? !this.content.equals(log.content) : log.content != null) {
            return false;
        }
        if (this.id != null ? !((Long)this.id).equals(log.id) : log.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(log.name) : log.name != null) {
            return false;
        }
        if (this.live != null ? !this.live.equals(log.live) : log.live != null) {
            return false;
        }
        if (this.result != null ? !this.result.equals(log.result) : log.result != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(log.startTime) : log.startTime != null) {
            return false;
        }
        if (this.stopTime != null ? !this.stopTime.equals(log.stopTime) : log.stopTime != null) {
            return false;
        }
        if (this.task != null ? !this.task.equals(log.task) : log.task != null) {
            return false;
        }
        if (this.mediaType != null ? !this.mediaType.equals((Object)log.mediaType) : log.mediaType != null) {
            return false;
        }
        return !(this.uri != null ? !this.uri.equals(log.uri) : log.uri != null);
    }

    @Override
    public int hashCode() {
        int result1 = this.id != null ? ((Long)this.id).hashCode() : 0;
        result1 = 31 * result1 + (this.task != null ? this.task.hashCode() : 0);
        result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
        result1 = 31 * result1 + (this.name != null ? this.name.hashCode() : 0);
        result1 = 31 * result1 + (this.startTime != null ? this.startTime.hashCode() : 0);
        result1 = 31 * result1 + (this.stopTime != null ? this.stopTime.hashCode() : 0);
        result1 = 31 * result1 + (this.live != null ? this.live.hashCode() : 0);
        result1 = 31 * result1 + (this.complete != null ? this.complete.hashCode() : 0);
        result1 = 31 * result1 + (int)(this.size ^ this.size >>> 32);
        result1 = 31 * result1 + (this.content != null ? this.content.hashCode() : 0);
        result1 = 31 * result1 + (this.mediaType != null ? this.mediaType.hashCode() : 0);
        result1 = 31 * result1 + (this.uri != null ? this.uri.hashCode() : 0);
        return result1;
    }

    @Override
    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Log " + this.id + " to JSON", e);
            return "Exception converting Log " + this.id + " to JSON: " + e.getMessage();
        }
    }

    public static enum LogMediaType {
        TEXT("text/plain"),
        JSON("application/json"),
        XML("application/xml"),
        HTML("text/html"),
        BINARY("application/octet-stream");

        private final String httpMediaTypeString;

        private LogMediaType(String httpMediaTypeString) {
            this.httpMediaTypeString = httpMediaTypeString;
        }

        public String getHttpMediaTypeString() {
            return this.httpMediaTypeString;
        }

        public static LogMediaType byHttpMediaType(String httpMediaTypeString) {
            for (LogMediaType logMediaType : LogMediaType.values()) {
                if (!httpMediaTypeString.toLowerCase().startsWith(logMediaType.getHttpMediaTypeString().toLowerCase())) continue;
                return logMediaType;
            }
            return null;
        }

        public static LogMediaType caseInsensitiveValueOf(String v) {
            return LogMediaType.valueOf(v.toUpperCase());
        }
    }
}

