/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Serializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context", "@type"})
public class MaintenanceInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MaintenanceInfo.class);
    @Nullable
    private final Timestamp reported;
    @Nullable
    private final Timestamp start;
    @Nullable
    private final Timestamp end;
    @Nullable
    private final String message;
    @Nullable
    private final Boolean planned;

    public MaintenanceInfo(@Nullable @JsonProperty(value="reported") Timestamp reported, @Nullable @JsonProperty(value="start") Timestamp start, @Nullable @JsonProperty(value="end") Timestamp end, @Nullable @JsonProperty(value="message") String message, @Nullable @JsonProperty(value="planned") Boolean planned) {
        this.reported = reported;
        this.start = start;
        this.end = end;
        this.message = message;
        this.planned = planned;
    }

    @JsonProperty
    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @Nullable
    public Timestamp getReported() {
        return this.reported;
    }

    @JsonProperty
    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @Nullable
    public Timestamp getStart() {
        return this.start;
    }

    @JsonProperty
    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @Nullable
    public Timestamp getEnd() {
        return this.end;
    }

    @JsonIgnore
    @Nullable
    public ZonedDateTime getReportTime() {
        if (this.reported == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(this.reported.toInstant(), ZoneId.systemDefault());
    }

    @JsonIgnore
    @Nullable
    public ZonedDateTime getStartTime() {
        if (this.start == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(this.start.toInstant(), ZoneId.systemDefault());
    }

    @JsonIgnore
    @Nullable
    public ZonedDateTime getEndTime() {
        if (this.end == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(this.end.toInstant(), ZoneId.systemDefault());
    }

    @JsonProperty
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @JsonProperty
    @Nullable
    public Boolean getPlanned() {
        return this.planned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaintenanceInfo)) {
            return false;
        }
        MaintenanceInfo that = (MaintenanceInfo)o;
        if (this.reported != null ? !this.reported.equals(that.reported) : that.reported != null) {
            return false;
        }
        if (this.start != null ? !this.start.equals(that.start) : that.start != null) {
            return false;
        }
        if (this.end != null ? !this.end.equals(that.end) : that.end != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return this.planned != null ? this.planned.equals(that.planned) : that.planned == null;
    }

    public int hashCode() {
        int result = this.reported != null ? this.reported.hashCode() : 0;
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.planned != null ? this.planned.hashCode() : 0);
        return result;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting MaintenanceMessage to JSON", e);
            return "Exception converting MaintenanceMessage to JSON: " + e.getMessage();
        }
    }
}

