/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ProxyBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="proxy", builderClass=ProxyBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Proxy
extends PrimaryIdObject<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(Proxy.class);
    private final String name;
    private final String type;
    private final String hostname;
    private final String portRange;
    private final String hostKey;
    private final String usernamePattern;

    @JsonCreator
    Proxy(@JsonProperty(value="id") Integer id, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="portRange") String portRange, @JsonProperty(value="hostKey") String hostKey, @JsonProperty(value="usernamePattern") String usernamePattern, @JsonProperty(value="@id") URI uri) {
        this(id, name, type, hostname, portRange, hostKey, usernamePattern, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    Proxy(Integer id, String name, String type, String hostname, String portRange, String hostKey, String usernamePattern, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super(id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.name = name;
        this.type = type;
        this.hostname = hostname;
        this.portRange = portRange;
        this.hostKey = hostKey;
        this.usernamePattern = usernamePattern;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty
    public String getPortRange() {
        return this.portRange;
    }

    @JsonProperty
    public String getHostKey() {
        return this.hostKey;
    }

    @JsonProperty
    public String getUsernamePattern() {
        return this.usernamePattern;
    }

    @JsonIgnore
    public String transformUsername(@Nonnull String origUsername) {
        if (this.usernamePattern == null || this.usernamePattern.trim().isEmpty()) {
            return Proxy.limitUsername(origUsername);
        }
        return this.usernamePattern.replaceAll(Pattern.quote("%u"), Proxy.limitUsername(origUsername));
    }

    @JsonIgnore
    public static String limitUsername(String username) {
        if (username == null || username.length() <= 8) {
            return username;
        }
        String shortUsername = username.replaceAll("[_ -]", "").toLowerCase();
        if (shortUsername.length() > 8) {
            shortUsername = shortUsername.substring(0, 8);
        }
        return shortUsername;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Proxy proxy = (Proxy)o;
        if (this.hostKey != null ? !this.hostKey.equals(proxy.hostKey) : proxy.hostKey != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(proxy.hostname) : proxy.hostname != null) {
            return false;
        }
        if (this.id != null ? !((Integer)this.id).equals(proxy.id) : proxy.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(proxy.name) : proxy.name != null) {
            return false;
        }
        if (this.portRange != null ? !this.portRange.equals(proxy.portRange) : proxy.portRange != null) {
            return false;
        }
        if (this.usernamePattern != null ? !this.usernamePattern.equals(proxy.usernamePattern) : proxy.usernamePattern != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(proxy.type) : proxy.type != null) {
            return false;
        }
        return !(this.uri != null ? !this.uri.equals(proxy.uri) : proxy.uri != null);
    }

    @Override
    public int hashCode() {
        int result = this.id != null ? ((Integer)this.id).hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + (this.portRange != null ? this.portRange.hashCode() : 0);
        result = 31 * result + (this.usernamePattern != null ? this.usernamePattern.hashCode() : 0);
        result = 31 * result + (this.hostKey != null ? this.hostKey.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(ProxyBuilder.minimize(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, this));
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getSimpleName() + " " + this.id + " to JSON", e);
            return "Exception converting " + this.getClass().getSimpleName() + " " + this.id + " to JSON: " + e.getMessage();
        }
    }
}

