/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Serializer;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dropwizard.jackson.Jackson;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="result", builderClass=ResultBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Result
extends PrimaryIdObject<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(Result.class);
    private final Task task;
    private final TestInstance testInstance;
    private final TestDefinition testDefinition;
    private final Timestamp created;
    private final Timestamp expire;
    private final String logFile;
    private final String logUrl;
    private final String summary;
    private final SortedMap<String, Object> results;

    @JsonCreator
    Result(@JsonProperty(value="id") Long id, @JsonProperty(value="task") Task task, @JsonProperty(value="created") Timestamp created, @JsonProperty(value="expire") Timestamp expire, @JsonProperty(value="logFile") String logFile, @JsonProperty(value="logUrl") String logUrl, @JsonProperty(value="summary") String summary, @JsonProperty(value="results") SortedMap<String, Object> results, @JsonProperty(value="testInstance") TestInstance testInstance, @JsonProperty(value="testDefinition") TestDefinition testDefinition, @JsonProperty(value="@id") URI uri) {
        this(id, task, created, expire, logFile, logUrl, summary, results, testInstance, testDefinition, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    Result(Long id, Task task, Timestamp created, Timestamp expire, String logFile, String logUrl, String summary, SortedMap<String, Object> results, TestInstance testInstance, TestDefinition testDefinition, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super(id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.task = task;
        this.created = created;
        this.expire = expire;
        this.logFile = logFile;
        this.logUrl = logUrl;
        this.summary = summary;
        this.results = results == null ? null : Collections.unmodifiableSortedMap(results);
        this.testInstance = testInstance;
        this.testDefinition = testDefinition;
    }

    @JsonIgnore
    public Integer getTestInstanceId() {
        return this.testInstance == null ? null : (Integer)this.testInstance.getId();
    }

    @JsonIgnore
    public URI getTestInstanceUri() {
        return this.testInstance == null ? null : this.testInstance.getUri();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestInstanceDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
    TestInstance getTestInstance() {
        return this.testInstance;
    }

    @JsonIgnore
    public String getTestDefinitionId() {
        return this.testDefinition == null ? null : (String)this.testDefinition.getId();
    }

    @JsonIgnore
    public URI getTestDefinitionUri() {
        return this.testDefinition == null ? null : this.testDefinition.getUri();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestDefinitionDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
    TestDefinition getTestDefinition() {
        return this.testDefinition;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TaskDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
    Task getTask() {
        return this.task;
    }

    @JsonIgnore
    public Long getTaskId() {
        return this.task == null ? null : (Long)this.task.getId();
    }

    @JsonIgnore
    public URI getTaskUri() {
        return this.task == null ? null : this.task.getUri();
    }

    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @JsonProperty
    public Timestamp getCreated() {
        return this.created;
    }

    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @JsonProperty
    public Timestamp getExpire() {
        return this.expire;
    }

    @JsonProperty
    public String getLogFile() {
        return this.logFile;
    }

    @JsonProperty
    public String getLogUrl() {
        return this.logUrl;
    }

    @JsonProperty
    public String getSummary() {
        return this.summary;
    }

    @JsonIgnore
    public SortedMap<String, Object> getResults() {
        if (this.results == null) {
            return Collections.emptySortedMap();
        }
        return this.results;
    }

    @JsonProperty(value="results")
    private SortedMap<String, Object> getResultsForJson() {
        if (this.results != null && this.results.isEmpty()) {
            return null;
        }
        return this.results;
    }

    @JsonIgnore
    public String getResultsAsJsonString() {
        if (this.results != null && this.results.isEmpty()) {
            return "{}";
        }
        ObjectMapper mapper = Jackson.newObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.results);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Result details into JSON", e);
            throw new RuntimeException("Exception converting Result details into JSON");
        }
    }

    @JsonIgnore
    public ResultStatus getSummaryStatus() {
        if (this.summary == null) {
            return null;
        }
        return ResultStatus.valueOf(this.summary.toUpperCase());
    }

    @JsonIgnore
    public Object getSubResult(String subResultName) {
        return this.results.get(subResultName);
    }

    public String getStringSubResult(String subResultName) {
        Object res;
        Object object = res = this.results == null ? null : (Object)this.results.get(subResultName);
        if (res == null) {
            return null;
        }
        if (res instanceof String) {
            return (String)res;
        }
        if (res instanceof Long || res instanceof Integer || res instanceof Double || res instanceof Number) {
            return "" + res;
        }
        throw new RuntimeException("Result.subResult[" + subResultName + "] is not a String but a " + res.getClass().getName());
    }

    @JsonIgnore
    public Boolean getBooleanSubResult(String subResultName, Boolean fallback) {
        return this.getBooleanSubResult(subResultName, fallback, fallback);
    }

    @JsonIgnore
    public Boolean getBooleanSubResult(String subResultName, Boolean notPresentFallback, Boolean parseFallback) {
        Object raw = this.getSubResult(subResultName);
        if (raw == null) {
            return notPresentFallback;
        }
        Boolean res = TextUtil.objectToBoolean(raw);
        if (res == null) {
            return parseFallback;
        }
        return res;
    }

    @JsonIgnore
    public Long getLongSubResult(String subResultName, Long fallback) {
        return this.getLongSubResult(subResultName, fallback, fallback);
    }

    @JsonIgnore
    public Long getLongSubResult(String subResultName, Long notPresentFallback, Long parseFallback) {
        Object raw = this.getSubResult(subResultName);
        if (raw == null) {
            return notPresentFallback;
        }
        if (raw instanceof Long) {
            return (Long)raw;
        }
        if (raw instanceof Integer) {
            return ((Integer)raw).longValue();
        }
        if (raw instanceof String) {
            try {
                return Long.parseLong((String)raw);
            }
            catch (NumberFormatException e) {
                LOG.error("Error parsing Long subresult \"" + subResultName + "\": \"" + raw + "\"", e);
                return parseFallback;
            }
        }
        throw new RuntimeException("Result.subResult[" + subResultName + "] is not compatible with Long, it is a " + raw.getClass().getName());
    }

    @JsonIgnore
    public Set<String> getSubResultKeys() {
        return this.results.keySet();
    }

    @JsonIgnore
    public Object getNestedSubResult(String ... keys) {
        if (this.getResults() == null) {
            return null;
        }
        Map<String, Object> cur = this.getResults();
        if (keys.length == 0) {
            throw new IllegalArgumentException("getNestedSubResult requires at least one key");
        }
        for (int i = 0; i < keys.length; ++i) {
            boolean last = i == keys.length - 1;
            String key = keys[i];
            Object v = cur.get(key);
            if (v == null) {
                return null;
            }
            if (last) {
                return v;
            }
            if (!(v instanceof Map)) {
                throw new RuntimeException("Intermediate subresult is not a Map at level " + i + ": subresults=" + this.getResults() + " keys=" + Arrays.asList(keys));
            }
            cur = (Map)v;
        }
        throw new RuntimeException("unreachable code unless there is a bug");
    }

    @JsonIgnore
    public Long getNestedLongSubResult(String ... keys) {
        Object o = this.getNestedSubResult(keys);
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        throw new RuntimeException("Nested sub result is a " + o.getClass().getName() + ", not a Long");
    }

    @JsonIgnore
    public String getNestedStringSubResult(String ... keys) {
        Object o = this.getNestedSubResult(keys);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Collection) {
            throw new RuntimeException("Nested sub result is a " + o.getClass().getName() + ", not a Long");
        }
        return "" + o;
    }

    @Override
    public String toString() {
        ObjectMapper mapper = Jackson.newObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Result " + this.getId() + " to JSON", e);
            return "Exception converting Result " + this.getId() + " to JSON: " + e.getMessage();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        if (this.expire != null ? !this.expire.equals(result.expire) : result.expire != null) {
            return false;
        }
        if (this.id != null ? !((Long)this.id).equals(result.id) : result.id != null) {
            return false;
        }
        if (this.logFile != null ? !this.logFile.equals(result.logFile) : result.logFile != null) {
            return false;
        }
        if (this.logUrl != null ? !this.logUrl.equals(result.logUrl) : result.logUrl != null) {
            return false;
        }
        if (this.getResults() != null ? !this.getResults().equals(result.getResults()) : result.getResults() != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(result.summary) : result.summary != null) {
            return false;
        }
        if (this.getTestInstanceId() != null ? !this.getTestInstanceId().equals(result.getTestInstanceId()) : result.getTestInstanceId() != null) {
            return false;
        }
        if (this.getTestDefinitionId() != null ? !this.getTestDefinitionId().equals(result.getTestDefinitionId()) : result.getTestDefinitionId() != null) {
            return false;
        }
        if (this.getTaskId() != null ? !this.getTaskId().equals(result.getTaskId()) : result.getTaskId() != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(result.created) : result.created != null) {
            return false;
        }
        return !(this.uri != null ? !this.uri.equals(result.uri) : result.uri != null);
    }

    @Override
    public int hashCode() {
        int result = this.id != null ? ((Long)this.id).hashCode() : 0;
        result = 31 * result + (this.getTaskId() != null ? this.getTaskId().hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.expire != null ? this.expire.hashCode() : 0);
        result = 31 * result + (this.logFile != null ? this.logFile.hashCode() : 0);
        result = 31 * result + (this.logUrl != null ? this.logUrl.hashCode() : 0);
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.getTestInstanceId() != null ? this.getTestInstanceId().hashCode() : 0);
        result = 31 * result + (this.getTestDefinitionId() != null ? this.getTestDefinitionId().hashCode() : 0);
        result = 31 * result + (this.getResults() != null ? this.getResults().hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }

    public static enum ResultStatus {
        SUCCESS(1),
        WARNING(2),
        FAILURE(3),
        CANCELLED(5);

        private final int worseScore;

        private ResultStatus(int worseScore) {
            this.worseScore = worseScore;
        }

        public boolean isWorseThan(ResultStatus other) {
            return this.worseScore > other.worseScore;
        }
    }
}

