/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TaskBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=Result.class)
public class ResultBuilder
extends PrimaryIdObjectBuilder<Long, Result, ResultBuilder> {
    private Long taskId;
    private URI taskUri;
    private Timestamp created;
    private Timestamp expire;
    private String logFile;
    private String logUrl;
    private String summary;
    private SortedMap<String, Object> results;
    private TestInstance testInstance;
    private TestDefinition testDefinition;

    public ResultBuilder() {
        this.results = new TreeMap<String, Object>();
    }

    public ResultBuilder(Result orig) {
        super(orig);
        this.taskId = orig.getTaskId();
        this.taskUri = orig.getTask() != null ? orig.getTask().getUri() : null;
        this.created = orig.getCreated();
        this.expire = orig.getExpire();
        this.logFile = orig.getLogFile();
        this.logUrl = orig.getLogUrl();
        this.summary = orig.getSummary();
        this.results = orig.getResults() == null ? null : new TreeMap<String, Object>(orig.getResults());
        this.testInstance = orig.getTestInstance();
        this.testDefinition = orig.getTestDefinition();
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Task.class)
    public ResultBuilder setTask(Task task) {
        if (task == null) {
            this.taskId = null;
            this.taskUri = null;
        } else {
            this.taskId = (Long)task.getId();
            this.taskUri = task.getUri();
        }
        return this;
    }

    public ResultBuilder setTask(Long taskId, URI taskUri) {
        this.taskId = taskId;
        this.taskUri = taskUri;
        return this;
    }

    public ResultBuilder setCreated(Timestamp created) {
        this.created = created;
        return this;
    }

    public ResultBuilder setExpire(Timestamp expire) {
        this.expire = expire;
        return this;
    }

    public ResultBuilder setLogFile(String logFile) {
        this.logFile = logFile;
        return this;
    }

    public ResultBuilder setLogUrl(String logUrl) {
        this.logUrl = logUrl;
        return this;
    }

    public ResultBuilder setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public ResultBuilder setSummaryIfWorse(@Nonnull String summary) {
        if (this.summary == null) {
            this.summary = summary.toUpperCase();
        } else if (Result.ResultStatus.valueOf(summary).isWorseThan(Result.ResultStatus.valueOf(this.summary))) {
            this.summary = summary.toUpperCase();
        }
        return this;
    }

    public ResultBuilder setSummary(Result.ResultStatus summary) {
        this.summary = summary == null ? null : summary.toString().toUpperCase();
        return this;
    }

    public ResultBuilder setSummaryIfWorse(@Nonnull Result.ResultStatus summary) {
        if (this.summary == null) {
            this.summary = summary.toString().toUpperCase();
        } else if (summary.isWorseThan(Result.ResultStatus.valueOf(this.summary))) {
            this.summary = summary.toString().toUpperCase();
        }
        return this;
    }

    public ResultBuilder setResults(Map<String, ? extends Object> results) {
        this.results = results == null ? null : new TreeMap<String, Object>(results);
        return this;
    }

    public ResultBuilder setResults(SortedMap<String, ? extends Object> results) {
        this.results = results == null ? null : new TreeMap<String, Object>(results);
        return this;
    }

    public ResultBuilder addResults(Map<String, ? extends Object> extraResults) {
        this.results = this.results == null ? new TreeMap() : this.results;
        this.results.putAll(extraResults);
        return this;
    }

    public ResultBuilder addSubResult(String subResultName, Object subResultValue) {
        if (subResultName.equalsIgnoreCase("logFile") || subResultName.equalsIgnoreCase("logUrl")) {
            throw new RuntimeException(subResultName + " is not a sub result. Use setLogFile() and setLogUrl() instead");
        }
        if (this.results == null) {
            this.results = new TreeMap<String, Object>();
        }
        this.results.put(subResultName, subResultValue);
        return this;
    }

    public void setNestedSubResult(@Nullable Object value, String ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("getNestedSubResult requires at least one key");
        }
        if (this.getResults() == null) {
            assert (keys[0] != null);
            this.addSubResult(keys[0], new TreeMap());
        }
        Map<String, Object> cur = this.getResults();
        for (int i = 0; i < keys.length; ++i) {
            boolean last = i == keys.length - 1;
            String key = keys[i];
            assert (key != null);
            if (last) {
                cur.put(key, value);
                continue;
            }
            Object v = cur.get(key);
            if (v == null) {
                v = new TreeMap();
                cur.put(key, v);
            }
            if (!(v instanceof Map)) {
                throw new RuntimeException("Intermediate subresult is not a Map at level " + i + ": subresults=" + this.getResults() + " keys=" + Arrays.asList(keys));
            }
            cur = (Map)v;
            assert (cur != null);
        }
    }

    public ResultBuilder setTestInstanceId(Integer testInstanceId) {
        this.testInstance = testInstanceId == null ? null : ((TestInstanceBuilder)new TestInstanceBuilder().setId(testInstanceId)).create();
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=TestInstance.class)
    public ResultBuilder setTestInstance(TestInstance testInstance) {
        this.testInstance = testInstance;
        return this;
    }

    public ResultBuilder setTestInstance(Integer testInstanceId, String testDefinitionId) {
        this.testInstance = testInstanceId == null ? null : ((TestInstanceBuilder)new TestInstanceBuilder().setId(testInstanceId)).setTestDefinition(testDefinitionId).create();
        return this;
    }

    public ResultBuilder setTestDefinitionId(String testDefinitionId) {
        this.testDefinition = testDefinitionId == null ? null : ((TestDefinitionBuilder)new TestDefinitionBuilder().setId(testDefinitionId)).create();
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=TestDefinition.class)
    public ResultBuilder setTestDefinition(TestDefinition testDefinition) {
        this.testDefinition = testDefinition;
        return this;
    }

    @Override
    public Result create() {
        Task task = this.taskId == null ? null : ((TaskBuilder)((TaskBuilder)new TaskBuilder().setId(this.taskId)).setUri(this.taskUri)).create();
        Result res = new Result((Long)this.id, task, this.created, this.expire, this.logFile, this.logUrl, this.summary, this.results, this.testInstance, this.testDefinition, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
        return res;
    }

    @Override
    public Result createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        Task task = this.taskId == null ? null : ((TaskBuilder)((TaskBuilder)new TaskBuilder().setId(this.taskId)).setUri(this.taskUri)).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        Result res = new Result(minimization.includeId() ? (Long)this.id : null, minimization.includeOtherProperties() ? task : null, minimization.includeOtherProperties() ? this.created : null, minimization.includeOtherProperties() ? this.expire : null, minimization.includeOtherProperties() ? this.logFile : null, minimization.includeOtherProperties() ? this.logUrl : null, minimization.includeOtherProperties() ? this.summary : null, minimization.includeOtherProperties() ? this.results : null, minimization.includeOtherProperties() || minimization.includeParent() ? (this.testInstance == null ? null : new TestInstanceBuilder(this.testInstance).createMinimized(minimization.includeChildren() ? minimization.getChildrenMinimization() : JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY)) : null, minimization.includeOtherProperties() || minimization.includeParent() ? (this.testDefinition == null ? null : new TestDefinitionBuilder(this.testDefinition).createMinimized(minimization.includeChildren() ? minimization.getChildrenMinimization() : JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY)) : null, minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
        return res;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public URI getTaskUri() {
        return this.taskUri;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Task.class)
    public Task getTask() {
        if (this.taskId == null) {
            return null;
        }
        return ((TaskBuilder)((TaskBuilder)new TaskBuilder().setId(this.taskId)).setUri(this.taskUri)).create();
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public Timestamp getExpire() {
        return this.expire;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public String getLogUrl() {
        return this.logUrl;
    }

    public String getSummary() {
        return this.summary;
    }

    public Result.ResultStatus getSummaryStatus() {
        return this.summary == null ? null : Result.ResultStatus.valueOf(this.summary.toUpperCase());
    }

    public SortedMap<String, Object> getResults() {
        return this.results;
    }

    public Object getSubResult(String subResultName) {
        return this.results == null ? null : this.results.get(subResultName);
    }

    public String getStringSubResult(String subResultName) {
        Object res;
        Object object = res = this.results == null ? null : (Object)this.results.get(subResultName);
        if (res == null) {
            return null;
        }
        if (res instanceof String) {
            return (String)res;
        }
        throw new RuntimeException("Result.subResult[" + subResultName + "] is not a String but a " + res.getClass().getName());
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=TestInstance.class)
    public TestInstance getTestInstance() {
        return this.testInstance;
    }

    public Integer getTestInstanceId() {
        return this.testInstance == null ? null : (Integer)this.testInstance.getId();
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=TestDefinition.class)
    public TestDefinition getTestDefinition() {
        return this.testDefinition;
    }

    public String getTestDefinitionId() {
        return this.testDefinition == null ? null : (String)this.testDefinition.getId();
    }
}

