/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse_v1;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.ForeignIdObjectBuilder;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=ServerGlimpse.class)
public class ServerGlimpseBuilder
extends ForeignIdObjectBuilder<ServerGlimpse, ServerGlimpseBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerGlimpseBuilder.class);
    private Server server;
    private ServerBuilder serverBuilder;
    private Timestamp advertisementTimestamp;
    private Result advertisementResult;
    private URI rspec;
    private Set<String> componentManagerIds;
    private TreeMap<String, ServerGlimpse.AdvertisementInfo.ComponentDetails> componentDetails;
    private Map<String, MutableDiskImage> diskImagesById;
    private TreeMap<String, Integer> counts;
    private TreeMap<String, Integer> hwCounts;
    private Map<String, MutableSliverTypeInfo> sliverTypeInfoBySliverType;
    private MutableSliverTypeInfo nullSliverTypeInfo;
    private Timestamp healthTimestamp;
    private Result healthResult;
    private Integer health;
    private String healthExplanation;
    private String healthExplanationFull;
    private String healthStatus;
    private Integer reputation;
    private List<MaintenanceInfo> maintenance;
    private ServerGlimpse.AdvertisementInfo.HardwareTypeInfo hardwareTypeInfo;

    public ServerGlimpseBuilder() {
    }

    public ServerGlimpseBuilder(ServerGlimpse orig) {
        super(orig);
        this.server = orig.getServer();
        this.serverBuilder = null;
        this.setAdvertisementInfo(orig.getAdvertisementInfo());
        this.setHealthInfo(orig.getHealthInfo());
        this.setMaintenance(orig.getMaintenance());
        this.setReputation(orig.getReputation());
    }

    public ServerGlimpseBuilder setHardwareTypeInfo(ServerGlimpse.AdvertisementInfo.HardwareTypeInfo hardwareTypeInfo) {
        this.hardwareTypeInfo = hardwareTypeInfo;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Server.class, name="server")
    public ServerGlimpseBuilder setServer(Server server) {
        this.server = server;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Server.class, name="server", builderReference=true)
    public ServerGlimpseBuilder setServerBuilder(ServerBuilder serverBuilder) {
        this.serverBuilder = serverBuilder;
        return this;
    }

    @Override
    public ServerGlimpseBuilder setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public ServerGlimpseBuilder setAdvertisementInfo(ServerGlimpse.AdvertisementInfo advertisementInfo) {
        if (advertisementInfo == null) {
            this.advertisementTimestamp = null;
            this.advertisementResult = null;
            this.rspec = null;
            this.diskImagesById = null;
            this.nullSliverTypeInfo = null;
            this.sliverTypeInfoBySliverType = null;
            this.counts = null;
            this.hwCounts = null;
            this.componentManagerIds = null;
            this.componentDetails = null;
            this.hardwareTypeInfo = null;
        } else {
            this.advertisementTimestamp = advertisementInfo.getTimestamp();
            this.advertisementResult = advertisementInfo.getResult();
            this.rspec = advertisementInfo.getRspec();
            this.counts = null;
            this.hwCounts = null;
            if (advertisementInfo.getCounts() != null) {
                this.counts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                this.counts.putAll(advertisementInfo.getCounts());
            }
            if (advertisementInfo.getHwCounts() != null) {
                this.hwCounts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                this.hwCounts.putAll(advertisementInfo.getHwCounts());
            }
            this.componentManagerIds = advertisementInfo.getComponentManagerIds() == null ? null : new TreeSet<String>(advertisementInfo.getComponentManagerIds());
            this.setComponentDetails(advertisementInfo.getComponentDetails());
            this.setDiskImages(advertisementInfo.getDiskImages());
            this.setSliverTypeInfo(advertisementInfo.getSliverTypeInfo());
            this.setHardwareTypeInfo(advertisementInfo.getHardwareTypeInfo());
        }
        return this;
    }

    public ServerGlimpseBuilder setHealthInfo(ServerGlimpse.HealthInfo healthInfo) {
        if (healthInfo != null) {
            this.healthTimestamp = healthInfo.getTimestamp();
            this.healthResult = healthInfo.getResult();
            this.health = healthInfo.getHealth();
            this.healthExplanation = healthInfo.getHealthExplanation();
            this.healthExplanationFull = healthInfo.getHealthExplanationFull();
            this.healthStatus = healthInfo.getStatus();
        } else {
            this.healthTimestamp = null;
            this.healthResult = null;
            this.health = null;
            this.healthExplanation = null;
            this.healthExplanationFull = null;
            this.healthStatus = null;
        }
        return this;
    }

    public ServerGlimpseBuilder setAdvertisementTimestamp(Timestamp timestamp) {
        this.advertisementTimestamp = timestamp;
        return this;
    }

    public ServerGlimpseBuilder setAdvertisementTimestamp(Date timestamp) {
        this.advertisementTimestamp = new Timestamp(timestamp.getTime());
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Result.class, name="advertisementResult")
    public ServerGlimpseBuilder setAdvertisementResult(Result result) {
        this.advertisementResult = result;
        return this;
    }

    public ServerGlimpseBuilder setAdvertisementResultId(Long resultId) {
        this.advertisementResult = resultId == null ? null : ((ResultBuilder)new ResultBuilder().setId(resultId)).create();
        return this;
    }

    public ServerGlimpseBuilder setRspec(URI rspec) {
        this.rspec = rspec;
        return this;
    }

    private void setSliverTypeInfo(List<ServerGlimpse.AdvertisementInfo.SliverTypeInfo> sliverTypeInfos) {
        if (sliverTypeInfos == null) {
            this.sliverTypeInfoBySliverType = null;
            this.nullSliverTypeInfo = null;
        } else {
            this.nullSliverTypeInfo = null;
            this.sliverTypeInfoBySliverType = new HashMap<String, MutableSliverTypeInfo>();
            for (ServerGlimpse.AdvertisementInfo.SliverTypeInfo sliverTypeInfo : sliverTypeInfos) {
                if (sliverTypeInfo.getSliverType() == null) {
                    assert (this.nullSliverTypeInfo == null);
                    this.nullSliverTypeInfo = new MutableSliverTypeInfo(sliverTypeInfo);
                    continue;
                }
                this.sliverTypeInfoBySliverType.put(sliverTypeInfo.getSliverType(), new MutableSliverTypeInfo(sliverTypeInfo));
            }
        }
    }

    public ServerGlimpseBuilder addNoSliverHardwareType(String hardwareType) {
        this.mergeSliverTypeInfo(null, Collections.singleton(hardwareType), null, null);
        return this;
    }

    public ServerGlimpseBuilder addNoSliverHardwareType(Collection<String> hardwareTypes) {
        this.mergeSliverTypeInfo(null, hardwareTypes, null, null);
        return this;
    }

    public ServerGlimpseBuilder mergeSliverTypeInfo(String sliverType, Collection<String> hardwareTypes, Collection<String> flavors, String defaultDiskImage) {
        MutableSliverTypeInfo existing;
        if (this.sliverTypeInfoBySliverType == null) {
            this.sliverTypeInfoBySliverType = new HashMap<String, MutableSliverTypeInfo>();
        }
        MutableSliverTypeInfo mutableSliverTypeInfo = existing = sliverType == null ? this.nullSliverTypeInfo : this.sliverTypeInfoBySliverType.get(sliverType);
        if (existing == null) {
            MutableSliverTypeInfo updated = new MutableSliverTypeInfo(sliverType, hardwareTypes, flavors, defaultDiskImage);
            if (sliverType == null) {
                this.nullSliverTypeInfo = updated;
            } else {
                this.sliverTypeInfoBySliverType.put(sliverType, updated);
            }
        } else {
            MutableSliverTypeInfo updated = existing;
            if (hardwareTypes != null) {
                updated.addHardwareTypes(hardwareTypes);
            }
            if (flavors != null) {
                updated.addFlavors(flavors);
            }
            if (defaultDiskImage != null) {
                updated.setDefaultDiskImage(defaultDiskImage);
            }
        }
        return this;
    }

    public ServerGlimpseBuilder setComponentManagerIds(Collection<String> componentManagerIds) {
        this.componentManagerIds = componentManagerIds == null ? null : new TreeSet<String>(componentManagerIds);
        return this;
    }

    public ServerGlimpseBuilder addComponentManagerId(String componentManagerId) {
        if (this.componentManagerIds == null) {
            this.componentManagerIds = new TreeSet<String>();
        }
        this.componentManagerIds.add(componentManagerId);
        return this;
    }

    public ServerGlimpseBuilder setComponentDetails(Collection<ServerGlimpse.AdvertisementInfo.ComponentDetails> componentDetails) {
        if (componentDetails == null) {
            this.componentDetails = null;
        } else {
            this.componentDetails = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            for (ServerGlimpse.AdvertisementInfo.ComponentDetails d : componentDetails) {
                this.componentDetails.put(d.getId(), d);
            }
        }
        return this;
    }

    public ServerGlimpseBuilder addComponentDetails(ServerGlimpse.AdvertisementInfo.ComponentDetails componentDetails) {
        if (this.componentDetails == null) {
            this.componentDetails = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
        this.componentDetails.put(componentDetails.getId(), componentDetails);
        return this;
    }

    public ServerGlimpseBuilder setAvailableComponentIds(Collection<String> availableComponentIds) {
        for (String ci : availableComponentIds) {
            this.addAvailableComponentId(ci);
        }
        return this;
    }

    public ServerGlimpseBuilder setUnavailableComponentIds(Collection<String> unavailableComponentIds) {
        for (String ci : unavailableComponentIds) {
            this.addUnavailableComponentId(ci);
        }
        return this;
    }

    public ServerGlimpseBuilder setLocationForComponent(String componentId, ServerGlimpse.AdvertisementInfo.ComponentDetails.Location location) {
        ServerGlimpse.AdvertisementInfo.ComponentDetails d = this.componentDetails.get(componentId);
        if (d == null || d.getId() == null) {
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, null, null, location, null, null));
        } else {
            assert (d.getId().equals(componentId));
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, d.getHardwareTypes(), d.getAvailable(), location, d.getComponentManagerId(), d.getSiteId()));
        }
        return this;
    }

    public ServerGlimpseBuilder setHardwareTypesAndLocationForComponent(String componentId, List<String> hardwareTypes, ServerGlimpse.AdvertisementInfo.ComponentDetails.Location location) {
        ServerGlimpse.AdvertisementInfo.ComponentDetails d = this.componentDetails.get(componentId);
        if (d == null || d.getId() == null) {
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, hardwareTypes, null, location, null, null));
        } else {
            assert (d.getId().equals(componentId));
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, hardwareTypes, d.getAvailable(), location, d.getComponentManagerId(), d.getSiteId()));
        }
        return this;
    }

    public ServerGlimpseBuilder setHardwareTypesForComponent(String componentId, List<String> hardwareTypes) {
        ServerGlimpse.AdvertisementInfo.ComponentDetails d = this.componentDetails.get(componentId);
        if (d == null || d.getId() == null) {
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, hardwareTypes, null, null, null, null));
        } else {
            assert (d.getId().equals(componentId));
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, hardwareTypes, d.getAvailable(), d.getLocation(), d.getComponentManagerId(), d.getSiteId()));
        }
        return this;
    }

    public ServerGlimpseBuilder addHardwareTypeForComponent(String componentId, String hardwareType) {
        ServerGlimpse.AdvertisementInfo.ComponentDetails d = this.componentDetails.get(componentId);
        if (d == null || d.getId() == null) {
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, Arrays.asList(hardwareType), null, null, null, null));
        } else {
            assert (d.getId().equals(componentId));
            ArrayList<String> newHardwareTypes = d.getHardwareTypes() == null ? new ArrayList<String>() : new ArrayList<String>(d.getHardwareTypes());
            newHardwareTypes.add(hardwareType);
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, newHardwareTypes, d.getAvailable(), d.getLocation(), d.getComponentManagerId(), d.getSiteId()));
        }
        return this;
    }

    public ServerGlimpseBuilder setComponentManagerIdForComponent(String componentId, String componentManagerId) {
        ServerGlimpse.AdvertisementInfo.ComponentDetails d = this.componentDetails.get(componentId);
        if (d == null || d.getId() == null) {
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, null, null, null, componentManagerId, null));
        } else {
            assert (d.getId().equals(componentId));
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, d.getHardwareTypes(), d.getAvailable(), d.getLocation(), componentManagerId, d.getSiteId()));
        }
        return this;
    }

    public ServerGlimpseBuilder setSiteIdForComponent(String componentId, String siteId) {
        ServerGlimpse.AdvertisementInfo.ComponentDetails d = this.componentDetails.get(componentId);
        if (d == null || d.getId() == null) {
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, null, null, null, null, siteId));
        } else {
            assert (d.getId().equals(componentId));
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, d.getHardwareTypes(), d.getAvailable(), d.getLocation(), d.getComponentManagerId(), siteId));
        }
        return this;
    }

    public ServerGlimpseBuilder addAvailableComponentId(String componentId) {
        ServerGlimpse.AdvertisementInfo.ComponentDetails d;
        if (this.componentDetails == null) {
            this.componentDetails = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
        if ((d = this.componentDetails.get(componentId)) == null || d.getId() == null) {
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, null, true, null, null, null));
        } else if (d.getAvailable() == null || !d.getAvailable().booleanValue()) {
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, d.getHardwareTypes(), true, d.getLocation(), d.getComponentManagerId(), d.getSiteId()));
        }
        return this;
    }

    public ServerGlimpseBuilder addUnavailableComponentId(String componentId) {
        ServerGlimpse.AdvertisementInfo.ComponentDetails d;
        if (this.componentDetails == null) {
            this.componentDetails = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
        if ((d = this.componentDetails.get(componentId)) == null || d.getId() == null) {
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, null, false, null, null, null));
        } else if (d.getAvailable() == null || d.getAvailable().booleanValue()) {
            this.componentDetails.put(componentId, new ServerGlimpse.AdvertisementInfo.ComponentDetails(componentId, d.getHardwareTypes(), false, d.getLocation(), d.getComponentManagerId(), d.getSiteId()));
        }
        return this;
    }

    public ServerGlimpseBuilder setDiskImages(Collection<ServerGlimpse.AdvertisementInfo.DiskImage> diskImages) {
        if (diskImages == null) {
            this.diskImagesById = null;
        } else {
            this.diskImagesById = new HashMap<String, MutableDiskImage>();
            for (ServerGlimpse.AdvertisementInfo.DiskImage diskImage : diskImages) {
                String id;
                String string = id = diskImage.getName() != null ? diskImage.getName() : diskImage.getUrl();
                if (id == null) {
                    LOG.warn("Ignoring DiskImage without name or url");
                    continue;
                }
                this.diskImagesById.put(id, new MutableDiskImage(diskImage));
            }
        }
        return this;
    }

    public ServerGlimpseBuilder mergeDiskImage(ServerGlimpse.AdvertisementInfo.DiskImage diskImage) {
        this.mergeDiskImage(diskImage.getName(), diskImage.getUrl(), diskImage.getDescription(), diskImage.getVersion(), diskImage.getOs(), diskImage.getSliverTypes());
        return this;
    }

    public ServerGlimpseBuilder mergeDiskImage(String name, String url, String description, String version, String os, String sliverType) {
        MutableDiskImage existing;
        String id;
        String string = id = name != null ? name : url;
        assert (id != null);
        if (this.diskImagesById == null) {
            this.diskImagesById = new HashMap<String, MutableDiskImage>();
        }
        if ((existing = this.diskImagesById.get(id)) == null) {
            MutableDiskImage newDi = new MutableDiskImage(name, url, description, version, os);
            if (sliverType != null) {
                newDi.addSliverType(sliverType);
            }
            this.diskImagesById.put(id, newDi);
        } else if (sliverType != null) {
            existing.addSliverType(sliverType);
        }
        return this;
    }

    public ServerGlimpseBuilder mergeDiskImage(String name, String url, String description, String version, String os, Collection<String> sliverTypes) {
        MutableDiskImage existing;
        String id;
        String string = id = name != null ? name : url;
        assert (id != null);
        if (this.diskImagesById == null) {
            this.diskImagesById = new HashMap<String, MutableDiskImage>();
        }
        if ((existing = this.diskImagesById.get(id)) == null) {
            MutableDiskImage newDi = new MutableDiskImage(name, url, description, version, os);
            if (sliverTypes != null) {
                newDi.addSliverTypes(sliverTypes);
            }
            this.diskImagesById.put(id, newDi);
        } else if (sliverTypes != null) {
            existing.addSliverTypes(sliverTypes);
        }
        return this;
    }

    public ServerGlimpseBuilder setCounts(Map<String, Integer> counts) {
        if (counts == null) {
            this.counts = null;
        } else {
            this.counts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            this.counts.putAll(counts);
        }
        return this;
    }

    public ServerGlimpseBuilder setCount(AdvertisementCounts.CountedObject object, Integer all, Integer available) {
        assert (object != null);
        if (this.counts == null) {
            this.counts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
        this.counts.put(object.getKeyPrefixName() + AdvertisementCounts.CountScope.ALL.getKeySuffixName(), all);
        this.counts.put(object.getKeyPrefixName() + AdvertisementCounts.CountScope.AVAILABLE.getKeySuffixName(), available);
        return this;
    }

    public ServerGlimpseBuilder setCount(AdvertisementCounts.CountedObject object, AdvertisementCounts.CountScope scope, Integer value) {
        assert (object != null);
        assert (scope != null);
        if (this.counts == null) {
            this.counts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
        this.counts.put(object.getKeyPrefixName() + scope.getKeySuffixName(), value);
        return this;
    }

    public ServerGlimpseBuilder setHwCounts(Map<String, Integer> hwCounts) {
        if (hwCounts == null) {
            this.hwCounts = null;
        } else {
            this.hwCounts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            this.hwCounts.putAll(hwCounts);
        }
        return this;
    }

    public ServerGlimpseBuilder setHwCount(@Nonnull String hwType, Integer all, Integer available) {
        assert (hwType != null);
        if (this.hwCounts == null) {
            this.hwCounts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
        if (all != null) {
            this.hwCounts.put(hwType + AdvertisementCounts.CountScope.ALL.getKeySuffixName(), all);
        } else {
            this.hwCounts.remove(hwType + AdvertisementCounts.CountScope.ALL.getKeySuffixName());
        }
        if (available != null) {
            this.hwCounts.put(hwType + AdvertisementCounts.CountScope.AVAILABLE.getKeySuffixName(), available);
        } else {
            this.hwCounts.remove(hwType + AdvertisementCounts.CountScope.AVAILABLE.getKeySuffixName());
        }
        return this;
    }

    public ServerGlimpseBuilder setHwCount(@Nonnull String hwType, @Nonnull AdvertisementCounts.CountScope scope, Integer value) {
        assert (hwType != null);
        assert (scope != null);
        if (this.hwCounts == null) {
            this.hwCounts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
        if (value != null) {
            this.hwCounts.put(hwType + scope.getKeySuffixName(), value);
        } else {
            this.hwCounts.remove(hwType + scope.getKeySuffixName());
        }
        return this;
    }

    public ServerGlimpseBuilder setHealthTimestamp(Timestamp healthTimestamp) {
        this.healthTimestamp = healthTimestamp;
        return this;
    }

    public ServerGlimpseBuilder setHealthTimestamp(Date healthTimestamp) {
        this.healthTimestamp = new Timestamp(healthTimestamp.getTime());
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Result.class, name="healthResult")
    public ServerGlimpseBuilder setHealthResult(Result healthResult) {
        this.healthResult = healthResult;
        return this;
    }

    public ServerGlimpseBuilder setHealthResultId(Long resultId) {
        this.healthResult = resultId == null ? null : ((ResultBuilder)new ResultBuilder().setId(resultId)).create();
        return this;
    }

    public ServerGlimpseBuilder setHealth(Integer health) {
        this.health = health;
        return this;
    }

    public ServerGlimpseBuilder setHealthExplanation(String healthExplanation) {
        this.healthExplanation = healthExplanation;
        return this;
    }

    public ServerGlimpseBuilder setHealthExplanationFull(String healthExplanationFull) {
        this.healthExplanationFull = healthExplanationFull;
        return this;
    }

    public ServerGlimpseBuilder setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
        return this;
    }

    public ServerGlimpseBuilder setReputation(@Nullable Integer reputation) {
        this.reputation = reputation;
        return this;
    }

    public ServerGlimpseBuilder setMaintenance(@Nullable List<MaintenanceInfo> newMaintenanceInfos) {
        this.maintenance = newMaintenanceInfos == null ? null : new ArrayList<MaintenanceInfo>(newMaintenanceInfos);
        return this;
    }

    public ServerGlimpseBuilder addMaintenance(@Nonnull MaintenanceInfo extraMaintenanceInfo) {
        if (this.maintenance == null) {
            this.maintenance = new ArrayList<MaintenanceInfo>();
        }
        this.maintenance.add(extraMaintenanceInfo);
        return this;
    }

    @Override
    public ServerGlimpse create() {
        ServerGlimpse.HealthInfo healthInfo;
        boolean hasAdvertisement;
        if (this.serverBuilder != null && this.server != null) {
            throw new IllegalStateException("Either none, only server or only serverBuilder must be set, not both.");
        }
        Result usedAdvertisementResult = this.advertisementResult == null ? null : new ResultBuilder(this.advertisementResult).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        boolean bl = hasAdvertisement = this.advertisementTimestamp != null || usedAdvertisementResult != null || this.rspec != null || this.sliverTypeInfoBySliverType != null || this.nullSliverTypeInfo != null || this.diskImagesById != null || this.componentManagerIds != null || this.componentDetails != null || this.counts != null || this.hwCounts != null;
        ServerGlimpse.AdvertisementInfo advertisementInfo = hasAdvertisement ? new ServerGlimpse.AdvertisementInfo(this.advertisementTimestamp, usedAdvertisementResult, this.rspec, this.getSliverTypeInfo(), this.getDiskImages(), this.componentManagerIds, this.componentDetails == null ? null : this.componentDetails.values(), this.counts, this.hwCounts, this.hardwareTypeInfo) : null;
        Result usedHealthResult = this.healthResult == null ? null : new ResultBuilder(this.healthResult).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        boolean hasHealth = this.health != null || this.healthExplanation != null || this.healthExplanationFull != null || usedHealthResult != null || this.healthStatus != null || this.healthTimestamp != null;
        ServerGlimpse.HealthInfo healthInfo2 = healthInfo = hasHealth ? new ServerGlimpse.HealthInfo(this.healthTimestamp, usedHealthResult, this.health, this.healthExplanation, this.healthExplanationFull, this.healthStatus) : null;
        Server usedServer = this.server == null && this.serverBuilder != null ? this.serverBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY) : (this.server == null ? null : new ServerBuilder(this.server).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
        return new ServerGlimpse(advertisementInfo, healthInfo, usedServer, this.reputation, this.maintenance, this.uri);
    }

    @Override
    public ServerGlimpse createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        ServerGlimpse.HealthInfo healthInfo;
        boolean hasAdvertisement;
        if (this.serverBuilder != null && this.server != null) {
            throw new IllegalStateException("Either none, only server or only serverBuilder must be set, not both.");
        }
        Result usedAdvertisementResult = this.advertisementResult == null ? null : new ResultBuilder(this.advertisementResult).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        boolean bl = hasAdvertisement = this.advertisementTimestamp != null || usedAdvertisementResult != null || this.rspec != null || this.sliverTypeInfoBySliverType != null || this.nullSliverTypeInfo != null || this.diskImagesById != null || this.componentManagerIds != null || this.componentDetails != null || this.counts != null || this.hwCounts != null;
        ServerGlimpse.AdvertisementInfo advertisementInfo = hasAdvertisement ? new ServerGlimpse.AdvertisementInfo(this.advertisementTimestamp, usedAdvertisementResult, this.rspec, this.getSliverTypeInfo(), this.getDiskImages(), this.componentManagerIds, this.componentDetails == null ? null : this.componentDetails.values(), this.counts, this.hwCounts, this.hardwareTypeInfo) : null;
        Result usedHealthResult = this.healthResult == null ? null : new ResultBuilder(this.healthResult).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        boolean hasHealth = this.health != null || this.healthExplanation != null || this.healthExplanationFull != null || usedHealthResult != null || this.healthStatus != null || this.healthTimestamp != null;
        ServerGlimpse.HealthInfo healthInfo2 = healthInfo = hasHealth ? new ServerGlimpse.HealthInfo(this.healthTimestamp, usedHealthResult, this.health, this.healthExplanation, this.healthExplanationFull, this.healthStatus) : null;
        Server usedServer = this.server == null && this.serverBuilder != null ? this.serverBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY) : (this.server == null ? null : new ServerBuilder(this.server).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
        return new ServerGlimpse(minimization.includeOtherProperties() ? advertisementInfo : null, minimization.includeOtherProperties() ? healthInfo : null, minimization.includeId() ? usedServer : null, minimization.includeOtherProperties() ? this.reputation : null, minimization.includeOtherProperties() ? this.maintenance : null, minimization.includeId() ? this.uri : null);
    }

    public ServerGlimpse_v1 create_v1() {
        ServerGlimpse_v1.HealthInfo healthInfo;
        if (this.serverBuilder != null && this.server != null) {
            throw new IllegalStateException("Either none, only server or only serverBuilder must be set, not both.");
        }
        Result usedAdvertisementResult = this.advertisementResult == null ? null : new ResultBuilder(this.advertisementResult).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        boolean hasAdvertisement = this.advertisementTimestamp != null || usedAdvertisementResult != null || this.rspec != null || this.sliverTypeInfoBySliverType != null || this.nullSliverTypeInfo != null || this.diskImagesById != null || this.componentManagerIds != null || this.componentDetails != null || this.counts != null || this.hwCounts != null;
        ServerGlimpse_v1.AdvertisementInfo advertisementInfo = hasAdvertisement ? new ServerGlimpse_v1.AdvertisementInfo(this.advertisementTimestamp, usedAdvertisementResult, this.rspec, this.getSliverTypeInfo_v1(), this.getDiskImages_v1(), this.componentManagerIds, this.getAvailableComponentIds(), this.getUnavailableComponentIds(), this.counts) : null;
        Result usedHealthResult = this.healthResult == null ? null : new ResultBuilder(this.healthResult).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY);
        boolean hasHealth = this.health != null || this.healthExplanation != null || this.healthExplanationFull != null || usedHealthResult != null || this.healthStatus != null || this.healthTimestamp != null;
        ServerGlimpse_v1.HealthInfo healthInfo2 = healthInfo = hasHealth ? new ServerGlimpse_v1.HealthInfo(this.healthTimestamp, usedHealthResult, this.health, this.healthExplanation, this.healthExplanationFull, this.healthStatus) : null;
        Server usedServer = this.server == null && this.serverBuilder != null ? this.serverBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY) : (this.server == null ? null : new ServerBuilder(this.server).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY));
        return new ServerGlimpse_v1(advertisementInfo, healthInfo, usedServer, this.uri);
    }

    public static List<ServerGlimpse> createAll(Collection<ServerGlimpseBuilder> builders) {
        if (builders == null) {
            return null;
        }
        ArrayList<ServerGlimpse> res = new ArrayList<ServerGlimpse>();
        for (ServerGlimpseBuilder b : builders) {
            res.add(b.create());
        }
        return res;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Server.class, name="server")
    public Server getServer() {
        return this.server;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Server.class, name="server", builderReference=true)
    public ServerBuilder getServerBuilder() {
        return this.serverBuilder;
    }

    public Date getTimestamp() {
        return this.advertisementTimestamp;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Result.class, name="advertisementResult")
    public Result getAdvertisementResult() {
        return this.advertisementResult;
    }

    public URI getRspec() {
        return this.rspec;
    }

    public Set<String> getComponentManagerIds() {
        return this.componentManagerIds;
    }

    public Map<String, ServerGlimpse.AdvertisementInfo.ComponentDetails> getComponentDetailsMap() {
        return this.componentDetails;
    }

    public Collection<ServerGlimpse.AdvertisementInfo.ComponentDetails> getComponentDetails() {
        return this.componentDetails == null ? null : this.componentDetails.values();
    }

    public Integer getServerId() {
        return this.server == null ? (this.serverBuilder == null ? null : (Integer)this.serverBuilder.getId()) : (Integer)this.server.getId();
    }

    public Map<String, Integer> getCounts() {
        return this.counts;
    }

    public Map<String, Integer> getHwCounts() {
        return this.hwCounts;
    }

    public Date getHealthTimestamp() {
        return this.healthTimestamp;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Result.class, name="healthResult")
    public Result getHealthResult() {
        return this.healthResult;
    }

    public Integer getHealth() {
        return this.health;
    }

    public String getHealthExplanation() {
        return this.healthExplanation;
    }

    public String getHealthExplanationFull() {
        return this.healthExplanationFull;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public Integer getReputation() {
        return this.reputation;
    }

    public List<MaintenanceInfo> getMaintenance() {
        return this.maintenance;
    }

    public ServerGlimpse.AdvertisementInfo.HardwareTypeInfo getHardwareTypeInfo() {
        return this.hardwareTypeInfo;
    }

    public Integer getCount(AdvertisementCounts.CountedObject object, AdvertisementCounts.CountScope scope) {
        if (this.counts == null) {
            return null;
        }
        return this.counts.get(object.getKeyPrefixName() + scope.getKeySuffixName());
    }

    public Integer getHwCount(String hwType, AdvertisementCounts.CountScope scope) {
        if (this.hwCounts == null) {
            return null;
        }
        return this.hwCounts.get(hwType + scope.getKeySuffixName());
    }

    public List<ServerGlimpse.AdvertisementInfo.SliverTypeInfo> getSliverTypeInfo() {
        if (this.nullSliverTypeInfo == null && this.sliverTypeInfoBySliverType == null) {
            return null;
        }
        ArrayList<ServerGlimpse.AdvertisementInfo.SliverTypeInfo> res = new ArrayList<ServerGlimpse.AdvertisementInfo.SliverTypeInfo>();
        if (this.sliverTypeInfoBySliverType != null) {
            for (MutableSliverTypeInfo msti : this.sliverTypeInfoBySliverType.values()) {
                res.add(msti.toSliverTypeInfo());
            }
        }
        if (this.nullSliverTypeInfo != null) {
            res.add(this.nullSliverTypeInfo.toSliverTypeInfo());
        }
        return res;
    }

    public List<ServerGlimpse.AdvertisementInfo.DiskImage> getDiskImages() {
        if (this.diskImagesById == null) {
            return null;
        }
        ArrayList<ServerGlimpse.AdvertisementInfo.DiskImage> res = new ArrayList<ServerGlimpse.AdvertisementInfo.DiskImage>();
        for (MutableDiskImage diskImage : this.diskImagesById.values()) {
            res.add(diskImage.toDiskImage());
        }
        return res;
    }

    public List<ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo> getSliverTypeInfo_v1() {
        if (this.nullSliverTypeInfo == null && this.sliverTypeInfoBySliverType == null) {
            return null;
        }
        ArrayList<ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo> res = new ArrayList<ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo>();
        if (this.sliverTypeInfoBySliverType != null) {
            for (MutableSliverTypeInfo msti : this.sliverTypeInfoBySliverType.values()) {
                res.add(msti.toSliverTypeInfo_v1());
            }
        }
        if (this.nullSliverTypeInfo != null) {
            res.add(this.nullSliverTypeInfo.toSliverTypeInfo_v1());
        }
        return res;
    }

    public List<ServerGlimpse_v1.AdvertisementInfo.DiskImage> getDiskImages_v1() {
        if (this.diskImagesById == null) {
            return null;
        }
        ArrayList<ServerGlimpse_v1.AdvertisementInfo.DiskImage> res = new ArrayList<ServerGlimpse_v1.AdvertisementInfo.DiskImage>();
        for (MutableDiskImage diskImage : this.diskImagesById.values()) {
            res.add(diskImage.toDiskImage_v1());
        }
        return res;
    }

    public List<String> getAvailableComponentIds() {
        return this.componentDetails == null ? null : this.componentDetails.values().stream().filter(Objects::nonNull).filter(ServerGlimpse.AdvertisementInfo.ComponentDetails::getAvailable).map(ServerGlimpse.AdvertisementInfo.ComponentDetails::getId).collect(Collectors.toList());
    }

    public Collection<String> getUnavailableComponentIds() {
        return this.componentDetails == null ? null : (Collection)this.componentDetails.values().stream().filter(Objects::nonNull).filter(ServerGlimpse.AdvertisementInfo.ComponentDetails::getUnavailable).map(ServerGlimpse.AdvertisementInfo.ComponentDetails::getId).collect(Collectors.toList());
    }

    private static class MutableSliverTypeInfo {
        private final String sliverType;
        private Set<String> hardwareTypes;
        private Set<String> flavors;
        private String defaultDiskImage;

        public MutableSliverTypeInfo(String sliverType) {
            this.sliverType = sliverType;
        }

        public MutableSliverTypeInfo(ServerGlimpse.AdvertisementInfo.SliverTypeInfo orig) {
            this.sliverType = orig.getSliverType();
            this.defaultDiskImage = orig.getDefaultDiskImage();
            this.hardwareTypes = orig.getHardwareTypes() == null ? null : new TreeSet<String>(orig.getHardwareTypes());
            this.flavors = orig.getFlavors() == null ? null : new TreeSet<String>(orig.getFlavors());
        }

        public MutableSliverTypeInfo(String sliverType, Collection<String> hardwareTypes, Collection<String> flavors, String defaultDiskImage) {
            this.sliverType = sliverType;
            this.defaultDiskImage = defaultDiskImage;
            this.hardwareTypes = hardwareTypes == null ? null : new TreeSet<String>(hardwareTypes);
            this.flavors = flavors == null ? null : new TreeSet<String>(flavors);
        }

        public void addHardwareType(String hardwareType) {
            if (this.hardwareTypes == null) {
                this.hardwareTypes = new TreeSet<String>();
            }
            this.hardwareTypes.add(hardwareType);
        }

        public void addHardwareTypes(Collection<String> hardwareTypes) {
            if (this.hardwareTypes == null) {
                this.hardwareTypes = new TreeSet<String>();
            }
            this.hardwareTypes.addAll(hardwareTypes);
        }

        public void addFlavor(String flavor) {
            if (this.flavors == null) {
                this.flavors = new TreeSet<String>();
            }
            this.flavors.add(flavor);
        }

        public void addFlavors(Collection<String> flavors) {
            if (this.flavors == null) {
                this.flavors = new TreeSet<String>();
            }
            this.flavors.addAll(flavors);
        }

        public void setDefaultDiskImage(String defaultDiskImage) {
            this.defaultDiskImage = defaultDiskImage;
        }

        public ServerGlimpse.AdvertisementInfo.SliverTypeInfo toSliverTypeInfo() {
            return new ServerGlimpse.AdvertisementInfo.SliverTypeInfo(this.sliverType, this.hardwareTypes, this.flavors, this.defaultDiskImage);
        }

        public ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo toSliverTypeInfo_v1() {
            return new ServerGlimpse_v1.AdvertisementInfo.SliverTypeInfo(this.sliverType, this.hardwareTypes, this.defaultDiskImage);
        }
    }

    private static class MutableDiskImage {
        private final String name;
        private final String url;
        private String description;
        private String os;
        private String version;
        private Set<String> sliverTypes;

        public MutableDiskImage(String name, String url, String description, String version, String os) {
            this.name = name;
            this.url = url;
            this.description = description;
            this.version = version;
            this.os = os;
            this.sliverTypes = new TreeSet<String>();
        }

        public MutableDiskImage(ServerGlimpse.AdvertisementInfo.DiskImage orig) {
            this.name = orig.getName();
            this.url = orig.getUrl();
            this.description = orig.getDescription();
            this.version = orig.getVersion();
            this.os = orig.getOs();
            this.sliverTypes = orig.getSliverTypes() == null ? new TreeSet<String>() : new TreeSet<String>(orig.getSliverTypes());
        }

        public void addSliverType(String sliverType) {
            this.sliverTypes.add(sliverType);
        }

        public void addSliverTypes(Collection<String> sliverTypes) {
            this.sliverTypes.addAll(sliverTypes);
        }

        public ServerGlimpse.AdvertisementInfo.DiskImage toDiskImage() {
            return new ServerGlimpse.AdvertisementInfo.DiskImage(this.description, this.name, this.os, this.url, this.version, this.sliverTypes);
        }

        public ServerGlimpse_v1.AdvertisementInfo.DiskImage toDiskImage_v1() {
            return new ServerGlimpse_v1.AdvertisementInfo.DiskImage(this.description, this.name, this.os, this.url, this.version, this.sliverTypes);
        }
    }
}

