/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder_v1;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Serializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.ForeignIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dropwizard.jackson.Jackson;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="serverglimpse", builderClass=ServerGlimpseBuilder_v1.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.FOREIGN)
public class ServerGlimpse_v1
extends ForeignIdObject {
    private static final Logger LOG = LoggerFactory.getLogger(ServerGlimpse_v1.class);
    private final AdvertisementInfo advertisementInfo;
    private final HealthInfo healthInfo;
    private final Server server;

    @JsonCreator
    ServerGlimpse_v1(@JsonProperty(value="advertisementInfo") AdvertisementInfo advertisementInfo, @JsonProperty(value="healthInfo") HealthInfo healthInfo, @JsonProperty(value="server") Server server, @JsonProperty(value="@id") URI uri) {
        super(uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
        this.advertisementInfo = advertisementInfo;
        this.healthInfo = healthInfo;
        this.server = server;
    }

    @JsonProperty
    public AdvertisementInfo getAdvertisementInfo() {
        return this.advertisementInfo;
    }

    @JsonProperty
    public HealthInfo getHealthInfo() {
        return this.healthInfo;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServerDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ParentLinkSerializer.class)
    public Server getServer() {
        return this.server;
    }

    @JsonIgnore
    public Integer getServerId() {
        return this.server == null ? null : (Integer)this.server.getId();
    }

    @Override
    @JsonProperty(value="@type")
    public String getClassName() {
        return "ServerGlimpse";
    }

    @JsonProperty(value="@type")
    private void setClassName(String className) {
        if (!this.getClassName().equals(className)) {
            throw new IllegalArgumentException("@type must be " + this.getClassName());
        }
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getSimpleName() + " to JSON", e);
            return "Exception converting " + this.getClass().getSimpleName() + " to JSON: " + e.getMessage();
        }
    }

    public static ServerGlimpse_v1 create(ServerGlimpse serverGlimpse_v2) {
        return new ServerGlimpseBuilder(serverGlimpse_v2).create_v1();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    public static class AdvertisementInfo {
        private final Timestamp timestamp;
        private final Result result;
        private final URI rspec;
        private final List<DiskImage> diskImages;
        private final List<SliverTypeInfo> sliverTypeInfo;
        private final List<String> componentManagerIds;
        private final List<String> availableComponentIds;
        private final List<String> unavailableComponentIds;
        private final TreeMap<String, Integer> counts;

        @JsonCreator
        AdvertisementInfo(@JsonProperty(value="timestamp") Timestamp timestamp, @JsonProperty(value="result") Result result, @JsonProperty(value="rspec") URI rspec, @JsonProperty(value="sliverTypeInfo") Collection<SliverTypeInfo> sliverTypeInfo, @JsonProperty(value="diskImages") Collection<DiskImage> diskImages, @JsonProperty(value="componentManagerIds") Collection<String> componentManagerIds, @JsonProperty(value="availableComponentIds") Collection<String> availableComponentIds, @JsonProperty(value="unavailableComponentIds") Collection<String> unavailableComponentIds, @JsonProperty(value="counts") Map<String, Integer> counts) {
            this.timestamp = timestamp;
            this.result = result;
            this.rspec = rspec;
            this.sliverTypeInfo = sliverTypeInfo == null ? null : Collections.unmodifiableList(new ArrayList<SliverTypeInfo>(sliverTypeInfo));
            this.diskImages = diskImages == null ? null : Collections.unmodifiableList(new ArrayList<DiskImage>(diskImages));
            this.componentManagerIds = componentManagerIds == null ? null : Collections.unmodifiableList(new ArrayList<String>(componentManagerIds));
            this.availableComponentIds = availableComponentIds == null ? null : Collections.unmodifiableList(new ArrayList<String>(availableComponentIds));
            this.unavailableComponentIds = unavailableComponentIds == null ? null : Collections.unmodifiableList(new ArrayList<String>(unavailableComponentIds));
            TreeMap treeMap = this.counts = counts == null ? null : new TreeMap(String.CASE_INSENSITIVE_ORDER);
            if (counts != null) {
                this.counts.putAll(counts);
            }
        }

        @JsonProperty
        @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
        @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        @JsonProperty
        @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResultDeserializer.class)
        @JsonSerialize(using=JsonLdObjectLinkSerializer.ChildLinkSerializer.class)
        public Result getResult() {
            return this.result;
        }

        @JsonProperty
        public URI getRspec() {
            return this.rspec;
        }

        @JsonProperty
        public List<DiskImage> getDiskImages() {
            return this.diskImages;
        }

        @JsonProperty
        public List<SliverTypeInfo> getSliverTypeInfo() {
            return this.sliverTypeInfo;
        }

        @JsonProperty
        public List<String> getComponentManagerIds() {
            return this.componentManagerIds;
        }

        @JsonProperty
        public List<String> getAvailableComponentIds() {
            return this.availableComponentIds;
        }

        @JsonProperty
        public List<String> getUnavailableComponentIds() {
            return this.unavailableComponentIds;
        }

        @JsonProperty
        public Map<String, Integer> getCounts() {
            if (this.counts == null) {
                return null;
            }
            return Collections.unmodifiableMap(this.counts);
        }

        @JsonIgnore
        public Integer getCount(CountedObject object, CountScope scope) {
            if (this.counts == null) {
                return null;
            }
            return this.counts.get(object.getKeyPrefixName() + scope.getKeySuffixName());
        }

        public String toString() {
            ObjectMapper mapper = Jackson.newObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting SliverTypeInfo to JSON", e);
                return "Exception converting SliverTypeInfo to JSON: " + e.getMessage();
            }
        }

        public static enum CountedObject {
            ANY("any"),
            RAW_PC("rawPCs"),
            VM("VMs"),
            IPV4("Ipv4s"),
            OPENFLOW("Openflows");

            private final String keyPrefixName;

            private CountedObject(String keyPrefixName) {
                this.keyPrefixName = keyPrefixName;
            }

            public String getKeyPrefixName() {
                return this.keyPrefixName;
            }
        }

        public static enum CountScope {
            AVAILABLE("Available"),
            ALL("Total");

            private final String keySuffixName;

            private CountScope(String keySuffixName) {
                this.keySuffixName = keySuffixName;
            }

            public String getKeySuffixName() {
                return this.keySuffixName;
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(value={"@context"})
        public static class SliverTypeInfo {
            private final String sliverType;
            private final Set<String> hardwareTypes;
            private final String defaultDiskImage;

            @JsonCreator
            public SliverTypeInfo(@JsonProperty(value="sliverType") String sliverType, @JsonProperty(value="hardwareTypes") Collection<String> hardwareTypes, @JsonProperty(value="defaultDiskImage") String defaultDiskImage) {
                this.sliverType = sliverType;
                this.hardwareTypes = hardwareTypes == null ? null : new TreeSet<String>(hardwareTypes);
                this.defaultDiskImage = defaultDiskImage;
            }

            @JsonProperty
            public String getSliverType() {
                return this.sliverType;
            }

            @JsonProperty
            public Set<String> getHardwareTypes() {
                return Collections.unmodifiableSet(this.hardwareTypes);
            }

            @JsonProperty
            public String getDefaultDiskImage() {
                return this.defaultDiskImage;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SliverTypeInfo that = (SliverTypeInfo)o;
                if (this.defaultDiskImage != null ? !this.defaultDiskImage.equals(that.defaultDiskImage) : that.defaultDiskImage != null) {
                    return false;
                }
                if (this.hardwareTypes != null ? !this.hardwareTypes.equals(that.hardwareTypes) : that.hardwareTypes != null) {
                    return false;
                }
                return !(this.sliverType != null ? !this.sliverType.equals(that.sliverType) : that.sliverType != null);
            }

            public int hashCode() {
                int result = this.sliverType != null ? this.sliverType.hashCode() : 0;
                result = 31 * result + (this.hardwareTypes != null ? this.hardwareTypes.hashCode() : 0);
                result = 31 * result + (this.defaultDiskImage != null ? this.defaultDiskImage.hashCode() : 0);
                return result;
            }

            public String toString() {
                ObjectMapper mapper = Jackson.newObjectMapper();
                try {
                    return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
                }
                catch (JsonProcessingException e) {
                    LOG.error("Exception converting SliverTypeInfo to JSON", e);
                    return "Exception converting SliverTypeInfo to JSON: " + e.getMessage();
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(value={"@context"})
        public static class DiskImage {
            private final String description;
            private final String name;
            private final String os;
            private final String url;
            private final String version;
            private final Set<String> sliverTypes;

            @JsonCreator
            public DiskImage(@JsonProperty(value="description") String description, @JsonProperty(value="name") String name, @JsonProperty(value="os") String os, @JsonProperty(value="url") String url, @JsonProperty(value="version") String version, @JsonProperty(value="sliverTypes") Collection<String> sliverTypes) {
                this.description = description;
                this.name = name;
                this.os = os;
                this.url = url;
                this.version = version;
                this.sliverTypes = sliverTypes == null ? null : new TreeSet<String>(sliverTypes);
            }

            @JsonProperty
            public String getDescription() {
                return this.description;
            }

            @JsonProperty
            public String getName() {
                return this.name;
            }

            @JsonProperty
            public String getOs() {
                return this.os;
            }

            @JsonProperty
            public String getUrl() {
                return this.url;
            }

            @JsonProperty
            public String getVersion() {
                return this.version;
            }

            @JsonProperty
            public Set<String> getSliverTypes() {
                return Collections.unmodifiableSet(this.sliverTypes);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DiskImage diskImage = (DiskImage)o;
                if (this.description != null ? !this.description.equals(diskImage.description) : diskImage.description != null) {
                    return false;
                }
                if (this.name != null ? !this.name.equals(diskImage.name) : diskImage.name != null) {
                    return false;
                }
                if (this.os != null ? !this.os.equals(diskImage.os) : diskImage.os != null) {
                    return false;
                }
                if (this.sliverTypes != null ? !this.sliverTypes.equals(diskImage.sliverTypes) : diskImage.sliverTypes != null) {
                    return false;
                }
                if (this.url != null ? !this.url.equals(diskImage.url) : diskImage.url != null) {
                    return false;
                }
                return !(this.version != null ? !this.version.equals(diskImage.version) : diskImage.version != null);
            }

            public int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.os != null ? this.os.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                result = 31 * result + (this.sliverTypes != null ? this.sliverTypes.hashCode() : 0);
                return result;
            }

            public String toString() {
                ObjectMapper mapper = Jackson.newObjectMapper();
                try {
                    return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
                }
                catch (JsonProcessingException e) {
                    LOG.error("Exception converting DiskImage to JSON", e);
                    return "Exception converting DiskImage to JSON: " + e.getMessage();
                }
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    public static class HealthInfo {
        private final Timestamp timestamp;
        private final Result result;
        private final Integer health;
        private final String healthExplanation;
        private final String healthExplanationFull;
        private final String status;

        @JsonCreator
        public HealthInfo(@JsonProperty(value="timestamp") Timestamp timestamp, @JsonProperty(value="result") Result result, @JsonProperty(value="health") Integer health, @JsonProperty(value="healthExplanation") String healthExplanation, @JsonProperty(value="healthExplanationFull") String healthExplanationFull, @JsonProperty(value="status") String status) {
            this.timestamp = timestamp;
            this.result = result;
            this.health = health;
            this.healthExplanation = healthExplanation;
            this.healthExplanationFull = healthExplanationFull;
            this.status = status;
        }

        @JsonProperty
        @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
        @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        @JsonProperty
        @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResultDeserializer.class)
        @JsonSerialize(using=JsonLdObjectLinkSerializer.ChildLinkSerializer.class)
        public Result getResult() {
            return this.result;
        }

        @JsonProperty
        public Integer getHealth() {
            return this.health;
        }

        @JsonProperty
        public String getHealthExplanation() {
            return this.healthExplanation;
        }

        @JsonProperty
        public String getHealthExplanationFull() {
            return this.healthExplanationFull;
        }

        @JsonProperty
        public String getStatus() {
            return this.status;
        }

        public String toString() {
            ObjectMapper mapper = Jackson.newObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting HealthInfo to JSON", e);
                return "Exception converting HealthInfo to JSON: " + e.getMessage();
            }
        }
    }
}

