/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="service", builderClass=ServiceBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Service
extends PrimaryIdObject<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(Service.class);
    private final Server server;
    private final String api;
    private final String apiVersion;
    private final String url;
    private final String urn;

    Service(Integer id, Server server, String api, String apiVersion, String url, String urn, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super(id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.server = server;
        this.api = api;
        this.apiVersion = apiVersion;
        this.url = url;
        this.urn = urn;
    }

    @JsonCreator
    Service(@JsonProperty(value="id") Integer id, @JsonProperty(value="server") Server server, @JsonProperty(value="api") String api, @JsonProperty(value="apiVersion") String apiVersion, @JsonProperty(value="url") String url, @JsonProperty(value="urn") String urn, @JsonProperty(value="@id") URI uri) {
        this(id, server, api, apiVersion, url, urn, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServerDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ParentLinkSerializer.class)
    public Server getServer() {
        return this.server;
    }

    @JsonIgnore
    public Integer getServerId() {
        return this.server == null ? null : (Integer)this.server.getId();
    }

    @JsonProperty
    public String getApi() {
        return this.api;
    }

    @JsonProperty
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    @JsonProperty
    public String getUrn() {
        return this.urn;
    }

    @JsonIgnore
    public GeniUrn getUrnAsGeniUrn() {
        if (this.urn == null) {
            return null;
        }
        try {
            return new GeniUrn(this.urn);
        }
        catch (GeniUrn.GeniUrnParseException e) {
            throw new RuntimeException("Service " + this.getId() + " has invalid urn \"" + this.urn + "\"");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        if (this.api != null ? !this.api.equals(service.api) : service.api != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(service.apiVersion) : service.apiVersion != null) {
            return false;
        }
        if (this.id != null ? !((Integer)this.id).equals(service.id) : service.id != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(service.uri) : service.uri != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(service.url) : service.url != null) {
            return false;
        }
        return !(this.urn != null ? !this.urn.equals(service.urn) : service.urn != null);
    }

    @Override
    public int hashCode() {
        int result = this.id != null ? ((Integer)this.id).hashCode() : 0;
        result = 31 * result + (this.api != null ? this.api.hashCode() : 0);
        result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.urn != null ? this.urn.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(ServiceBuilder.minimize(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, this));
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getSimpleName() + " " + this.id + " to JSON", e);
            return "Exception converting " + this.getClass().getSimpleName() + " " + this.id + " to JSON: " + e.getMessage();
        }
    }
}

