/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TaskBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Serializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="task", builderClass=TaskBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Task
extends PrimaryIdObject<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(Task.class);
    public static long CREATED_TASK_DEADLINE_MILLIS = 120000L;
    public static long STRESSTEST_CREATED_TASK_DEADLINE_MILLIS = 0x6DDD00L;
    private final TestInstance testInstance;
    private final Timestamp start;
    private final Timestamp deadline;
    private final Timestamp stop;
    private final String log;
    private final Result result;
    private final String runInfo;
    private final State state;

    @JsonCreator
    Task(@JsonProperty(value="id") Long id, @JsonProperty(value="testInstance") TestInstance testInstance, @JsonProperty(value="start") Timestamp start, @JsonProperty(value="deadline") Timestamp deadline, @JsonProperty(value="stop") Timestamp stop, @JsonProperty(value="log") String log, @JsonProperty(value="result") Result result, @JsonProperty(value="runInfo") String runInfo, @JsonProperty(value="state") State state, @JsonProperty(value="@id") URI uri) {
        this(id, testInstance, start, deadline, stop, log, result, runInfo, state, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    Task(Long id, TestInstance testInstance, Timestamp start, Timestamp deadline, Timestamp stop, String log, Result result, String runInfo, State state, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super(id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.testInstance = testInstance;
        this.start = start;
        this.deadline = deadline;
        this.stop = stop;
        this.log = log;
        this.result = result;
        this.runInfo = runInfo;
        this.state = state;
    }

    @JsonIgnore
    public Integer getTestInstanceId() {
        return this.testInstance == null ? null : (Integer)this.testInstance.getId();
    }

    @JsonIgnore
    public URI getTestInstanceUri() {
        return this.testInstance == null ? null : this.testInstance.getUri();
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.TestInstanceDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.ParentLinkSerializer.class)
    TestInstance getTestInstance() {
        return this.testInstance;
    }

    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @JsonProperty
    public Timestamp getStart() {
        return this.start;
    }

    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @JsonProperty
    public Timestamp getDeadline() {
        return this.deadline;
    }

    @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
    @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
    @JsonProperty
    public Timestamp getStop() {
        return this.stop;
    }

    @JsonProperty
    public String getLog() {
        return this.log;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResultDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkSerializer.class)
    Result getResult() {
        return this.result;
    }

    @JsonIgnore
    public Long getResultId() {
        return this.result == null ? null : (Long)this.result.getId();
    }

    @JsonIgnore
    public URI getResultUri() {
        return this.result == null ? null : this.result.getUri();
    }

    @JsonProperty
    public String getRunInfo() {
        return this.runInfo;
    }

    @JsonProperty
    public State getState() {
        return this.state;
    }

    @JsonIgnore
    public boolean isInActiveState() {
        switch (this.state) {
            case RUNNING: 
            case CANCELLING: 
            case CREATED: {
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean isExpired() {
        switch (this.state) {
            case RUNNING: 
            case CREATED: {
                Date now = Clock.nowDate();
                assert (this.deadline != null);
                return now.after(this.deadline);
            }
            case CANCELLING: {
                return false;
            }
            case EXPIRED: {
                return true;
            }
            case FINISHED: {
                return false;
            }
            case CANCELLED: {
                return false;
            }
        }
        throw new RuntimeException("state not handled: " + this.state);
    }

    @Override
    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting Task " + this.getId() + " to JSON", e);
            return "Exception converting Task " + this.getId() + " to JSON: " + e.getMessage();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        if (this.state != null ? !this.state.equals((Object)task.state) : task.state != null) {
            return false;
        }
        if (this.deadline != null ? !this.deadline.equals(task.deadline) : task.deadline != null) {
            return false;
        }
        if (this.stop != null ? !this.stop.equals(task.stop) : task.stop != null) {
            return false;
        }
        if (this.id != null ? !((Long)this.id).equals(task.id) : task.id != null) {
            return false;
        }
        if (this.log != null ? !this.log.equals(task.log) : task.log != null) {
            return false;
        }
        if (this.getResultId() != null ? !this.getResultId().equals(task.getResultId()) : task.getResultId() != null) {
            return false;
        }
        if (this.runInfo != null ? !this.runInfo.equals(task.runInfo) : task.runInfo != null) {
            return false;
        }
        if (this.start != null ? !this.start.equals(task.start) : task.start != null) {
            return false;
        }
        if (this.getTestInstanceId() != null ? !this.getTestInstanceId().equals(task.getTestInstanceId()) : task.getTestInstanceId() != null) {
            return false;
        }
        return !(this.uri != null ? !this.uri.equals(task.uri) : task.uri != null);
    }

    @Override
    public int hashCode() {
        int result = this.id != null ? ((Long)this.id).hashCode() : 0;
        result = 31 * result + (this.getTestInstanceId() != null ? this.getTestInstanceId().hashCode() : 0);
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        result = 31 * result + (this.deadline != null ? this.deadline.hashCode() : 0);
        result = 31 * result + (this.stop != null ? this.stop.hashCode() : 0);
        result = 31 * result + (this.log != null ? this.log.hashCode() : 0);
        result = 31 * result + (this.getResultId() != null ? this.getResultId().hashCode() : 0);
        result = 31 * result + (this.runInfo != null ? this.runInfo.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }

    public static enum State {
        CREATED,
        RUNNING,
        EXPIRED,
        FINISHED,
        CANCELLING,
        CANCELLED;

    }
}

