/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=TestbedCategory.class)
public class TestbedCategoryBuilder
extends PrimaryIdObjectBuilder<Integer, TestbedCategory, TestbedCategoryBuilder> {
    private String name;
    private Boolean guiFilter;
    private Collection<Testbed> testbeds;

    public TestbedCategoryBuilder() {
    }

    public TestbedCategoryBuilder(TestbedCategory orig) {
        super(orig);
        this.name = orig.getName();
        this.testbeds = orig.getTestbeds();
        this.guiFilter = orig.isGuiFilter();
    }

    public TestbedCategoryBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public TestbedCategoryBuilder setGuiFilter(Boolean guiFilter) {
        this.guiFilter = guiFilter;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Testbed.class)
    public TestbedCategoryBuilder setTestbeds(Collection<Testbed> testbeds) {
        this.testbeds = testbeds;
        return this;
    }

    public TestbedCategoryBuilder setTestbedIds(Collection<String> testbedIds) {
        ArrayList<Testbed> newTestbeds = new ArrayList<Testbed>();
        for (String id : testbedIds) {
            Testbed testbed = ((TestbedBuilder)new TestbedBuilder().setId(id)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
            newTestbeds.add(testbed);
        }
        this.testbeds = newTestbeds;
        return this;
    }

    @Override
    public TestbedCategory create() {
        return new TestbedCategory((Integer)this.id, this.name, this.guiFilter, this.testbeds, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    @Override
    public TestbedCategory createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        return new TestbedCategory(minimization.includeId() ? (Integer)this.id : null, minimization.includeExtraIds() ? this.name : null, minimization.includeExtraIds() ? this.guiFilter : null, this.testbeds == null || !minimization.includeChildren() ? null : TestbedBuilder.minimize(minimization.getChildrenMinimization(), this.testbeds), minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
    }

    @Nullable
    public static List<TestbedCategory> minimize(@Nonnull JsonLdObjectsMetaData.Minimization minimization, @Nullable Collection<TestbedCategory> in) {
        if (in == null) {
            return null;
        }
        ArrayList<TestbedCategory> res = new ArrayList<TestbedCategory>();
        for (TestbedCategory tb : in) {
            res.add(new TestbedCategoryBuilder(tb).createMinimized(minimization));
        }
        return res;
    }

    @Nullable
    public static TestbedCategory minimize(@Nonnull JsonLdObjectsMetaData.Minimization minimization, @Nullable TestbedCategory in) {
        if (in == null) {
            return null;
        }
        return new TestbedCategoryBuilder(in).createMinimized(minimization);
    }

    public String getName() {
        return this.name;
    }

    public Boolean isGuiFilter() {
        return this.guiFilter;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Testbed.class)
    public Collection<Testbed> getTestbeds() {
        return this.testbeds;
    }
}

