/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.logic;

import be.iminds.ilabt.jfed.fedmon.spring_helpers.CronSequenceGenerator;
import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedmonLogic {
    private static final Logger LOG = LoggerFactory.getLogger(FedmonLogic.class);
    private static final Timestamp farFuture = new Timestamp(1576800000000000L);
    private static final NextRunAndExpire never = new NextRunAndExpire(null, farFuture);

    public static NextRunAndExpire calculateResultNextRunAndExpire(Result result, TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, Date resultReceivedDate) {
        return FedmonLogic.calculateResultNextRunAndExpire(result.getCreated(), testInstance, testInstanceFrequency, testDefinition, resultReceivedDate);
    }

    public static NextRunAndExpire calculateResultNextRunAndExpire(Date resultTimestamp, TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, Date resultReceivedDate) {
        Date nextRun;
        if (testInstance == null) {
            throw new IllegalArgumentException("result TestInstance must be non null");
        }
        if (testDefinition == null) {
            throw new IllegalArgumentException("result TestDefinition must be non null");
        }
        if (testInstanceFrequency == null) {
            LOG.debug("TestInstance has no frequency: will assume no nextRun and no expire. ti=" + testInstance.getName() + " id=" + testInstance.getId());
            return never;
        }
        String cronline = testInstanceFrequency.getCron();
        if (cronline == null) {
            LOG.debug("TestInstance frequency has no cron: will assume no nextRun and no expire. ti=" + testInstance.getName() + " id=" + testInstance.getId());
            return never;
        }
        Date pastDate = new Date(resultReceivedDate.getTime() - 300000L);
        Date futureDate = new Date(resultReceivedDate.getTime() + 120000L);
        if (resultTimestamp == null || resultTimestamp.after(futureDate) || resultTimestamp.before(pastDate)) {
            LOG.warn("Received result has a suspicious date: " + resultTimestamp);
            resultTimestamp = resultReceivedDate;
        }
        if (testInstanceFrequency.isNever()) {
            return never;
        }
        try {
            CronSequenceGenerator cronSequenceGenerator = new CronSequenceGenerator("0 " + cronline, TimeZone.getTimeZone("UTC"));
            nextRun = cronSequenceGenerator.next(resultTimestamp);
        }
        catch (IllegalStateException e) {
            LOG.warn("Error finding next cron sequence date. Assuming the expression has no next date. (Because this occurs for example for February 31)");
            return never;
        }
        if (nextRun == null) {
            LOG.warn("Error finding next cron sequence date. Assuming the expression has no next date.");
            return never;
        }
        long timeoutMs = testDefinition.getMaxTestDurationMs();
        if (timeoutMs < 600000L) {
            timeoutMs = 600000L;
        }
        Timestamp expire = new Timestamp(nextRun.getTime() + 2L * timeoutMs);
        return new NextRunAndExpire(expire, new Timestamp(nextRun.getTime()));
    }

    public static ResultBuilder initNewResultFromTask(@Nonnull Task task, @Nonnull TestInstance testInstance, @Nullable Frequency testInstanceFrequency, @Nonnull TestDefinition testDefinition) {
        Timestamp now = new Timestamp(Clock.currentTimeMillis());
        NextRunAndExpire nextRunAndExpire = FedmonLogic.calculateResultNextRunAndExpire(now, testInstance, testInstanceFrequency, testDefinition, (Date)now);
        return ((ResultBuilder)new ResultBuilder().setId((Object)null)).setTask((Long)task.getId(), null).setCreated(now).setExpire(nextRunAndExpire.getExpire()).setResults(new HashMap()).setTestInstance(testInstance);
    }

    public static URIBuilder getFedmonExternalReadUriBuilder(Properties config, Class<? extends JsonLdObjectWithUri> objectClass, String pathEnd) {
        String urlObjectName = JsonLdObjectsMetaData.getUrlObjectName(objectClass);
        assert (urlObjectName != null);
        String baseUrl = config.getProperty("fedmon_origins_external_url_read_base");
        if (baseUrl == null) {
            throw new RuntimeException("fedmon_origins_external_url_read_base config option not set");
        }
        try {
            URIBuilder builder = new URIBuilder(baseUrl);
            String basePath = ("/" + builder.getPath() + "/").replaceAll("//", "/");
            String fullPath = basePath + urlObjectName + "/" + pathEnd;
            builder.setPath(fullPath);
            return builder;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invallid URL in configuration: \"" + baseUrl + "\"", e);
        }
    }

    public static boolean mustRunNow(TestInstance testInstance, Frequency frequency, TestInstanceStatistics testInstanceStatistics) {
        if (testInstance.getEnabled() != Boolean.TRUE) {
            return false;
        }
        if (frequency == null) {
            return false;
        }
        if (frequency.isNever()) {
            return false;
        }
        if (testInstanceStatistics.getNextRun() != null) {
            long next = testInstanceStatistics.getNextRun().getTime();
            return next < Clock.currentTimeMillis();
        }
        return true;
    }

    public static class NextRunAndExpire {
        private final Timestamp expire;
        private final Timestamp nextRun;

        public NextRunAndExpire(Timestamp expire, Timestamp nextRun) {
            this.expire = expire;
            this.nextRun = nextRun;
        }

        public Timestamp getExpire() {
            return this.expire;
        }

        public Timestamp getNextRun() {
            return this.nextRun;
        }
    }
}

