/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.GraphDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GraphBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.codahale.metrics.annotation.Timed;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/graph")
@Produces(value={"application/json"})
public class GraphResource {
    private static final Logger LOG = LoggerFactory.getLogger(GraphResource.class);
    @Context
    UriInfo uriInfo;
    private final GraphDao graphDAO;
    private final FedmonWebApiServiceConfiguration configuration;

    public GraphResource(GraphDao graphDAO, FedmonWebApiServiceConfiguration configuration) {
        this.graphDAO = graphDAO;
        this.configuration = configuration;
    }

    private URI getUri(String graphId, boolean imageUri) {
        try {
            String slash;
            String string = slash = this.configuration.getBaseUrl().endsWith("/") ? "" : "/";
            if (graphId == null) {
                return new URI(this.configuration.getBaseUrl() + slash + "graph");
            }
            if (imageUri) {
                return new URI(this.configuration.getBaseUrl() + slash + "graph/" + graphId + "/image");
            }
            return new URI(this.configuration.getBaseUrl() + slash + "graph/" + graphId);
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException("Failed to construct URI. Server misconfiguration? baseUrl=\"" + this.configuration.getBaseUrl() + "\"", e);
        }
    }

    @GET
    @Timed
    public List<Graph> search(@Nonnull @QueryParam(value="testinstanceid") Integer testInstanceId) throws SQLException {
        assert (testInstanceId != null);
        List<Graph> resBase = this.graphDAO.getByTestInstanceId(testInstanceId);
        ArrayList<Graph> res = new ArrayList<Graph>(resBase.size());
        for (Graph r : resBase) {
            GraphBuilder graphBuilder = new GraphBuilder(r);
            graphBuilder.setUri(this.getUri((String)r.getId(), false));
            graphBuilder.setImageUri(this.getUri((String)r.getId(), true));
            graphBuilder = this.configuration.getUriTool().setUriRecursive(graphBuilder);
            res.add(graphBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS));
        }
        return res;
    }

    @GET
    @Path(value="{id}")
    @Timed
    public Graph getGraph(@NotNull @PathParam(value="id") String id) throws SQLException {
        Graph res = this.graphDAO.getById(id);
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        GraphBuilder graphBuilder = new GraphBuilder(res);
        graphBuilder.setUri(this.getUri(id, false));
        graphBuilder.setImageUri(this.getUri(id, true));
        graphBuilder = this.configuration.getUriTool().setUriRecursive(graphBuilder);
        return graphBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
    }

    @GET
    @Path(value="{id}/image")
    @Produces(value={"image/png"})
    @Timed
    public Response getContent(@NotNull @PathParam(value="id") String id, @Context HttpServletRequest request) throws SQLException {
        final byte[] res = this.graphDAO.getImageDataById(id);
        if (res == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("Graph " + id + " does not exist").type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        if (res.length == 0) {
            return Response.noContent().build();
        }
        StreamingOutput stream = new StreamingOutput(){

            @Override
            public void write(OutputStream os) throws IOException, WebApplicationException {
                os.write(res);
            }
        };
        return Response.ok((Object)stream, new MediaType("image", "png")).build();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Timed
    public Graph upsertGraph(@NotNull Graph graph, @Context HttpServletRequest request) throws SQLException {
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, request);
        if (graph.getId() == null || ((String)graph.getId()).trim().isEmpty()) {
            throw new BadRequestException("Graph requires an ID");
        }
        if (!((String)graph.getId()).contains("-")) {
            throw new BadRequestException("Graph ID \"" + (String)graph.getId() + "\" is invalid");
        }
        if (graph.getGraphDefinitionId() == null || graph.getGraphDefinitionId().trim().isEmpty()) {
            throw new BadRequestException("Graph requires a graphDefinitionId");
        }
        if (graph.getPeriodString() == null || graph.getPeriodString().trim().isEmpty()) {
            throw new BadRequestException("Graph requires a periodString");
        }
        int changedRows = this.graphDAO.upsertFields(graph);
        if (changedRows == 0) {
            LOG.error("Error upserting Graph (graphDAO.upsertFields returned 0)");
            throw new InternalServerErrorException("Error upserting Graph (graphDAO.upsertFields returned 0)");
        }
        GraphBuilder graphBuilder = new GraphBuilder(graph);
        graphBuilder.setUri(this.getUri((String)graph.getId(), false));
        graphBuilder.setImageUri(this.getUri((String)graph.getId(), true));
        graphBuilder = this.configuration.getUriTool().setUriRecursive(graphBuilder);
        return graphBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
    }

    @PUT
    @Path(value="{id}/image")
    @Consumes(value={"image/png"})
    @Timed
    public Response setContent(@NotNull @PathParam(value="id") String id, byte[] imageData, @Context HttpServletRequest httpServletRequest) throws SQLException {
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, httpServletRequest);
        ByteArrayInputStream appendedIS = new ByteArrayInputStream(imageData);
        int rowsChanged = this.graphDAO.updateImageData(id, appendedIS);
        if (rowsChanged == 0) {
            LOG.error("Could not set image data for graph " + id);
            throw new WebApplicationException("Could not set image data for graph " + id, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.noContent().build();
    }
}

