/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.JFedUserStatisticsDao;
import com.codahale.metrics.annotation.Timed;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/jfed-user-statistics")
@Produces(value={"application/json"})
public class JFedUserStatisticsResource {
    private static final Logger LOG = LoggerFactory.getLogger(JFedUserStatisticsResource.class);
    @Context
    UriInfo uriInfo;
    private final JFedUserStatisticsDao jFedUserStatisticsDAO;
    private final FedmonWebApiServiceConfiguration configuration;

    public JFedUserStatisticsResource(JFedUserStatisticsDao jFedUserStatisticsDAO, FedmonWebApiServiceConfiguration configuration) {
        this.jFedUserStatisticsDAO = jFedUserStatisticsDAO;
        this.configuration = configuration;
    }

    @GET
    @Timed
    public List<JFedUserStatisticsDao.AggUserStatistics> getAll(@Nullable @QueryParam(value="aggBy") String aggBy, @Context HttpServletRequest request) {
        ChronoUnit aggregationUnit;
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (aggBy == null) {
            aggBy = "MONTH";
        }
        return this.jFedUserStatisticsDAO.get(switch (aggBy.trim().toUpperCase(Locale.ROOT)) {
            case "WEEK", "WEEKS" -> {
                aggregationUnit = ChronoUnit.WEEKS;
                yield 90;
            }
            case "YEAR", "YEARS" -> {
                aggregationUnit = ChronoUnit.YEARS;
                yield 1461;
            }
            case "MONTH", "MONTHS" -> {
                aggregationUnit = ChronoUnit.MONTHS;
                yield 366;
            }
            default -> throw new BadRequestException("Invalid aggBy value \"" + aggBy + "\" (valid: WEEK, MONTH, YEAR)");
        }, aggregationUnit);
    }
}

