/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class ResourceCommon {
    static List<String> parseArg(String arg) {
        if (arg == null || arg.isEmpty()) {
            return Collections.emptyList();
        }
        if (arg.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] parts = arg.split(",");
        if (parts.length == 1 && parts[0].trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(parts);
    }

    static List<Integer> parseIntListArg(String arg) {
        if (arg == null || arg.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] parts = arg.split(",");
        if (parts.length == 1 && parts[0].trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> res = new ArrayList<Integer>(parts.length);
        for (String p : parts) {
            try {
                res.add(Integer.parseInt(p));
            }
            catch (NumberFormatException e) {
                throw new WebApplicationException("invalid integer in query parameter: \"" + p + "\"", Response.Status.BAD_REQUEST);
            }
        }
        return res;
    }

    public static boolean empty(List<?> l) {
        return l == null || l.isEmpty();
    }

    public static boolean parameterTruth(@NotNull String paramVal) {
        if (paramVal == null) {
            throw new NullPointerException("paramVal should not be null");
        }
        if (paramVal.trim().isEmpty()) {
            return true;
        }
        Boolean res = TextUtil.stringToBoolean(paramVal);
        if (res == null) {
            throw new RuntimeException("Invalid truth value \"" + paramVal + "\"");
        }
        return res;
    }

    public static Boolean parameterTruthOrNull(@Nullable String paramVal) {
        if (paramVal == null) {
            return null;
        }
        if (paramVal.trim().isEmpty()) {
            return true;
        }
        Boolean res = TextUtil.stringToBoolean(paramVal);
        if (res == null) {
            throw new RuntimeException("Invalid truth value \"" + paramVal + "\"");
        }
        return res;
    }
}

