/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Admin;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SearchUriGenerator;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.UriTool;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json"})
public class RootResource {
    private static final Logger LOG = LoggerFactory.getLogger(RootResource.class);
    @Context
    UriInfo uriInfo;
    private final FedmonWebApiServiceConfiguration configuration;

    public RootResource(FedmonWebApiServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    @GET
    @Timed
    public Root get(@Context HttpServletRequest request) {
        Set access = this.configuration.getAccess(request);
        GeniUrn authenticatedUser = request == null ? null : this.configuration.getAuthenticatedUserUrn(request);
        return new Root(this.uriInfo, this.configuration, access.stream().map(Enum::toString).collect(Collectors.toList()), request == null ? null : request.getRemoteAddr(), authenticatedUser == null ? null : authenticatedUser.toString());
    }

    @Path(value="robots.txt")
    @GET
    @Produces(value={"text/plain"})
    @Timed
    public String getRobotsTxt(@Context HttpServletRequest request) {
        return "User-agent: *\nDisallow: /\n";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    public static class Root {
        private final URI organisations;
        private final URI testbeds;
        private final URI federations;
        private final URI testbedsEmbed;
        private final URI testbedsXml;
        private final URI testDefinitions;
        private final URI testInstances;
        private final URI testInstanceStatistics;
        private final URI results;
        private final URI frequencies;
        private final URI tasks;
        private final URI activeTasks;
        private final URI admin;
        private final URI serverGlimpses;
        private final URI guiConfig;
        private final URI guiConfigExample;
        private final URI self;
        private final List<String> callerAccess;
        private final String callerIp;
        private final String callerUserUrn;

        public Root(@Nonnull UriInfo uriInfo, @Nonnull FedmonWebApiServiceConfiguration configuration, @Nonnull List<String> callerAccess, @Nullable String callerIp, @Nullable String callerUserUrn) {
            UriTool uriTool = configuration.getUriTool();
            this.organisations = uriTool.getUriUsingFedmonObject(Organisation.class, null);
            this.testbeds = uriTool.getUriUsingFedmonObject(Testbed.class, null);
            this.federations = uriTool.getUriUsingFedmonObject(Federation.class, null);
            this.testbedsEmbed = SearchUriGenerator.getTestbedEmbedUri(uriTool);
            this.testDefinitions = uriTool.getUriUsingFedmonObject(TestDefinition.class, null);
            this.testInstances = uriTool.getUriUsingFedmonObject(TestInstance.class, null);
            this.testInstanceStatistics = uriTool.getUriUsingFedmonObject(TestInstanceStatistics.class, null);
            this.results = SearchUriGenerator.getResultSearchUri(true, null, null, uriTool);
            this.tasks = SearchUriGenerator.getTaskSearchUri(false, false, 100, uriTool);
            this.activeTasks = SearchUriGenerator.getTaskSearchUri(true, false, null, uriTool);
            this.admin = uriTool.getUriUsingFedmonObject(Admin.class, null);
            this.serverGlimpses = uriTool.getUriUsingFedmonObject(ServerGlimpse.class, null);
            this.frequencies = uriTool.getUriUsingFedmonObject(Frequency.class, null);
            this.guiConfigExample = SearchUriGenerator.getGuiConfigUri(uriTool);
            this.callerAccess = callerAccess;
            this.callerIp = callerIp;
            this.callerUserUrn = callerUserUrn;
            String baseUrl = uriTool.getBaseUrlString();
            assert (baseUrl != null);
            assert (baseUrl.endsWith("/"));
            try {
                this.testbedsXml = new URI(baseUrl + "testbeds.xml");
                this.self = new URI(baseUrl);
                this.guiConfig = new URI(baseUrl + "guiconfig");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to initialise using baseUrl=\"" + baseUrl + "\"", e);
            }
        }

        @JsonCreator
        public Root(@JsonProperty(value="organisations") URI organisations, @JsonProperty(value="testbeds") URI testbeds, @JsonProperty(value="federations") URI federations, @JsonProperty(value="testbedsEmbed") URI testbedsEmbed, @JsonProperty(value="testbedsXml") URI testbedsXml, @JsonProperty(value="testDefinitions") URI testDefinitions, @JsonProperty(value="testInstances") URI testInstances, @JsonProperty(value="testInstanceStatistics") URI testInstanceStatistics, @JsonProperty(value="results") URI results, @JsonProperty(value="frequencies") URI frequencies, @JsonProperty(value="tasks") URI tasks, @JsonProperty(value="activeTasks") URI activeTasks, @JsonProperty(value="admin") URI admin, @JsonProperty(value="serverGlimpses") URI serverGlimpses, @JsonProperty(value="guiConfig") URI guiConfig, @JsonProperty(value="guiConfigExample") URI guiConfigExample, @JsonProperty(value="caller") Caller caller, @JsonProperty(value="@id") URI self) {
            this.organisations = organisations;
            this.testbeds = testbeds;
            this.federations = federations;
            this.testbedsEmbed = testbedsEmbed;
            this.testbedsXml = testbedsXml;
            this.testDefinitions = testDefinitions;
            this.testInstances = testInstances;
            this.testInstanceStatistics = testInstanceStatistics;
            this.results = results;
            this.frequencies = frequencies;
            this.tasks = tasks;
            this.activeTasks = activeTasks;
            this.admin = admin;
            this.serverGlimpses = serverGlimpses;
            this.guiConfig = guiConfig;
            this.guiConfigExample = guiConfigExample;
            this.self = self;
            this.callerAccess = caller == null ? null : caller.getAccess();
            this.callerIp = caller == null ? null : caller.getIp();
            this.callerUserUrn = caller == null ? null : caller.getUrn();
        }

        @JsonProperty
        public URI getOrganisations() {
            return this.organisations;
        }

        @JsonProperty
        public URI getTestbeds() {
            return this.testbeds;
        }

        @JsonProperty
        public URI getTestbedsXml() {
            return this.testbedsXml;
        }

        @JsonProperty
        public URI getTestbedsEmbed() {
            return this.testbedsEmbed;
        }

        @JsonProperty
        public URI getFederations() {
            return this.federations;
        }

        @JsonProperty
        public URI getTestDefinitions() {
            return this.testDefinitions;
        }

        @JsonProperty
        public URI getTestInstances() {
            return this.testInstances;
        }

        @JsonProperty
        public URI getTestInstanceStatistics() {
            return this.testInstanceStatistics;
        }

        @JsonProperty
        public URI getResults() {
            return this.results;
        }

        @JsonProperty
        public URI getTasks() {
            return this.tasks;
        }

        @JsonProperty
        public URI getActiveTasks() {
            return this.activeTasks;
        }

        @JsonProperty
        public URI getAdmin() {
            return this.admin;
        }

        @JsonProperty
        public URI getFrequencies() {
            return this.frequencies;
        }

        @JsonProperty
        public URI getServerGlimpses() {
            return this.serverGlimpses;
        }

        @JsonProperty
        public URI getGuiConfig() {
            return this.guiConfig;
        }

        @JsonProperty
        public URI getGuiConfigExample() {
            return this.guiConfigExample;
        }

        @JsonIgnore
        public List<String> getCallerAccess() {
            return this.callerAccess;
        }

        @JsonIgnore
        public String getCallerIp() {
            return this.callerIp;
        }

        @JsonIgnore
        public String getCallerUserUrn() {
            return this.callerUserUrn;
        }

        @Nonnull
        @JsonProperty(value="caller")
        public Caller getCaller() {
            return new Caller(this.callerIp, this.callerUserUrn, this.callerAccess);
        }

        @JsonProperty(value="@id")
        public URI getSelf() {
            return this.self;
        }

        public String toString() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting Admin Info to JSON", e);
                return "Exception converting Admin Info to JSON: " + e.getMessage();
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    private static class Caller {
        private final String ip;
        private final String urn;
        private final List<String> access;

        public Caller(@JsonProperty(value="ip") String ip, @JsonProperty(value="urn") String urn, @JsonProperty(value="access") List<String> access) {
            this.ip = ip;
            this.urn = urn;
            this.access = access;
        }

        @JsonProperty
        public String getIp() {
            return this.ip;
        }

        @JsonProperty(value="urn")
        public String getUrn() {
            return this.urn;
        }

        @JsonProperty
        public List<String> getAccess() {
            return this.access;
        }
    }
}

