/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServerGlimpseDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse_v1;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SharedResourceCache;
import com.codahale.metrics.annotation.Timed;
import java.util.List;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/serverglimpse")
@Produces(value={"application/json"})
@Singleton
public class ServerGlimpseResource {
    private static final Logger LOG = LoggerFactory.getLogger(ServerGlimpseResource.class);
    @Context
    UriInfo uriInfo;
    private final ServerGlimpseDao serverGlimpseDao;
    private final FedmonWebApiServiceConfiguration configuration;
    private final SharedResourceCache sharedResourceCache;

    public ServerGlimpseResource(ServerGlimpseDao serverGlimpseDao, FedmonWebApiServiceConfiguration configuration, SharedResourceCache sharedResourceCache) {
        this.serverGlimpseDao = serverGlimpseDao;
        this.configuration = configuration;
        this.sharedResourceCache = sharedResourceCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{serverId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public ServerGlimpse upsert(@NotNull @PathParam(value="serverId") Integer serverId, ServerGlimpse serverGlimpse, @Context HttpServletRequest request) {
        boolean requireAdminPermission;
        boolean requireCreateTaskPermission = serverGlimpse.getAdvertisementInfo() != null || serverGlimpse.getHealthInfo() != null;
        boolean bl = requireAdminPermission = serverGlimpse.getReputation() != null || serverGlimpse.getMaintenance() != null;
        if (requireCreateTaskPermission) {
            this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, request);
        }
        if (requireAdminPermission) {
            this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        }
        if (serverGlimpse.getServerId() == null || !serverGlimpse.getServerId().equals(serverId)) {
            LOG.info("ServerGlimpse.upsert error: serverId of provided ServerGlimpse ({}) differs with ID in request URL path ({})", (Object)serverGlimpse.getServerId(), (Object)serverId);
            throw new WebApplicationException("serverId of provided ServerGlimpse differs with ID in request URL path", Response.Status.BAD_REQUEST);
        }
        this.serverGlimpseDao.upsert(serverGlimpse, serverGlimpse.getAdvertisementInfo() != null, serverGlimpse.getHealthInfo() != null, serverGlimpse.getReputation() != null, serverGlimpse.getMaintenance() != null);
        SharedResourceCache.SingleResourceCache<Integer, ServerGlimpse> singleResourceCache = this.sharedResourceCache.getServerGlimpseCache();
        synchronized (singleResourceCache) {
            this.sharedResourceCache.getServerGlimpseCache().invalidateOnlySingle(serverGlimpse.getServerId());
            return this.getV2(serverGlimpse.getServerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{serverId}/maintenance")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Response addMaintenance(@NotNull @PathParam(value="serverId") Integer serverId, MaintenanceInfo maintenanceInfo, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (maintenanceInfo == null) {
            throw new WebApplicationException("no maintenanceInfo provided", Response.Status.BAD_REQUEST);
        }
        if (maintenanceInfo.getStart() == null) {
            throw new WebApplicationException("maintenanceInfo.start is mandatory", Response.Status.BAD_REQUEST);
        }
        if (maintenanceInfo.getEnd() == null) {
            throw new WebApplicationException("maintenanceInfo.end is mandatory", Response.Status.BAD_REQUEST);
        }
        this.serverGlimpseDao.addMaintenance(serverId, maintenanceInfo);
        SharedResourceCache.SingleResourceCache<Integer, ServerGlimpse> singleResourceCache = this.sharedResourceCache.getServerGlimpseCache();
        synchronized (singleResourceCache) {
            this.sharedResourceCache.getServerGlimpseCache().invalidateOnlySingle(serverId);
            return Response.created(this.configuration.getUriTool().getUriUsingFedmonObject(ServerGlimpse.class, serverId)).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{serverId}/maintenance")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Response replaceMaintenances(@NotNull @PathParam(value="serverId") Integer serverId, List<MaintenanceInfo> maintenanceInfos, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (maintenanceInfos == null) {
            throw new WebApplicationException("no maintenanceInfo provided", Response.Status.BAD_REQUEST);
        }
        for (MaintenanceInfo maintenanceInfo : maintenanceInfos) {
            if (maintenanceInfo.getStart() == null) {
                throw new WebApplicationException("maintenanceInfo.start is mandatory", Response.Status.BAD_REQUEST);
            }
            if (maintenanceInfo.getEnd() != null) continue;
            throw new WebApplicationException("maintenanceInfo.end is mandatory", Response.Status.BAD_REQUEST);
        }
        this.serverGlimpseDao.replaceMaintenances(serverId, maintenanceInfos);
        SharedResourceCache.SingleResourceCache<Integer, ServerGlimpse> singleResourceCache = this.sharedResourceCache.getServerGlimpseCache();
        synchronized (singleResourceCache) {
            this.sharedResourceCache.getServerGlimpseCache().invalidateOnlySingle(serverId);
            return Response.noContent().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    public List<ServerGlimpse> getAll() {
        return this.sharedResourceCache.getServerGlimpseCache().getAll();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{serverId}")
    @Timed
    public Object getAutoVersion(@NotNull @PathParam(value="serverId") Integer serverId, @HeaderParam(value="User-Agent") String userAgent) {
        if (userAgent == null || userAgent.trim().isEmpty()) {
            return this.getV1(serverId);
        }
        return this.getV2(serverId);
    }

    public ServerGlimpse_v1 getV1(@NotNull Integer serverId) {
        return ServerGlimpse_v1.create(this.getV2(serverId));
    }

    public ServerGlimpse getV2(@NotNull Integer serverId) {
        return this.sharedResourceCache.getServerGlimpseCache().getById(serverId);
    }

    @DELETE
    @Path(value="{serverId}")
    @Timed
    public void delete(@NotNull @PathParam(value="serverId") Integer serverId, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        SharedResourceCache.SingleResourceCache<Integer, ServerGlimpse> singleResourceCache = this.sharedResourceCache.getServerGlimpseCache();
        synchronized (singleResourceCache) {
            this.sharedResourceCache.getServerGlimpseCache().invalidateAllAndSingle(serverId);
            throw new WebApplicationException("not yet implemented", Response.Status.NOT_IMPLEMENTED);
        }
    }
}

