/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServerDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServiceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SharedResourceCache;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.codahale.metrics.annotation.Timed;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/server")
@Produces(value={"application/json"})
public class ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ServerResource.class);
    @Context
    UriInfo uriInfo;
    private final ServerDao serverDao;
    private final ServiceDao serviceDao;
    private final FedmonWebApiServiceConfiguration configuration;
    private final SharedResourceCache sharedResourceCache;

    public ServerResource(ServerDao serverDao, ServiceDao serviceDao, FedmonWebApiServiceConfiguration configuration, SharedResourceCache sharedResourceCache) {
        this.serverDao = serverDao;
        this.serviceDao = serviceDao;
        this.configuration = configuration;
        this.sharedResourceCache = sharedResourceCache;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Timed
    public Server get(@NotNull @PathParam(value="id") Integer id) {
        Server res = this.serverDao.findWithServicesById(id);
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        ServerBuilder serverBuilder = new ServerBuilder(res);
        this.configuration.getUriTool().setUriRecursive(serverBuilder);
        return serverBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Server update(@NotNull @PathParam(value="id") Integer id, Server server, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (server.getId() == null || !((Integer)server.getId()).equals(id)) {
            throw new WebApplicationException("ID of provided Server differs with ID in request URL path", Response.Status.BAD_REQUEST);
        }
        if (server.getTestbedId() == null) {
            throw new WebApplicationException("Server must have testbedID for PUT (= update) call", Response.Status.BAD_REQUEST);
        }
        if (server.getServices() != null && !server.getServices().isEmpty()) {
            throw new WebApplicationException("Server must not have Services for PUT (= update) call. Edit, add and delete Services directly.", Response.Status.BAD_REQUEST);
        }
        this.serverDao.update(server);
        this.sharedResourceCache.invalidateFull();
        return this.get(id);
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull @PathParam(value="id") Integer id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        throw new WebApplicationException("not yet implemented", Response.Status.NOT_IMPLEMENTED);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Server insert(@NotNull Server server, @Context HttpServletRequest request) {
        LOG.debug("Received server to add: " + server.toStringWithoutMinimize());
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (server.getTestbedId() == null) {
            throw new WebApplicationException("Server must have testbedID for POST (= create/insert) call", Response.Status.BAD_REQUEST);
        }
        if (server.getServices() != null && !server.getServices().isEmpty()) {
            for (Service service : server.getServices()) {
                if (service.getId() != null || service.getUri() != null) {
                    throw new WebApplicationException("For POST (= create/insert) call, Server must not have Services with an id or @id. These IDs will instead be generated automatically.", Response.Status.BAD_REQUEST);
                }
                if (service.getServer() != null || service.getServerId() != null) {
                    throw new WebApplicationException("For POST (= create/insert) call, Server must not have Services with a Server reference.", Response.Status.BAD_REQUEST);
                }
                if (service.getApi() == null || service.getApiVersion() == null) {
                    throw new WebApplicationException("For POST (= create/insert) Server call, any Services must have API and version specified.", Response.Status.BAD_REQUEST);
                }
                if (service.getUrn() != null && service.getUrl() != null) continue;
                throw new WebApplicationException("For POST (= create/insert) Server call, any Services must have URL and URN specified.", Response.Status.BAD_REQUEST);
            }
        }
        Integer newId = this.serverDao.insert(server);
        ServerBuilder res = (ServerBuilder)new ServerBuilder(server).setId(newId);
        if (server.getServices() != null) {
            res.setServices(null);
            res.setServiceBuilders(null);
            for (Service service : server.getServices()) {
                ServiceBuilder serviceBuilder = new ServiceBuilder(service);
                serviceBuilder.setServerId(newId);
                Integer serviceId = this.serviceDao.insert(serviceBuilder.create());
                serviceBuilder.setId(serviceId);
                res.addService(serviceBuilder.create());
            }
        }
        this.sharedResourceCache.invalidateFull();
        this.configuration.getUriTool().setUriRecursive(res);
        Server finalRes = res.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
        LOG.debug("Replying with inserted server: " + finalRes.toStringWithoutMinimize());
        return finalRes;
    }
}

