/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TaskDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.UserDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserBuilder;
import com.codahale.metrics.annotation.Timed;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/user")
@Produces(value={"application/json"})
public class UserResource {
    private static final Logger LOG = LoggerFactory.getLogger(UserResource.class);
    @Context
    UriInfo uriInfo;
    private final UserDao userDAO;
    private final TaskDao taskDAO;
    private final FedmonWebApiServiceConfiguration configuration;

    public UserResource(UserDao userDAO, TaskDao taskDAO, FedmonWebApiServiceConfiguration configuration) {
        this.userDAO = userDAO;
        this.taskDAO = taskDAO;
        this.configuration = configuration;
    }

    @GET
    @Timed
    public List<User> all(@Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, request);
        List<User> resBase = this.userDAO.findAll();
        if (resBase == null) {
            return null;
        }
        ArrayList<User> res = new ArrayList<User>();
        for (User base : resBase) {
            UriBuilder ub = this.uriInfo.getAbsolutePathBuilder();
            assert (ub != null);
            URI uri = ub.path((String)base.getId()).build(new Object[0]);
            assert (uri != null);
            UserBuilder userBuilder = new UserBuilder(base);
            userBuilder.setUri(uri);
            res.add(userBuilder.create());
        }
        return res;
    }

    @GET
    @Path(value="{id}")
    @Timed
    public User get(@NotNull @PathParam(value="id") String id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, request);
        User res = this.userDAO.findById(id);
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        UserBuilder userBuilder = new UserBuilder(res);
        userBuilder.setUri(this.uriInfo.getAbsolutePathBuilder().build(new Object[0]));
        return userBuilder.create();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public User update(@NotNull @PathParam(value="id") String id, User user, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (id == null) {
            throw new BadRequestException("Path ID cannot be null");
        }
        if (user.getId() == null) {
            throw new BadRequestException("Provided User ID may not be null");
        }
        if (!id.equals(user.getId())) {
            throw new BadRequestException("Path ID (" + id + ") does not match ID of provided User (" + (String)user.getId() + ")");
        }
        if (user.getAuthorityUrn() == null) {
            throw new BadRequestException("You need to specify authorityUrn");
        }
        if (user.getUsername() == null) {
            throw new BadRequestException("You need to specify username");
        }
        if (user.getPrivateKeyAndCertPem() == null) {
            throw new BadRequestException("You need to specify privateKeyAndCertPem");
        }
        this.userDAO.update(user);
        if (Objects.equals(user.getSelfTestFailed(), Boolean.TRUE)) {
            LOG.info("User had self test failed set to TRUE. Will cancel all currently running tests for the user.");
            this.taskDAO.forceCancellingStateForUser((String)user.getId(), Clock.nowTimestamp());
        }
        return this.get(id, request);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public User insert(@NotNull User user, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (user.getId() == null) {
            throw new BadRequestException("You need to specify an ID for the testdefinition (a unique String)");
        }
        if (user.getAuthorityUrn() == null) {
            throw new BadRequestException("You need to specify authorityUrn");
        }
        if (user.getUsername() == null) {
            throw new BadRequestException("You need to specify username");
        }
        if (user.getPrivateKeyAndCertPem() == null) {
            throw new BadRequestException("You need to specify privateKeyAndCertPem");
        }
        this.userDAO.insert(user);
        UserBuilder res = new UserBuilder(user);
        this.configuration.getUriTool().setUriRecursive(res);
        return res.create();
    }
}

