/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.git;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface GitAuthPreferences {
    @Nonnull
    public static Set<GitAuthMethod> getRepoUrlGitAuthMethod(@Nonnull String repoUrl) {
        if (repoUrl.startsWith("https://")) {
            return EnumSet.of(GitAuthMethod.USER_PASS, GitAuthMethod.OAUTH);
        }
        if (repoUrl.startsWith("git@") || repoUrl.contains("@") && repoUrl.endsWith(".git")) {
            return Collections.singleton(GitAuthMethod.SSH);
        }
        throw new IllegalArgumentException("Unsupported repo url '" + repoUrl + "'");
    }

    public static boolean urlMatchesAuth(@Nullable GitAuth gitAuth, @Nullable String url) {
        if (gitAuth == null || url == null) {
            return false;
        }
        return GitAuthPreferences.urlMatchesAuth(gitAuth.getMethod(), url);
    }

    public static boolean urlMatchesAuth(@Nullable GitAuthMethod gitAuthMethod, @Nullable String url) {
        if (gitAuthMethod == null || url == null) {
            return false;
        }
        Set<GitAuthMethod> urlMethods = GitAuthPreferences.getRepoUrlGitAuthMethod(url);
        return urlMethods.contains((Object)gitAuthMethod);
    }

    @Nonnull
    public List<GitAuthMethod> getGitAuthMethodAvailable(String var1);

    public boolean hasAuth(String var1);

    @Nullable
    public GitAuth getGitAuth(String var1, GitAuthMethod ... var2);

    @Nullable
    public GitAuthSsh getGitAuthSsh(String var1);

    @Nullable
    public GitAuthUserPass getGitAuthUserPass(String var1);

    public static enum GitAuthMethod {
        SSH,
        USER_PASS,
        OAUTH;

    }

    public static interface GitAuth {
        @Nonnull
        public GitAuthMethod getMethod();

        @Nonnull
        public String getRepoUrl();
    }

    public static class GitAuthUserPass
    extends AbstractGitAuth {
        @Nonnull
        private final String username;
        @Nullable
        private final String password;

        public GitAuthUserPass(@Nonnull String repoUrl, @Nonnull String username, @Nullable String password) {
            super(GitAuthMethod.USER_PASS, repoUrl);
            this.username = username;
            this.password = password;
        }

        @Nonnull
        public String getUsername() {
            return this.username;
        }

        @Nullable
        public String getPassword() {
            return this.password;
        }
    }

    public static class GitAuthSsh
    extends AbstractGitAuth {
        @Nonnull
        private final String privateKey;

        public GitAuthSsh(@Nonnull String repoUrl, @Nonnull String privateKey) {
            super(GitAuthMethod.SSH, repoUrl);
            this.privateKey = privateKey;
        }

        @Nonnull
        public String getPrivateKey() {
            return this.privateKey;
        }
    }

    public static abstract class AbstractGitAuth
    implements GitAuth {
        @Nonnull
        private final GitAuthMethod method;
        @Nonnull
        private final String repoUrl;

        public AbstractGitAuth(@Nonnull GitAuthMethod method, @Nonnull String repoUrl) {
            this.method = method;
            this.repoUrl = repoUrl;
        }

        @Override
        @Nonnull
        public GitAuthMethod getMethod() {
            return this.method;
        }

        @Override
        @Nonnull
        public String getRepoUrl() {
            return this.repoUrl;
        }
    }
}

