/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.git;

import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.git.GitFetcherCommand;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.google.common.base.Charsets;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.SubmoduleConfig;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(GitFetcher.class);
    @Nullable
    private final GitAuthPreferences fallbackGitAuthPreferences;

    public GitFetcher(@Nullable GitAuthPreferences fallbackGitAuthPreferences) {
        this.fallbackGitAuthPreferences = fallbackGitAuthPreferences;
    }

    public File fetch(GitFetcherCommand gitFetcherCommand) {
        String subDir = gitFetcherCommand.getRepoSubDir();
        String gitUrl = gitFetcherCommand.getGitUrl();
        String branch = gitFetcherCommand.getBranch() != null ? gitFetcherCommand.getBranch() : "master";
        File rootGitDir = gitFetcherCommand.getTargetDir();
        assert (rootGitDir != null);
        File resDir = subDir != null && !subDir.trim().equals("/") ? new File(rootGitDir, subDir) : rootGitDir;
        UsernamePasswordCredentialsProvider gitCredsProvider = null;
        TransportConfigCallback transportConfigCallback = null;
        GitAuthPreferences.GitAuth gitAuthForRepo = gitFetcherCommand.getGitAuth();
        if (!GitAuthPreferences.urlMatchesAuth(gitAuthForRepo, gitUrl)) {
            gitAuthForRepo = null;
        }
        if (gitAuthForRepo == null && this.fallbackGitAuthPreferences != null) {
            gitAuthForRepo = this.fallbackGitAuthPreferences.getGitAuth(gitUrl, GitAuthPreferences.GitAuthMethod.SSH, GitAuthPreferences.GitAuthMethod.USER_PASS);
        }
        if (!GitAuthPreferences.urlMatchesAuth(gitAuthForRepo, gitUrl)) {
            gitAuthForRepo = null;
        }
        if (gitAuthForRepo != null) {
            if (gitAuthForRepo.getMethod() == GitAuthPreferences.GitAuthMethod.SSH) {
                LOG.debug("Configuring git SSH authentication");
                final GitAuthPreferences.GitAuthSsh gitAuthSsh = (GitAuthPreferences.GitAuthSsh)gitAuthForRepo;
                final JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

                    @Override
                    protected JSch createDefaultJSch(FS fs) throws JSchException {
                        byte[] pubkey;
                        JSch jSch = super.createDefaultJSch(fs);
                        byte[] privkey = gitAuthSsh.getPrivateKey().getBytes(Charsets.UTF_8);
                        try {
                            String pubkeyString = KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat(KeyUtil.rsaPrivateKeyToRsaPublicKey(KeyUtil.pemToRsaPrivateKey(gitAuthSsh.getPrivateKey(), null)));
                            pubkey = pubkeyString == null ? null : pubkeyString.getBytes(Charsets.UTF_8);
                        }
                        catch (KeyUtil.PEMDecodingException e) {
                            throw new RuntimeException("Error getting public key from private key", e);
                        }
                        byte[] pass = new byte[]{};
                        jSch.addIdentity("jFed user private SSH key", privkey, pubkey, pass);
                        return jSch;
                    }

                    @Override
                    protected void configure(OpenSshConfig.Host host, Session session) {
                        session.setConfig("StrictHostKeyChecking", "no");
                    }
                };
                transportConfigCallback = new TransportConfigCallback(){

                    @Override
                    public void configure(Transport transport) {
                        SshTransport sshTransport = (SshTransport)transport;
                        sshTransport.setSshSessionFactory(sshSessionFactory);
                    }
                };
            }
            if (gitAuthForRepo.getMethod() == GitAuthPreferences.GitAuthMethod.USER_PASS) {
                LOG.debug("Configuring git username/password authentication");
                assert (gitAuthForRepo instanceof GitAuthPreferences.GitAuthUserPass);
                GitAuthPreferences.GitAuthUserPass gitAuthUserPass = (GitAuthPreferences.GitAuthUserPass)gitAuthForRepo;
                gitCredsProvider = new UsernamePasswordCredentialsProvider(gitAuthUserPass.getUsername(), gitAuthUserPass.getPassword());
            }
        } else {
            LOG.debug("Not configuring git authentication");
        }
        try {
            Ref ref2;
            Git git = Git.init().setDirectory(rootGitDir).call();
            RemoteAddCommand remoteAddCommand = git.remoteAdd();
            remoteAddCommand.setName("origin");
            remoteAddCommand.setUri(new URIish(gitUrl));
            remoteAddCommand.call();
            FetchCommand fetchCommand = git.fetch();
            fetchCommand.setRemote("origin");
            if (gitCredsProvider != null) {
                fetchCommand.setCredentialsProvider(gitCredsProvider);
            }
            if (transportConfigCallback != null) {
                fetchCommand.setTransportConfigCallback(transportConfigCallback);
            }
            fetchCommand.setRecurseSubmodules(SubmoduleConfig.FetchRecurseSubmodulesMode.YES);
            FetchResult fetchResult = fetchCommand.call();
            Object banchRefs = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            banchRefs.forEach(ref -> LOG.debug("Got branch ref {}", ref));
            Object tagRefs = git.tagList().call();
            tagRefs.forEach(ref -> LOG.debug("Got tag ref {}", ref));
            Ref foundRef = null;
            Iterator iterator = banchRefs.iterator();
            while (iterator.hasNext()) {
                ref2 = (Ref)iterator.next();
                if (!ref2.getName().endsWith("/" + branch)) continue;
                foundRef = ref2;
            }
            iterator = tagRefs.iterator();
            while (iterator.hasNext()) {
                ref2 = (Ref)iterator.next();
                if (!ref2.getName().endsWith("/" + branch)) continue;
                foundRef = ref2;
            }
            CheckoutCommand checkoutCommand = git.checkout();
            if (foundRef != null) {
                LOG.warn("Using foundRef=" + foundRef.getName());
                checkoutCommand.setName(foundRef.getName());
            } else {
                LOG.warn("Did not find a matching git ref. Will try it as branch, which will probably fail.");
                checkoutCommand.setName("refs/remotes/origin/" + branch);
            }
            checkoutCommand.call();
        }
        catch (GitAPIException e) {
            LOG.error("Error fetching Git repo: " + e.getMessage(), e);
            throw new RuntimeException("Exception fetching git repo:" + e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            LOG.error("Invalid git repo: " + e.getMessage(), e);
            throw new RuntimeException("Invalid git repo:" + e.getMessage(), e);
        }
        return resDir;
    }

    @Nonnull
    private static String assureStartsAndEndWithSlash(@Nonnull String origPath) {
        Object res = origPath;
        if (!((String)res).startsWith("/")) {
            res = "/" + (String)res;
        }
        if (!((String)res).endsWith("/")) {
            res = (String)res + "/";
        }
        return res;
    }
}

