/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.git;

import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SingleSshGitAuthPreferences
implements GitAuthPreferences {
    @Nonnull
    private final String privateSshPemKey;

    public SingleSshGitAuthPreferences(@Nonnull String privateSshPemKey) {
        this.privateSshPemKey = privateSshPemKey;
    }

    public SingleSshGitAuthPreferences(@Nonnull PrivateKey privateSshKey) {
        this.privateSshPemKey = new String(KeyUtil.privateKeyToAnyPem(privateSshKey));
    }

    @Override
    @Nonnull
    public List<GitAuthPreferences.GitAuthMethod> getGitAuthMethodAvailable(String repoUrl) {
        return Collections.singletonList(GitAuthPreferences.GitAuthMethod.SSH);
    }

    @Override
    public boolean hasAuth(String repoUrl) {
        return GitAuthPreferences.getRepoUrlGitAuthMethod(repoUrl).contains((Object)GitAuthPreferences.GitAuthMethod.SSH);
    }

    @Override
    @Nullable
    public GitAuthPreferences.GitAuth getGitAuth(String repoUrl, GitAuthPreferences.GitAuthMethod ... allowedMethods) {
        for (GitAuthPreferences.GitAuthMethod allowedMethod : allowedMethods) {
            if (allowedMethod != GitAuthPreferences.GitAuthMethod.SSH) continue;
            return this.getGitAuthSsh(repoUrl);
        }
        return null;
    }

    @Override
    @Nullable
    public GitAuthPreferences.GitAuthSsh getGitAuthSsh(String repoUrl) {
        return new GitAuthPreferences.GitAuthSsh(repoUrl, this.privateSshPemKey);
    }

    @Override
    @Nullable
    public GitAuthPreferences.GitAuthUserPass getGitAuthUserPass(String repoUrl) {
        return null;
    }
}

