/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.log;

import be.iminds.ilabt.jfed.log.ApiCallIdGenerator;
import be.iminds.ilabt.jfed.lowlevel.connection.ApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.XmlRpcPrintUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCallDetails {
    private static final Logger LOG = LoggerFactory.getLogger(ApiCallDetails.class);
    private final int id;
    @Nullable
    private final Integer serviceId;
    @Nullable
    private final Integer serverId;
    @Nullable
    private final String serverName;
    @Nullable
    private final String serverUrn;
    @Nullable
    private final String testbedId;
    private final String serverUrl;
    private final ConnectionConfig connectionConfig;
    private final String connectionId;
    private final String httpRequestStatusLine;
    private final String httpRequestHeaders;
    private final String httpRequest;
    private final String httpResponseStatusLine;
    private final String httpResponseHeaders;
    private final String httpResponse;
    private final List xmlRpcRequest;
    private final Object xmlRpcResponse;
    private final String apiName;
    private final String javaMethodName;
    private final String geniMethodName;
    private final Map<String, Object> methodParameters;
    private final Date startTime;
    private final Date stopTime;
    private final Throwable exception;
    private ApiCallReply reply;

    public ApiCallDetails(@Nullable Integer serviceId, @Nullable Integer serverId, @Nullable String serverName, @Nullable String serverUrn, @Nullable String testbedId, ConnectionConfig connectionConfig, String serverUrl, String connectionId, String apiName, String javaMethodName, String geniMethodName, ApiCallReply reply, String httpRequestStatusLine, String httpRequestHeaders, String httpRequest, String httpResponseStatusLine, String httpResponseHeaders, String httpResponse, Vector xmlRpcRequest, Object xmlRpcReply, Map<String, Object> methodParameters, Date startTime, Date stopTime, Throwable exception) {
        this(serviceId, serverId, serverName, serverUrn, testbedId, connectionConfig, serverUrl, connectionId, apiName, javaMethodName, geniMethodName, reply, httpRequestStatusLine, httpRequestHeaders, httpRequest, httpResponseStatusLine, httpResponseHeaders, httpResponse, xmlRpcRequest != null ? new ArrayList(xmlRpcRequest) : null, xmlRpcReply, methodParameters, startTime, stopTime, exception);
    }

    public ApiCallDetails(@Nullable Integer serviceId, @Nullable Integer serverId, @Nullable String serverName, @Nullable String serverUrn, @Nullable String testbedId, ConnectionConfig connectionConfig, String serverUrl, String connectionId, String apiName, String javaMethodName, String geniMethodName, ApiCallReply reply, String httpRequestStatusLine, String httpRequestHeaders, String httpRequest, String httpResponseStatusLine, String httpResponseHeaders, String httpResponse, List xmlRpcRequest, Object xmlRpcReply, Map<String, Object> methodParameters, Date startTime, Date stopTime, Throwable exception) {
        assert (connectionConfig != null);
        this.id = ApiCallIdGenerator.getNextId();
        this.connectionConfig = connectionConfig;
        this.serverUrl = serverUrl;
        this.connectionId = connectionId;
        this.serviceId = serviceId;
        this.serverId = serverId;
        this.serverName = serverName;
        this.serverUrn = serverUrn;
        this.testbedId = testbedId;
        this.apiName = apiName;
        this.javaMethodName = javaMethodName;
        this.geniMethodName = geniMethodName;
        this.reply = reply;
        this.httpRequestStatusLine = httpRequestStatusLine;
        this.httpRequestHeaders = httpRequestHeaders;
        this.httpRequest = httpRequest;
        this.httpResponseStatusLine = httpResponseStatusLine;
        this.httpResponseHeaders = httpResponseHeaders;
        this.httpResponse = httpResponse;
        this.xmlRpcRequest = xmlRpcRequest;
        this.xmlRpcResponse = xmlRpcReply;
        this.methodParameters = methodParameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(methodParameters);
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.exception = exception;
    }

    public int getId() {
        return this.id;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    @Nullable
    public Integer getServiceId() {
        return this.serviceId;
    }

    @Nullable
    public Integer getServerId() {
        return this.serverId;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    @Nullable
    public String getServerUrnString() {
        return this.serverUrn;
    }

    @Nullable
    public String getTestbedId() {
        return this.testbedId;
    }

    @Nullable
    public String getServerComponentManagerUrnString() {
        return this.serverUrn;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public String getApiName() {
        return this.apiName;
    }

    public Object getXmlRpcRequest() {
        return this.xmlRpcRequest;
    }

    public Object getXmlRpcResponse() {
        return this.xmlRpcResponse;
    }

    public Map<String, Object> getMethodParameters() {
        return this.methodParameters;
    }

    public String getJavaMethodName() {
        return this.javaMethodName;
    }

    public String getGeniMethodName() {
        return this.geniMethodName;
    }

    @Nullable
    public ApiCallReply getReply() {
        return this.reply;
    }

    public String getHttpRequestStatusLine() {
        return this.httpRequestStatusLine;
    }

    public String getHttpRequestHeaders() {
        return this.httpRequestHeaders;
    }

    public String getHttpRequest() {
        return this.httpRequest;
    }

    public String getHttpResponseStatusLine() {
        return this.httpResponseStatusLine;
    }

    public String getHttpResponseHeaders() {
        return this.httpResponseHeaders;
    }

    public String getHttpResponse() {
        return this.httpResponse;
    }

    public String toString() {
        String responseCode = "no reply";
        if (this.reply != null && this.reply.getGeniResponseCode() != null) {
            responseCode = this.reply.getGeniResponseCode().toString();
        }
        return "Result{\nserverUrl='" + this.serverUrl + "'\n, proxyInfo='" + this.connectionConfig.getProxyInfo() + "'\n, connectionBasicHttpAuthUsername='" + (this.connectionConfig.getLogin() == null || this.connectionConfig.getLogin().getUsername() == null ? "null" : this.connectionConfig.getLogin().getUsername()) + "'\n, connectionSslAuthUser='" + (this.connectionConfig.getDebugInfo() == null || this.connectionConfig.getDebugInfo().getGeniUserUrnString() == null ? "null" : this.connectionConfig.getDebugInfo().getGeniUserUrnString()) + "'\n" + (String)(this.exception == null ? "" : ", exception='" + this.exception.getMessage() + " -> Stacktrace:\n" + IOUtils.exceptionToStacktraceString(this.exception) + "'\n") + ", apiName='" + this.apiName + "'\n, javaMethodName='" + this.javaMethodName + "'\n, geniMethodName='" + this.geniMethodName + "'\n, reply.getGeniResponseCode()=" + responseCode + "\n, httpRequest='" + this.httpRequest + "'\n, httpResponseStatusLine='" + this.httpResponseStatusLine + "'\n, httpResponse='" + this.httpResponse + "'\n}";
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getStopTime() {
        return this.stopTime;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getXmlRpcRequestJsonString() {
        return XmlRpcPrintUtil.xmlRpcObjectToString(this.xmlRpcRequest);
    }

    public String getXmlRpcResponseJsonString() {
        return XmlRpcPrintUtil.xmlRpcObjectToString(this.xmlRpcResponse);
    }
}

